/*
 * Copyright (C) 2002  Bogdan Surdu (tim@rdsnet.ro)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Revision: 1.4 $
 *
 * $Log: list.c,v $
 * Revision 1.4  2003/06/19 17:11:20  tim
 * new memory management
 * removed the fragment list
 *
 * Revision 1.3  2003/03/07 18:53:14  tim
 * *** empty log message ***
 *
 * Revision 1.2  2002/12/13 19:40:30  tim
 * - interface MAC chain-list
 *
 * Revision 1.1  2002/12/03 23:28:36  tim
 * Initial revision
 *
 *
 *
 */

#include <stdio.h>
#include <stdlib.h>

#include "list.h"
#include "fprobe.h"

struct iif_node *lookup_iif_id(struct iif_node *list, int iif_id) {
  struct iif_node *current, *found;

  found = NULL;
  current = list;
  while(current) {
    if (current->iif_id == iif_id) return found;
    current = current->next;
  }
  return found;
}

struct iif_node *lookup_iif_mac(struct iif_node *list, struct ether_addr *eth_addr) {
  struct iif_node *current;

  current = list;
  while(current) {
    if (memcmp(&current->mac, eth_addr, sizeof(struct ether_addr)) == 0) 
      return current;
    current = current->next;
  }
  return NULL;
}

struct iif_node *add_iif(struct iif_node *list, int iif_id, char *mac) {
  struct iif_node *current, *temp;
  struct ether_addr *addr;

  if (lookup_iif_id(list, iif_id)) return NULL;

  temp = (struct iif_node *)MALLOC(sizeof((iif_node)),3);
  printf("Allocated pointer %x\n", temp);
  temp->iif_id = iif_id;
#ifdef	DEBUG
  printf("Will add IIF with ID %d and MAC %s\n", iif_id, mac);
#endif
  addr = ether_aton(mac);
  if (!addr) return NULL;
  memcpy(&temp->mac, addr, sizeof(struct ether_addr));
  temp->next = list;

  return temp;
}

void dump_list(struct iif_node *list) {
  struct iif_node *current;

  current = list;
  while(current) {
    printf(" *** IIF %d Mac: %s\n", current->iif_id, ether_ntoa(&current->mac));
    current = current->next;
  }
}

