/*---[ preferences.c ]------------------------------------------------
 * Copyright (C) 2000 Tomas Junnonen (majix@sci.fi)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * The preferences notebook window
 *--------------------------------------------------------------------*/
#include <stdio.h>
#include <errno.h>

#include "preferences.h"
#include "firestarter.h"
#include "service.h"
#include "modrules.h"
#include "parse.h"

/* #include "xpm/play.xpm" */

#define LOG 0
#define HIT 1
#define STOP 2
#define RESTART 3


static GtkWidget *sections_clist;

GtkWidget *scriptentry;
GtkWidget *logentry;

GtkWidget *startup;
GtkWidget *stopatexit;
GtkWidget *exitonclose;
GtkWidget *starthidden;
GtkWidget *removedups;

/*
GtkWidget *enablesounds;
GtkWidget *hitsoundentry;
GtkWidget *stopsoundentry;
GtkWidget *restartsoundentry;
*/

GtkWidget *logclist;

GtkWidget *showall;
GtkWidget *experiments;
GtkWidget *locatesbins;
GtkWidget *selectdeny;
GtkWidget *selectreject;

GtkWidget *filesel;

gboolean ifo = FALSE;

/*
static GtkWidget *create_browse_button (GtkWidget *button, gint which);

static void 	 create_filesel	       (GtkWidget *widget, gpointer data);
static void	 set_file_log	       (GtkWidget *widget, gpointer data);
static void	 set_file_hit	       (GtkWidget *widget, gpointer data);
static void 	 set_file_stop	       (GtkWidget *widget, gpointer data);
static void 	 set_file_restart      (GtkWidget *widget, gpointer data);

static void 	 give_false_ifo	       (GtkWidget *widget, gpointer data);
*/
static void 	 destroy_filesel       (GtkWidget *pbox,   gpointer data);

/* [ starthidden_sensitive ]
 * The sensitivity of the starthidden widget is determined from exitonclose
 */
static void
starthidden_sensitive (GtkWidget *widget)
{
	if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (exitonclose)))
		gtk_widget_set_sensitive (starthidden, FALSE);
	else
		gtk_widget_set_sensitive (starthidden, TRUE);
}


/* [ save_preferences ]
 * Save the preferences to the gnome registry
 */
static void
save_preferences (GnomePropertyBox *property_box, gint page_num, gint num)
{
/* TODO: This function is called 2 times when apply is pressed, why? */

	gchar *logpath = FIRESTARTER_RULES_DIR "/firestarter/block-ports";
	FILE *f;
	gchar *text;
	gint i, j;

    if ((f = fopen (logpath, "w")) == NULL) {
       perror(logpath);
       return;
    }
    
/* General */
	/*gnome_config_set_string ("/firestarter/Files/logfile",
		gtk_entry_get_text (GTK_ENTRY (logentry)));
	*/

	gnome_config_set_bool ("/firestarter/Program/startup",
		gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (startup)));

	gnome_config_set_bool ("/firestarter/Program/shutdown",
		gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (stopatexit)));

	gnome_config_set_bool ("/firestarter/Program/exitonclose",
		gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (exitonclose)));

	if (!gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (exitonclose)))
		gnome_config_set_bool ("/firestarter/Program/starthidden",
			gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (starthidden)));
	else
		gnome_config_set_bool ("/firestarter/Program/starthidden", FALSE);
/*
	gnome_config_set_bool ("/firestarter/Program/removedups",
		gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (removedups)));
*/
/* Logging */

	fclose (f);

	j = gtk_clist_get_text (GTK_CLIST (logclist), 0, 0, &text);
	for (i = 0; j != 0; i++) {
		j = gtk_clist_get_text (GTK_CLIST (logclist), i, 0, &text);

		if (j != 0)
			do_not_log_port (atoi (text));
	}
	restart_firewall ();

/* Advanced */
	gnome_config_set_bool ("/firestarter/Druid/showall",
		gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (showall)));

	gnome_config_set_bool ("/firestarter/Druid/experiments",
		gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (experiments)));

	gnome_config_set_bool ("/firestarter/Druid/locatesbins",
		gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (locatesbins)));

	gnome_config_set_bool ("/firestarter/Druid/selectdeny",
		gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (selectdeny)));

	gnome_config_set_bool ("/firestarter/Druid/selectreject",
		gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (selectreject)));

/* Sounds */
/*	gnome_config_set_bool ("/firestarter/Sounds/enablesounds",
		gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (enablesounds)));

 	gnome_config_set_string ("/firestarter/Sounds/hitsoundfile",
		gtk_entry_get_text (GTK_ENTRY (hitsoundentry)));

 	gnome_config_set_string ("/firestarter/Sounds/stopsoundfile",
		gtk_entry_get_text (GTK_ENTRY (stopsoundentry)));

 	gnome_config_set_string ("/firestarter/Sounds/restartsoundfile",
		gtk_entry_get_text (GTK_ENTRY (restartsoundentry)));
*/
	gnome_config_sync ();
}

/* [ create_general_page ]
 * Create the general property page
 */
static GtkWidget*
create_general_page (GtkWidget *pbox)
{
	GtkWidget *table;
	GtkWidget *frame;
	GtkWidget *vbox;
	GtkWidget *hbox;

	table = gtk_table_new (1, 1, FALSE);
	gtk_table_set_row_spacings (GTK_TABLE (table), 0);
	gtk_table_set_col_spacings (GTK_TABLE (table), GNOME_PAD_SMALL);

	frame = gtk_frame_new (_("General options"));
	gtk_table_attach (GTK_TABLE (table), frame, 0, 1, 0, 1,
			  GTK_FILL, GTK_FILL, GNOME_PAD, GNOME_PAD_SMALL);

	vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (frame), vbox);

	startup = gtk_check_button_new_with_label (_(
		"Start firewall on program startup"));
	gtk_tooltips_set_tip (ttips, startup, _(
		"Check this and the firewall will be restarted each time the "
		"program starts. Enabled by default."), "");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (startup),
		gnome_config_get_bool ("/firestarter/Program/startup=TRUE"));
	gtk_box_pack_start (GTK_BOX (vbox), startup, FALSE, FALSE, 0);

	stopatexit = gtk_check_button_new_with_label (_(
		"Stop firewall on program exit"));
	gtk_tooltips_set_tip (ttips, stopatexit, _(
		"Check this and the firewall will be stopped when you exit "
		"Firestarter. Enabled by default."), "");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (stopatexit),
		gnome_config_get_bool ("/firestarter/Program/shutdown=FALSE"));
	gtk_box_pack_start (GTK_BOX (vbox), stopatexit, FALSE, FALSE, 0);

	exitonclose = gtk_check_button_new_with_label (_(
		"Exit program when window is closed (otherwise hide)"));
	gtk_tooltips_set_tip (ttips, exitonclose, _(
		"By default when you close the program window the program is "
		"merely hidden, you can then make it visible again by clicking "
		"on the status button."), "");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (exitonclose),
		 gnome_config_get_bool ("/firestarter/Program/exitonclose=FALSE"));
	gtk_box_pack_start (GTK_BOX (vbox), exitonclose, FALSE, FALSE, 0);

	starthidden = gtk_check_button_new_with_label (_("Start hidden"));
	gtk_tooltips_set_tip (ttips, starthidden, _(
		"Check this and Firestarter will start hidden. Click on the "
		"status button to unhide. Disabled by default."), "");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (starthidden),
		gnome_config_get_bool ("/firestarter/Program/starthidden=FALSE"));
	gtk_box_pack_start (GTK_BOX (vbox), starthidden, FALSE, FALSE, 0);

	if (gnome_config_get_bool ("/firestarter/Program/exitonclose=FALSE"))
		gtk_widget_set_sensitive (starthidden, FALSE);

	hbox = gtk_hbox_new (FALSE, 2);
	gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

	gtk_signal_connect_object (GTK_OBJECT (startup), "toggled",
		GTK_SIGNAL_FUNC (gnome_property_box_changed), GTK_OBJECT (pbox));
	gtk_signal_connect_object (GTK_OBJECT (stopatexit), "toggled",
		GTK_SIGNAL_FUNC (gnome_property_box_changed), GTK_OBJECT (pbox));
	gtk_signal_connect_object (GTK_OBJECT (exitonclose), "toggled",
		GTK_SIGNAL_FUNC (gnome_property_box_changed), GTK_OBJECT (pbox));

	gtk_signal_connect (GTK_OBJECT (exitonclose), "toggled",
			    GTK_SIGNAL_FUNC (starthidden_sensitive), NULL);

	gtk_signal_connect_object (GTK_OBJECT (starthidden), "toggled",
		GTK_SIGNAL_FUNC (gnome_property_box_changed), GTK_OBJECT (pbox));

	return (table);
}
/*
static void
play_sound (GtkWidget *widget, GtkWidget *entry)
{
	gnome_sound_play (gtk_entry_get_text (GTK_ENTRY (entry)));
}
*/

/* [ create_play_button ]
 * Convenience function to create a sound play button
 */
 /*
static GtkWidget*
create_play_button (GtkWidget *button, GtkWidget *entry)
{
	GtkWidget *picture;

	button = gtk_button_new ();
	gtk_tooltips_set_tip (ttips, button, _(
		"Play current sound file"), "");
	picture = gnome_pixmap_new_from_xpm_d (play_xpm);
	gtk_container_add (GTK_CONTAINER (button), picture);

	gtk_signal_connect (GTK_OBJECT (button), "clicked",
		GTK_SIGNAL_FUNC (play_sound), entry);

	return (button);
}
*/

/* [ create_sounds_page ]
 * Create the sound property page
 */
/*
static GtkWidget*
create_sounds_page (GtkWidget *pbox)
{
	GtkWidget *table;
	GtkWidget *label;
	GtkWidget *button = NULL;
	GtkWidget *frame;
	GtkWidget *vbox;
	GtkWidget *hbox;

	table = gtk_table_new (1, 1, FALSE);
	gtk_table_set_row_spacings (GTK_TABLE (table), 0);
	gtk_table_set_col_spacings (GTK_TABLE (table), GNOME_PAD_SMALL);

	frame = gtk_frame_new (_("Sound options"));
	gtk_table_attach (GTK_TABLE (table), frame, 0, 1, 0, 1,
			  GTK_FILL, GTK_FILL, GNOME_PAD, GNOME_PAD_SMALL);

	vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (frame), vbox);

	enablesounds = gtk_check_button_new_with_label (_("Enable sounds"));
	gtk_tooltips_set_tip (ttips, enablesounds, _(
		"Check this if you want to hear sounds on certain events"), "");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (enablesounds),
		gnome_config_get_bool ("/firestarter/Sounds/enablesounds=FALSE"));
	gtk_box_pack_start (GTK_BOX (vbox), enablesounds, FALSE, FALSE, 0);

	hbox = gtk_hbox_new (FALSE, 2);
	gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

	label = gtk_label_new (_("File to play on firewall hit:"));
	gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 4);

	hitsoundentry = gtk_entry_new ();
	gtk_tooltips_set_tip (ttips, hitsoundentry, _(
		"Enter the path to the sound file that should be played when a firewall hit occurs."), "");
	gtk_entry_set_text (GTK_ENTRY (hitsoundentry),
		gnome_config_get_string ("/firestarter/Sounds/hitsoundfile="));

	button = create_browse_button (button, HIT);
	gtk_box_pack_end (GTK_BOX (hbox), button, FALSE, FALSE, 2);

	button = create_play_button (button, hitsoundentry);
	gtk_box_pack_end (GTK_BOX (hbox), button, FALSE, FALSE, 0);

	gtk_box_pack_end (GTK_BOX (hbox), hitsoundentry, FALSE, FALSE, 2);

	hbox = gtk_hbox_new (FALSE, 2);
	gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

	label = gtk_label_new (_("File to play on firewall stop:"));
	gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 4);

	stopsoundentry = gtk_entry_new ();
	gtk_tooltips_set_tip (ttips, stopsoundentry, _(
		"Enter the path to the sound file that should be played when the firewall is stopped."), "");
	gtk_entry_set_text (GTK_ENTRY (stopsoundentry),
		gnome_config_get_string ("/firestarter/Sounds/stopsoundfile="));

	button = create_browse_button (button, STOP);
	gtk_box_pack_end (GTK_BOX (hbox), button, FALSE, FALSE, 2);

	button = create_play_button (button, stopsoundentry);
	gtk_box_pack_end (GTK_BOX (hbox), button, FALSE, FALSE, 0);

	gtk_box_pack_end (GTK_BOX (hbox), stopsoundentry, FALSE, FALSE, 2);

	hbox = gtk_hbox_new (FALSE, 2);
	gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

	label = gtk_label_new (_("File to play on firewall restart:"));
	gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 4);

	restartsoundentry = gtk_entry_new ();
	gtk_tooltips_set_tip (ttips, restartsoundentry, _(
		"Enter the path to the sound file that should be played when the firewall is restarted."), "");
	gtk_entry_set_text (GTK_ENTRY (restartsoundentry),
		gnome_config_get_string ("/firestarter/Sounds/restartsoundfile="));

	button = create_browse_button (button, RESTART);
	gtk_box_pack_end (GTK_BOX (hbox), button, FALSE, FALSE, 2);

	button = create_play_button (button, restartsoundentry);
	gtk_box_pack_end (GTK_BOX (hbox), button, FALSE, FALSE, 0);

	gtk_box_pack_end (GTK_BOX (hbox), restartsoundentry, FALSE, FALSE, 2);

	gtk_signal_connect_object (GTK_OBJECT (enablesounds), "toggled",
				   GTK_SIGNAL_FUNC (gnome_property_box_changed), GTK_OBJECT (pbox));
	gtk_signal_connect_object (GTK_OBJECT (hitsoundentry), "changed",
				   GTK_SIGNAL_FUNC (gnome_property_box_changed), GTK_OBJECT (pbox));
	gtk_signal_connect_object (GTK_OBJECT (stopsoundentry), "changed",
				   GTK_SIGNAL_FUNC (gnome_property_box_changed), GTK_OBJECT (pbox));
	gtk_signal_connect_object (GTK_OBJECT (restartsoundentry), "changed",
				   GTK_SIGNAL_FUNC (gnome_property_box_changed), GTK_OBJECT (pbox));
	return (table);
}
*/

static void
log_add_clicked (GtkWidget *button, gpointer entry)
{
	gchar *text[2];

	text[0] = g_strdup (
		gtk_editable_get_chars (GTK_EDITABLE (entry), 0, -1));
	text[1] = g_strdup (service (atoi (text[0]), 6));

	gtk_entry_set_text (GTK_ENTRY (entry), "");

	gtk_clist_append (GTK_CLIST (logclist), text);
}

static void
log_entry_activated (GtkWidget *entry, gpointer button)
{
	gtk_signal_emit_by_name (GTK_OBJECT (button), "clicked", entry);
}

static void
log_clist_select (GtkCList *clist, gint row, gint column,
		  GdkEventButton *event, gpointer user_data)
{
	gtk_clist_remove (clist, row);
}

/* [ create_log_page ]
 * Create the firewall log property page
 */
static GtkWidget*
create_log_page (GtkWidget *pbox)
{
	GtkWidget *table;
	GtkWidget *scrolled_win;
	GtkWidget *button;
	GtkWidget *entry;
	GtkWidget *frame;
	GtkWidget *vbox, *hbox;
/*	GtkWidget *label; */
	gchar *logtitles[2];

	logtitles[0] = _("Port");
	logtitles[1] = _("Service");

	table = gtk_table_new (3, 2, FALSE);
	gtk_table_set_row_spacings (GTK_TABLE (table), 0);
	gtk_table_set_col_spacings (GTK_TABLE (table), GNOME_PAD_SMALL);

	frame = gtk_frame_new (_("Block these ports explicitly"));
	gtk_table_attach (GTK_TABLE (table), frame, 0, 1, 0, 1,
			  GTK_FILL, GTK_FILL, 0, GNOME_PAD_SMALL);

	hbox = gtk_hbox_new (FALSE, 5);
	gtk_container_add (GTK_CONTAINER (frame), hbox);

	vbox = gtk_vbox_new (FALSE, 2);
	gtk_box_pack_start (GTK_BOX (hbox), vbox, FALSE, FALSE, 7);

	logclist = gtk_clist_new_with_titles (2, logtitles);
	gtk_widget_set_usize (logclist, 175, 130);
	gtk_clist_set_column_width (GTK_CLIST (logclist), 0, 50);
	parse_do_not_log_ports (logclist);

	gtk_signal_connect (GTK_OBJECT (logclist), "select-row",
		GTK_SIGNAL_FUNC (log_clist_select), NULL);

	scrolled_win = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
					GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	gtk_container_add (GTK_CONTAINER (scrolled_win), logclist);

	gtk_box_pack_start (GTK_BOX (vbox), scrolled_win, FALSE, FALSE, 3);

	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

	entry = gtk_entry_new ();
	gtk_box_pack_start (GTK_BOX (hbox), entry, FALSE, FALSE, 1);

	button = gtk_button_new_with_label (_("Add"));
	gtk_box_pack_start (GTK_BOX (hbox), button, FALSE, FALSE, 1);
	gtk_signal_connect (GTK_OBJECT (button), "clicked",
		GTK_SIGNAL_FUNC (log_add_clicked), entry);

	gtk_signal_connect (GTK_OBJECT (entry), "activate",
		GTK_SIGNAL_FUNC (log_entry_activated), button);

	gtk_signal_connect_object (GTK_OBJECT (logclist), "select-row",
		GTK_SIGNAL_FUNC (gnome_property_box_changed), GTK_OBJECT (pbox));
	gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
		GTK_SIGNAL_FUNC (gnome_property_box_changed), GTK_OBJECT (pbox));
		
/*
	frame = gtk_frame_new (_("Misc. options"));
	gtk_table_attach (GTK_TABLE (table), frame, 1, 2, 0, 1,
			  GTK_FILL, GTK_FILL, GNOME_PAD, GNOME_PAD_SMALL);

	vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (frame), vbox);

	hbox = gtk_hbox_new (FALSE, 4);
	gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 4);

	label = gtk_label_new (_("Syslog file:"));
	gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 3);

	hbox = gtk_hbox_new (FALSE, 4);
	gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

	logentry = gtk_entry_new ();
	gtk_tooltips_set_tip (ttips, logentry, _(
		"Enter the path to the file the syslog daemon logs to. "
		"This is almost always /var/log/messages."), "");
	gtk_entry_set_text (GTK_ENTRY (logentry),
		gnome_config_get_string (
			"/firestarter/Files/logfile=/var/log/messages"));
	gtk_box_pack_start (GTK_BOX (hbox), logentry, FALSE, FALSE, 3);

	button = create_browse_button (button, LOG);
	gtk_box_pack_start (GTK_BOX (hbox), button, FALSE, FALSE, 3);

	gtk_signal_connect_object (GTK_OBJECT (logentry), "changed",
		GTK_SIGNAL_FUNC (gnome_property_box_changed), GTK_OBJECT (pbox));

	removedups = gtk_check_button_new_with_label (_(
		"Filter identical hits"));
	gtk_tooltips_set_tip (ttips, removedups, _(
		"Check this and the firewall hit log will filter out identical "
		"lines. Enabled by default."), "");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (removedups),
		gnome_config_get_bool ("/firestarter/Program/removedups=TRUE"));
	gtk_box_pack_start (GTK_BOX (vbox), removedups, FALSE, FALSE, 5);

	gtk_signal_connect_object (GTK_OBJECT (removedups), "toggled",
		GTK_SIGNAL_FUNC (gnome_property_box_changed), GTK_OBJECT (pbox));

	*/

	return table;
}

static GtkWidget*
create_advanced_page (GtkWidget *pbox)
{
	GtkWidget *frame;
	GtkWidget *table;
	GtkWidget *vbox;
	GtkWidget *label;

	table = gtk_table_new (3, 1, FALSE);
	gtk_table_set_row_spacings (GTK_TABLE (table), 0);
	gtk_table_set_col_spacings (GTK_TABLE (table), GNOME_PAD_SMALL);

	frame = gtk_frame_new (_("Wizard options"));
	gtk_table_attach (GTK_TABLE (table), frame, 0, 1, 0, 1,
			  GTK_FILL, GTK_FILL, GNOME_PAD, GNOME_PAD_SMALL);

	vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (frame), vbox);

	showall = gtk_check_button_new_with_label (_("Show every page in wizard"));
	gtk_tooltips_set_tip (ttips, showall, _(
		"Check this and every wizard page will be available in the wizard"), "");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (showall),
		gnome_config_get_bool ("/firestarter/Druid/showall=FALSE"));
	gtk_box_pack_start (GTK_BOX (vbox), showall, FALSE, FALSE, 0);

	experiments = gtk_check_button_new_with_label (_("Enable Experimental Options"));
	gtk_tooltips_set_tip (ttips, experiments, _(
		"If you enable this, Firestarter can use some experimental patches for filtering,"
		"Do not enable this option until you have read the manual for the pre-requisties"), "");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (experiments),
		gnome_config_get_bool ("/firestarter/Druid/experiments=FALSE"));
	gtk_box_pack_start (GTK_BOX (vbox), experiments, FALSE, FALSE, 0);

	locatesbins = gtk_check_button_new_with_label (_("Try to detect the location of system binaries"));
	gtk_tooltips_set_tip (ttips, locatesbins, _(
		"Check this and Firestarter will search for the location of some "
		"needed binaries. Do not check unless you're having problems."), "");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (locatesbins),
		gnome_config_get_bool ("/firestarter/Druid/locatesbins=FALSE"));
	gtk_box_pack_start (GTK_BOX (vbox), locatesbins, FALSE, FALSE, 0);

	frame = gtk_frame_new (_("Preferred packet rejection method"));
	gtk_table_attach (GTK_TABLE (table), frame, 0, 1, 1, 2,
			  GTK_FILL, GTK_FILL, GNOME_PAD, GNOME_PAD_SMALL);

	vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (frame), vbox);

	selectdeny = gtk_radio_button_new_with_label (NULL, _("Deny"));
	gtk_tooltips_set_tip (ttips, selectdeny, _(
		"Checking this box will simply ignore the unauthorized packets."), "");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (selectdeny),
		gnome_config_get_bool ("/firestarter/Druid/selectdeny=FALSE"));
	gtk_box_pack_start (GTK_BOX (vbox), selectdeny, FALSE, FALSE, 0);

	selectreject = gtk_radio_button_new_with_label_from_widget (GTK_RADIO_BUTTON (selectdeny),
		_("Reject"));
	gtk_tooltips_set_tip (ttips, selectreject, _(
		"Checking this box will reject the unauthorized packets"), "");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (selectreject),
		gnome_config_get_bool ("/firestarter/Druid/selectreject=FALSE"));
	gtk_box_pack_start (GTK_BOX (vbox), selectreject, FALSE, FALSE, 0);

	label = gtk_label_new (_("You must rerun the wizard for the changes to take effect"));
	gtk_table_attach (GTK_TABLE (table), label, 0, 1, 2, 3,
			  GTK_FILL, GTK_FILL, GNOME_PAD, GNOME_PAD_SMALL);


	gtk_signal_connect_object (GTK_OBJECT (showall), "toggled",
		GTK_SIGNAL_FUNC (gnome_property_box_changed), GTK_OBJECT (pbox));

	gtk_signal_connect_object (GTK_OBJECT (experiments), "toggled",
		GTK_SIGNAL_FUNC (gnome_property_box_changed), GTK_OBJECT (pbox));
 
	gtk_signal_connect_object (GTK_OBJECT (locatesbins), "toggled",
		GTK_SIGNAL_FUNC (gnome_property_box_changed), GTK_OBJECT (pbox));

	gtk_signal_connect_object (GTK_OBJECT (selectdeny), "toggled",
		GTK_SIGNAL_FUNC (gnome_property_box_changed), GTK_OBJECT (pbox));

	gtk_signal_connect_object (GTK_OBJECT (selectreject), "toggled",
		GTK_SIGNAL_FUNC (gnome_property_box_changed), GTK_OBJECT (pbox));

	return table;
}

static void
prefs_select_row_cb (GtkCList *clist,
                     gint row,
                     gint column,
                     GdkEventButton *event,
                     GtkWidget *pbox)
{
        gtk_notebook_set_page (GTK_NOTEBOOK (
		GNOME_PROPERTY_BOX (pbox)->notebook), row);
}

static int
prefs_add_section_page (gchar     *name,
                        GtkWidget *widget,
			GtkWidget *pbox)
{
	gchar *text[2] = {name, NULL};
	gtk_notebook_append_page (GTK_NOTEBOOK (GNOME_PROPERTY_BOX (pbox)->notebook),
				  widget, gtk_label_new (name));
	return gtk_clist_append (GTK_CLIST (sections_clist), text);
}

/* [ preferences_cb ]
 * Create the preferences property_box
 */
void
preferences_cb (GtkWidget *widget, gpointer data)
{
	static GtkWidget *pbox;
	GtkWidget *hbox;
	GtkWidget *label;

	if (pbox != NULL) {
		g_assert (GTK_WIDGET_REALIZED (pbox));
		gdk_window_show (pbox->window);
		gdk_window_raise (pbox->window);

		return;
	}

	pbox = gnome_property_box_new ();
	gtk_window_set_title (GTK_WINDOW (pbox), _("Firestarter: Preferences"));

	hbox = gtk_hbox_new (FALSE, GNOME_PAD);
	gtk_container_set_border_width (GTK_CONTAINER (hbox), 6);

	sections_clist = gtk_clist_new (1);
	gtk_clist_set_selection_mode (GTK_CLIST (sections_clist),
				      GTK_SELECTION_BROWSE);

	gtk_signal_connect (GTK_OBJECT (sections_clist), "select_row",
			    GTK_SIGNAL_FUNC (prefs_select_row_cb), pbox);

	label = gtk_label_new ("Test");
	prefs_add_section_page (_("General"), create_general_page (pbox), pbox);
	prefs_add_section_page (_("Blocking"), create_log_page (pbox), pbox);
/*	prefs_add_section_page (_("Sounds"), create_sounds_page (pbox), pbox); */
	prefs_add_section_page (_("Advanced"), create_advanced_page (pbox), pbox);
	
	gtk_clist_columns_autosize (GTK_CLIST (sections_clist) );

	gtk_notebook_set_show_tabs (GTK_NOTEBOOK (GNOME_PROPERTY_BOX (pbox)->notebook), FALSE);
	gtk_notebook_set_show_border (GTK_NOTEBOOK (GNOME_PROPERTY_BOX (pbox)->notebook), FALSE);

	gtk_widget_ref (GNOME_PROPERTY_BOX (pbox)->notebook);

	gtk_container_remove (GTK_CONTAINER (GNOME_DIALOG (pbox)->vbox),
			      GNOME_PROPERTY_BOX (pbox)->notebook);

	gtk_box_pack_start (GTK_BOX (GNOME_DIALOG(pbox)->vbox),
			    hbox, TRUE, TRUE, 0);

	gtk_box_pack_start (GTK_BOX (hbox),
			    sections_clist,
			    TRUE, TRUE, 0);

	gtk_box_pack_start (GTK_BOX (hbox),
			    GNOME_PROPERTY_BOX (pbox)->notebook,
			    TRUE, TRUE, 0);

	gtk_widget_unref (GNOME_PROPERTY_BOX (pbox)->notebook);

	gtk_signal_connect (GTK_OBJECT (pbox), "apply",
		   GTK_SIGNAL_FUNC (destroy_filesel), NULL);

	gtk_signal_connect (GTK_OBJECT (pbox), "apply",
			    GTK_SIGNAL_FUNC (save_preferences), NULL);
			    
	gtk_signal_connect (GTK_OBJECT (pbox), "destroy",
		   GTK_SIGNAL_FUNC (destroy_filesel), NULL);

	gtk_signal_connect (GTK_OBJECT (pbox), "destroy",
			    GTK_SIGNAL_FUNC (gtk_widget_destroyed), &pbox);

	gtk_widget_show_all (pbox);
}
/*
static void
set_file_log (GtkWidget *widget, gpointer data)
{
	gtk_entry_set_text (GTK_ENTRY (logentry),
			gtk_file_selection_get_filename (GTK_FILE_SELECTION (data)));
}


static void
set_file_hit (GtkWidget *widget, gpointer data)
{
	gtk_entry_set_text (GTK_ENTRY (hitsoundentry),
			gtk_file_selection_get_filename (GTK_FILE_SELECTION (data)));
}

static void
set_file_stop (GtkWidget *widget, gpointer data)
{
	gtk_entry_set_text (GTK_ENTRY (stopsoundentry),
			gtk_file_selection_get_filename (GTK_FILE_SELECTION (data)));
}

static void
set_file_restart (GtkWidget *widget, gpointer data)
{
	gtk_entry_set_text (GTK_ENTRY (restartsoundentry),
			gtk_file_selection_get_filename (GTK_FILE_SELECTION (data)));
}
*/
static void
give_false_ifo (GtkWidget *widget, gpointer data)
{
	ifo = FALSE;
}
/*
static void
create_filesel (GtkWidget *widget, gpointer data)
{
	gint which = (gint) data;

	ifo = TRUE;
	filesel = (which == LOG) ?
		gtk_file_selection_new (_("Select the syslog log file")):
		gtk_file_selection_new (_("Select the file to play a sound"));

	gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (
		filesel)->ok_button), "clicked",
		GTK_SIGNAL_FUNC ((which == LOG ? set_file_log :
					  (which == HIT ? set_file_hit :
					  (which == STOP ? set_file_stop :
					   set_file_restart)))),
			GTK_OBJECT (GTK_FILE_SELECTION (filesel)));

	gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (filesel)->ok_button),
		"clicked", GTK_SIGNAL_FUNC (give_false_ifo), NULL);

	gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION (filesel)->ok_button),
		"clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy),
		GTK_OBJECT (GTK_FILE_SELECTION (filesel)));

	gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (filesel)->cancel_button),
		"clicked", GTK_SIGNAL_FUNC (give_false_ifo), NULL);

	gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION (filesel)->cancel_button),
		"clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy),
		GTK_OBJECT (GTK_FILE_SELECTION (filesel)));

	gtk_widget_show (filesel);
}
*/
/* [ create_browse_button ]
 * Convenience function to create a browse button
 */
/*
static GtkWidget*
create_browse_button (GtkWidget *button, gint which)
{
	button = gtk_button_new_with_label ("...");
	gtk_tooltips_set_tip (ttips, button, _("Browse"), "");

	gtk_signal_connect (GTK_OBJECT (button), "clicked",
		GTK_SIGNAL_FUNC (create_filesel), (gpointer) which);

	return (button);
}
*/
/* [ destroy_filesel ]
 * Destroy the file selector window if open when the preference
 * window receive the any signal
 */

static void
destroy_filesel (GtkWidget *pbox, gpointer data)
{
	if (ifo) {
		gtk_widget_destroy (GTK_WIDGET (filesel));
		ifo = FALSE;
	}
}
