--TEST--
ffmpeg getFrame backwards test
--SKIPIF--
<?php 
extension_loaded('ffmpeg') or die("skip ffmpeg extension not loaded"); 
extension_loaded('gd') or die("skip gd extension not avaliable.");
function_exists("imagecreatetruecolor") or die("skip function imagecreatetruecolor unavailable");
?>
--FILE--
<?php
$mov = new ffmpeg_movie(dirname(__FILE__) . '/test_media/robot.avi');

$framecount = $mov->getFrameCount();
for($i = $framecount; $i > 0; $i--) {
    $img = sprintf("%s/test-%04d.png", dirname(__FILE__), $i);
    $frame = $mov->getFrame($i);
    $image = $frame->toGDImage();
    imagepng($image, $img);
    printf("ffmpeg getFramesBackward($i): md5 = %s\n", md5(file_get_contents($img)));
    imagedestroy($image);
    unlink($img);
}
?>
--EXPECT--
ffmpeg getFramesBackward(240): md5 = d4a2f7c2ab68650389c59908d4c0782d
ffmpeg getFramesBackward(239): md5 = d4a2f7c2ab68650389c59908d4c0782d
ffmpeg getFramesBackward(238): md5 = d4a2f7c2ab68650389c59908d4c0782d
ffmpeg getFramesBackward(237): md5 = d61dfde9607fae63d95f851caf11c3ca
ffmpeg getFramesBackward(236): md5 = d61dfde9607fae63d95f851caf11c3ca
ffmpeg getFramesBackward(235): md5 = d61dfde9607fae63d95f851caf11c3ca
ffmpeg getFramesBackward(234): md5 = b413f14785c34a33e376dca390919e44
ffmpeg getFramesBackward(233): md5 = b413f14785c34a33e376dca390919e44
ffmpeg getFramesBackward(232): md5 = b413f14785c34a33e376dca390919e44
ffmpeg getFramesBackward(231): md5 = 46d48ec5a5430631e08549af827f641d
ffmpeg getFramesBackward(230): md5 = 46d48ec5a5430631e08549af827f641d
ffmpeg getFramesBackward(229): md5 = 46d48ec5a5430631e08549af827f641d
ffmpeg getFramesBackward(228): md5 = 4999a95e6866d811ab2d909c97446183
ffmpeg getFramesBackward(227): md5 = 4999a95e6866d811ab2d909c97446183
ffmpeg getFramesBackward(226): md5 = 4999a95e6866d811ab2d909c97446183
ffmpeg getFramesBackward(225): md5 = 7eeda0f3c9f4b21917ca0ffb10192941
ffmpeg getFramesBackward(224): md5 = 7eeda0f3c9f4b21917ca0ffb10192941
ffmpeg getFramesBackward(223): md5 = 7eeda0f3c9f4b21917ca0ffb10192941
ffmpeg getFramesBackward(222): md5 = 910a63ec4bd4e2f73e723ae237ccb5ee
ffmpeg getFramesBackward(221): md5 = 910a63ec4bd4e2f73e723ae237ccb5ee
ffmpeg getFramesBackward(220): md5 = 910a63ec4bd4e2f73e723ae237ccb5ee
ffmpeg getFramesBackward(219): md5 = f5976f8cd67073146ef6ef8d001c6e34
ffmpeg getFramesBackward(218): md5 = f5976f8cd67073146ef6ef8d001c6e34
ffmpeg getFramesBackward(217): md5 = f5976f8cd67073146ef6ef8d001c6e34
ffmpeg getFramesBackward(216): md5 = 9acee9aeb40524d051674ac6b30e1c8b
ffmpeg getFramesBackward(215): md5 = 9acee9aeb40524d051674ac6b30e1c8b
ffmpeg getFramesBackward(214): md5 = 9acee9aeb40524d051674ac6b30e1c8b
ffmpeg getFramesBackward(213): md5 = 4db82d394a2311522fdb8b15f448827a
ffmpeg getFramesBackward(212): md5 = 4db82d394a2311522fdb8b15f448827a
ffmpeg getFramesBackward(211): md5 = 4db82d394a2311522fdb8b15f448827a
ffmpeg getFramesBackward(210): md5 = aef1e2cc24a18bf1515cef5bb189aeb3
ffmpeg getFramesBackward(209): md5 = aef1e2cc24a18bf1515cef5bb189aeb3
ffmpeg getFramesBackward(208): md5 = aef1e2cc24a18bf1515cef5bb189aeb3
ffmpeg getFramesBackward(207): md5 = 7ddc765161e0c22514b5c0828e1362f3
ffmpeg getFramesBackward(206): md5 = 7ddc765161e0c22514b5c0828e1362f3
ffmpeg getFramesBackward(205): md5 = 7ddc765161e0c22514b5c0828e1362f3
ffmpeg getFramesBackward(204): md5 = 490e9a5423e458d82f7cfae8064492b7
ffmpeg getFramesBackward(203): md5 = 490e9a5423e458d82f7cfae8064492b7
ffmpeg getFramesBackward(202): md5 = 490e9a5423e458d82f7cfae8064492b7
ffmpeg getFramesBackward(201): md5 = 18dd6bade0c7f812d0cba2de1f413175
ffmpeg getFramesBackward(200): md5 = 18dd6bade0c7f812d0cba2de1f413175
ffmpeg getFramesBackward(199): md5 = 18dd6bade0c7f812d0cba2de1f413175
ffmpeg getFramesBackward(198): md5 = 8dea42da4ce7c3083d949b0f974399e3
ffmpeg getFramesBackward(197): md5 = 8dea42da4ce7c3083d949b0f974399e3
ffmpeg getFramesBackward(196): md5 = 8dea42da4ce7c3083d949b0f974399e3
ffmpeg getFramesBackward(195): md5 = d5cd91272f4712fb2944fbd2e4552c45
ffmpeg getFramesBackward(194): md5 = d5cd91272f4712fb2944fbd2e4552c45
ffmpeg getFramesBackward(193): md5 = d5cd91272f4712fb2944fbd2e4552c45
ffmpeg getFramesBackward(192): md5 = 365b1cadbf6bda704d4f7b0f7f904785
ffmpeg getFramesBackward(191): md5 = 365b1cadbf6bda704d4f7b0f7f904785
ffmpeg getFramesBackward(190): md5 = 365b1cadbf6bda704d4f7b0f7f904785
ffmpeg getFramesBackward(189): md5 = f9ea01aef8b5bf246c74e3bab2439ebf
ffmpeg getFramesBackward(188): md5 = f9ea01aef8b5bf246c74e3bab2439ebf
ffmpeg getFramesBackward(187): md5 = f9ea01aef8b5bf246c74e3bab2439ebf
ffmpeg getFramesBackward(186): md5 = c414947d7b620ee44267b4f182d89ec8
ffmpeg getFramesBackward(185): md5 = c414947d7b620ee44267b4f182d89ec8
ffmpeg getFramesBackward(184): md5 = c414947d7b620ee44267b4f182d89ec8
ffmpeg getFramesBackward(183): md5 = 21af6e0bd1f8011808c6890d394396e1
ffmpeg getFramesBackward(182): md5 = 21af6e0bd1f8011808c6890d394396e1
ffmpeg getFramesBackward(181): md5 = 21af6e0bd1f8011808c6890d394396e1
ffmpeg getFramesBackward(180): md5 = e16c4d5c8b22f8b864a16891b3bd14e7
ffmpeg getFramesBackward(179): md5 = e16c4d5c8b22f8b864a16891b3bd14e7
ffmpeg getFramesBackward(178): md5 = e16c4d5c8b22f8b864a16891b3bd14e7
ffmpeg getFramesBackward(177): md5 = 1c61d3ca67f7202adb31bf6089fbff2e
ffmpeg getFramesBackward(176): md5 = 1c61d3ca67f7202adb31bf6089fbff2e
ffmpeg getFramesBackward(175): md5 = 1c61d3ca67f7202adb31bf6089fbff2e
ffmpeg getFramesBackward(174): md5 = 48229edb0a5fda484c7482265b078009
ffmpeg getFramesBackward(173): md5 = 48229edb0a5fda484c7482265b078009
ffmpeg getFramesBackward(172): md5 = 48229edb0a5fda484c7482265b078009
ffmpeg getFramesBackward(171): md5 = 18ff30e3c231f1967aa44fe2f9f5285c
ffmpeg getFramesBackward(170): md5 = 18ff30e3c231f1967aa44fe2f9f5285c
ffmpeg getFramesBackward(169): md5 = 18ff30e3c231f1967aa44fe2f9f5285c
ffmpeg getFramesBackward(168): md5 = a40db68641c4ad76ac5368dcd247eb4a
ffmpeg getFramesBackward(167): md5 = a40db68641c4ad76ac5368dcd247eb4a
ffmpeg getFramesBackward(166): md5 = a40db68641c4ad76ac5368dcd247eb4a
ffmpeg getFramesBackward(165): md5 = ee1eeb86a69a2e4210033aebcf39bca2
ffmpeg getFramesBackward(164): md5 = ee1eeb86a69a2e4210033aebcf39bca2
ffmpeg getFramesBackward(163): md5 = ee1eeb86a69a2e4210033aebcf39bca2
ffmpeg getFramesBackward(162): md5 = f4a0d9cf31ad0cad81e1deaceb47a756
ffmpeg getFramesBackward(161): md5 = f4a0d9cf31ad0cad81e1deaceb47a756
ffmpeg getFramesBackward(160): md5 = f4a0d9cf31ad0cad81e1deaceb47a756
ffmpeg getFramesBackward(159): md5 = 16c737c2d00c6d37292c3afe3515bf56
ffmpeg getFramesBackward(158): md5 = 16c737c2d00c6d37292c3afe3515bf56
ffmpeg getFramesBackward(157): md5 = 16c737c2d00c6d37292c3afe3515bf56
ffmpeg getFramesBackward(156): md5 = 1e0c149d1c96ad596f0b2a308ec5673c
ffmpeg getFramesBackward(155): md5 = 1e0c149d1c96ad596f0b2a308ec5673c
ffmpeg getFramesBackward(154): md5 = 1e0c149d1c96ad596f0b2a308ec5673c
ffmpeg getFramesBackward(153): md5 = e0eb7b58ca5ebdedcd68207c952cbdf3
ffmpeg getFramesBackward(152): md5 = e0eb7b58ca5ebdedcd68207c952cbdf3
ffmpeg getFramesBackward(151): md5 = e0eb7b58ca5ebdedcd68207c952cbdf3
ffmpeg getFramesBackward(150): md5 = 8a9edebd11a1c00a4d7f70d86214e3f0
ffmpeg getFramesBackward(149): md5 = 8a9edebd11a1c00a4d7f70d86214e3f0
ffmpeg getFramesBackward(148): md5 = 8a9edebd11a1c00a4d7f70d86214e3f0
ffmpeg getFramesBackward(147): md5 = f8edd77736d0ee5fa659e48c5fbd08e5
ffmpeg getFramesBackward(146): md5 = f8edd77736d0ee5fa659e48c5fbd08e5
ffmpeg getFramesBackward(145): md5 = f8edd77736d0ee5fa659e48c5fbd08e5
ffmpeg getFramesBackward(144): md5 = 5cf78bf4a1e2d315cfaa727a01b9e76b
ffmpeg getFramesBackward(143): md5 = 5cf78bf4a1e2d315cfaa727a01b9e76b
ffmpeg getFramesBackward(142): md5 = 5cf78bf4a1e2d315cfaa727a01b9e76b
ffmpeg getFramesBackward(141): md5 = 8ad6920211bc42e3c5d60aac49269ab6
ffmpeg getFramesBackward(140): md5 = 8ad6920211bc42e3c5d60aac49269ab6
ffmpeg getFramesBackward(139): md5 = 8ad6920211bc42e3c5d60aac49269ab6
ffmpeg getFramesBackward(138): md5 = 13207b57813c674964b90710d20015a7
ffmpeg getFramesBackward(137): md5 = 13207b57813c674964b90710d20015a7
ffmpeg getFramesBackward(136): md5 = 13207b57813c674964b90710d20015a7
ffmpeg getFramesBackward(135): md5 = fcfd42f03b43c758f5809ddb6f838e35
ffmpeg getFramesBackward(134): md5 = fcfd42f03b43c758f5809ddb6f838e35
ffmpeg getFramesBackward(133): md5 = fcfd42f03b43c758f5809ddb6f838e35
ffmpeg getFramesBackward(132): md5 = 884d3ead6edadfe270bde7f4d892c4e7
ffmpeg getFramesBackward(131): md5 = 884d3ead6edadfe270bde7f4d892c4e7
ffmpeg getFramesBackward(130): md5 = 884d3ead6edadfe270bde7f4d892c4e7
ffmpeg getFramesBackward(129): md5 = 96ef5c0f473fb42ccafb025e72ac21e2
ffmpeg getFramesBackward(128): md5 = 96ef5c0f473fb42ccafb025e72ac21e2
ffmpeg getFramesBackward(127): md5 = 96ef5c0f473fb42ccafb025e72ac21e2
ffmpeg getFramesBackward(126): md5 = 0f25e44c066a254c2e03ce62491eb436
ffmpeg getFramesBackward(125): md5 = 0f25e44c066a254c2e03ce62491eb436
ffmpeg getFramesBackward(124): md5 = 0f25e44c066a254c2e03ce62491eb436
ffmpeg getFramesBackward(123): md5 = 1ff5678204c04832e938dbcecd9d6b3b
ffmpeg getFramesBackward(122): md5 = 1ff5678204c04832e938dbcecd9d6b3b
ffmpeg getFramesBackward(121): md5 = 1ff5678204c04832e938dbcecd9d6b3b
ffmpeg getFramesBackward(120): md5 = a6a6dc77c91df625209a1fa1938518b3
ffmpeg getFramesBackward(119): md5 = a6a6dc77c91df625209a1fa1938518b3
ffmpeg getFramesBackward(118): md5 = a6a6dc77c91df625209a1fa1938518b3
ffmpeg getFramesBackward(117): md5 = fddf364fef227491aec27335cacbf16b
ffmpeg getFramesBackward(116): md5 = fddf364fef227491aec27335cacbf16b
ffmpeg getFramesBackward(115): md5 = fddf364fef227491aec27335cacbf16b
ffmpeg getFramesBackward(114): md5 = 1e03742868e2f4cecb0a549a33a2d910
ffmpeg getFramesBackward(113): md5 = 1e03742868e2f4cecb0a549a33a2d910
ffmpeg getFramesBackward(112): md5 = 1e03742868e2f4cecb0a549a33a2d910
ffmpeg getFramesBackward(111): md5 = 4352d4fa27f4be91ab4b9bbefbff0e61
ffmpeg getFramesBackward(110): md5 = 4352d4fa27f4be91ab4b9bbefbff0e61
ffmpeg getFramesBackward(109): md5 = 4352d4fa27f4be91ab4b9bbefbff0e61
ffmpeg getFramesBackward(108): md5 = 649b4d326c90454a062f7ac7ae6fed18
ffmpeg getFramesBackward(107): md5 = 649b4d326c90454a062f7ac7ae6fed18
ffmpeg getFramesBackward(106): md5 = 649b4d326c90454a062f7ac7ae6fed18
ffmpeg getFramesBackward(105): md5 = 84e40366d9075b2390132eefb5d977f4
ffmpeg getFramesBackward(104): md5 = 84e40366d9075b2390132eefb5d977f4
ffmpeg getFramesBackward(103): md5 = 84e40366d9075b2390132eefb5d977f4
ffmpeg getFramesBackward(102): md5 = 7ece3c2a510e5e0447d4a40ac7719e6d
ffmpeg getFramesBackward(101): md5 = 7ece3c2a510e5e0447d4a40ac7719e6d
ffmpeg getFramesBackward(100): md5 = 7ece3c2a510e5e0447d4a40ac7719e6d
ffmpeg getFramesBackward(99): md5 = 8f86f86cd2a39e33938eb9a726c7820c
ffmpeg getFramesBackward(98): md5 = 8f86f86cd2a39e33938eb9a726c7820c
ffmpeg getFramesBackward(97): md5 = 8f86f86cd2a39e33938eb9a726c7820c
ffmpeg getFramesBackward(96): md5 = b7b6e8e39d88630746b2d67fad071516
ffmpeg getFramesBackward(95): md5 = b7b6e8e39d88630746b2d67fad071516
ffmpeg getFramesBackward(94): md5 = b7b6e8e39d88630746b2d67fad071516
ffmpeg getFramesBackward(93): md5 = 68888902a3d8a13b8efe3e070809f54e
ffmpeg getFramesBackward(92): md5 = 68888902a3d8a13b8efe3e070809f54e
ffmpeg getFramesBackward(91): md5 = 68888902a3d8a13b8efe3e070809f54e
ffmpeg getFramesBackward(90): md5 = f1d135a68a5fd11bafa562a32833df34
ffmpeg getFramesBackward(89): md5 = f1d135a68a5fd11bafa562a32833df34
ffmpeg getFramesBackward(88): md5 = f1d135a68a5fd11bafa562a32833df34
ffmpeg getFramesBackward(87): md5 = df9b4592ff49efab623aface0764a4c2
ffmpeg getFramesBackward(86): md5 = df9b4592ff49efab623aface0764a4c2
ffmpeg getFramesBackward(85): md5 = df9b4592ff49efab623aface0764a4c2
ffmpeg getFramesBackward(84): md5 = db6501ae0cf6e7cc3c3080333b710fc6
ffmpeg getFramesBackward(83): md5 = db6501ae0cf6e7cc3c3080333b710fc6
ffmpeg getFramesBackward(82): md5 = db6501ae0cf6e7cc3c3080333b710fc6
ffmpeg getFramesBackward(81): md5 = ea3c7e80a76ec87227e1cb010b433a8b
ffmpeg getFramesBackward(80): md5 = ea3c7e80a76ec87227e1cb010b433a8b
ffmpeg getFramesBackward(79): md5 = ea3c7e80a76ec87227e1cb010b433a8b
ffmpeg getFramesBackward(78): md5 = dffcd10146ba07e7b9411be5a92c5ab1
ffmpeg getFramesBackward(77): md5 = dffcd10146ba07e7b9411be5a92c5ab1
ffmpeg getFramesBackward(76): md5 = dffcd10146ba07e7b9411be5a92c5ab1
ffmpeg getFramesBackward(75): md5 = 0fa5666b36d14e22c2d685a2f4b6e85e
ffmpeg getFramesBackward(74): md5 = 0fa5666b36d14e22c2d685a2f4b6e85e
ffmpeg getFramesBackward(73): md5 = 0fa5666b36d14e22c2d685a2f4b6e85e
ffmpeg getFramesBackward(72): md5 = c9aa54c0791a759696f008cc3c968e24
ffmpeg getFramesBackward(71): md5 = c9aa54c0791a759696f008cc3c968e24
ffmpeg getFramesBackward(70): md5 = c9aa54c0791a759696f008cc3c968e24
ffmpeg getFramesBackward(69): md5 = 61b587178a423dcda2bf799e03de1484
ffmpeg getFramesBackward(68): md5 = 61b587178a423dcda2bf799e03de1484
ffmpeg getFramesBackward(67): md5 = 61b587178a423dcda2bf799e03de1484
ffmpeg getFramesBackward(66): md5 = ce0fc3dec90418318499cebc9b941ba9
ffmpeg getFramesBackward(65): md5 = ce0fc3dec90418318499cebc9b941ba9
ffmpeg getFramesBackward(64): md5 = ce0fc3dec90418318499cebc9b941ba9
ffmpeg getFramesBackward(63): md5 = 038a9ed388dc0d91bda47ea0465dc30f
ffmpeg getFramesBackward(62): md5 = 038a9ed388dc0d91bda47ea0465dc30f
ffmpeg getFramesBackward(61): md5 = 038a9ed388dc0d91bda47ea0465dc30f
ffmpeg getFramesBackward(60): md5 = 48caff6d37b2b14e6ad210bcfafa16ab
ffmpeg getFramesBackward(59): md5 = 48caff6d37b2b14e6ad210bcfafa16ab
ffmpeg getFramesBackward(58): md5 = 48caff6d37b2b14e6ad210bcfafa16ab
ffmpeg getFramesBackward(57): md5 = 02eb1aac0e9d4d3c81416e191a20d257
ffmpeg getFramesBackward(56): md5 = 02eb1aac0e9d4d3c81416e191a20d257
ffmpeg getFramesBackward(55): md5 = 02eb1aac0e9d4d3c81416e191a20d257
ffmpeg getFramesBackward(54): md5 = 9bfd5d1cfeecb659a215e7f3d4e5de02
ffmpeg getFramesBackward(53): md5 = 9bfd5d1cfeecb659a215e7f3d4e5de02
ffmpeg getFramesBackward(52): md5 = 9bfd5d1cfeecb659a215e7f3d4e5de02
ffmpeg getFramesBackward(51): md5 = b8b29c18c40c509e2e41a8e4acecfe8f
ffmpeg getFramesBackward(50): md5 = b8b29c18c40c509e2e41a8e4acecfe8f
ffmpeg getFramesBackward(49): md5 = b8b29c18c40c509e2e41a8e4acecfe8f
ffmpeg getFramesBackward(48): md5 = 4c863b95302db3cfa2233451bd2e73b6
ffmpeg getFramesBackward(47): md5 = 4c863b95302db3cfa2233451bd2e73b6
ffmpeg getFramesBackward(46): md5 = 4c863b95302db3cfa2233451bd2e73b6
ffmpeg getFramesBackward(45): md5 = d587512789736d66516ce303114422a9
ffmpeg getFramesBackward(44): md5 = d587512789736d66516ce303114422a9
ffmpeg getFramesBackward(43): md5 = d587512789736d66516ce303114422a9
ffmpeg getFramesBackward(42): md5 = e87d72bd40ea57bc00c4ef50a71f35ef
ffmpeg getFramesBackward(41): md5 = e87d72bd40ea57bc00c4ef50a71f35ef
ffmpeg getFramesBackward(40): md5 = e87d72bd40ea57bc00c4ef50a71f35ef
ffmpeg getFramesBackward(39): md5 = 149870ca6f4a12b847353096b757c164
ffmpeg getFramesBackward(38): md5 = 149870ca6f4a12b847353096b757c164
ffmpeg getFramesBackward(37): md5 = 149870ca6f4a12b847353096b757c164
ffmpeg getFramesBackward(36): md5 = 23d4de81c1f7aa17bd2a7ccd987fae7f
ffmpeg getFramesBackward(35): md5 = 23d4de81c1f7aa17bd2a7ccd987fae7f
ffmpeg getFramesBackward(34): md5 = 23d4de81c1f7aa17bd2a7ccd987fae7f
ffmpeg getFramesBackward(33): md5 = 2a7127004e1b7508f226f8061ed8f2d8
ffmpeg getFramesBackward(32): md5 = 2a7127004e1b7508f226f8061ed8f2d8
ffmpeg getFramesBackward(31): md5 = 2a7127004e1b7508f226f8061ed8f2d8
ffmpeg getFramesBackward(30): md5 = 44653b1d6d363fac2b02c7a3b0a97526
ffmpeg getFramesBackward(29): md5 = 44653b1d6d363fac2b02c7a3b0a97526
ffmpeg getFramesBackward(28): md5 = 44653b1d6d363fac2b02c7a3b0a97526
ffmpeg getFramesBackward(27): md5 = 50777e945146885bdafd34ce5a3b4f4d
ffmpeg getFramesBackward(26): md5 = 50777e945146885bdafd34ce5a3b4f4d
ffmpeg getFramesBackward(25): md5 = 50777e945146885bdafd34ce5a3b4f4d
ffmpeg getFramesBackward(24): md5 = c0882e134e1e664f57974979dc35e31c
ffmpeg getFramesBackward(23): md5 = c0882e134e1e664f57974979dc35e31c
ffmpeg getFramesBackward(22): md5 = c0882e134e1e664f57974979dc35e31c
ffmpeg getFramesBackward(21): md5 = 5ade66c53654918ee20dd41143e29a15
ffmpeg getFramesBackward(20): md5 = 5ade66c53654918ee20dd41143e29a15
ffmpeg getFramesBackward(19): md5 = 5ade66c53654918ee20dd41143e29a15
ffmpeg getFramesBackward(18): md5 = 445b0d22b8f823e3c2de48c559bfaa12
ffmpeg getFramesBackward(17): md5 = 445b0d22b8f823e3c2de48c559bfaa12
ffmpeg getFramesBackward(16): md5 = 445b0d22b8f823e3c2de48c559bfaa12
ffmpeg getFramesBackward(15): md5 = 1a7f0815238b66aef51468fd492029d3
ffmpeg getFramesBackward(14): md5 = 1a7f0815238b66aef51468fd492029d3
ffmpeg getFramesBackward(13): md5 = 1a7f0815238b66aef51468fd492029d3
ffmpeg getFramesBackward(12): md5 = 80847ac09f73b1d6c6d0a4edc46b4aff
ffmpeg getFramesBackward(11): md5 = 80847ac09f73b1d6c6d0a4edc46b4aff
ffmpeg getFramesBackward(10): md5 = 80847ac09f73b1d6c6d0a4edc46b4aff
ffmpeg getFramesBackward(9): md5 = 962ad04cfe5e96c2f0c1bd348369c9e5
ffmpeg getFramesBackward(8): md5 = 962ad04cfe5e96c2f0c1bd348369c9e5
ffmpeg getFramesBackward(7): md5 = 962ad04cfe5e96c2f0c1bd348369c9e5
ffmpeg getFramesBackward(6): md5 = 46f5adce6b22e79e2683e76bd1f8b247
ffmpeg getFramesBackward(5): md5 = 46f5adce6b22e79e2683e76bd1f8b247
ffmpeg getFramesBackward(4): md5 = 46f5adce6b22e79e2683e76bd1f8b247
ffmpeg getFramesBackward(3): md5 = 693aa31b50a57aac4780af051799d9f8
ffmpeg getFramesBackward(2): md5 = 693aa31b50a57aac4780af051799d9f8
ffmpeg getFramesBackward(1): md5 = 693aa31b50a57aac4780af051799d9f8

