/*
 * reducer.c source file for extace
 * 
 /GDK/GNOME sound (esd) system output display program
 * 
 * Based on the original extace written by The Rasterman and Michael Fulbright
 *  
 * 
 * This software comes under the GPL (GNU Public License)
 * You may freely copy,distribute etc. this as long as the source code
 * is made available for FREE.
 * 
 * No warranty is made or implied. You may use this program at your own risk.
 */

#include <config.h>
#include <globals.h>
#include <protos.h>
#include <math.h>


/* See globals.h for variable declarations and DEFINES */


/* pip = vertical line on screen
 * spike = datapoint from output of fft
 * axis_length is length of frequency axis on screen in PIXELS
 * spike_per_pip can go from above 0 up.  (depending on how large the fft is)
 * typically spike per pip is around 0.3-12 depending on FFT length and screen
 * size.
 *
 * This routine does a linear interpolation (well thats what I intended)
 * to smoothly fit the data on screen with minimal distortion.
 */
void reducer(float spike_per_pip,int axis_length)
{
    gint i = 0;
    gint j = 0;
    gfloat pip;
    gfloat running_total = 0.0;
    gfloat pip_total = 0.0;
    gfloat partial = 0.0;
    gint special_case = 0.0;
    gint count = 0;
 
/*    printf("spike_per_pip= %f\n",spike_per_pip); */
    if ((spike_per_pip <= 0.0) || (axis_length <= 0))
	printf("ERROR!!, spike_per_pip %f, axis_length %i\n",spike_per_pip,axis_length);
    pip = spike_per_pip;

    while (i < axis_length)
    {
	if (j >= nsamp)
	    printf("reducer error, disp_val OVERFLOW!!\n");
	count ++;
	if (count >10000)
	{
	    g_print("ERROR in reducer!!!!\n");
	    g_print("Main while loop counter = %i\n",i);
	    g_print("Spikes per pip value = %f\n",spike_per_pip);
	    g_print("Running total = %f\n",running_total);
	    g_print("Email the author with this information so he can fix it\n");
	    exit(-4);
	}

	while (pip >= 1.0)
	{
	    pip_total += disp_val[j]*1.0;
	    pip--;
	    j++;
	}
	if ((pip < 1.0)  && (spike_per_pip > 1.0))
	{
	    pip_total += disp_val[j]*pip;
	    pip_arr[i] = (gint)(pip_total/spike_per_pip);

	    pip_total = disp_val[j]*(1.0-pip);
	    pip = spike_per_pip - (1.0 -pip);
	    j++;
	    i++;
	}
	if (spike_per_pip == 0.5)
	{
	    pip_arr[i] = (gint)disp_val[j]*0.5;
	    i++;
	    if(i%2)
		j++;

	}
	if (spike_per_pip < 1.0 )
	{
	    if (running_total + pip > 1)
	    {
		partial = 1 - running_total;
		special_case = 1;
	    }
	    running_total += pip;
	    if (special_case)
	    {
		pip_total = disp_val[j]*partial;
		j++;
		pip_total += disp_val[j]*(running_total - 1.0);
		special_case = 0;
	    }
	    else
	    {
		pip_total += disp_val[j]*pip;
	    }
	    if (running_total >= 1.0)
	    {
		running_total -= 1.0;
	    }

	    pip_arr[i] = (gint)(pip_total/spike_per_pip);
	    i++;
	    pip_total = 0;

	}

    }
}
