/*
 * color_win.c source file for extace (color picker)
 * 
 * /GDK/GNOME sound (esd) system output display program
 *
 * Based on the original extace written by The Rasterman and Michael Fulbright
 * 
 * Hacked by Dave J. Andruczyk <djandruczyk@yahoo.com>
 * to be fully scalable with lots of new options, for tilting the axis's
 * and various other cool stuff.
 * 
 * This software comes under the GPL (GNU Public License)
 * You may freely copy,distribute etc. this as long as the source code
 * is made available for FREE.
 * 
 * No warranty is made or implied. You use this program at your own risk.
 */

#include <config.h>
#include <globals.h>
#include <protos.h>
#include <configfile.h>
#include <gtk/gtk.h>
#include <string.h>


/* See globals.h for variable declarations and DEFINES */

gint color_event (GtkWidget *widget, GdkEventButton *event, gpointer data)
{

    gdouble colsel_colors[3];
    gint handled = FALSE;
//    printf("Color_event()\n");


    /* Check if we've received a button pressed event */
    
           if (event->type == GDK_BUTTON_PRESS && colorseldlg != NULL)
	   {
	       /* where did the user press the button */
	       color_loc = widget->allocation.height - event->y;
	       colsel_colors[0] = cr[color_loc]/256.0;
	       colsel_colors[1] = cg[color_loc]/256.0;
	       colsel_colors[2] = cb[color_loc]/256.0;


	       /* Set the color in the selction dialog to wherever we clicked */

	       gtk_color_selection_set_color (GTK_COLOR_SELECTION(colorseldlg),colsel_colors);


	   }

    return handled;

}
int color_button(GtkWidget *widget, gpointer data)
{
    GtkWidget * filew;
//    printf("Color_button()\n");
    if (data == (gpointer)SET_COLOR)
    {
	update_gradient(NULL, color_loc);
	init_colortab();
	gradient_update();
	
    }
    else if (data == (gpointer)CLOSE)
    {
	gtk_widget_hide(grad_win_ptr);
	grad_win_present = 0;
    }
    else if (data == (gpointer)SAVE)
    {
	filew = gtk_file_selection_new("Save Colormap");
	gtk_signal_connect (GTK_OBJECT(filew), "destroy",
		(GtkSignalFunc) gtk_widget_destroy, GTK_OBJECT (filew));
	gtk_signal_connect(GTK_OBJECT (GTK_FILE_SELECTION (filew)->ok_button),
		"clicked", (GtkSignalFunc) file_ok_save, filew);
	gtk_signal_connect_object(GTK_OBJECT (GTK_FILE_SELECTION
		    (filew)->cancel_button),
		"clicked", (GtkSignalFunc) gtk_widget_destroy,
		GTK_OBJECT (filew));
	gtk_file_selection_set_filename(GTK_FILE_SELECTION(filew),g_strconcat(g_get_home_dir(),"/.eXtace/ColorMaps/", NULL));
	gtk_widget_show(filew);
    }
    else if (data == (gpointer)LOAD)
    {
	filew = gtk_file_selection_new("Load Colormap");
	gtk_signal_connect (GTK_OBJECT(filew), "destroy",
		(GtkSignalFunc) gtk_widget_destroy, GTK_OBJECT (filew));
	gtk_signal_connect(GTK_OBJECT (GTK_FILE_SELECTION (filew)->ok_button),
		"clicked", (GtkSignalFunc) file_ok_load, filew);
	gtk_signal_connect_object(GTK_OBJECT (GTK_FILE_SELECTION
		    (filew)->cancel_button),
		"clicked", (GtkSignalFunc) gtk_widget_destroy,
		GTK_OBJECT (filew));
	gtk_file_selection_set_filename(GTK_FILE_SELECTION(filew),g_strconcat(g_get_home_dir(), "/.eXtace/ColorMaps/", NULL));
	gtk_widget_show(filew);
    }
    return TRUE;
}
void create_initial_colormaps(void)
{
    gint temp_array[] = { \
	/* 5 RGB triplets deterimine the color gradient */
	/*  steps R1  G1  B1  R2  G2  B2  R3  G3  B3  R4  G4  B4  R5  G5  B5  */
/*AuthFav*/  5,   19, 17, 18,160, 40,140,210,130, 20,240,200, 20,255,240, 80, \
/*Autumn*/   5,  255,  0,  0,255, 64,  0,255,128,  0,255,191,  0,255,255,  0, \
/*B&W*/	     5,    1,  1,  1, 65, 63, 65,118,113,116,182,182,188,240,241,246, \
/*Bone*/     5,    0,  0, 32, 56, 88, 88,122,143,143,189,199,199,255,255,255, \
/*Cool*/     5,    0,255,255, 64,191,255,128,128,255,191, 64,255,255,  0,255, \
/*Copper*/   5,    0,  0,  0, 80, 50, 32,159,100, 63,239,149, 95,255,199,127, \
/*Default*/  5,   30,  0,160,160, 40,140,210,130, 20,240,200, 20,255,240, 80, \
/*FireEngRd*/5,   16,  0,  0, 67,  2,  5,139,  1,  7,136,  0,  0,247,  3, 10, \
/*Flag*/     5,  255,  0,  0,255,255,255,  0,  0,255,  0,  0,  0,255,  0,  0, \
/*GreenScrn*/5,    0,  2,  0,  4, 45,  1,  9,104,  5, 21,184,  7, 16,245, 18, \
/*Hot*/      5,  255,  0,  0,255,255,  0,255,255, 85,255,255,170,255,255,255, \
/*HSV*/      5,  255,  0,  0,204,255,  0,  0,255,102,  0,102,255,204,  0,255, \
/*Inv B&W*/  5,  245,245,254,191,185,193,118,113,116, 78, 76, 79,  1,  1,  1, \
/*Jet*/	     5,    0,  0,128,  0,255,255,255,255,255,255,255,  0,128,  0,  0, \
/*Pink*/     5,  147,  0,  0,180,180,104,208,208,170,233,233,217,255,255,255, \
/*Spring*/   5,  255,  0,255,255, 64,191,255,128,128,255,191, 64,255,255,  0, \
/*Summer*/   5,    0,128,102, 64,159,102,128,191,102,191,223,102,255,255,102, \
/*Blues*/    5,    0,  1, 18,  3,  6, 83,  6,  4,147, 11, 10,192,  6,  9,251, \
/*Winter*/   5,    0,  0,255,  0, 64,223,  0,128,191,  0,191,159,  0,255,128 };

    gchar * filename;
    ConfigFile *cfgfile;
    gint i = 0;
    gint x = 0;
    gchar * names[] = {"Authors_Favorite","Autumn","Black_n_White","Bone","Cool","Copper", "Default","Fire_Engine_Red","Flag","Green_Screen","Hot","HSV","Inverse_BW","Jet","Pink","Spring","Summer","The_Blues","Winter","NULL"};
//    printf("create_initial_colormaps()\n");

    /* Setup at least one default one */
    start->red=30;start->green=0;start->blue=160;
    pt2->red=160;pt2->green=40;pt2->blue=140;
    pt3->red=210;pt3->green=130;pt3->blue=20;
    pt4->red=240;pt4->green=200;pt4->blue=20;
    end->red=255;end->green=240;end->blue=80;

    while (strcmp("NULL",names[i]))
    {
	filename = g_strconcat(g_get_home_dir(), "/.eXtace/ColorMaps/", names[i],NULL);
	cfgfile = extace_cfg_open_file(filename);
	if (!cfgfile)
	    cfgfile = extace_cfg_new();
	else
	{
	    x+=16; /* Move up to next set of vars for colormap */
	    i++;
	    extace_cfg_free(cfgfile);
	    g_free(filename);
	    continue;
	}
	extace_cfg_write_int(cfgfile, "General", "steps", temp_array[x++]);
	extace_cfg_write_int(cfgfile, "Colormap", "red_start", temp_array[x++]);
	extace_cfg_write_int(cfgfile, "Colormap", "green_start", temp_array[x++]);
	extace_cfg_write_int(cfgfile, "Colormap", "blue_start", temp_array[x++]);
	extace_cfg_write_int(cfgfile, "Colormap", "red_pt2", temp_array[x++]);
	extace_cfg_write_int(cfgfile, "Colormap", "green_pt2", temp_array[x++]);
	extace_cfg_write_int(cfgfile, "Colormap", "blue_pt2", temp_array[x++]);
	extace_cfg_write_int(cfgfile, "Colormap", "red_pt3", temp_array[x++]);
	extace_cfg_write_int(cfgfile, "Colormap", "green_pt3", temp_array[x++]);
	extace_cfg_write_int(cfgfile, "Colormap", "blue_pt3", temp_array[x++]);
	extace_cfg_write_int(cfgfile, "Colormap", "red_pt4", temp_array[x++]);
	extace_cfg_write_int(cfgfile, "Colormap", "green_pt4", temp_array[x++]);
	extace_cfg_write_int(cfgfile, "Colormap", "blue_pt4", temp_array[x++]);
	extace_cfg_write_int(cfgfile, "Colormap", "red_end", temp_array[x++]);
	extace_cfg_write_int(cfgfile, "Colormap", "green_end", temp_array[x++]);
	extace_cfg_write_int(cfgfile, "Colormap", "blue_end", temp_array[x++]);
	extace_cfg_write_file(cfgfile, filename);
	extace_cfg_free(cfgfile);

	g_free(filename);


	i++;
    }
}
void file_ok_save(GtkWidget * widget, GtkFileSelection *filesel)
{
    /* This routine needs to be rewritten for the new colortable file format
     * The new format has a variable number of steps (up to 50 or so).
     * Thus the file has to store hte number of steps, and their positions 
     * in the map. (percentage of height sound simple enuf to me..)
     */

    gchar * filename;
    ConfigFile *cfgfile;
//    printf("file_ok_save\n");

    filename = g_strconcat(gtk_file_selection_get_filename(GTK_FILE_SELECTION(filesel)),NULL);
    
    cfgfile = extace_cfg_open_file(filename);
    if (!cfgfile)
	cfgfile = extace_cfg_new();
    extace_cfg_write_int(cfgfile, "Colormap", "red_start", start->red);
    extace_cfg_write_int(cfgfile, "Colormap", "green_start", start->green);
    extace_cfg_write_int(cfgfile, "Colormap", "blue_start", start->blue);
    extace_cfg_write_int(cfgfile, "Colormap", "red_pt2", pt2->red);
    extace_cfg_write_int(cfgfile, "Colormap", "green_pt2", pt2->green);
    extace_cfg_write_int(cfgfile, "Colormap", "blue_pt2", pt2->blue);
    extace_cfg_write_int(cfgfile, "Colormap", "red_pt3", pt3->red);
    extace_cfg_write_int(cfgfile, "Colormap", "green_pt3", pt3->green);
    extace_cfg_write_int(cfgfile, "Colormap", "blue_pt3", pt3->blue);
    extace_cfg_write_int(cfgfile, "Colormap", "red_pt4", pt4->red);
    extace_cfg_write_int(cfgfile, "Colormap", "green_pt4", pt4->green);
    extace_cfg_write_int(cfgfile, "Colormap", "blue_pt4", pt4->blue);
    extace_cfg_write_int(cfgfile, "Colormap", "red_end", end->red);
    extace_cfg_write_int(cfgfile, "Colormap", "green_end", end->green);
    extace_cfg_write_int(cfgfile, "Colormap", "blue_end", end->blue);
    extace_cfg_write_file(cfgfile, filename);
    extace_cfg_free(cfgfile);

    colormap_in_use = g_strdup(filename);

    g_free(filename);

    gtk_widget_hide(GTK_WIDGET(filesel));
}

void file_ok_load(GtkWidget * widget, GtkFileSelection *filesel)
{
    gchar * filename;
//    printf("file_ok_load\n");
    filename = g_strdup(gtk_file_selection_get_filename(GTK_FILE_SELECTION(filesel)));
    read_colormap(filename);
    gtk_widget_hide(GTK_WIDGET(filesel));
    init_colortab();
    gradient_update();
}
void read_colormap(char * filename)
{
    /* This routine needs to be rewritten for the new colortable file format
     * The new format has a variable number of steps (up to 50 or so).
     * Thus the file has to store hte number of steps, and their positions 
     * in the map. (percentage of height sound simple enuf to me..)
     */

    ConfigFile *cfgfile;
    gint steps=0;
    gint older = 0;
    gint temp_array[15];
//    printf("read_colormap\n");

    
    cfgfile = extace_cfg_open_file(filename);
    /* For some reason I can't figure out I cannot use the read functions
     * below to read directly into the structures (start.red and so on) so
     * I used this functional hack, which I'd like to remove eventually.
     * (using the temporary storage array.. :( 
     */
    if (cfgfile)
    {
	extace_cfg_read_int(cfgfile, "General", "Steps", &steps);
	if (steps == 0)
	{
/*	    This is an older file, we should convert it to the newer format. */
	    older = 1;
	}

	extace_cfg_read_int(cfgfile, "Colormap", "red_start", &temp_array[0]);
	extace_cfg_read_int(cfgfile, "Colormap", "green_start", &temp_array[1]);
	extace_cfg_read_int(cfgfile, "Colormap", "blue_start", &temp_array[2]);
	extace_cfg_read_int(cfgfile, "Colormap", "red_pt2", &temp_array[3]);
	extace_cfg_read_int(cfgfile, "Colormap", "green_pt2", &temp_array[4]);
	extace_cfg_read_int(cfgfile, "Colormap", "blue_pt2", &temp_array[5]);
	extace_cfg_read_int(cfgfile, "Colormap", "red_pt3", &temp_array[6]);
	extace_cfg_read_int(cfgfile, "Colormap", "green_pt3", &temp_array[7]);
	extace_cfg_read_int(cfgfile, "Colormap", "blue_pt3", &temp_array[8]);
	extace_cfg_read_int(cfgfile, "Colormap", "red_pt4", &temp_array[9]);
	extace_cfg_read_int(cfgfile, "Colormap", "green_pt4", &temp_array[10]);
	extace_cfg_read_int(cfgfile, "Colormap", "blue_pt4", &temp_array[11]);
	extace_cfg_read_int(cfgfile, "Colormap", "red_end", &temp_array[12]);
	extace_cfg_read_int(cfgfile, "Colormap", "green_end", &temp_array[13]);
	extace_cfg_read_int(cfgfile, "Colormap", "blue_end", &temp_array[14]);

	extace_cfg_free(cfgfile);

	start->red = temp_array[0] < 255 ? temp_array[0] : 255;
	start->green = temp_array[1] < 255 ? temp_array[1] : 255;
	start->blue = temp_array[2] < 255 ? temp_array[2] : 255;
	pt2->red = temp_array[3] < 255 ? temp_array[3] : 255;
	pt2->green = temp_array[4] < 255 ? temp_array[4] : 255;
	pt2->blue = temp_array[5] < 255 ? temp_array[5] : 255;
	pt3->red = temp_array[6] < 255 ? temp_array[6] : 255;
	pt3->green = temp_array[7] < 255 ? temp_array[7] : 255;
	pt3->blue = temp_array[8] < 255 ? temp_array[8] : 255;
	pt4->red = temp_array[9] < 255 ? temp_array[9] : 255;
	pt4->green = temp_array[10] < 255 ? temp_array[10] : 255;
	pt4->blue = temp_array[11] < 255 ? temp_array[11] : 255;
	end->red = temp_array[12] < 255 ? temp_array[12] : 255;
	end->green = temp_array[13] < 255 ? temp_array[13] : 255;
	end->blue = temp_array[14] < 255 ? temp_array[14] : 255;

	colormap_in_use = g_strdup(filename);
    }
    else
    {
	g_free(colormap_in_use);
	colormap_in_use = (gchar *)NULL;
    }
    g_free(filename);
}

void update_gradient(GtkWidget *widget, int y)
{
    gdouble color[3];

//    printf("update_gradient\n");

    /* Get current color where we clicked */
    gtk_color_selection_get_color (GTK_COLOR_SELECTION(colorseldlg),color);

    /* Fit to a unsigned 16 bit integer (0..65535) and
     * insert into the GdkColor structure */

    temp_color.red = (guint16)(color[0]*255);
    temp_color.green = (guint16)(color[1]*255);
    temp_color.blue = (guint16)(color[2]*255);

/*    y = MAXBANDS-y; */
    if (y <= 1*(MAXBANDS/8)) /* start color */
	*start = temp_color;
    if ((y > 1*(MAXBANDS/8)) && (y <= 3*(MAXBANDS/8))) /* part 2 color */
	*pt2 = temp_color;
    if ((y > 3*(MAXBANDS/8)) && (y <= 5*(MAXBANDS/8))) /* part 3 color */
	*pt3 = temp_color;
    if ((y > 5*(MAXBANDS/8)) && (y <= 7*(MAXBANDS/8))) /* part 4 color */
	*pt4 = temp_color;
    if (y > 7*(MAXBANDS/8)) /* end color */
	*end = temp_color;
}

void init_colortab()
{
    gint i,j;
    gint w, h;
    gint r,g,b;
    unsigned char *data;
//    printf("init_colortab\n");

    j=0;
//    if ((colormap_in_use) && (!force))
//	read_colormap(colormap_in_use);
//    printf("rgb endpts, %i,%i,%i\n",pt2->red,pt2->green,pt2->blue);
    for(i=0;i<(MAXBANDS/4);i++)
    {
	cr[j]=(((((MAXBANDS/4)-1)-i)*start->red)+(i*pt2->red))/((MAXBANDS/4)-1);
	cg[j]=(((((MAXBANDS/4)-1)-i)*start->green)+(i*pt2->green))/((MAXBANDS/4)-1);
	cb[j]=(((((MAXBANDS/4)-1)-i)*start->blue)+(i*pt2->blue))/((MAXBANDS/4)-1);
	j++;
    }
//    printf("rgb endpts, %i,%i,%i\n",pt3->red,pt3->green,pt3->blue);
    for(i=0;i<(MAXBANDS/4);i++)
    {
	cr[j]=(((((MAXBANDS/4)-1)-i)*pt2->red)+(i*pt3->red))/((MAXBANDS/4)-1);
	cg[j]=(((((MAXBANDS/4)-1)-i)*pt2->green)+(i*pt3->green))/((MAXBANDS/4)-1);
	cb[j]=(((((MAXBANDS/4)-1)-i)*pt2->blue)+(i*pt3->blue))/((MAXBANDS/4)-1);
	j++;
    }
 //   printf("rgb endpts, %i,%i,%i\n",pt4->red,pt4->green,pt4->blue);
    for(i=0;i<MAXBANDS/4;i++)
    {
	cr[j]=(((((MAXBANDS/4)-1)-i)*pt3->red)+(i*pt4->red))/((MAXBANDS/4)-1);
	cg[j]=(((((MAXBANDS/4)-1)-i)*pt3->green)+(i*pt4->green))/((MAXBANDS/4)-1);
	cb[j]=(((((MAXBANDS/4)-1)-i)*pt3->blue)+(i*pt4->blue))/((MAXBANDS/4)-1);
	j++;
    }
//    printf("rgb endpts, %i,%i,%i\n",end->red,end->green,end->blue);
    for(i=0;i<MAXBANDS/4;i++)
    {
	cr[j]=((((MAXBANDS/4-1)-i)*pt4->red)+(i*end->red))/(MAXBANDS/4-1);
	cg[j]=((((MAXBANDS/4-1)-i)*pt4->green)+(i*end->green))/(MAXBANDS/4-1);
	cb[j]=((((MAXBANDS/4-1)-i)*pt4->blue)+(i*end->blue))/(MAXBANDS/4-1);
	j++;
    }
    for(i=0;i<MAXBANDS;i++)
    {
	for(j=0;j<MAXBANDS;j++)
	{
	    r=cr[j]+((i-16)*2);
	    g=cg[j]+((i-16)*2);
	    b=cb[j]+((i-16)*2);
	    if (r < 0) r=0;
	    else if (r > 255) r=255;
	    if (g < 0) g=0;
	    else if (g > 255) g=255;
	    if (b < 0) b=0;
	    else if (b > 255) b=255;
	    colortab[i][j]=gdk_imlib_best_color_match(&r,&g,&b);
	}
    }
    data=malloc(MAXBANDS*3);
    memset((void *)data, 0, MAXBANDS*3);
    for(i=0;i<MAXBANDS;i++)
    {
	data[i*3]=cr[i];
	data[(i*3)+1]=cg[i];
	data[(i*3)+2]=cb[i];
    }
    im=gdk_imlib_create_image_from_data(data,NULL,1,MAXBANDS);
    free(data);
    w=MAXBANDS;
    h=im->rgb_height;

    for(i=128;i<256;i++)
    {
	gdk_imlib_render(im,1,i-127);
	grad[i]=gdk_imlib_move_image(im);
    }
    gdk_imlib_flip_image_vertical(im);
    for(i=0;i<127;i++)
    {
	gdk_imlib_render(im,1,127-i);
	grad[i]=gdk_imlib_move_image(im);
    }
    colortab_ready = 1;
//    if (ready)
//	grad_win_create();
//    else if ((!ready) && (grad_win_present)) /* from past run i.e. conf file */
//	grad_win_create();	
//    gdk_imlib_kill_image(im);

//    gradient_update();
}

void grad_win_create()
{
    GtkWidget * hbox = NULL;
    GtkWidget * grad_win = NULL;
    GtkWidget * vbox = NULL;
    GtkWidget * eventbox = NULL;
    GtkWidget *	frame = NULL;
    GtkWidget * button = NULL;
    GtkWidget * sep = NULL;

//    printf("grad_win_create\n");

    if(!grad_win)
    {
	grad_win = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	grad_win_ptr = grad_win;
	gtk_widget_set_uposition(grad_win,grad_x_origin,grad_y_origin);
	gtk_window_set_title(GTK_WINDOW(grad_win),"Color Picker");
	gtk_window_set_policy(GTK_WINDOW(grad_win), 
		FALSE,		/* allow shrink */
		FALSE,		/* allow grow */
		FALSE);		/* auto shrink */
	gtk_signal_connect(GTK_OBJECT(grad_win),"delete_event",
		GTK_SIGNAL_FUNC(close_grad_win),NULL);

	hbox = gtk_hbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(grad_win), hbox);

	frame = gtk_frame_new("Colormap");
	gtk_box_pack_start(GTK_BOX(hbox),frame,TRUE,TRUE,0);

	eventbox = gtk_event_box_new();
	gtk_container_add(GTK_CONTAINER(frame),eventbox);
	gtk_widget_set_events (eventbox, GDK_BUTTON_PRESS_MASK);
	gtk_signal_connect(GTK_OBJECT(eventbox), "button_press_event",
		(GtkSignalFunc) color_event, NULL);
	gtk_signal_connect(GTK_OBJECT(eventbox), "focus_out_event",
		(GtkSignalFunc) grad_win_save_state, NULL);
	gtk_signal_connect(GTK_OBJECT(eventbox), "motion_notify_event",
		(GtkSignalFunc) motion_notify_event, NULL);
	gtk_widget_set_events (eventbox,GDK_BUTTON_PRESS_MASK
		| GDK_EXPOSURE_MASK
		| GDK_FOCUS_CHANGE_MASK);

	gtk_widget_set_usize(eventbox,256,256);
	gtk_widget_realize(eventbox);


	grad_disp = gtk_drawing_area_new();
	gtk_container_add(GTK_CONTAINER(eventbox),grad_disp);

	gtk_widget_show(grad_disp);
	gtk_widget_realize(grad_disp);

	vbox = gtk_vbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),vbox,TRUE,TRUE,0);

	frame = gtk_frame_new("Color Selector");
	gtk_box_pack_start(GTK_BOX(vbox),frame,FALSE,TRUE,0);

	colorseldlg = gtk_color_selection_new();

	gtk_container_add(GTK_CONTAINER(frame),colorseldlg);

	sep = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(vbox),sep,TRUE,TRUE,0);

	hbox = gtk_hbox_new(TRUE,0);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);

	button = gtk_button_new_with_label("Set Color");
	gtk_box_pack_start(GTK_BOX(hbox),button,TRUE,TRUE,0);
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
		(GtkSignalFunc)color_button, (gpointer)SET_COLOR);

	button = gtk_button_new_with_label("Close");
	gtk_box_pack_start(GTK_BOX(hbox),button,TRUE,TRUE,0);
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
		(GtkSignalFunc)color_button, (gpointer)CLOSE);

	hbox = gtk_hbox_new(TRUE,0);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);

	button = gtk_button_new_with_label("Save");
	gtk_box_pack_start(GTK_BOX(hbox),button,TRUE,TRUE,0);
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
		(GtkSignalFunc)color_button, (gpointer)SAVE);

	button = gtk_button_new_with_label("Load");
	gtk_box_pack_start(GTK_BOX(hbox),button,TRUE,TRUE,0);
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
		(GtkSignalFunc)color_button, (gpointer)LOAD);

	gtk_widget_show_all(grad_win);
    }
    if (!grad_pixmap)
    {

	 grad_pixmap = gdk_pixmap_new(grad_disp->window,width,height,
				 gtk_widget_get_visual(grad_disp)->depth);
//	 init_colortab();
    }
}

void gradient_update()
{
//    gdk_imlib_flip_image_vertical(im);
    int h = MAXBANDS;
    int w = MAXBANDS;
//    printf("gradient_update()\n");

    if (grad_win_ptr)
    {
	if (colortab_ready == 0)
	{
	    init_colortab();
	}
	gdk_imlib_render(im,w,h);
	grad_pixmap=gdk_imlib_move_image(im);

	gdk_window_set_back_pixmap(grad_disp->window,grad_pixmap,0);

	gdk_draw_pixmap(grad_disp->window,
		grad_disp->style->fg_gc[GTK_WIDGET_STATE (grad_disp)],
		grad_pixmap,
		0,0,
		0,0,
		w,h);
	if (!grad_win_present)
	{
	    gtk_widget_show(grad_win_ptr);
	    gtk_widget_set_uposition(grad_win_ptr,grad_x_origin,grad_y_origin);
	    grad_win_present = 1;
	}
    }
}



gint grad_win_save_state(GtkWidget *widget, GdkEventFocus *event)
{
    int x,y;
//    printf("grad_win_save_state\n");
    if(!grad_win_present)
	return TRUE;
    if (!event->in)
    {
	gdk_window_get_root_origin((gpointer) grad_win_ptr->window, &x, &y);
	grad_x_origin = x;
	grad_y_origin = y;
    }

    return FALSE;
}
