/*
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: mdregmgr
 * File: raid5_mgr.h
 */

#ifndef _RAID5_MGR_H_
#define _RAID5_MGR_H_ 1

typedef struct disk_info_s {
	md_member_t             *dev;
	int                     operational;
	int                     number;
	int                     raid_disk;
	int                     write_only;
	int                     spare;
	int                     used_slot;
} disk_info_t;

typedef struct chunk_s {
	md_member_t *    dev;
	lsn_t            lsn_on_dev;
	unsigned char    *data;
} chunk_t;


typedef struct stripe_s {
	md_volume_t   * volume;
	unsigned long   number;
	lsn_t           start_lsn;
	sector_count_t  data_size;
	u_int32_t        nr_disks;
	chunk_t         *chunks;
} stripe_t;

typedef struct raid5_private_data {
	md_volume_t             *mddev;
	disk_info_t             *disks;
	disk_info_t             spare;
	u_int64_t                chunksize;      // in sectors
	u_int64_t		size;            // in sectors
	int                     level;
	int                     algorithm;
	int                     raid_disks;
	int                     active_disks;
	int                     spare_disks;
	int                     failed_disks;
	int                     failed_raid_disks;
	int                     failed_disk_index;
	stripe_t                stripe;
} raid5_conf_t;


#define mdvol_to_conf(mdvol) ((raid5_conf_t *) mdvol->private_data)



typedef struct kill_sectors_s {
	storage_object_t      * region;
	lsn_t                   lsn;
	sector_count_t          count;
	struct kill_sectors_s * next;
} kill_sectors_t;


/********************/
/* "Create" options */
/********************/

/*
 * Our supported RAID levels
 */
#define RAID4_LEVEL_NAME	"RAID4"
#define RAID5_LEVEL_NAME	"RAID5"


/*
 * Names of our supported algorithms
 */
#define ALGORITHM_LEFT_ASYMMETRIC_NAME  _("Left Asymmetric")
#define ALGORITHM_RIGHT_ASYMMETRIC_NAME _("Right Asymmetric")
#define ALGORITHM_LEFT_SYMMETRIC_NAME   _("Left Symmetric")
#define ALGORITHM_RIGHT_SYMMETRIC_NAME  _("Right Symmetric")


#define RAID5_CREATE_OPT_SB1_INDEX              0
#define RAID5_CREATE_OPT_SB1_NAME               "ver1_superblock"
#define RAID5_CREATE_OPT_SPARE_DISK_INDEX       1
#define RAID5_CREATE_OPT_SPARE_DISK_NAME        "sparedisk"
#define RAID5_CREATE_OPT_CHUNK_SIZE_INDEX       2
#define RAID5_CREATE_OPT_CHUNK_SIZE_NAME        "chunksize"
#define RAID5_CREATE_OPT_RAID_LEVEL_INDEX       3
#define RAID5_CREATE_OPT_RAID_LEVEL_NAME        "level"
#define RAID5_CREATE_OPT_PARITY_ALGORITHM_INDEX 4
#define RAID5_CREATE_OPT_PARITY_ALGORITHM_NAME  "algorithm"
#define RAID5_CREATE_NO_SELECTION               _("None")

#define MD_CREATE_OPTIONS_COUNT			5


/*
 * Plug-in functions
 */
#define MD_RAID5_FUNCTION_ADD_SPARE		EVMS_Task_Plugin_Function
#define MD_RAID5_FUNCTION_REMOVE_SPARE  	(EVMS_Task_Plugin_Function + 1)
#define MD_RAID5_FUNCTION_REMOVE_FAULTY 	(EVMS_Task_Plugin_Function + 2)
#define MD_RAID5_FUNCTION_MARK_FAULTY   	(EVMS_Task_Plugin_Function + 3)
#define MD_RAID5_FUNCTION_REMOVE_STALE		(EVMS_Task_Plugin_Function + 4)

#define MD_RAID5_FUNCTION_COUNT			5

#define RAID5_EXPAND_OPTION_COUNT       0
#define RAID5_SHRINK_OPTION_COUNT       0

#define RAID5_MIN_RAID_DISKS            3

/*
 * The following definitions and structures were taken from
 * <linux/evms/evms_md_k.h> and <linux/evms/evms_raid5.h>.  Keep them in sync
 * with the definitions in that file. That file cannot be included here because
 * it pulls in other kernel header files that do not like to be compiled in user
 * space.
 */
#define ALGORITHM_LEFT_ASYMMETRIC	0
#define ALGORITHM_RIGHT_ASYMMETRIC	1
#define ALGORITHM_LEFT_SYMMETRIC	2
#define ALGORITHM_RIGHT_SYMMETRIC	3

#define MD_RAID5_CONFIG_CHANGE_PENDING		(1<<0)
#define MD_RAID5_EXPAND_PENDING			(1<<1)
#define MD_RAID5_SHRINK_PENDING			(1<<2)
#define MD_RAID5_UNWIND_EXPANSION_PENDING	(1<<3)
#define MD_RAID5_RESUME_SHRINKING_PENDING	(1<<4)

int raid5_resume_shrinking( storage_object_t *region);
int raid5_unwind_expansion( storage_object_t *region);

/* RAID5 plugin functions */
int raid5_add_spare_disk(md_volume_t * volume, storage_object_t * spare);
int raid5_remove_spare_disk(md_volume_t * volume, storage_object_t * spare);
int raid5_remove_faulty_disk(md_volume_t * volume, storage_object_t * faulty);
int raid5_remove_stale_disk(md_volume_t * volume, storage_object_t * stale);
int raid5_mark_faulty_disk(md_volume_t * volume, storage_object_t * active);


#endif

