/*
 *
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *   Module: libgpt.so
 *
 *   File: options.h
 */

#ifndef   GPT_OPTIONS_HEADER
#define   GPT_OPTIONS_HEADER 1


//
// Create
//
#define   SEG_CREATE_OPTION_COUNT                   2
#define   SEG_CREATE_OPTION_SIZE_INDEX              0
#define   SEG_CREATE_OPTION_SIZE_NAME               "Size"
#define   SEG_CREATE_OPTION_OFFSET_INDEX            1
#define   SEG_CREATE_OPTION_OFFSET_NAME             "Offset"
// #define   SEG_CREATE_OPTION_TYPE_INDEX              2
// #define   SEG_CREATE_OPTION_TYPE_NAME               "Type"


//
// Assign
//
#define SEG_ASSIGN_OPTION_COUNT                   1
#define SEG_ASSIGN_OPTION_SYSPARTITION_INDEX      0
#define SEG_ASSIGN_OPTION_SYSPARTITION_NAME       "Create System Partition"

//
// Expand Option Info
//
#define SEG_EXPAND_OPTION_COUNT                     1
#define SEG_EXPAND_OPTION_SIZE_INDEX                0
#define SEG_EXPAND_OPTION_SIZE_NAME                 "Size"


//
// Shrink Option Info
//
#define SEG_SHRINK_OPTION_COUNT                     1
#define SEG_SHRINK_OPTION_SIZE_INDEX                0
#define SEG_SHRINK_OPTION_SIZE_NAME                 "Size"



//
//  Seg Info
//
#define SEG_INFO_COUNT            6
#define SEG_INFO_NAME_INDEX       0
#define SEG_INFO_SIZE_INDEX       1
#define SEG_INFO_START_INDEX      2
#define SEG_INFO_TYPE_INDEX       3
#define SEG_INFO_GUIDT_INDEX      4
#define SEG_INFO_GUIDI_INDEX      5



//
//  Metadata Info
//
#define GPT_HEADER_INFO_COUNT             10
#define GPT_HEADER_INFO_VERSION_INDEX     0
#define GPT_HEADER_INFO_HDRSIZE_INDEX     1
#define GPT_HEADER_INFO_MYLBA_INDEX       2
#define GPT_HEADER_INFO_ALTLBA_INDEX      3
#define GPT_HEADER_INFO_START_INDEX       4
#define GPT_HEADER_INFO_END_INDEX         5
#define GPT_HEADER_INFO_GUID_INDEX        6
#define GPT_HEADER_INFO_PTBLLBA_INDEX     7
#define GPT_HEADER_INFO_PCOUNT_INDEX      8
#define GPT_HEADER_INFO_PNUM_INDEX        9


//
//  Plugin Info
//
#define SEG_PLUGIN_INFO_COUNT                    6
#define SEG_PLUGIN_INFO_SNAME_INDEX              0
#define SEG_PLUGIN_INFO_LNAME_INDEX              1
#define SEG_PLUGIN_INFO_TYPE_INDEX               2
#define SEG_PLUGIN_INFO_VERSION_INDEX            3
#define SEG_PLUGIN_INFO_REQENGSVCVERSION_INDEX   4
#define SEG_PLUGIN_INFO_REQPLUGAPIVERSION_INDEX  5



//
// Priate Plugin Functions
//
#define SEG_MOVE_OPTION_COUNT                     1

#define EVMS_Task_GPT_Move_Segment  (EVMS_Task_Plugin_Function+1)

#define SEG_MOVE_OPTION_INDEX            0
#define SEG_MOVE_OPTION_NAME             "Move"


int         GPT_GetOptionCount(task_context_t * task);

int         GPT_InitTask(task_context_t * context);

int         GPT_SetOption( task_context_t * context, u_int32_t index, value_t * value, u_int32_t * info );

int         GPT_GetInfo( storage_object_t  * object, extended_info_array_t **info);

int         GPT_GetMetadataInfo(storage_object_t * object, extended_info_array_t **info_array);

int         GPT_GetPluginInfo( char * descriptor_name, extended_info_array_t * * info );

int         GPT_SetObjects( task_context_t * context,
                            list_anchor_t    declined_objects,
                            task_effect_t  * effect );
#endif

