# -*- coding: utf-8 -*-

# Copyright (c) 2006 - 2008 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Compatibility module to use the KDE Print Dialog instead of the Qt Print Dialog.
"""

# TODO: KDE 4
# Delete this file by the setup() method of KQPrinter, change all calls to
# the KQPrintDialog to use the setup() method.

import os

import Preferences

try:
    raise ImportError

except (ImportError, RuntimeError):
    os.environ["e4nokde"] = "1"

from PyQt4.QtGui import QPrintDialog
class __qtKQPrintDialog(QPrintDialog):
    """
    Compatibility class to use the Qt Print Dialog.
    """
    pass

################################################################################

def KQPrintDialog(printer, parent = None):
    """
    Public function to instantiate a printer dialog object.
    
    @param printer reference to the printer object
    @param parent reference to the parent widget (QWidget)
    @return reference to the printer dialog object
    """
    if Preferences.getUI("UseKDEDialogs") and not os.getenv("e4nokde"):
        return __kdeKQPrintDialog(printer, parent)
    else:
        return __qtKQPrintDialog(printer, parent)
