
! Copyright (C) 2014 J. K. Dewhurst, S. Sharma and E. K. U. Gross.
! This file is distributed under the terms of the GNU General Public License.
! See the file COPYING for license details.

complex(8) function rzfinp(rfmt,rfir,zfmt,zfir)
use modmain
use modomp
implicit none
! arguments
real(8), intent(in) :: rfmt(npcmtmax,natmtot),rfir(ngtot)
complex(8), intent(in) :: zfmt(npcmtmax,natmtot),zfir(ngtot)
! local variables
integer is,ias,ir,nthd
! external functions
complex(8) rzfmtinp
external rzfmtinp
! interstitial contribution
rzfinp=(cfunir(1)*rfir(1))*zfir(1)
do ir=2,ngtot
  rzfinp=rzfinp+(cfunir(ir)*rfir(ir))*zfir(ir)
end do
rzfinp=rzfinp*(omega/dble(ngtot))
! muffin-tin contribution
call omp_hold(natmtot,nthd)
!$OMP PARALLEL DEFAULT(SHARED) &
!$OMP PRIVATE(is) REDUCTION(+:rzfinp) &
!$OMP NUM_THREADS(nthd)
!$OMP DO
do ias=1,natmtot
  is=idxis(ias)
  rzfinp=rzfinp+rzfmtinp(nrcmt(is),nrcmti(is),rcmt(:,is),r2cmt(:,is), &
   rfmt(:,ias),zfmt(:,ias))
end do
!$OMP END DO
!$OMP END PARALLEL
call omp_free(nthd)
return
end function

