# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

"""
MediaProvider that can access to Elisa's media db
"""


__maintainer__ = 'Lionel Martin <lionel@fluendo.com>'

from elisa.base_components.media_provider import MediaProvider
from elisa.core.media_uri import MediaUri
from elisa.core import common
from twisted.internet import defer

from elisa.plugins.media_db.db import MediaDB

class ElisaMedia(MediaProvider):
    """
    This class implements elisa metadata-like fs support
    """

    def initialize(self):
        super(ElisaMedia, self).initialize()

    def scannable_uri_schemes__get(self):
        return []

    def supported_uri_schemes__get(self):
        return { 'elisa': 0 }

    def get_media_type(self, uri): 
        # ElisaMedia always deal with virtual directories
        d = { 'file_type' : 'directory', 'mime_type' : '' }
        return defer.succeed(d)

    def is_directory(self, uri):
        return self.has_children_with_types(uri, 'audio')
    
    def has_children_with_types(self, uri, media_types):
        if 'directory' not in media_types and 'audio' not in media_types:
            return defer.succeed(False)

        db = MediaDB.get_connection()
        return defer.succeed(db.has_children(uri))

    def get_direct_children(self, uri, children_with_info):
        db = MediaDB.get_connection()
        list_of_children = db.get_uris_by_meta_uri(uri, children_with_info)
        return defer.succeed(children_with_info)

    def uri_is_monitorable(self, uri):
        return False

