# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

__maintainer__ = 'Benjamin Kampmann <benjamin@fluendo.com>'

from elisa.core.media_uri import MediaUri
from elisa.core import plugin_registry

import gst

PlaybinEngine = plugin_registry.get_component_class('base:playbin_engine')
class CddaEngine(PlaybinEngine):
    """ 
    This class implements a player engine for cdda (inheriting from
    PlaybinEngine)
    """

    uri_schemes = {'cdda' : 0}

    def uri__set(self, uri):
        if not self._pipeline:
            self._create_pipeline()
        self._pipeline.set_state(gst.STATE_READY)
        states = self._pipeline.get_state(3000 * gst.MSECOND)

        if states[1] == gst.STATE_READY:
           
            source = self._pipeline.get_property('source')
            if source:
                track = uri.host
                self.debug("Loading track %s" % track)
                source.set_property('track', track)
                self.debug("Ready to play track %s" % track)
                self._current_uri = uri
            else:
                PlaybinEngine.uri__set(self, uri)
