#ifndef __FTEXT_H__
#define __FTEXT_H__

#include <time.h>
#include <gdk/gdk.h>
#include <gtk/gtkadjustment.h>
#include <gtk/gtkwidget.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define GTK_FTEXT(obj) ((GtkFText*)obj)
#define GTK_FTEXT_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, gtk_ftext_get_type (), GtkFTextClass)
#define GTK_IS_FTEXT(obj)       GTK_CHECK_TYPE (obj, gtk_ftext_get_type ())

#define FONT_1BYTE 0
#define FONT_2BYTE 1
#define FONT_SET 2

  typedef struct _GtkFText      GtkFText;
  typedef struct _GtkFTextClass GtkFTextClass;

  typedef struct textentry
  {
    struct textentry *next;
    char *str;
    int str_width;
    time_t stamp;
    short str_len;
    short mark_start;
    short mark_end;
    short indent;
    short lines_taken;
    short left_len;
    int   color;
  }
  textentry;

  struct _GtkFText
  {
    GtkWidget widget;
  
    GtkAdjustment *adj;
    gfloat old_value;	      /* last known adj->value */
    GdkDrawable *draw_buf;    /* points to ->window */
    GdkCursor *hand_cursor;
  
    int pixel_offset;	      /* amount of pixels the top line is chopped by */
  
    int last_win_x;
    int last_win_y;
    int last_win_h;
    int last_win_w;
  
    GdkGC *bgc;			     /* backing pixmap */
    GdkGC *fgc;			     /* text foreground color */
  
    textentry *text_first;
    textentry *text_last;
  
    gint io_tag;	     /* for delayed refresh events */
    gint add_io_tag;	     /* "" when adding new text */
    gint scroll_tag;	     /* marking-scroll timeout */

    GdkFont *font;
    int fontsize;
    int fonttype;
    guint16 fontwidth[256];  /* each char's width, only for FONT_1BYTE type */
    int space_width;	     /* width (pixels) of the space " " character */
    int stamp_width;	     /* width of "[88:88:88]" */

    int indent;		     /* position of separator (pixels) from left */
    int max_auto_indent;

    int select_start_adj;    /* the adj->value when the selection started */
    int select_start_x;
    int select_start_y;
    int select_end_x;
    int select_end_y;

    textentry *last_ent_start; /* this basically describes the last rendered */
    textentry *last_ent_end;   /* selection. */
    int last_offset_start;
    int last_offset_end;

    int num_lines;
    int max_lines;

    int pagetop_subline;
    textentry *pagetop_ent;	  /* what's at ftext->adj->value */

    int col_fore;
    int col_back;

    int depth;		   /* gdk window depth */

    /*   int frozen;*/

    textentry *hilight_ent;
    int hilight_start;
    int hilight_end;

    short grid_offset[256];

    GtkWidget *(*error_function) (char *text);
    int (*urlcheck_function) (GtkFText * ftext, char *word);

    unsigned char scratch_buffer[4096];

    unsigned int fixed_width_font:1;
    unsigned int auto_indent:1;
    unsigned int moving_separator:1;
    unsigned int time_stamp:1;
    unsigned int scrollbar_down:1;
    unsigned int word_or_line_select:1;
    unsigned int color_paste:1;
    unsigned int thinline:1;
    unsigned int button_down:1;
    unsigned int bold:1;
    unsigned int underline:1;
    unsigned int reverse:1;
    unsigned int transparent:1;
    unsigned int separator:1;
    unsigned int shaded:1;
    unsigned int wordwrap:1;
    unsigned int dont_render:1;
    unsigned int cursor_hand:1;
    unsigned int skip_fills:1;
    unsigned int skip_border_fills:1;
    unsigned int skip_stamp:1;
    unsigned int do_underline_fills_only:1;
  };

  struct _GtkFTextClass
  {
    GtkWidgetClass parent_class;
    void (*word_click) (GtkFText * ftext, char *word, GdkEventButton * event);
    void (*changed) (GtkFText * ftext, gpointer data);
  };

  GtkWidget *gtk_ftext_new (int indent, int separator);
  guint gtk_ftext_get_type (void);
  void gtk_ftext_append (GtkFText * ftext, char *text, int len, int color);
  void gtk_ftext_set_font (GtkFText * ftext, GdkFont * font, char *name);
  void gtk_ftext_clear (GtkFText * ftext);
  gchar *gtk_ftext_get_chars (GtkFText * ftext);
  void gtk_ftext_refresh (GtkFText * ftext);
  void gtk_ftext_thaw (GtkFText * ftext);
  void gtk_ftext_freeze (GtkFText * ftext);
  void *gtk_ftext_search (GtkFText * ftext, char *text, void *start);

  gint gtk_ftext_save_buffer(GtkFText * ftext, char *filename);
  gint gtk_ftext_get_last_line(GtkFText * ftext);
  gint gtk_ftext_find_text_upwards(GtkFText * ftext, char *needle,
				   int topline, int bottomline, 
				   gboolean hilight);
  void gtk_ftext_goto(GtkFText * ftext, int pseudoline);

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif
