#ifdef VFLIB

#include	"defs.h"
#include	"emit.h"
#include	"global.h"
#include	"bifont.h"
#include	"rastfont.h"
#include	"ps.h"
#include	"VF.h"

void
dev_vfl_initfe(fe)
struct font_entry *fe;
{
    DEV_FONT vfl_fontdict();
    int vfl_setchar(), vfl_setstring();
    int vfl_setchar_abs(), vfl_setstring_abs();

    fe->dev_fontdict = vfl_fontdict;
    if (bifpos_rel(jfmfinfo(fe)->jfm_bf)) {
	fe->dev_setchar = vfl_setchar;
	fe->dev_setstring = vfl_setstring;
    } else {
	fe->dev_setchar = vfl_setchar_abs;
	fe->dev_setstring = vfl_setstring_abs;
    }
}

void
dev_vfl_initfontdict(fe, vflfi, k, c, tw, xo, w, h, d, pixel)
struct font_entry *fe;
struct vflfntinfo *vflfi;
int k, c;
int tw, xo, w, h, d;
char *pixel;
{
    struct vflchar_entry *ce;
    struct pdlist *pl;
    int bw;

    end_string();

    ce = vflfi->ch+k;
    /* open font dict before first char */
    if ((pl = getpdlist(CORRNORM))->pl_char == FIRSTPACKPSCHAR)
	EMIT(outfp, "%.3f %d /%s NF\n",
	     1.0, NPACKPSCHARS, psfname(pl->pl_font));
#ifdef STATS
    if (fe->ncdl == -1)
	fe->ncdl = 0;
#endif
    ce->dev_font = pl->pl_font;
    ce->dev_char = pl->pl_char;
    dev_setfont(ce->dev_font);

#ifdef DEBUG
    if (Debug)
	EMIT(outfp, "%% font: %s char: %x\n", fe->n, c);
#endif
    bw = (w+7)>>3;
    EMITC('[');
    if (!pscharbitmap(bw, bw, h, pixel)) {
	bw = 1;
	h = 1;
    }
    EMIT(outfp, "\n%d %d %d %d %.3f] %d D\n", 
	 bw<<3, h,
	 xo, d, ((float)tw)/hconv,
	 /*ce->xoffset, (((int)ce->height)-ce->yoffset)-1, cw/cf,*/
	 ce->dev_char);
}

/* The following function pscharoutline is written by Ein Terakawa. */

#define	TOKEN_INITIAL	0
#define	TOKEN_LINE	1
#define	TOKEN_BEZ	2
#define	ConvX(x)	((VFD_GET_X(x)-OUTLINE_OFFSET))
#define	ConvY(x)	((OUTLINE_SIZE-(VFD_GET_Y(x)-OUTLINE_OFFSET)))

#define	checklen(l)	\
	{cc += l; \
	 if (cc > 67) {EMITC('\n'); cc = 0;} \
	 else EMITC(' ');}
#define	emitdata(x,y,i)	{EMIT(outfp, "%d %d %c", (x), (y), i); checklen(12);}
#define	emitdata0(x,y)	{EMIT(outfp, "%d %d", (x), (y)); checklen(10);}

pscharoutline(w, h, outline)
int w, h;
long *outline;
{
    long *ptr;
    int token;
    int cmd, dat;
    int cc;
    int initialx, initialy;
    
    EMITC('{');
    EMIT(outfp, "%.3f %.3f scale\n",
	 (float)w/OUTLINE_SIZE, (float)h/OUTLINE_SIZE);
    ptr = &outline[2];
    token = TOKEN_INITIAL;
    cc = 0;
    
    while (*ptr != 0) {
	if (*ptr&VFD_TOKEN) {
	    cmd = *ptr++;
	    dat = *ptr++;;
	    if ((cmd&VFD_CWCURV) == VFD_CWCURV ||
		(cmd&VFD_CCWCURV) == VFD_CCWCURV) {
		if (token != TOKEN_INITIAL) {
		    if (token == TOKEN_BEZ) {
			emitdata(initialx, initialy, 'c');
		    }
		    EMITS("closepath\n");
		    cc = 0;
		}
		emitdata(ConvX(dat), ConvY(dat), 'p');
		initialx = ConvX(dat);
		initialy = ConvY(dat);
	    } else if (token == TOKEN_BEZ) {
		emitdata(ConvX(dat), ConvY(dat), 'c');
	    } else {
		emitdata(ConvX(dat), ConvY(dat), 'l');
	    }
	    if ((cmd&VFD_BEZ) == VFD_BEZ)
		token = TOKEN_BEZ;
	    else if ((cmd&VFD_LINE) == VFD_LINE)
		token = TOKEN_LINE;
	} else {
	    dat = *ptr++;
	    if (token == TOKEN_BEZ) {
		emitdata(ConvX(dat), ConvY(dat), 'c');
	    } else {
		emitdata(ConvX(dat), ConvY(dat), 'l');
	    }
	}
	if (token == TOKEN_BEZ) {
	    dat = *ptr++;
	    emitdata0(ConvX(dat), ConvY(dat));
	    dat = *ptr++;
	    emitdata0(ConvX(dat), ConvY(dat));
	}
    }
    if (token == TOKEN_BEZ) {
	emitdata(initialx, initialy, 'c');
    }
    EMITS("closepath eofill}");
    
    /*
    if(outline[0] & 1)
	EMIT(outfp, "{0 0 p %d %d l %d 0 p 0 %d l 20 setlinewidth stroke}",
	     w,h,w,h);
    else
	EMIT(outfp, "{0 %d p 0 %d %d 0 %d 0 c %d 0 %d %d %d %d c %d %d %d %d %d %d c %d %d 0 %d 0 %d c closepath fill}",
	     h/2,h/4,w/4,w/2,w*3/4,w,h/4,w,h/2,
	     w,h*3/4,w*3/4,h,w/2,h,w/4,h,h*3/4,h/2);
     */
}

static int pl_font, pl_char = LASTPACKPSCHAR;

static void
getpd()
{
    if (pl_char++ == LASTPACKPSCHAR) {
	pl_font = dev_newdevfont();
	pl_char = FIRSTPACKPSCHAR;
    } else if (pl_char == NPACKPSCHARS)
	pl_char = 0;
}

void
dev_vfl_initfontdict_ol(fe, vflfi, k, c, tw, w, h, d, outline)
struct font_entry *fe;
struct vflfntinfo *vflfi;
int k, c;
int tw, w, h, d;
long *outline;
{
    struct vflchar_entry *ce;
    int bw;

    end_string();

    ce = vflfi->ch+k;
    /* open font dict before first char */
    getpd();
    if (pl_char == FIRSTPACKPSCHAR)
	EMIT(outfp, "%.3f %d /%s NF2\n",
	     1.0, NPACKPSCHARS, psfname(pl_font));
#ifdef STATS
    if (fe->ncdl == -1)
	fe->ncdl = 0;
#endif
    ce->dev_font = pl_font;
    ce->dev_char = pl_char;
    dev_setfont(ce->dev_font);

#ifdef DEBUG
    if (Debug)
	EMIT(outfp, "%% font: %s char: %x\n", fe->n, c);
#endif
    bw = (w+7)>>3;
    EMITC('[');
    pscharoutline(w, h, outline);
    EMIT(outfp, "\n%d %d %d %d %.3f] %d D\n", 
	 bw<<3, h,
	 0, d, ((float)tw)/hconv,
	 /*ce->xoffset, (((int)ce->height)-ce->yoffset)-1, cw/cf,*/
	 ce->dev_char);
}

vfl_setchar(c)
int c;
{
    struct vflchar_entry *ce;
    int cw;

    ce = &(vflfinfo(curfontent)->ch[jis_to_idx94(c)]);
    begin_string();
    pschar(ce->dev_char);
    *ps_move += (cw = ce->tfmw);
    return cw;
}

/* ARGSUSED */
vfl_setstring(s, len)
char *s;
int len;
{
    Fatal("%s implementation error: vfl_setstring", G_progname);
}

vfl_setchar_abs(c)
int c;
{
    int cw;

    cw = vfl_setchar(c);
    dev_setposn_abs(ps_h, ps_v);
    return cw;
}

/* ARGSUSED */
vfl_setstring_abs(s, len)
char *s;
int len;
{
    Fatal("%s implementation error: vfl_setstring_abs", G_progname);
}


dev_jsvfl_initfe(fe)
struct font_entry *fe;
{
    DEV_FONT jsvfl_fontdict();
    int jsvfl_setchar(), jsvfl_setstring();
    int jsvfl_setchar_abs(), jsvfl_setstring_abs();

    fe->dev_fontdict = jsvfl_fontdict;
    if (bifpos_rel(jstfmfinfo(fe)->js_bf)) {
	fe->dev_setchar = jsvfl_setchar;
	fe->dev_setstring = jsvfl_setstring;
    } else {
	fe->dev_setchar = jsvfl_setchar_abs;
	fe->dev_setstring = jsvfl_setstring_abs;
    }
}

jsvfl_setchar(c)
int c;
{
    struct jstfmfntinfo *jsfi;
    int cw;

    jsfi = jstfmfinfo(curfontent);
    begin_string();
    pschar(jsvflfinfo(jsfi)->ch[jsub_to_idx94(jsfi->jsubfont,c)].dev_char);
    *ps_move += (cw = jsfi->ch[c].tfmw);
    return cw;
}

/* ARGSUSED */
jsvfl_setstring(s, len)
char *s;
int len;
{
    char *sp;
    struct jstfmchar_entry *ce = jstfmfinfo(curfontent)->ch;
    struct jstfmfntinfo *jsfi;
    int cw;

    jsfi = jstfmfinfo(curfontent);
    begin_string();
    for (sp = s, cw = 0; sp < s+len; sp++) {
	pschar(jsvflfinfo(jsfi)->ch[jsub_to_idx94(jsfi->jsubfont,*sp)].dev_char);
	cw += (ce+*sp)->tfmw;
    }
    *ps_move += cw;
    return cw;
}

jsvfl_setchar_abs(c)
int c;
{
    int cw;

    cw = jsvfl_setchar(c);
    dev_setposn_abs(ps_h, ps_v);
    return cw;
}

/* ARGSUSED */
jsvfl_setstring_abs(s, len)
char *s;
int len;
{
    char *sp;
    struct jstfmchar_entry *ce = jstfmfinfo(curfontent)->ch;
    struct jstfmfntinfo *jsfi;
    int cw, w;

    jsfi = jstfmfinfo(curfontent);
    for (sp = s, cw = 0; sp < s+len; sp++) {
	begin_string();
	pschar(jsvflfinfo(jsfi)->ch[jsub_to_idx94(jsfi->jsubfont,*sp)].dev_char);
	end_string();
	cw += (w = (ce+*sp)->tfmw);
	*ps_move += w;
	dev_setposn_abs(ps_h, ps_v);
    }
    return cw;
}

#endif
