/*
 * savedump.h - lkcd defs for savedump.c
 * Created by:	John Daley (John.Daley@hp.com)
 * Minor mods:	Bob Montgomery (bobm@fc.hp.com)
 *
 * Copyright 2004 Hewlett-Packard Development Company, L.P.
 * 
 * Adapted from lkcdutils
 * Created by: Matt D. Robinson (yakker@aparity.com)
 * Copyright 2001 Matt D. Robinson (yakker@aparity.com), all rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */ 

/* There should be a savedump.h, a savedump386.h and a savedumpIA64.h.  
 * the arch specific stuff should go in the savedump.h.  
 * 
 * Include header files
 *  */
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <time.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/utsname.h>
#include <sys/time.h>
#include <fcntl.h>
#include <string.h>

#define DATE_SIZE		15
#define CONF_FILE		"/etc/dumputils.conf"

#define DUMP_BUFFER_SIZE	(64 * 1024)
#define DUMP_HEADER_SIZE	DUMP_BUFFER_SIZE
#if defined(i386)
// Use to be 4K
#define DUMP_HEADER_OFFSET	(64 * 1024)
#else
#if defined(ia64)
#define DUMP_HEADER_OFFSET	(64 * 1024)
#else
#define DUMP_HEADER_OFFSET	(64 * 1024) // Put something real here
#endif
#endif

#define DUMP_MAGIC_NUMBER   0xa8190173618f23edULL  /* dump magic number     */
#define DUMP_MAGIC_LIVE     0xa8190173618f23cdULL  /* live magic number     */
#define DUMP_MAGIC_ERASED   0x00000000deadbeefULL  /* erased magic number   */

#define DUMP_ASM_MAGIC_NUMBER     0xdeaddeadULL  /* magic number            */
#define DUMP_ASM_VERSION_NUMBER   0x3            /* version number          */
 
#define DUMP_DH_FLAGS_NONE     0x0      /* no flags set (error condition!)  */
#define DUMP_DH_RAW            0x1      /* raw page (no compression)        */
#define DUMP_DH_COMPRESSED     0x2      /* page is compressed               */
#define DUMP_DH_END            0x4      /* end marker on a full dump        */
#define DUMP_DH_TRUNCATED      0x8      /* dump is incomplete               */
#define DUMP_DH_TEST_PATTERN   0x10     /* dump page is a test pattern      */
#define DUMP_DH_NOT_USED       0x20     /* 1st bit not used in flags        */
 
#define  DUMP_LEVEL_HEADER      0x1

typedef struct _dump_page_s {

	/* the address of this dump page */
	uint64_t             dp_address;

	/* the size of this dump page */
	uint32_t             dp_size;

	/* flags (currently DUMP_COMPRESSED, DUMP_RAW or DUMP_END) */
	uint32_t             dp_flags;
} dump_page_t;


/* Generic front ends of headers */

typedef struct generic_dump_header_s {
	/* the dump magic number -- unique to verify dump is valid */
	uint64_t             dh_magic_number;

	/* the version number of this dump */
	uint32_t             dh_version;

	/* the size of this header (in case we can't read it) */
	uint32_t             dh_header_size;

	/* the level of this dump (just a header?) */
	uint32_t             dh_dump_level;

	/* 
	 * The size of a hardware/physical memory page (DUMP_PAGE_SIZE).
	 * NB: Not the configurable system page (PAGE_SIZE) (4K, 8K, 16K, etc.) 
	 */
	uint32_t             dh_dump_page_size;

	/* the size of all physical memory */
	uint64_t             dh_memory_size;

	/* the start of physical memory */
	uint64_t             dh_memory_start;

	/* the end of physical memory */
	uint64_t             dh_memory_end;

	/* the number of hardware/physical pages in this dump specifically */
	uint32_t             dh_num_dump_pages;

} generic_dump_header_t;

typedef struct generic_dump_header_asm_s {
 
        /* the dump magic number -- unique to verify dump is valid */
        uint64_t             dha_magic_number;
 
        /* the version number of this dump */
        uint32_t             dha_version;
 
        /* the size of this header (in case we can't read it) */
        uint32_t             dha_header_size;
 
} generic_dump_header_asm_t;
