/* devdspsound.c */

#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>
#include <linux/soundcard.h>
#include <math.h>

#include "ditty.h"
#include "devdspsound.h"

#define DEVDSPSOUND_MAX_VOL	100

static int	soundDevice;

void
devdspGoodbye (void)
{
  close (soundDevice);
}

void
devdspPlayTone (int duration, int pitch)
{
  unsigned char	*sbuffer;
  int		i, cycle, err;

  if (duration <= 0)
    return;

  sbuffer = malloc (duration);
  if (sbuffer == NULL)
    {
      fputs ("Out of memory!\n", stderr);
      exit (-1);
    }

  if (pitch == 0)
    {
      memset (sbuffer, 0, duration);
    }
  else
    {
      cycle = (double)dittyRate / (double)pitch;
      for (i=0; i<duration; i++)
	{
	  sbuffer[i] = (((i % cycle) < (cycle/2))
			?  DEVDSPSOUND_MAX_VOL
			: -DEVDSPSOUND_MAX_VOL );
	}
    }

  err = write (soundDevice, sbuffer, duration);
  if (err == -1)
    {
      perror ("Couldn't write to sound device");
      exit (-1);
    }

  //  (void) ioctl (soundDevice, SNDCTL_DSP_SYNC);

  free (sbuffer);
}

void
devdspPlayRest (int dur)
{
  devdspPlayTone (dur, 0);
}

  
int
devdspInit (void)
{
  int	err, arg;
  
  // open soundcard device special file
  soundDevice = open ("/dev/dsp", O_WRONLY);
  if (soundDevice == -1)
    {
      perror ("Couldn't open soundcard device");
      return soundDevice;
    }

  // we want it in 8-bit-mode
  arg = AFMT_U8;
  err = ioctl( soundDevice, SNDCTL_DSP_SETFMT, &arg);
  if (err)
    goto devdsp_init_error;

  // and we don't want stereo
  arg = 0;
  err = ioctl( soundDevice, SNDCTL_DSP_CHANNELS, &arg);
  if (err)
    goto devdsp_init_error;

  // 11025 sound rate
  arg = 22050;
  err = ioctl( soundDevice, SNDCTL_DSP_SPEED, &arg);
  if (err)
    goto devdsp_init_error;
  dittyRate = arg;
  
  // install exit proc
  err = atexit(devdspGoodbye);
  if (err)
    goto devdsp_init_error;
  
  // install player procs
  playTone = devdspPlayTone;
  playRest = devdspPlayRest;

  // success!
  return 0;

 devdsp_init_error:
  close (soundDevice);
  perror ("There was a problem communicating with sound device");
  return -1;
}

