/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2009 Christian Schallhart <christian@schallhart.net>,
 *                    Michael Tautschnig <tautschnig@forsyte.de>
 *               2008 model.in.tum.de group, FORSYTE group
 *               2006-2007 model.in.tum.de group
 *               2002-2005 Christian Schallhart
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#ifndef DIAGNOSTICS__EXTENSIONS__MEMORY__ALLOCATION_RECORD__INCLUDE_GUARD
#define DIAGNOSTICS__EXTENSIONS__MEMORY__ALLOCATION_RECORD__INCLUDE_GUARD

#include <diagnostics/extensions/memory/tick.hpp>

DIAGNOSTICS_NAMESPACE_BEGIN;
MEMORY_NAMESAPCE_BEGIN;

class Allocation_Record 
{
    typedef Allocation_Record Self;
public:
    inline Allocation_Record() 
		: m_len(0),
		  m_creation_tick(0) 
    {
    }
    inline Allocation_Record(::std::size_t const len,Tick_t const  creation_tick) 
		: m_len(len),
		  m_creation_tick(creation_tick) 
    {
    }
    inline Allocation_Record(Self const & other) 
		: m_len(other.m_len),
		  m_creation_tick(other.m_creation_tick) 
    {
    }

    inline Self & operator=(Self const & other)
    {
		m_len=other.m_len;
		m_creation_tick=other.m_creation_tick;
		return *this;
    }

    ::std::size_t m_len;
    Tick_t m_creation_tick;
};

MEMORY_NAMESAPCE_END;
DIAGNOSTICS_NAMESPACE_END;


#endif

// vim:ts=4:sw=4
