#!/bin/bash -e

if test $# -gt 0; then
    case $1 in
	-h|--help)
	    cat <<EOF
Usage: $0 [options] [<arg> ...]
Build package and generate build dependencies.
All args are passed to dpkg-buildpackage.
Options:
   -h, --help     This help
   -v, --version  Report version and exit
EOF
	    exit 1
	    ;;
	-v|--version)
	    echo "dpkg-genbuilddeps wrapper for dpkg-depcheck:"
	    dpkg-depcheck --version
	    exit 1
	    ;;
    esac
fi

if test -d debian -a -x debian/rules; then
    :
else
    echo "dpkg-genbuilddeps must be run in the source package directory" >&2
    exit 1
fi

echo "Warning: if this program hangs, kill it and read the manpage!" >&2
dpkg-depcheck -b dpkg-buildpackage -us -uc -b "$@"
