# debpartial_mirror - partial debian mirror package tool
# (c) 2004 Otavio Salvador <otavio@debian.org>, Marco Presi <zufus@debian.org>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA	02111-1307	USA

from cdd import FileSystem

from debpartial_mirror import Config
from debpartial_mirror import Dists
from debpartial_mirror import Files
from debpartial_mirror import Pool

class Backend:
	"""
	This class provides methods to create backendss dirs into the
	partial-mirror
	"""

	backends = []

	def __init__ (self, name, config):
		# Store myself on list
		self.backends.append(self)

		self._cfg = config
		self._name = name

		self._filesystem = FileSystem.FileSystem(self["mirror_dir"])

	def __getitem__ (self, key):
		try:
			item = self._cfg.get_option(key, self._name)
		except Config.InvalidOption, msg:
			raise Config.InvalidOption(self._name, key, "lookup")
		return item

	def has_key (self, key):
		try:
			self.__getitem__ (key)
		except:
			return False
		else:
			return True

	def get_config_with_default(self, key, default):
		if self.has_key(key):
			return self[key]
		return default

	def get_binary_list (self):
		"""
		Return the partial binList associated to this Backend
		"""
		return self._dists.get_binary_list()

	def get_source_list (self):
		"""
		Return the partial srcList associated to this Backend
		"""
		return self._dists.get_source_list()

	def get_full_binary_list (self):
		"""
		Return the full binList associated to this Backend
		"""
		return self._dists.get_full_binary_list()

	def get_full_source_list (self):
		"""
		Return the full srcList associated to this Backend
		"""
		return self._dists.get_full_source_list()

	def filter(self):
		return self._dists.filter()

	def remove (self):
		""" Remove backend """
		self._pool.remove()
		self._dists.remove()

	def clean (self):
		self._pool.clean()


class MirrorBackend(Backend):
	def __init__ (self, name, config):
		Backend.__init__(self, name, config)
		self._dists = Dists.RemoteDists(self)
		self._pool = Pool.RemotePool(self)
		self._files = Files.RemoteFiles(self)

	def update (self):
		if not self._filesystem.exists(self._name):
			self._filesystem.mkdir(self._name)
		self._dists.update()

	def load (self):
		self._dists.load()

	def process (self):
		self._dists.process()

	def upgrade (self):
		self._files.upgrade()
		self._pool.upgrade()
		if self.isIndexGenerationRequired():
			self._dists.writeIndexFiles()

	def isIndexGenerationRequired(self):
		return self._pool.containsForeignPackages()


class MergeBackend(Backend):
	def __init__ (self, name, config):
		Backend.__init__(self, name, config)
		self._dists = Dists.MergeDists(self)
		self._pool = Pool.MergePool(self)
		self._files = Files.RemoteFiles(self)

	def merge (self):
		self._dists.merge()
		self._pool.merge()

	def get_mirrors (self):
		return self._dists.get_mirrors()

	def get_packages_for_mirror(self, mirror):
		return self._dists.get_packages_for_mirror(mirror)

