/* dc_gui2 - a GTK+2 GUI for DCTC
 * Copyright (C) 2002 Eric Prevoteau
 *
 * public_hub_clist.c: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: public_hub_clist.c,v 1.6 2003/12/26 14:35:04 uid68112 Exp $
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/file.h>
#include <sys/wait.h>
#include <fcntl.h>
#include <signal.h>
#include <dirent.h>
#include <gnome.h>

#include "gtkcellrenderertextx.h"
#include "gtkcellrendererpixbufx.h"
#include "misc_gtk.h"
#include "public_hub_clist.h"
#include "seen_hub_clist.h"
#include "main.h"
#include "gui_define.h"
#include "macro.h"
#include "status.h"
#include "init_fnc.h"
#include "gtk_helper.h"
#include "sound.h"
#include "misc.h"
#include "hublist_converter.h"

#include "country_flag_cz.xpm"
#include "country_flag_hu.xpm"
#include "country_flag_se.xpm"
#include "country_flag_us.xpm"
#include "country_flag_fi.xpm"
#include "country_flag_fr.xpm"
#include "country_flag_no.xpm"
#include "country_flag_dk.xpm"
#include "country_flag_it.xpm"
#include "country_flag_gb.xpm"
#include "country_flag_il.xpm"
#include "country_flag_lv.xpm"
#include "country_flag_nl.xpm"
#include "country_flag_de.xpm"
#include "country_flag_eu.xpm"
#include "country_flag_gr.xpm"
#include "country_flag_ie.xpm"
#include "country_flag_jp.xpm"
#include "country_flag_hk.xpm"
#include "country_flag_lt.xpm"
#include "country_flag_nz.xpm"
#include "country_flag_pl.xpm"
#include "country_flag_ae.xpm"
#include "country_flag_hr.xpm"
#include "country_flag_pt.xpm"
#include "country_flag_ar.xpm"
#include "country_flag_in.xpm"
#include "country_flag_ro.xpm"
#include "country_flag_at.xpm"
#include "country_flag_ir.xpm"
#include "country_flag_sa.xpm"
#include "country_flag_au.xpm"
#include "country_flag_is.xpm"
#include "country_flag_sg.xpm"
#include "country_flag_be.xpm"
#include "country_flag_kr.xpm"
#include "country_flag_si.xpm"
#include "country_flag_bg.xpm"
#include "country_flag_kw.xpm"
#include "country_flag_sk.xpm"
#include "country_flag_br.xpm"
#include "country_flag_lu.xpm"
#include "country_flag_sv.xpm"
#include "country_flag_ca.xpm"
#include "country_flag_mc.xpm"
#include "country_flag_tr.xpm"
#include "country_flag_ch.xpm"
#include "country_flag_mt.xpm"
#include "country_flag_tw.xpm"
#include "country_flag_cl.xpm"
#include "country_flag_mx.xpm"
#include "country_flag_ua.xpm"
#include "country_flag_cn.xpm"
#include "country_flag_my.xpm"
#include "country_flag_uy.xpm"
#include "country_flag_co.xpm"
#include "country_flag_mz.xpm"
#include "country_flag_ve.xpm"
#include "country_flag_ec.xpm"
#include "country_flag_ph.xpm"
#include "country_flag_yu.xpm"
#include "country_flag_ee.xpm"
#include "country_flag_pk.xpm"
#include "country_flag_za.xpm"
#include "country_flag_es.xpm"
#include "country_flag_pr.xpm"
#include "country_flag_sat.xpm"
#include "country_flag_ge.xpm"
#include "country_flag_km.xpm"
#include "country_flag_lb.xpm"
#include "country_flag_ma.xpm"
#include "country_flag_om.xpm"
#include "country_flag_qa.xpm"
#include "country_flag_so.xpm"
#include "country_flag_th.xpm"


static GtkListStore *build_empty_public_hub_list(void);

typedef struct
{
	char *country;
	GdkPixbuf *country_pixbuf;
	char **xpm_data;
} COUNTRY_ENTRY;

static COUNTRY_ENTRY country_entry[]={
													{"Yugoslavia",		NULL,country_flag_yu_xpm},
													{"Venezuela",		NULL,country_flag_ve_xpm},
													{"Uruguay",			NULL,country_flag_uy_xpm},
													{"United States",	NULL,country_flag_us_xpm},
													{"United Kingdom",NULL,country_flag_gb_xpm},
													{"United Arab Emirates",NULL,country_flag_ae_xpm},
													{"Ukraine",			NULL,country_flag_ua_xpm},
													{"Turkey",			NULL,country_flag_tr_xpm},
													{"Thailand",		NULL,country_flag_th_xpm},
													{"Taiwan",			NULL,country_flag_tw_xpm},
													{"Switzerland",	NULL,country_flag_ch_xpm},
													{"Sweden",			NULL,country_flag_se_xpm},
													{"Spain",			NULL,country_flag_es_xpm},
													{"South Korea",	NULL,country_flag_kr_xpm},
													{"South Africa",	NULL,country_flag_za_xpm},
													{"Slovenia",		NULL,country_flag_si_xpm},
													{"Slovakia",		NULL,country_flag_sk_xpm},
													{"Somalia",			NULL,country_flag_so_xpm},
													{"Singapore",		NULL,country_flag_sg_xpm},
													{"Saudi Arabia",	NULL,country_flag_sa_xpm},
													{"Satellite Provider",NULL,country_flag_sat_xpm},
													{"Romania",			NULL,country_flag_ro_xpm},
													{"Qatar",			NULL,country_flag_qa_xpm},
													{"Puerto Rico",	NULL,country_flag_pr_xpm},
													{"Portugal",		NULL,country_flag_pt_xpm},
													{"Poland",			NULL,country_flag_pl_xpm},
													{"Philippines",	NULL,country_flag_ph_xpm},
													{"Pakistan",		NULL,country_flag_pk_xpm},
													{"Oman",				NULL,country_flag_om_xpm},
													{"New Zealand",	NULL,country_flag_nz_xpm},
													{"Netherlands",	NULL,country_flag_nl_xpm},
													{"Norway",			NULL,country_flag_no_xpm},
													{"Mozambique",		NULL,country_flag_mz_xpm},
													{"Morocco",			NULL,country_flag_ma_xpm},
													{"Monaco",			NULL,country_flag_mc_xpm},
													{"Mexico",			NULL,country_flag_mx_xpm},
													{"Malta",			NULL,country_flag_mt_xpm},
													{"Malaysia",		NULL,country_flag_my_xpm},
													{"Luxembourg",		NULL,country_flag_lu_xpm},
													{"Lithuania",		NULL,country_flag_lt_xpm},
													{"Lebanon",			NULL,country_flag_lb_xpm},
													{"Latvia",			NULL,country_flag_lv_xpm},
													{"Kuwait",			NULL,country_flag_kw_xpm},
													{"Japan",			NULL,country_flag_jp_xpm},
													{"Italy",			NULL,country_flag_it_xpm},
													{"Israel",			NULL,country_flag_il_xpm},
													{"Ireland",			NULL,country_flag_ie_xpm},
													{"Iran",				NULL,country_flag_ir_xpm},
													{"India",			NULL,country_flag_in_xpm},
													{"Iceland",			NULL,country_flag_is_xpm},
													{"Hungary",			NULL,country_flag_hu_xpm},
													{"Hong Kong",		NULL,country_flag_hk_xpm},
													{"Greece",			NULL,country_flag_gr_xpm},
													{"Germany",			NULL,country_flag_de_xpm},
													{"Georgia",			NULL,country_flag_ge_xpm},
													{"France",			NULL,country_flag_fr_xpm},
													{"Finland",			NULL,country_flag_fi_xpm},
													{"European Union",NULL,country_flag_eu_xpm},
													{"Estonia",			NULL,country_flag_ee_xpm},
													{"El Salvador",	NULL,country_flag_sv_xpm},
													{"Ecuador",			NULL,country_flag_ec_xpm},
													{"Denmark",			NULL,country_flag_dk_xpm},
													{"Czech Republic",NULL,country_flag_cz_xpm},
													{"Croatia",			NULL,country_flag_hr_xpm},
													{"Comoros",			NULL,country_flag_km_xpm},
													{"Colombia",		NULL,country_flag_co_xpm},
													{"China",			NULL,country_flag_cn_xpm},
													{"Chile",			NULL,country_flag_cl_xpm},
													{"Canada",			NULL,country_flag_ca_xpm},
													{"Bulgaria",		NULL,country_flag_bg_xpm},
													{"Brazil",			NULL,country_flag_br_xpm},
													{"Belgium",			NULL,country_flag_be_xpm},
													{"Austria",			NULL,country_flag_at_xpm},
													{"Australia",		NULL,country_flag_au_xpm},
													{"Argentina",		NULL,country_flag_ar_xpm},
													//Andorra =none
													{NULL,NULL,NULL},
													};

/*********************************/
/* create GdkPixbuf for each xpm */
/*********************************/
static void initialize_country_pixbuf_array(void)
{
	int i;

	i=0;
	while(country_entry[i].country!=NULL)
	{
		country_entry[i].country_pixbuf=gdk_pixbuf_new_from_xpm_data((const char**)(country_entry[i].xpm_data));
		i++;
	}
}

/*********************************************************************/
/* return the reference of a pixbuf of the flag of the given country */
/*********************************************************************/
/* output: NULL if not found else it is the reference of the pixbuf */
/*         (the reference must NOT be unref)                        */
/********************************************************************/
static GdkPixbuf *get_country_const_pixbuf(const char *country_name)
{
	static gboolean init_done=FALSE;
	int i;

	if(!init_done)
	{
		init_done=TRUE;
		initialize_country_pixbuf_array();
	}

	i=0;
	while(country_entry[i].country!=NULL)
	{
		if(!strcmp(country_name,country_entry[i].country))
			return country_entry[i].country_pixbuf;
		i++;
	}

	return NULL;
}

/**********************************************************/
/* build hublist command line according to GUI parameters */
/**********************************************************/
static void start_hublist(void)
{
	GStringChunk *gsc=NULL;
	GPtrArray *gpa=NULL;
	int valid_len;
	int i;
	const char *cnxtype;
	char *hubcnxtype[3]={_("No proxy needed"), _("Use SOCKS parameters"), _("Use Web proxy")};
	GtkWidget *w;
	const char *t;

	/* update the HUBLIST shell variable to match the current config */
	if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(get_widget_by_widget_name(main_window,"hublist_radiobutton")))==TRUE)
	{
		unsetenv("HUBLIST");
	}
	else
	{
		if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(get_widget_by_widget_name(main_window,"xml_hublist_org_radiobutton")))==TRUE)
		{
			setenv("HUBLIST","http://www.hublist.org/PublicHubList.xml.bz2",TRUE);
		}
		else
		{
			t=gtk_entry_get_text(GTK_ENTRY(get_widget_by_widget_name(main_window,"hidden_planar_hublist")));
			if((t==NULL)||(strlen(t)==0))
			{
				unsetenv("HUBLIST");
			}
			else
			{
				setenv("HUBLIST",t,TRUE);
			}
		}
	}

	gsc=g_string_chunk_new(128);
	gpa=g_ptr_array_new();

	g_ptr_array_add(gpa,g_string_chunk_insert(gsc,"hublist"));	/* argv[0] */

	cnxtype=gtk_entry_get_text(GTK_ENTRY(get_widget_by_widget_name(main_window,"hublist_cnxtype_entry")));
	for(i=0;i<3;i++)
	{
		if(!strcmp(cnxtype,hubcnxtype[i]))
			break;
	}

	valid_len=gpa->len;

	switch(i)
	{
		case 0:		/* no proxy needed */
						break;

		case 1:		/* use socks param */
						g_ptr_array_add(gpa,g_string_chunk_insert(gsc,"--socks"));
						{
							/* add socks proxy address */
							w=get_widget_by_widget_name(main_window,"socks_address_entry");
							if(w==NULL)
								break;
							
							t=gtk_entry_get_text(GTK_ENTRY(w));
							if((t==NULL)||(strlen(t)==0))
								break;

							g_ptr_array_add(gpa,g_string_chunk_insert(gsc,t));
						}
						{
							/* add socks proxy port */
							w=get_widget_by_widget_name(main_window,"socks_port_entry");
							if(w==NULL)
								break;
							
							t=gtk_entry_get_text(GTK_ENTRY(w));
							if((t==NULL)||(strlen(t)==0))
								break;

							g_ptr_array_add(gpa,g_string_chunk_insert(gsc,t));
							valid_len=gpa->len;
						}
						{
							/* add socks user ID (if exist) */
							w=get_widget_by_widget_name(main_window,"socks_userid_entry");
							if(w==NULL)
								break;
							
							t=gtk_entry_get_text(GTK_ENTRY(w));
							if((t==NULL)||(strlen(t)==0))
								break;

							g_ptr_array_add(gpa,g_string_chunk_insert(gsc,t));
							valid_len=gpa->len;
						}
						break;

		case 2:		/* use web proxy */
						g_ptr_array_add(gpa,g_string_chunk_insert(gsc,"--proxy"));
						{
							/* add web proxy address */
							w=get_widget_by_widget_name(main_window,"web_proxy_host_entry");
							if(w==NULL)
								break;
							
							t=gtk_entry_get_text(GTK_ENTRY(w));
							if((t==NULL)||(strlen(t)==0))
								break;

							g_ptr_array_add(gpa,g_string_chunk_insert(gsc,t));
						}
						{
							/* add socks proxy port */
							w=get_widget_by_widget_name(main_window,"web_proxy_port_entry");
							if(w==NULL)
								break;
							
							t=gtk_entry_get_text(GTK_ENTRY(w));
							if((t==NULL)||(strlen(t)==0))
								break;

							g_ptr_array_add(gpa,g_string_chunk_insert(gsc,t));
							valid_len=gpa->len;
						}
						break;

		default:		/* eh ??? */
						break;
	}

	/* discard any incomplete parameter */
	if(valid_len==gpa->len)
		g_ptr_array_add(gpa,NULL);		/* ends the array */
	else
		gpa->pdata[valid_len]=NULL;

	/* and start hublist */
	execvp(gpa->pdata[0],(char **)(gpa->pdata));
	
	/* on error, we leave */
	g_string_chunk_free(gsc);
	g_ptr_array_free(gpa,TRUE);
}

static guint fill_pubhub_handle_id=-1;			/* when !=-1, it is the gdk_input handle for the function updating the hub_public_clist */
static int fill_pubhub_pipe=-1;					/* pipe used to communicate with hub list (it is a read only pipe) */
static pid_t fill_pubhub_procpid=-1;			/* when !=-1, it is the pid of the hublist program */
static GtkWidget *fill_pubhub_hpc_wid=NULL;	/* it is the GtkWidget named "hub_public_clist" */
static GtkTreeModel *fill_pubhub_hpc_gtm=NULL;	/* it is the GtkTreeModel of the "hub_public_clist" */
static GtkListStore *fill_pubhub_hpc_gls=NULL;	/* it is the GtkListStore of the "hub_public_clist" */
static GString *fill_pubhub_incoming_data=NULL;	/* string containing received data */

/**************************************************************************/
/* fill the clist named "hub_public_clist" with the list of existing hubs */
/**************************************************************************/
static void async_fill_pub_hub_clist(gpointer data, gint source, GdkInputCondition condition)
{
	int rd;
	int i;
	GArray *hub_entry_array=NULL;

	SORT_VARS( )

	char buf[1024+1];

	rd=read(source,buf,sizeof(buf)-1);
	if(rd==-1)
	{
		if((errno==EAGAIN)||(errno==EINTR))		/* come back later */
			return;
	}
	else if(rd!=0)			/* we have something */
	{
		buf[rd]='\0';
		fill_pubhub_incoming_data=g_string_append(fill_pubhub_incoming_data,buf);
		return;
	}

	/* we come here either after an error on read or when no more data are available */
	/* 1) remove the gdk tag */
	gdk_input_remove(fill_pubhub_handle_id);
	fill_pubhub_handle_id=-1;
	/* 2) close the com pipe */
	close(fill_pubhub_pipe);
	fill_pubhub_pipe=-1;
	/* 3) just to avoid problem, kill the hublist process */
	kill(fill_pubhub_procpid,SIGKILL);
	waitpid(fill_pubhub_procpid,NULL,0);
	fill_pubhub_procpid=-1;

	/* now, it's time to process the result */
	hub_entry_array=hublist_output_to_hub_entry_array(fill_pubhub_incoming_data->str);
	if(fill_pubhub_incoming_data)
	{
		g_string_free(fill_pubhub_incoming_data,TRUE);
		fill_pubhub_incoming_data=NULL;
	}

	SORT_GET(,fill_pubhub_hpc_gtm)
	fill_pubhub_hpc_gtm=GTK_TREE_MODEL(fill_pubhub_hpc_gls=build_empty_public_hub_list());

	for(i=0;i<hub_entry_array->len;i++)
	{
		GtkTreeIter iter;
		GdkPixbuf *pb;

		gboolean has_extended_info=FALSE;
		HUB_ENTRY *he=&(g_array_index(hub_entry_array,HUB_ENTRY,i));

		gtk_list_store_append (fill_pubhub_hpc_gls, &iter);
		/* first, populate values available everywhere */
		gtk_list_store_set(fill_pubhub_hpc_gls,&iter,
											PHC_HUB_ADDR_COL,he->hubaddr,
											PHC_RIGHT_ALIGN_COL,1.0,
											PHC_HUB_NAME,he->hubname,
											PHC_DESC,he->hubdesc,
											PHC_NB_USERS,he->nb_users,
											PHC_COUNTRY,(strlen(he->country)?he->country:NULL),
											PHC_SHARES,(guint64)(he->shares),
											PHC_STATUS,(strlen(he->status)?he->status:NULL),
											PHC_MIN_SHARE,(guint64)(he->minshare),
											PHC_MAXHUB,(guint)(he->maxhub),
											PHC_MAXUSERS,(guint)(he->maxusers),
											PHC_RELIABILITY,(gfloat)(he->reliability),
											PHC_RATING,(gint)(he->rating),
											-1);
		if(strlen(he->status))
			has_extended_info=TRUE;

		if(!strcmp(he->status,"Online"))
		{
			gtk_list_store_set(fill_pubhub_hpc_gls,&iter,PHC_STATUS_BACKGROUND,"green",-1);
		}

		if((pb=get_country_const_pixbuf(he->country))!=NULL)
		{
			gtk_list_store_set(fill_pubhub_hpc_gls,&iter,PHC_COUNTRY_COL,pb,-1);
		}

		if((has_extended_info)||(utf8_mode==TRUE))
		{
			gtk_list_store_set(fill_pubhub_hpc_gls,&iter,PHC_HUB_NAME_COL,he->hubname,
																		PHC_DESC_COL,he->hubdesc,
																		-1);
		}
		else
		{
			gchar *utf8_e0, *utf8_e2;

			utf8_e0=g_locale_to_utf8(he->hubname,-1,NULL,NULL,NULL);
			utf8_e2=g_locale_to_utf8(he->hubdesc,-1,NULL,NULL,NULL);
			gtk_list_store_set(fill_pubhub_hpc_gls,&iter,PHC_HUB_NAME_COL,utf8_e0,
																		PHC_DESC_COL,utf8_e2,
																		-1);
			g_free(utf8_e0);
			g_free(utf8_e2);
		}

		if(he->maxusers==0)
		{
#ifndef NO_PRINTF_LOCALE
			sprintf(buf,"%'d",he->nb_users);   /* NO_PRINTF_LOCAL support added */
#else
			sprintf(buf,"%d",he->nb_users);
#endif
		}
		else
		{
#ifndef NO_PRINTF_LOCALE
			sprintf(buf,"%'d / %'u",he->nb_users,he->maxusers);   /* NO_PRINTF_LOCAL support added */
#else
			sprintf(buf,"%d / %'u",he->nb_users,he->maxusers);
#endif
		}
		gtk_list_store_set(fill_pubhub_hpc_gls,&iter,PHC_NB_USERS_COL,buf,-1);

		if(he->shares)
		{
			GString *tgs;
			tgs=value_to_readable(he->shares,1024);
			g_string_append_c(tgs,'B');
			gtk_list_store_set(fill_pubhub_hpc_gls,&iter,PHC_SHARES_COL,tgs->str,-1);
			g_string_free(tgs,TRUE);
		}

		if(he->minshare)
		{
			GString *tgs;
			tgs=value_to_readable(he->minshare,1024);
			g_string_append_c(tgs,'B');
			gtk_list_store_set(fill_pubhub_hpc_gls,&iter,PHC_MIN_SHARE_COL,tgs->str,-1);
			g_string_free(tgs,TRUE);
		}

		if((he->maxhub)&&(he->maxhub<10000))
		{
			sprintf(buf,"%d",he->maxhub);
			gtk_list_store_set(fill_pubhub_hpc_gls,&iter,PHC_MAXHUB_COL,buf,-1);
		}

		if(he->rating>=0)
		{
			sprintf(buf,"%d / 5",he->rating);
			gtk_list_store_set(fill_pubhub_hpc_gls,&iter,PHC_RATING_COL,buf,-1);
		}

		if(he->reliability>=0)
		{
			sprintf(buf,"%.2f%%",he->reliability);
			gtk_list_store_set(fill_pubhub_hpc_gls,&iter,PHC_RELIABILITY_COL,buf,-1);
		}
	}

	/* restore original sort order */
	SORT_RESTORE(,fill_pubhub_hpc_gtm)

	/* install the new store in place of the current want (will be automatically released) */
	gtk_tree_view_set_model(GTK_TREE_VIEW(fill_pubhub_hpc_wid),fill_pubhub_hpc_gtm);

	update_seen_hub_list(hub_entry_array);

	g_array_free(hub_entry_array,TRUE);

	if(gtk_notebook_get_current_page(GTK_NOTEBOOK(get_widget_by_widget_name(main_window,"main_notebook")))!=CONNECT_TAB)
		blink_on("connect_page");
	if(gtk_notebook_get_current_page(GTK_NOTEBOOK(get_widget_by_widget_name(main_window,"connect_notebook")))!=PUBLIC_HUB_TAB)
		blink_on("connect_public_label");

	play_the_sound_of_event(SOUND_HUBLIST);
}

/*****************************************************/
/* routine fixant le flag non bloquant sur un socket */
/*****************************************************/
void set_non_bloquant_sock(int socket_fd)
{
   long retval;

   retval=fcntl(socket_fd,F_GETFL);
   retval|= O_NONBLOCK;

   fcntl(socket_fd,F_SETFL,retval);
}


/**************************************************************************/
/* fill the clist named "hub_public_clist" with the list of existing hubs */
/**************************************************************************/
void fill_pub_hub_clist(int flag)
{
	int com_pipe[2];

	if(fill_pubhub_handle_id!=-1)	/* update already in progress */
		return;

	fill_pubhub_hpc_wid=get_widget_by_widget_name(main_window,"hub_public_clist");
	if(fill_pubhub_hpc_wid==NULL)
		return;

	fill_pubhub_hpc_gls=GTK_LIST_STORE(fill_pubhub_hpc_gtm=gtk_tree_view_get_model(GTK_TREE_VIEW(fill_pubhub_hpc_wid)));

	if((flag==FALSE)&&(gtk_tree_model_is_not_empty(fill_pubhub_hpc_gtm)))
		return;

	if(pipe(com_pipe)==-1)
	{
		perror("fill_pub_hub_clist: pipe fail");
		return;
	}

	gtk_list_store_clear(fill_pubhub_hpc_gls);

	/* array must have been set to NULL at the end */
	if(fill_pubhub_incoming_data)
		g_string_free(fill_pubhub_incoming_data,TRUE);

	fill_pubhub_incoming_data=g_string_new("");	

	switch(fill_pubhub_procpid=fork())
	{
		case -1:
				perror("fill_pub_hub_clist: fork fail");
				/* close communication pipe */
				close(com_pipe[0]);
				close(com_pipe[1]);
	
				/* and free memory */
				if(fill_pubhub_incoming_data)
				{
					g_string_free(fill_pubhub_incoming_data,TRUE);
					fill_pubhub_incoming_data=NULL;
				}
				return;

		case 0:	/* it is the son, it will start hublist */
				close(com_pipe[0]);
				dup2(com_pipe[1],1);		/* connect the com_pipe to stdout */

				start_hublist();
				close(1);
				close(com_pipe[1]);
				_exit(0);

		default:
				close(com_pipe[1]);
				fill_pubhub_pipe=com_pipe[0];					/* pipe used to communicate with hub list (it is a read only pipe) */
				set_non_bloquant_sock(fill_pubhub_pipe);
				
				fill_pubhub_handle_id=gdk_input_add(fill_pubhub_pipe,GDK_INPUT_READ,async_fill_pub_hub_clist,NULL);
				break;
	}
}

/**************************************/
/* build an empty model for this list */
/**************************************/
static GtkListStore *build_empty_public_hub_list(void)
{
   return gtk_list_store_new(NB_PHC_COL, 
						GDK_TYPE_PIXBUF,G_TYPE_STRING, G_TYPE_STRING,
						G_TYPE_STRING,G_TYPE_STRING,G_TYPE_STRING,
						G_TYPE_STRING,G_TYPE_STRING,G_TYPE_STRING,
						G_TYPE_STRING,G_TYPE_FLOAT,
						G_TYPE_STRING,G_TYPE_STRING, G_TYPE_UINT, 
						G_TYPE_STRING,G_TYPE_UINT64,G_TYPE_STRING,
						G_TYPE_UINT64,G_TYPE_UINT,G_TYPE_UINT,
						G_TYPE_FLOAT, G_TYPE_INT, G_TYPE_STRING);
}

/**************************************************/
/* build modele and view for the public hub clist */
/**************************************************/
void bmav4_public_hub_clist(void)
{
   GtkListStore *model;
   GtkWidget *view;
   GtkCellRenderer *rend;
   GtkTreeSelection *slc;
	
	model=build_empty_public_hub_list();

   view=get_widget_by_widget_name(main_window,"hub_public_clist");

   gtk_tree_view_set_model(GTK_TREE_VIEW(view),GTK_TREE_MODEL(model));
   gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(view),TRUE);

   slc=gtk_tree_view_get_selection(GTK_TREE_VIEW(view));
   gtk_tree_selection_set_mode(slc,GTK_SELECTION_MULTIPLE);

	/* country */
	rend=gtk_cell_renderer_pixbufx_new();
	g_object_set(rend,"rowspacing",TRUE,NULL);
   MY_RS2_gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(view),PHC_COUNTRY_COL,PHC_COUNTRY,"",rend,"pixbuf",PHC_COUNTRY_COL,NULL);
	
	/* hubname */
   rend=gtk_cell_renderer_textx_new();
	g_object_set(rend,"rowspacing",TRUE,NULL);
   MY_RS_gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(view),PHC_HUB_NAME_COL,_("Hubname"),rend,"text",PHC_HUB_NAME_COL,"background",PHC_STATUS_BACKGROUND,NULL);

	/* #users/max user */
   rend=gtk_cell_renderer_textx_new();
	g_object_set(rend,"rowspacing",TRUE,NULL);
   MY_RS2_gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(view),PHC_NB_USERS_COL,PHC_NB_USERS,_("#users"),rend,"text",PHC_NB_USERS_COL,"xalign",PHC_RIGHT_ALIGN_COL,NULL);

	/* shares */
   rend=gtk_cell_renderer_textx_new();
	g_object_set(rend,"rowspacing",TRUE,NULL);
   MY_RS2_gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(view),PHC_SHARES_COL,PHC_SHARES,_("Shares"),rend,"text",PHC_SHARES_COL,NULL);

	/* min shares */
   rend=gtk_cell_renderer_textx_new();
	g_object_set(rend,"rowspacing",TRUE,NULL);
   MY_RS2_gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(view),PHC_MIN_SHARE_COL,PHC_MIN_SHARE,_("Min share"),rend,"text",PHC_MIN_SHARE_COL,"xalign",PHC_RIGHT_ALIGN_COL,NULL);

	/* max hub */
   rend=gtk_cell_renderer_textx_new();
	g_object_set(rend,"rowspacing",TRUE,NULL);
   MY_RS2_gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(view),PHC_MAXHUB_COL,PHC_MAXHUB,_("#hubs"),rend,"text",PHC_MAXHUB_COL,"xalign",PHC_RIGHT_ALIGN_COL,NULL);

	/* hub address */
   rend=gtk_cell_renderer_textx_new();
	g_object_set(rend,"rowspacing",TRUE,NULL);
   MY_RS_gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(view),PHC_HUB_ADDR_COL,_("Address"),rend,"text",PHC_HUB_ADDR_COL,NULL);

	/* hub rating */
   rend=gtk_cell_renderer_textx_new();
	g_object_set(rend,"rowspacing",TRUE,NULL);
   MY_RS2_gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(view),PHC_RATING_COL,PHC_RATING,_("Rating"),rend,"text",PHC_RATING_COL,"xalign",PHC_RIGHT_ALIGN_COL,NULL);

	/* hub reliability */
   rend=gtk_cell_renderer_textx_new();
	g_object_set(rend,"rowspacing",TRUE,NULL);
   MY_RS2_gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(view),PHC_RELIABILITY_COL,PHC_RELIABILITY,_("Reliability"),rend,"text",PHC_RELIABILITY_COL,"xalign",PHC_RIGHT_ALIGN_COL,NULL);

	/* description */
   rend=gtk_cell_renderer_textx_new();
	g_object_set(rend,"rowspacing",TRUE,NULL);
   MY_RS_gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(view),PHC_DESC_COL,_("Description"),rend,"text",PHC_DESC_COL,NULL);

   /* The view now holds a reference.  We can get rid of our own
    * reference */
   g_object_unref (G_OBJECT (model));
}


