/* dc_gui2 - a GTK+2 GUI for DCTC
 * Copyright (C) 2002 Eric Prevoteau
 *
 * gui_define.h: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: gui_define.h,v 1.3 2004/01/10 16:16:34 ericprev Exp $
*/

#ifndef __GUI_DEFINE_H__
#define __GUI_DEFINE_H__

/*
 meaning of () values:

wo => write only. This value should never been read to perform task. There is
      always another column in the same model containing the "unformatted"
      version. For numeric "unformatted" value, this column probably contains
      a "locale" formatted one. For string "unformatted" value, this column
      is the UTF-8 version (required to be displayed correctly).
		This column is displayed in a view.
org => read/write value. It is the value as it was received from the client
      (it is an "unformatted" value).  This column is NOT displayed in a view.
*/

/* list of all tabs of notebook1 */
enum
{
	XFER_DONE_TAB=0,
};

/* list of all column of the "done_clist" clist */
/* UTF8: ok */
enum
{
	DOC_FNAME_COL=0,		/* char * (wo) */
	DOC_END_TIME,			/* char * (wo) */
	DOC_SIZE_COL,			/* char * (wo) */
	DOC_LFNAME_COL,		/* char * (wo) */
	DOC_SIZE_AS_VAL,		/* guint64: unformatted value of DOC_SIZE_COL */
	DOC_END_TIME_AS_VAL,	/* gulong: unformatted value of DOC_END_TIME */
	NB_DOC_COL
};

/* list of all column of the "ul_done_treeview" clist */
/* UTF8: ok */
enum
{
	UDT_NICK_COL=0,		/* char * (wo) */
	UDT_END_TIME,			/* char * (wo) */
	UDT_XFER_SIZE_COL,	/* char * (wo) */
	UDT_LFNAME_COL,		/* char * (wo) */
	UDT_XFER_SIZE_AS_VAL,/* guint64: unformatted value of DOC_SIZE_COL */
	UDT_END_TIME_AS_VAL,	/* gulong: unformatted value of DOC_END_TIME */
	NB_UDT_COL
};


#endif
