/* dc_gui2 - a GTK+2 GUI for DCTC
 * Copyright (C) 2002 Eric Prevoteau
 *
 * gtk_helper.h: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: gtk_helper.h,v 1.1 2004/01/02 15:37:53 ericprev Exp $
*/

#ifndef __GTK_HELPER_H__
#define __GTK_HELPER_H__

/*********************************************************************/
/* GTK2 has no function to freeze/thaw tree_store and list_store     */
/* thus, if a store is sorted, insertion of 1,000s rows is very slow */
/* to bypass the problem, we can set the sort column on a column     */
/* containing always the same value (the sort occurs but takes a lot */
/* less time)                                                        */
/*********************************************************************/

#define SORT_VARS(id)		gboolean __sort_valid##id; gint __sort_col##id; GtkSortType __sort_order##id;

#define SORT_SAVE(id,model,dummy_column)															\
							__sort_valid##id=gtk_tree_sortable_get_sort_column_id(GTK_TREE_SORTABLE(model),&__sort_col##id,&__sort_order##id);\
							if(__sort_valid##id)																													\
								gtk_tree_sortable_set_sort_column_id(GTK_TREE_SORTABLE(model),dummy_column,__sort_order##id);				

/* it is a dirty trick but -2 is the code used by GTK for unsorted list and -2 cannot be set using *_set_sort_column_id */
#define SORT_SAVE_GLS_TO_UNSORTED(id,model,list_store)															\
							__sort_valid##id=gtk_tree_sortable_get_sort_column_id(GTK_TREE_SORTABLE(model),&__sort_col##id,&__sort_order##id);\
							if(__sort_valid##id)																													\
								list_store->sort_column_id=-2;

#define SORT_GET(id,model)															\
							__sort_valid##id=gtk_tree_sortable_get_sort_column_id(GTK_TREE_SORTABLE(model),&__sort_col##id,&__sort_order##id);

#define SORT_RESTORE(id,model)																		\
							if(__sort_valid##id)															\
								gtk_tree_sortable_set_sort_column_id(GTK_TREE_SORTABLE(model),__sort_col##id,__sort_order##id);				

/* ========================================================================================== */
/* set/get gtk label by widget */

/***********************************************************************/
/* set a string in the given GtkLabel                                  */
/* the function performs locale to UTF8 conversion if utf8_mode is set */
/***********************************************************************/
void set_gtk_label(GtkLabel *lbl, const char *string);

/***********************************************************************/
/* get the string from the given GtkLabel                              */
/* the function performs UTF8 to locale conversion if utf8_mode is set */
/* output: a copy of the string (must be free)                         */
/***********************************************************************/
gchar *get_gtk_label(GtkLabel *lbl);

/* ========================================================================================== */
/* set/get gtk entry by widget */

/***********************************************************************/
/* set a string in the given GtkEntry                                  */
/* the function performs locale to UTF8 conversion if utf8_mode is set */
/***********************************************************************/
void set_gtk_entry(GtkEntry *lbl, const char *string);

/***********************************************************************/
/* get the string from the given GtkEntry                              */
/* the function performs UTF8 to locale conversion if utf8_mode is set */
/* output: a copy of the string (must be free)                         */
/***********************************************************************/
gchar *get_gtk_entry(GtkEntry *lbl);

/* ========================================================================================== */
/* set/get gtk label by name */

/***********************************************************************/
/* set a string in the given GtkLabel                                  */
/* the function performs locale to UTF8 conversion if utf8_mode is set */
/***********************************************************************/
void set_gtk_label_by_name(GtkWidget *root_window,const char *label_name, const char *string);

/***********************************************************************/
/* get the string from the given GtkLabel                              */
/* the function performs UTF8 to locale conversion if utf8_mode is set */
/* output: a copy of the string (must be free)                         */
/***********************************************************************/
gchar *get_gtk_label_by_name(GtkWidget *root_window,const char *label_name);

/* ========================================================================================== */
/* set/get gtk entry by name */

/***********************************************************************/
/* set a string in the given GtkEntry                                  */
/* the function performs locale to UTF8 conversion if utf8_mode is set */
/***********************************************************************/
void set_gtk_entry_by_name(GtkWidget *root_window,const char *label_name, const char *string);

/***********************************************************************/
/* get the string from the given GtkEntry                              */
/* the function performs UTF8 to locale conversion if utf8_mode is set */
/* output: a copy of the string (must be free)                         */
/***********************************************************************/
gchar *get_gtk_entry_by_name(GtkWidget *root_window,const char *label_name);

/***************************************************************************************************************/
/* automatically scroll the textview at the bottom but only if the user has not changed its automatic position */
/***************************************************************************************************************/
/* gtv is the GTK_TEXT_VIEW extracted from base_widget. base_widget is a GtkTextView, it is needed to */
/* access to its parent (the GtkScrolledWindow)                                                       */
/******************************************************************************************************/
void auto_scroll_view(GtkTextView *gtv, GtkTextBuffer *gtb, GtkWidget *base_widget);
#endif
