/* dc_gui2 - a GTK+2 GUI for DCTC
 * Copyright (C) 2002 Eric Prevoteau
 *
 * callbacks.c: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: callbacks.c,v 1.4 2004/01/16 18:58:09 ericprev Exp $
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/param.h>
#include <ctype.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <dirent.h>
#include <glib.h>
#include <gnome.h>

#include "main.h"
#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "gui_layout.h"
#include "unattached_gdl_treeview.h"
#include "gui_define.h"
#include "misc_gtk.h"
#include "dc_gui2_com_channel_client.h"

void
on_add_uatgdl_item_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	foreach_selected_entry_send_cmd_to_gdl("/GDLATTACH","unattached_gdl_treeview",UAG_FILENAME);
	load_unattached_gdl_treeview();
}


void
on_refresh_uatgdl_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	load_unattached_gdl_treeview();
}


gboolean
on_app1_delete_event                   (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
   gui_full_save(widget,NULL);
   gtk_widget_destroy(widget);
   gtk_main_quit();

   return FALSE;
}


gboolean
on_unattached_gdl_treeview_button_press_event
                                        (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	if(event==NULL)
		return TRUE;
	
	if((event->button==1)&&(event->type==GDK_2BUTTON_PRESS))
	{  /* left click */
		/* double click on a row */
		foreach_selected_entry_send_cmd_to_gdl("/GDLATTACH","unattached_gdl_treeview",UAG_FILENAME);
		load_unattached_gdl_treeview();
		return TRUE;							 
	}
													 
	if(event->button==3)
	{  /* right-click */
		gtk_menu_popup(GTK_MENU(uatgdl_popup),NULL,NULL,NULL,NULL,event->button,event->time);
		return TRUE;
	}
	
	return FALSE;
}

/******************************************/
/* Recursively delete the given directory */
/******************************************/
static void recur_del(GString *str)
{
	GString *name;
	DIR *dir;
	struct dirent *obj;

	if((str==NULL)||(str->len==0))
		return;

	dir=opendir(str->str);
	if(dir==NULL)
	{
		fprintf(stderr,"recur_del - unable to open directory %s\n",str->str);
		return;
	}

	name=g_string_new(NULL);
	while((obj=readdir(dir))!=NULL)
	{
		if(!strcmp(obj->d_name,"."))
			continue;
		if(!strcmp(obj->d_name,".."))
			continue;

		g_string_sprintf(name,"%s/%s",str->str,obj->d_name);
		if(unlink(name->str)==-1)
		{
			if(errno==EISDIR)
				recur_del(name);
		}
	}

	g_string_free(name,TRUE);
	closedir(dir);
	rmdir(str->str);
}


/*****************************************************************/
/* try to lock the given GDL and on success, erase the directory */
/*****************************************************************/
static void discard_gdl(GString *gdl_dir)
{
	GString *str;
	int fd;

	str=g_string_new(gdl_dir->str);
	g_string_append(str,"/.lock");
	
	fd=open(str->str,O_RDWR);
	if(fd!=-1)
	{
		if(lockf(fd,F_TLOCK,1)==0)
		{
			/* .lock file of the GDL is locked, we can destroy the directory */
			recur_del(gdl_dir);		/* don't release the lock to prevent an attachment during the deletion */
		}
	
		close(fd);
	}

	g_string_free(str,TRUE);
}

/**********************************/
/* attempt to erase the given GDL */
/**********************************************************************************************/
/* input: data is a const gchar * containing the name of the GDL directory (slash terminated) */
/**********************************************************************************************/
void try_to_erase_gdl_callback (GtkTreeModel *model, GtkTreePath *path, GtkTreeIter *iter, gpointer data)
{
	gchar *gdl_name;

	gtk_tree_model_get(model,iter,UAG_FILENAME,&gdl_name,-1);

	if(gdl_name)
	{
		/* gdl_name is the name of the GDL */
		/* it must be preprended by the name of the GDL directory */
		GString *str;

		str=g_string_new((const gchar*)data);
		g_string_append(str,gdl_name);
		discard_gdl(str);

		g_string_free(str,TRUE);
		g_free(gdl_name);
	}
}

void
on_delete_selected_gdls_activate       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	gchar *t;

	t=gconf_client_get_string(gconf_engine,"/apps/Dc_gui2/Profile/default/dl_dir_entry_ent_cnt",NULL);
	if((t!=NULL)&&(strlen(t)))
	{
		gchar *gdl_dir;

		gdl_dir=g_strconcat(t,"/GDL/",NULL);
		generic_selected_unattached_gdl_calls(try_to_erase_gdl_callback,gdl_dir);
		g_free(gdl_dir);

		load_unattached_gdl_treeview();
	}
	if(t)
		g_free(t);
}
gboolean
on_unattached_gdl_treeview_key_press_event
                                        (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
	if(event==NULL)
		return FALSE;
	
	switch(event->keyval)
	{
		case GDK_a: /* 'a' pressed */
		case GDK_A:
						foreach_selected_entry_send_cmd_to_gdl("/GDLATTACH","unattached_gdl_treeview",UAG_FILENAME);
						load_unattached_gdl_treeview();
						break;
							 
		case GDK_r: /* 'r' pressed */
		case GDK_R:
						load_unattached_gdl_treeview();
						break;

		case GDK_d:	/* 'd' pressed */
		case GDK_D:
						on_delete_selected_gdls_activate(NULL,NULL);
						break;
	}

	return FALSE;
}



