#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <math.h>
#include <sys/types.h>
#include <signal.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <dirent.h>
#include <gdk/gdkkeysyms.h>
#include <gdk/gdk.h>
#include <linux/sem.h>
#include <gnome.h>
#include <glib.h>
#include <time.h>
#include <db.h>
#include <string.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "gui_layout.h"
#include "main.h"
#include "misc_gtk.h"
#include "init_fnc.h"
#include "do_connect.h"
#include "dctc_process.h"
#include "gui_define.h"
#include "bookmark.h"
#include "misc.h"
#include "bdb.h"
#include "unode.h"

static void start_download_from_clist(char *clist_name, int nick_col, int filename_col, int localfname_col, int fsize_col);
static void reload_flagged_user_clist(int only_if_empty);
static void reload_unode_clist(int only_if_empty);

void
on_connect1_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *w;

	w=get_widget_by_widget_name("main_notebook");
	gtk_notebook_set_page(GTK_NOTEBOOK(w),CONNECT_TAB);
}


void
on_disconnect1_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	send_data_to_dctc("/FORCEQUIT\n");
}


void
on_find1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *w;

	w=get_widget_by_widget_name("main_notebook");
	gtk_notebook_set_page(GTK_NOTEBOOK(w),FIND_TAB);
}


void
on_exit1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	gui_full_save(main_window,NULL);
	gtk_main_quit();
}


void
on_preferences1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *w;

	w=get_widget_by_widget_name("main_notebook");
	gtk_notebook_set_page(GTK_NOTEBOOK(w),USER_PREFERENCES_TAB);
	
	fix_pref_window();
}


void
on_about1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *w;

	w=create_about2();
	gtk_widget_show(w);
}


void
on_hub_favorite_clist_click_column     (GtkCList        *clist,
                                        gint             column,
                                        gpointer         user_data)
{
	gtk_clist_freeze(clist);

	if(clist->sort_column==column)
	{
		if(clist->sort_type==GTK_SORT_ASCENDING)
			gtk_clist_set_sort_type(clist,GTK_SORT_DESCENDING);
		else
			gtk_clist_set_sort_type(clist,GTK_SORT_ASCENDING);
	}
	else
	{
		gtk_clist_set_sort_column(clist,column);
		gtk_clist_set_sort_type(clist,GTK_SORT_ASCENDING);
	}
	gtk_clist_sort(clist);
	gtk_clist_thaw(clist);
}


gboolean
on_hub_favorite_clist_button_press_event
                                        (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	if(event==NULL)
		return TRUE;

	if(event->window != GTK_CLIST(widget)->clist_window)
		return FALSE;

	if(event->button==1)
	{	/* left click */
		gint ret;
		gint row,col;

		ret = gtk_clist_get_selection_info(GTK_CLIST(widget), (gint) event->x, (gint) event->y, &row, &col);
		if(ret && (row < GTK_CLIST(widget)->rows) )
		{
			if(event->type==GDK_2BUTTON_PRESS)
			{	/* double click on a row */
				char *col;

				if(gtk_clist_get_text(GTK_CLIST(widget),row,2,&col))
					start_a_new_dctc(col,0);
			}
		}
		return TRUE;
	}

  return FALSE;
}


void
on_hub_public_clist_click_column       (GtkCList        *clist,
                                        gint             column,
                                        gpointer         user_data)
{
	on_hub_favorite_clist_click_column(clist,column,user_data);
}


gboolean
on_hub_public_clist_button_press_event (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	if(event==NULL)
		return TRUE;

	if(event->window != GTK_CLIST(widget)->clist_window)
		return FALSE;

	if(event->button==1)
	{	/* left click */
		gint ret;
		gint row,col;

		ret = gtk_clist_get_selection_info(GTK_CLIST(widget), (gint) event->x, (gint) event->y, &row, &col);
		if(ret && (row < GTK_CLIST(widget)->rows) )
		{
			if(event->type==GDK_2BUTTON_PRESS)
			{	/* double click on a row */
				char *col;

				if(gtk_clist_get_text(GTK_CLIST(widget),row,3,&col))
					start_a_new_dctc(col,0);
			}
		}
		return TRUE;
	}

  return FALSE;
}


void
on_hub_recent_clist_click_column       (GtkCList        *clist,
                                        gint             column,
                                        gpointer         user_data)
{
	on_hub_favorite_clist_click_column(clist,column,user_data);
}


gboolean
on_hub_recent_clist_button_press_event (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	if(event==NULL)
		return TRUE;

	if(event->window != GTK_CLIST(widget)->clist_window)
		return FALSE;

	if(event->button==1)
	{	/* left click */
		gint ret;
		gint row,col;

		ret = gtk_clist_get_selection_info(GTK_CLIST(widget), (gint) event->x, (gint) event->y, &row, &col);
		if(ret && (row < GTK_CLIST(widget)->rows) )
		{
			if(event->type==GDK_2BUTTON_PRESS)
			{	/* double click on a row */
				char *col;

				if(gtk_clist_get_text(GTK_CLIST(widget),row,3,&col))
					start_a_new_dctc(col,0);
			}
		}
		return TRUE;
	}


  return FALSE;
}


void
on_find_result_click_column            (GtkCList        *clist,
                                        gint             column,
                                        gpointer         user_data)
{
	on_hub_favorite_clist_click_column(clist,column,user_data);
}

static void add_source_to_gdl(unsigned long int gdl_id, char *clist_name, int nick_col, int fname_col, int fsize_col)
{
	GtkWidget *w;
	GString *dl;
	GtkCList *clst;
	GtkCListRow *clist_row;
	int row;

	w=get_widget_by_widget_name(clist_name);
	if(w==NULL)
		return;

	clst=GTK_CLIST(w);
	
	dl=g_string_new("");
	for(row=0;row<clst->rows;row++)
	{
		clist_row=g_list_nth(clst->row_list,row)->data;

		if(clist_row->state==GTK_STATE_SELECTED)
		{
			char *nick, *fname, *fsize;

	
			if( (gtk_clist_get_text(clst,row,nick_col,&nick)) &&
				 (gtk_clist_get_text(clst,row,fname_col,&fname)) &&
				 (gtk_clist_get_text(clst,row,fsize_col,&fsize)) )
			{
				if((nick!=NULL)&&(fname!=NULL)&&(fsize!=NULL))
				{
					g_string_sprintf(dl,"/GDLADD %lu|%s|%s|%s\n",gdl_id,nick,fname,fsize);
					send_data_to_dctc(dl->str);
				}
			}
		}
	}
	g_string_free(dl,TRUE);
}


/******************************************************************************************/
/* this function is called when the user clicks on a GDL entry of the start_dl_popup_menu */
/******************************************************************************************/
/* user_data is the GDL ID */
/***************************/
static void add_selected_entries_to_this_gdl(GtkMenuItem *menuitem, gpointer user_data)
{
	unsigned long gdl_id=(unsigned long)user_data;
	GtkWidget *w;

	w=get_widget_by_widget_name("main_notebook");
	if(w==NULL)
		return;

	switch(gtk_notebook_get_current_page(GTK_NOTEBOOK(w)))
	{
		case FIND_TAB:		/* find */
					add_source_to_gdl(gdl_id,"find_result",0,1,2);
					break;

		case USER_FILE_LIST_TAB:	/* user file list */
					add_source_to_gdl(gdl_id,"user_file_list_clist",UFLC_NICK_COL,UFLC_FULL_PATH_COL,UFLC_SIZE_COL);
					break;

		default:
					break;
	}
}


/*********************************************************/
/* add the given cnode to the end of start_dl_popup_menu */
/*********************************************************/
static void add_gdl_entry_to_popup(GtkCTree *ctree, GtkCTreeNode *cnode, gpointer data)
{
	gchar *gdl_id;
	gchar *fname;
	gchar *fsize;

	/* the first column of a ctree is always a pixtext */
	if((gtk_ctree_node_get_pixtext(ctree,cnode,0,&gdl_id,NULL,NULL,NULL)) &&
		(gtk_ctree_node_get_text(ctree,cnode,1,&fname)) &&
		(gtk_ctree_node_get_text(ctree,cnode,2,&fsize)) )
	{
		if((gdl_id!=NULL)&&(fname!=NULL)&&(fsize!=NULL))
		{
			GtkWidget *mitem;
			GString *str;
			unsigned long num_gdl_id;

			num_gdl_id=strtoul(gdl_id,NULL,10);

			str=g_string_new("");
			g_string_sprintf(str,"%s: %s (%s)",gdl_id,fname,fsize);
			mitem=gtk_menu_item_new_with_label(str->str);
			gtk_signal_connect(GTK_OBJECT(mitem),"activate", GTK_SIGNAL_FUNC(add_selected_entries_to_this_gdl),(void*)num_gdl_id);
			gtk_menu_append(GTK_MENU(start_dl_popup),mitem);
			gtk_widget_show(mitem);
			g_string_free(str,TRUE);
		}
	}
}

/***************************************************************************************/
/* create a new GDL from the given gdl_id, the remote filename and the remote filesize */
/***************************************************************************************/
static void	do_gdl_new_from_info(unsigned long int gdl_id, char *remote_fname, unsigned long remote_fsize)
{
	GString *str;
	char *lname;

	lname=strrchr(remote_fname,'\\');
	if(lname==NULL)
		lname=remote_fname;
	else
		lname++;

	str=g_string_new("");
	g_string_sprintf(str,"/GDLNEW %lu|%lu|%s\n",gdl_id,remote_fsize,lname);
	send_data_to_dctc(str->str);
	g_string_free(str,TRUE);
}

/****************************************************************************************/
/* this function is called when the user wants to create one GDL for all selected files */
/****************************************************************************************/
/* autoscan_pattern can be either NULL or a string with the format "filetype|pattern" */
/**************************************************************************************/
static void create_one_gdl_for_all_files_optionnal_autoscan(char *clist_name, int nick_col, int fname_col, int fsize_col, char *autoscan_pattern)
{
	GtkWidget *w;
	GString *dl;
	GtkCList *clst;
	GtkCListRow *clist_row;
	int row;
	int max_row=-1;
	unsigned long max_size=0;
	unsigned long int gdl_id=time(NULL);;

	w=get_widget_by_widget_name(clist_name);
	if(w==NULL)
		return;

	clst=GTK_CLIST(w);
	
	/* we must process in 2 steps: 1) find the biggest source file */
	/*                             2) add all sources to the newly created GDL */
	/* step 1 */
	for(row=0;row<clst->rows;row++)
	{
		clist_row=g_list_nth(clst->row_list,row)->data;

		if(clist_row->state==GTK_STATE_SELECTED)
		{
			char *fsize;
	
			if(gtk_clist_get_text(clst,row,fsize_col,&fsize))
			{
				if(fsize!=NULL)
				{
					unsigned long temp_size;

					temp_size=strtoul(fsize,NULL,10);
					if(temp_size>=max_size)		/* >= because a 0 file_size would generate problem else */
					{
						max_size=temp_size;
						max_row=row;
					}
				}
			}
		}
	}
	
	if(max_row==-1)	/* nothing selected */
		return;

	/* create a new GDL, using information of the biggest file */
	{
		char *fname, *fsize;
	
		if( (gtk_clist_get_text(clst,max_row,fname_col,&fname)) &&
			 (gtk_clist_get_text(clst,max_row,fsize_col,&fsize)) )
		{
			if((fname!=NULL)&&(fsize!=NULL))
			{
				do_gdl_new_from_info(gdl_id, fname, max_size);
			}
			else
				return;
		}
		else
			return;
	}

	/* step 2) add all entries to the newly created GDL */
	dl=g_string_new("");
	for(row=0;row<clst->rows;row++)
	{
		clist_row=g_list_nth(clst->row_list,row)->data;

		if(clist_row->state==GTK_STATE_SELECTED)
		{
			char *nick, *fname, *fsize;
	
			if( (gtk_clist_get_text(clst,row,nick_col,&nick)) &&
				 (gtk_clist_get_text(clst,row,fname_col,&fname)) &&
				 (gtk_clist_get_text(clst,row,fsize_col,&fsize)) )
			{
				if((nick!=NULL)&&(fname!=NULL)&&(fsize!=NULL))
				{
					g_string_sprintf(dl,"/GDLADD %lu|%s|%s|%s\n",gdl_id,nick,fname,fsize);
					send_data_to_dctc(dl->str);
				}
			}
		}
	}

	/* step 3) add the autoscan pattern if exist */
	if(autoscan_pattern!=NULL)
	{
		g_string_sprintf(dl,"/GDLAS+ %lu|%s\n",gdl_id,autoscan_pattern);
		send_data_to_dctc(dl->str);
	}
	g_string_free(dl,TRUE);
}

/****************************************************************************************/
/* this function is called when the user wants to create one GDL for all selected files */
/****************************************************************************************/
static void create_one_gdl_for_all_files(char *clist_name, int nick_col, int fname_col, int fsize_col)
{
	create_one_gdl_for_all_files_optionnal_autoscan(clist_name,nick_col,fname_col,fsize_col,NULL);
}

static const char *ftype_str[]={ "any", "audio", "compressed", "document", "exe", "picture", "video", "folder", NULL};

/****************************************************************************************/
/* this function is called when the user wants to create one GDL for all selected files */
/****************************************************************************************/
static void create_one_gdl_for_all_files_with_autoscan(char *clist_name, int nick_col, int fname_col, int fsize_col)
{
	GtkWidget *w3;
	char *pattern;
	unsigned int ftype;
	GString *str;

	w3=get_widget_by_widget_name("find_entry");
	if(w3==NULL)
	{
		create_one_gdl_for_all_files_optionnal_autoscan(clist_name,nick_col,fname_col,fsize_col,NULL);
		return;
	}

	pattern=gtk_entry_get_text(GTK_ENTRY(w3));
	if(strlen(pattern)==0)
	{
		create_one_gdl_for_all_files_optionnal_autoscan(clist_name,nick_col,fname_col,fsize_col,NULL);
		return;
	}

	ftype=gtk_entry_to_number("filetype_entry",ftype_str);

	str=g_string_new("");
	g_string_sprintf(str,"%u|%s",ftype+1,pattern);
	create_one_gdl_for_all_files_optionnal_autoscan(clist_name,nick_col,fname_col,fsize_col,str->str);
	g_string_free(str,TRUE);
}

/*****************************************************************************************/
/* this function is called when the user wants to create one GDL for each selected files */
/*****************************************************************************************/
static void create_one_gdl_per_files(char *clist_name, int nick_col, int fname_col, int fsize_col)
{
	GtkWidget *w;
	GString *dl;
	GtkCList *clst;
	GtkCListRow *clist_row;
	int row;
	unsigned long int gdl_id=time(NULL);
	unsigned long int increment=123456789;	/* this value is added to gdl_id each time */

	w=get_widget_by_widget_name(clist_name);
	if(w==NULL)
		return;

	clst=GTK_CLIST(w);
	
	dl=g_string_new("");
	for(row=0;row<clst->rows;row++)
	{
		clist_row=g_list_nth(clst->row_list,row)->data;

		if(clist_row->state==GTK_STATE_SELECTED)
		{
			char *nick, *fname, *fsize;
	
			if( (gtk_clist_get_text(clst,row,nick_col,&nick)) &&
				 (gtk_clist_get_text(clst,row,fname_col,&fname)) &&
				 (gtk_clist_get_text(clst,row,fsize_col,&fsize)) )
			{
				if((nick!=NULL)&&(fname!=NULL)&&(fsize!=NULL))
				{
					do_gdl_new_from_info(gdl_id,fname,strtoul(fsize,NULL,10));
					g_string_sprintf(dl,"/GDLADD %lu|%s|%s|%s\n",gdl_id,nick,fname,fsize);
					send_data_to_dctc(dl->str);
					gdl_id+=increment;		/* to limit the risk of having 2 GDL with the same number, should be safe enough */
				}
			}
		}
	}
	g_string_free(dl,TRUE);
}


/*********************************************************************************************/
/* this function is called when the user wants to create one GDL for each/all selected files */
/*********************************************************************************************/
static void add_to_gdl_with_create(GtkMenuItem *menuitem, gpointer user_data)
{
	GtkWidget *w;
	void (*fnc)(char *clist_name, int nick_col,int fname_col,int fsize_col)=user_data;

	w=get_widget_by_widget_name("main_notebook");
	if(w==NULL)
		return;

	switch(gtk_notebook_get_current_page(GTK_NOTEBOOK(w)))
	{
		case FIND_TAB:		/* find */
					(*fnc)("find_result",0,1,2);
					break;

		case USER_FILE_LIST_TAB:	/* user file list */
					(*fnc)("user_file_list_clist",UFLC_NICK_COL,UFLC_FULL_PATH_COL,UFLC_SIZE_COL);
					break;

		default:
					break;
	}
}

/****************************************************/
/* used to store the name of unattached GDL entries */
/****************************************************/
static GStringChunk *gdl_popup_gsc=NULL;

/******************************************************************************************/
/* this function is called when the user clicks on a GDL entry of the start_dl_popup_menu */
/******************************************************************************************/
/* user_data is the name of the GDL */
/************************************/
static void active_add_unattached_gdl(GtkMenuItem *menuitem, gpointer user_data)
{
	GString *str;

	str=g_string_new("/GDLATTACH ");
	str=g_string_append(str,user_data);
	str=g_string_append_c(str,'\n');
	send_data_to_dctc(str->str);
	g_string_free(str,TRUE);
}


static void try_to_add_to_gdl_popup(const char *dir1, const char *dir2)
{
	GString *str;
	int fd;

	str=g_string_new("");
	g_string_sprintf(str,"%s/%s/.lock",dir1,dir2);

	fd=open(str->str,O_RDWR);
	if(fd!=-1)
	{
		if(lockf(fd,F_TEST,1)==0)
		{
			/* .lock file exists and is lockable, so nobody uses this entry */
			GtkWidget *mitem;

			if(gdl_popup_gsc==NULL)
				gdl_popup_gsc=g_string_chunk_new(48);

			mitem=gtk_menu_item_new_with_label(dir2);
			gtk_signal_connect(GTK_OBJECT(mitem),"activate", 
							GTK_SIGNAL_FUNC(active_add_unattached_gdl),
								g_string_chunk_insert_const(gdl_popup_gsc,dir2));
			gtk_menu_append(GTK_MENU(gdl_popup),mitem);
			gtk_widget_show(mitem);
			
		}
		close(fd);
	}
	g_string_free(str,TRUE);
}

/**********************************************************/
/* rebuild a new gdl_popup_menu with currently unused GDL */
/**********************************************************/
static void build_gdl_popup(void)
{
	DIR *dir;
	struct dirent *obj;
	const char *t;
	GtkWidget *mitem;

	if(gdl_popup!=NULL)
	{
		widget_unlog(gdl_popup);
		gtk_widget_destroy(gdl_popup);
	}
	if(gdl_popup_gsc!=NULL)
	{
		g_string_chunk_free(gdl_popup_gsc);
		gdl_popup_gsc=NULL;
	}

	/* create the default gdl_popup_menu */
	gdl_popup=create_gdl_popup_menu();

	mitem=gtk_menu_item_new_with_label(_("-- unattached GDLs"));
	gtk_widget_set_sensitive(mitem,FALSE);
	gtk_menu_append(GTK_MENU(gdl_popup),mitem);
	gtk_widget_show(mitem);

	t=get_var("dl_path");
	if((t!=NULL)&&(strlen(t)))
	{
		GString *st1;

		st1=g_string_new(t);
		st1=g_string_append(st1,"/GDL");
		dir=opendir(st1->str);
		if(dir!=NULL)
		{
			while((obj=readdir(dir))!=NULL)
			{
				try_to_add_to_gdl_popup(st1->str,obj->d_name);
			}
			closedir(dir);
		}
		g_string_free(st1,TRUE);
	}
}

static void
on_expand_all_ctree             (GtkMenuItem     *menuitem,
                                 gpointer         user_data)
{
   GtkWidget *w;

   w=get_widget_by_widget_name((char*)user_data);
   if(w!=NULL)
   {
      GtkCTreeNode *work;
               
      work=GTK_CTREE_NODE (GTK_CLIST (w)->row_list);

      while(work!=NULL)
      {
         gtk_ctree_expand_recursive(GTK_CTREE(w),work);
         work = GTK_CTREE_ROW (work)->sibling;
      }
   }
}
      
static void
on_shrink_all_ctree             (GtkMenuItem     *menuitem,
                                 gpointer         user_data)
{
   GtkWidget *w;

   w=get_widget_by_widget_name((char*)user_data);
   if(w!=NULL)
   {
      GtkCTreeNode *work;
               
      work=GTK_CTREE_NODE (GTK_CLIST (w)->row_list);

      while(work!=NULL)
      {
         gtk_ctree_collapse_recursive(GTK_CTREE(w),work);
         work = GTK_CTREE_ROW (work)->sibling;
      }
   }
}
 
/****************************************************************/
/* rebuild a new start_dl_popup_menu with currently running GDL */
/****************************************************************/
static void build_start_dl_popup(int from_panel)
{
	GtkWidget *w;

	if(start_dl_popup!=NULL)
	{
		widget_unlog(start_dl_popup);
		gtk_widget_destroy(start_dl_popup);
	}

	/* create the default start_dl_popup_menu */
	start_dl_popup=create_start_dl_popup_menu();

	/* and add it the list of GDL */
	w=get_widget_by_widget_name("gdl_ctree");
	if(w!=NULL)
	{
		GtkCTree *ctree;
		GtkWidget *mitem;

		if(from_panel==USER_FILE_LIST_TAB)
		{
			mitem=gtk_menu_item_new_with_label(_("Shrink all"));
			gtk_menu_append(GTK_MENU(start_dl_popup),mitem);
			gtk_signal_connect(GTK_OBJECT(mitem),"activate", GTK_SIGNAL_FUNC(on_shrink_all_ctree),"user_file_list_clist");
			gtk_widget_show(mitem);

			mitem=gtk_menu_item_new_with_label(_("Expand all"));
			gtk_menu_append(GTK_MENU(start_dl_popup),mitem);
			gtk_signal_connect(GTK_OBJECT(mitem),"activate", GTK_SIGNAL_FUNC(on_expand_all_ctree),"user_file_list_clist");
			gtk_widget_show(mitem);
		}

		mitem=gtk_menu_item_new_with_label(_("-- create GDLs"));
		gtk_widget_set_sensitive(mitem,FALSE);
		gtk_menu_append(GTK_MENU(start_dl_popup),mitem);
		gtk_widget_show(mitem);

		mitem=gtk_menu_item_new_with_label(_("Create a new GDL for each selected files"));
		gtk_menu_append(GTK_MENU(start_dl_popup),mitem);
		gtk_signal_connect(GTK_OBJECT(mitem),"activate", GTK_SIGNAL_FUNC(add_to_gdl_with_create),create_one_gdl_per_files);
		gtk_widget_show(mitem);

		mitem=gtk_menu_item_new_with_label(_("Create one new GDL for all selected files"));
		gtk_menu_append(GTK_MENU(start_dl_popup),mitem);
		gtk_signal_connect(GTK_OBJECT(mitem),"activate", GTK_SIGNAL_FUNC(add_to_gdl_with_create),create_one_gdl_for_all_files);
		gtk_widget_show(mitem);

		if(from_panel==FIND_TAB)
		{
			mitem=gtk_menu_item_new_with_label(_("Create one new GDL for all selected files + add autoscan"));
			gtk_menu_append(GTK_MENU(start_dl_popup),mitem);
			gtk_signal_connect(GTK_OBJECT(mitem),"activate", GTK_SIGNAL_FUNC(add_to_gdl_with_create),create_one_gdl_for_all_files_with_autoscan);
			gtk_widget_show(mitem);
		}

		ctree=GTK_CTREE(w);

		mitem=gtk_menu_item_new_with_label(_("-- active GDLs"));
		gtk_widget_set_sensitive(mitem,FALSE);
		gtk_menu_append(GTK_MENU(start_dl_popup),mitem);
		gtk_widget_show(mitem);

		gtk_ctree_post_recursive_to_depth(ctree,NULL,1,add_gdl_entry_to_popup,NULL);
	}
}

gboolean
on_find_result_button_press_event      (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	if(event==NULL)
		return TRUE;

	if(event->window != GTK_CLIST(widget)->clist_window)
		return FALSE;

	if(event->button==1)
	{	/* left click */
		gint ret;
		gint row,col;

		ret = gtk_clist_get_selection_info(GTK_CLIST(widget), (gint) event->x, (gint) event->y, &row, &col);
		if(ret && (row < GTK_CLIST(widget)->rows) )
		{
			if(event->type==GDK_2BUTTON_PRESS)
			{	/* double click on a row */
				GString *dl;
				char *col;

				dl=g_string_new("/DL |"); 							/* adapted to new /DL */
				gtk_clist_get_text(GTK_CLIST(widget),row,0,&col);
				g_string_sprintfa(dl,"%s||",col);				/* let DCTC generate the filename itself */
				gtk_clist_get_text(GTK_CLIST(widget),row,1,&col);
				g_string_sprintfa(dl,"%s|",col);
				gtk_clist_get_text(GTK_CLIST(widget),row,2,&col);
				g_string_sprintfa(dl,"%s\n",col);	/* file size */

				send_data_to_dctc(dl->str);
				g_string_free(dl,TRUE);
			}
		}
		return TRUE;
	}
	else if(event->button==3)
	{	/* right-click */
		build_start_dl_popup(FIND_TAB);
		gtk_menu_popup(GTK_MENU(start_dl_popup),NULL,NULL,NULL,NULL,event->button,event->time);
		return TRUE;
	}
	
  return FALSE;
}

void
on_find_entry_activate                 (GtkEditable     *editable,
                                        gpointer         user_data)
{
	char *param;
	unsigned int ftype1,ftype2;
	GString *req1,*req2;
	GString *req;				/* common part of the request */
	GtkWidget *w;

	param=gtk_entry_get_text(GTK_ENTRY(editable));
	if(strlen(param)<1)
		return;

	/* convert filetype_entry into a number */
	ftype1=gtk_entry_to_number("filetype_entry",ftype_str);
	req1=g_string_new("/SRCH ");
	g_string_sprintfa(req1,"|%s|%u",param,ftype1+1);

	/* same thing for fileentry_entry1 */
	ftype2=gtk_entry_to_number_wo_default("filetype_entry1",ftype_str);
	req2=g_string_new("/SRCH ");
	g_string_sprintfa(req2,"|%s|%u",param,ftype2+1);

	/* build the common part of the request */
	req=g_string_new("");

	w=get_widget_by_widget_name("size_checkbutton");
	if(w==NULL)
	{
		abrt:
		g_string_free(req,TRUE);
		return;
	}
	
	if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w))==TRUE)
	{
		static const char *sizetype_str[3];
		static const char *scale_str[5];
		static int unset=1;
		double val;
		double scale;

		if(unset)
		{
			sizetype_str[0]=_("at least");
			sizetype_str[1]=_("at most");
			sizetype_str[2]=NULL;
			scale_str[0]=_("Bytes");
			scale_str[1]=_("KBytes");
			scale_str[2]=_("MBytes");
			scale_str[3]=_("GBytes");
			scale_str[4]=NULL;
			unset=0;
		}

		/* get the size type */
		switch(gtk_entry_to_number("sizetype_entry",sizetype_str))
		{
			case 0:
						req=g_string_append(req,"|L|");
						break;

			case 1:
						req=g_string_append(req,"|M|");
						break;
		}

		switch(gtk_entry_to_number("size_unit_entry",scale_str))
		{
			default:
			case 0:	scale=1.0;
						break;
			case 1:	scale=1024.0;
						break;
			case 2:	scale=1024.0*1024.0;
						break;
			case 3:	scale=1024.0*1024.0*1024.0;
						break;
		}

		w=get_widget_by_widget_name("size_entry");
		if(w==NULL)
			goto abrt;

		val=atof(gtk_entry_get_text(GTK_ENTRY(w)));

		g_string_sprintfa(req,"%lf",scale*val);
	}

	w=get_widget_by_widget_name("find_result");
	if(w!=NULL)
	{
		gtk_clist_freeze(GTK_CLIST(w));
		gtk_clist_clear(GTK_CLIST(w));
		gtk_clist_thaw(GTK_CLIST(w));
	}

	req=g_string_append_c(req,'\n');

	/* send the first string */
	req1=g_string_append(req1,req->str);
	send_data_to_dctc(req1->str);

	if(last_search[0]!=NULL)
	{
		g_string_free(last_search[0],TRUE);
	}
	last_search[0]=req1;

	/* if the second search criteria exists, start a search */
	if((ftype2!=-1)&&(ftype2!=ftype1))
	{
		req2=g_string_append(req2,req->str);
		send_data_to_dctc(req2->str);

		if(last_search[1]!=NULL)
		{
			g_string_free(last_search[1],TRUE);
		}
		last_search[1]=req2;
	}
	else
	{
		if(last_search[1]!=NULL)
		{
			g_string_free(last_search[1],TRUE);
			last_search[1]=NULL;
		}
		g_string_free(req2,TRUE);
	}

	if(last_search_tag!=-1)
	{
		gtk_timeout_remove(last_search_tag);
		last_search_tag=-1;
	}

	if(last_search[0]!=NULL)
	{
		int i;

		i=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(get_widget_by_widget_name("multihub_checkbutton")));
		if(i==TRUE)
		{
			last_search_tag=gtk_timeout_add(10*1000,start_msearch,NULL);		/* wait 10 seconds before doing a multi-hub search */
		}
	}

	g_string_free(req,TRUE);
#if 0
	g_string_free(req1,TRUE);
	g_string_free(req2,TRUE);
#endif

	/* keep a pre-sliced search pattern */
	if(last_started_search!=NULL)
	{
		g_strfreev(last_started_search);
		last_started_search=NULL;
	}

	last_started_search=g_strsplit(param,"$",0);
}

void
on_find_button_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w;

	w=get_widget_by_widget_name("find_entry");
	if(w!=NULL)
	{
		on_find_entry_activate(GTK_EDITABLE(w),NULL);
	}
}

void
on_user_clist_click_column             (GtkCList        *clist,
                                        gint             column,
                                        gpointer         user_data)
{
	on_hub_favorite_clist_click_column(clist,column,user_data);
}


gboolean
on_user_clist_button_press_event       (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	if(event==NULL)
		return TRUE;

	if(event->window!=GTK_CLIST(widget)->clist_window)
		return FALSE;

  if(event->button==1 && event->type==GDK_2BUTTON_PRESS)
  {	/* double left-click on a row */
	  view_file_selected_entry("/LS","user_clist");
    return TRUE;
  }
    
	if(event->button==3)
	{	/* right-click */
		gtk_menu_popup(GTK_MENU(user_popup),NULL,NULL,NULL,NULL,event->button,event->time);
		return TRUE;
	}

  return FALSE;
}


void
on_download_clist_click_column         (GtkCList        *clist,
                                        gint             column,
                                        gpointer         user_data)
{
	on_hub_favorite_clist_click_column(clist,column,user_data);
}


gboolean
on_download_clist_button_press_event   (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	if(event==NULL)
		return TRUE;

	if(event->window!=GTK_CLIST(widget)->clist_window)
		return FALSE;

	if(event->button==3)
	{	/* right-click */
		gtk_menu_popup(GTK_MENU(dl_popup),NULL,NULL,NULL,NULL,event->button,event->time);
		return TRUE;
	}
  return FALSE;
}


void
on_upload_clist_click_column           (GtkCList        *clist,
                                        gint             column,
                                        gpointer         user_data)
{
	on_hub_favorite_clist_click_column(clist,column,user_data);
}


gboolean
on_upload_clist_button_press_event     (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	if(event==NULL)
		return TRUE;

	if(event->window!=GTK_CLIST(widget)->clist_window)
		return FALSE;

	if(event->button==3)
	{	/* right-click */
		gtk_menu_popup(GTK_MENU(ul_popup),NULL,NULL,NULL,NULL,event->button,event->time);
		return TRUE;
	}

  return FALSE;
}


void
on_queue_clist_click_column            (GtkCList        *clist,
                                        gint             column,
                                        gpointer         user_data)
{
	on_hub_favorite_clist_click_column(clist,column,user_data);
}


gboolean
on_queue_clist_button_press_event      (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	if(event==NULL)
		return TRUE;

	if(event->window!=GTK_CLIST(widget)->clist_window)
		return FALSE;

	if(event->button==3)
	{	/* right-click */
		gtk_menu_popup(GTK_MENU(q_popup),NULL,NULL,NULL,NULL,event->button,event->time);
		return TRUE;
	}

  return FALSE;
}


void
on_done_clist_click_column             (GtkCList        *clist,
                                        gint             column,
                                        gpointer         user_data)
{
	on_hub_favorite_clist_click_column(clist,column,user_data);
}


gboolean
on_done_clist_button_press_event       (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{

	if(event==NULL)
		return TRUE;

	if(event->window!=GTK_CLIST(widget)->clist_window)
		return FALSE;

	if(event->button==3)
	{	/* right-click */
		gtk_menu_popup(GTK_MENU(done_popup),NULL,NULL,NULL,NULL,event->button,event->time);
		return TRUE;
	}
  return FALSE;
}




gboolean
on_app1_delete_event                   (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	gui_full_save(widget,NULL);
	gtk_widget_destroy(widget);
	gtk_main_quit();
  return FALSE;
}



void
on_about2_clicked                      (GnomeDialog     *gnomedialog,
                                        gint             arg1,
                                        gpointer         user_data)
{

}


void
on_do_browse_dl_dir_button_clicked     (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w;

	w=create_dl_dir_fileselection();
	{
		GtkWidget *dl_dir_ent;

		dl_dir_ent=get_widget_by_widget_name("dl_dir_entry");
		if(dl_dir_ent!=NULL)
		{
			char *t;

			t=gtk_entry_get_text(GTK_ENTRY(dl_dir_ent));
			gtk_file_selection_set_filename(GTK_FILE_SELECTION(w),t);
		}
	}
	gtk_widget_show(w);
	widget_log(w);			/* for an unknown reason, widget_log is not called for the widget containing widgets created by create_* functions */
								/* so we must manually register it */
}


gboolean
on_shared_dir_clist_key_press_event    (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{

  return FALSE;
}


void
on_add_shared_dir_button_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w;

	w=create_shared_dir_fileselection();
	{
		GtkWidget *dl_dir_ent;

		dl_dir_ent=get_widget_by_widget_name("dl_dir_entry");		/* start directory is the one use to download directory */
		if(dl_dir_ent!=NULL)
		{
			char *t;

			t=gtk_entry_get_text(GTK_ENTRY(dl_dir_ent));
			gtk_file_selection_set_filename(GTK_FILE_SELECTION(w),t);
		}
	}
	gtk_widget_show(w);
	widget_log(w);			/* for an unknown reason, widget_log is not called for the widget containing widgets created by create_* functions */
								/* so we must manually register it */
}


void
on_remove_shared_dir_button_clicked    (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w;
	GtkCList *clist;
	GtkCListRow *clist_row;
	GString *str;
	int row;
	int i;

	w=get_widget_by_widget_name("shared_dir_clist");
	if(w==NULL)
		return;

	clist=GTK_CLIST(w);
	row=clist->rows-1;
	while(row>=0)
	{
		clist_row=g_list_nth(clist->row_list,row)->data;

		if(clist_row->state==GTK_STATE_SELECTED)
		{
			gtk_clist_remove(clist,row);
		}
		row--;
	}

	/* refresh the hidden entry */
	str=g_string_new("");
	for(i=0;i<clist->rows;i++)
	{
		char *t=NULL;

		gtk_clist_get_text(clist,i,0,&t);
		if(t!=NULL)
		{
			if(str->len!=0)
				str=g_string_append_c(str,'|');
		
			str=g_string_append(str,t);
		}
	}

	w=get_widget_by_widget_name("hidden_shared_dir_entry");
	if(w!=NULL)
	{
		gtk_entry_set_text(GTK_ENTRY(w),str->str);	
	}
	g_string_free(str,TRUE);
}

void
on_refresh_sitelist_button_clicked     (GtkButton       *button,
                                        gpointer         user_data)
{
	switch(gtk_notebook_get_current_page(GTK_NOTEBOOK(get_widget_by_widget_name("connect_notebook"))))
	{
		case RUNNING_HUB_TAB:
					fill_running_hub_clist();
					break;

		case PUBLIC_HUB_TAB:	
					fill_pub_hub_clist(TRUE);
					break;

		case RECENT_HUB_TAB:
					fill_recent_hub_clist();
					break;

		case SEEN_PUBLIC_HUB_TAB:
					fill_seen_hub_clist(TRUE);
					break;

		default:
	}
}


void
on_connect_entry_activate              (GtkEditable     *editable,
                                        gpointer         user_data)
{
	GtkWidget *w;

	w=get_widget_by_widget_name("connect_entry");
	if(w!=NULL)
	{
		char *name;
		name=gtk_entry_get_text(GTK_ENTRY(w));

		if(name&&(strlen(name)>3))
			start_a_new_dctc(name,0);
	}
}


void
on_do_connection_button_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w;

	w=get_widget_by_widget_name("connect_entry");
	if(w!=NULL)
	{
		char *name;
		name=gtk_entry_get_text(GTK_ENTRY(w));

		if(name&&(strlen(name)>3))
			start_a_new_dctc(name,0);
	}
}

/********************************************************/
/* convert all \n in \r except the last one (last byte) */
/********************************************************/
static void translate_char(GString *str,int start_pos)
{
	int i;

	for(i=start_pos;i<(str->len-1);i++)
	{
		if(str->str[i]=='\n')
			str->str[i]='\r';
	}
}


void
on_chat_input_activate                 (GtkEditable     *editable,
                                        gpointer         user_data)
{
#if 0
	GString *req;
	char *param;

	param=gtk_entry_get_text(GTK_ENTRY(editable));
	if(strlen(param)<1)
		return;

	/* convert filetype_entry into a number */
	req=g_string_new("/CHAT ");
	g_string_sprintfa(req,"%s",param);

	req=g_string_append_c(req,'\n');
	send_data_to_dctc(req->str);
	g_string_free(req,TRUE);
	return;
#else
	char *msg;
	msg=gtk_editable_get_chars(GTK_EDITABLE(editable),0,-1);
	if(strlen(msg)>0)
	{
		GString *req;

		req=g_string_new("/CHAT ");
		g_string_sprintfa(req,"%s\n",msg);
		translate_char(req,6);
		send_data_to_dctc(req->str);
		g_string_free(req,TRUE);
	}
	g_free(msg);
	gtk_editable_set_position(GTK_EDITABLE(editable),0);
	gtk_editable_delete_text(GTK_EDITABLE(editable),0,-1);
#endif
}


void
on_nickname_entry_changed              (GtkEditable     *editable,
                                        gpointer         user_data)
{

}


void
on_e_mail_entry_changed                (GtkEditable     *editable,
                                        gpointer         user_data)
{

}


void
on_user_description_entry_changed      (GtkEditable     *editable,
                                        gpointer         user_data)
{

}


void
on_connect_notebook_switch_page        (GtkNotebook     *notebook,
                                        GtkNotebookPage *page,
                                        gint             page_num,
                                        gpointer         user_data)
{
	if(page_num==RUNNING_HUB_TAB)
	{
		/* we enter the page of running process */
		fill_running_hub_clist();
		gtk_widget_show(get_widget_by_widget_name("bookmark_button"));
		gtk_widget_hide(get_widget_by_widget_name("delete_selected_bookmark_button"));
		gtk_widget_hide(get_widget_by_widget_name("start_dctc_selected_hub_button"));
		gtk_widget_show(get_widget_by_widget_name("terminate_selected_dctcs_button"));
		gtk_widget_show(get_widget_by_widget_name("kill_selected_dctcs_button"));
	}
	else if(page_num==PUBLIC_HUB_TAB)
	{	
		/* we enter the public hub list */
		fill_pub_hub_clist(FALSE);
		gtk_widget_show(get_widget_by_widget_name("bookmark_button"));
		gtk_widget_hide(get_widget_by_widget_name("delete_selected_bookmark_button"));
		gtk_widget_show(get_widget_by_widget_name("start_dctc_selected_hub_button"));
		gtk_widget_hide(get_widget_by_widget_name("terminate_selected_dctcs_button"));
		gtk_widget_hide(get_widget_by_widget_name("kill_selected_dctcs_button"));
	}
	else if(page_num==RECENT_HUB_TAB)
	{
		/* we enter the recent hub list */
		fill_recent_hub_clist();
		gtk_widget_show(get_widget_by_widget_name("bookmark_button"));
		gtk_widget_hide(get_widget_by_widget_name("delete_selected_bookmark_button"));
		gtk_widget_show(get_widget_by_widget_name("start_dctc_selected_hub_button"));
		gtk_widget_hide(get_widget_by_widget_name("terminate_selected_dctcs_button"));
		gtk_widget_hide(get_widget_by_widget_name("kill_selected_dctcs_button"));
	}
	else if(page_num==FAVORITE_HUB_TAB)
	{
		gtk_widget_hide(get_widget_by_widget_name("bookmark_button"));
		gtk_widget_show(get_widget_by_widget_name("delete_selected_bookmark_button"));
		gtk_widget_show(get_widget_by_widget_name("start_dctc_selected_hub_button"));
		gtk_widget_hide(get_widget_by_widget_name("terminate_selected_dctcs_button"));
		gtk_widget_hide(get_widget_by_widget_name("kill_selected_dctcs_button"));
	}
	else if(page_num==SEEN_PUBLIC_HUB_TAB)
	{
		fill_seen_hub_clist(FALSE);
		gtk_widget_show(get_widget_by_widget_name("bookmark_button"));
		gtk_widget_hide(get_widget_by_widget_name("delete_selected_bookmark_button"));
		gtk_widget_show(get_widget_by_widget_name("start_dctc_selected_hub_button"));
		gtk_widget_hide(get_widget_by_widget_name("terminate_selected_dctcs_button"));
		gtk_widget_hide(get_widget_by_widget_name("kill_selected_dctcs_button"));
	}
}


/*********************************************************************/
/* this function is called when the user clicks on running_hub_clist */
/*********************************************************************/
gboolean
on_running_hub_clist_button_press_event
                                        (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	if(event==NULL)
		return TRUE;

	if(event->window != GTK_CLIST(widget)->clist_window)
		return FALSE;

	if(event->button==1)
	{	/* left click */
		gint ret;
		gint row,col;

		ret = gtk_clist_get_selection_info(GTK_CLIST(widget), (gint) event->x, (gint) event->y, &row, &col);
		if(ret && (row < GTK_CLIST(widget)->rows) )
		{
			if(event->type==GDK_2BUTTON_PRESS)
			{	/* double click on a row */
				char *col;

				if(gtk_clist_get_text(GTK_CLIST(widget),row,1,&col))
					connect_to_a_running_dctc(col);
			}
		}
		return TRUE;
	}
	return FALSE;
}



gboolean
on_download_clist_key_press_event      (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
	if(event==NULL)
		return FALSE;

	switch(event->keyval)
	{
		case GDK_d:	/* 'd' pressed */
		case GDK_D:
						kill_selected_entry("/KILL","download_clist");
						break;
	}

  return FALSE;
}


gboolean
on_upload_clist_key_press_event        (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
	if(event==NULL)
		return FALSE;

	switch(event->keyval)
	{
		case GDK_d:	/* 'd' pressed */
		case GDK_D:
						kill_selected_entry("/KILL","upload_clist");
						break;
	}

  return FALSE;
}


gboolean
on_queue_clist_key_press_event         (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
	if(event==NULL)
		return FALSE;

	switch(event->keyval)
	{
		case GDK_d:	/* 'd' pressed */
		case GDK_D:
						kill_selected_entry("/KILLKBN","queue_clist");
						break;
	}
  return FALSE;
}


void
on_cancel_dl_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	kill_selected_entry("/KILL","download_clist");
}


void
on_cancel_ul_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	kill_selected_entry("/KILL","upload_clist");
}


void
on_unqueue_xfer_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	kill_selected_entry("/KILLKBN","queue_clist");
}


void
on_view_file_list_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	view_file_selected_entry("/LS","user_clist");
}


void
on_open_private_chat_activate          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *w;
	char *nick;
	GList *glst;
	int row;
	GtkWidget *chat_text;
	char *pchat_label;
	int pchat_num;

	/* get the nickname of the remote side of the private chat */
	w=get_widget_by_widget_name("user_clist");
	glst=GTK_CLIST(w)->selection;
	if(glst==NULL)
		return;			/* no one is selected */

	row=(int)(glst->data);
	/* wrong column for nickname: bug fixed by Tero Aaltonen */
	gtk_clist_get_text(GTK_CLIST(w),row,1,&nick);
	if(nick==NULL)
		return;

	w=get_widget_by_widget_name("main_notebook");
	gtk_notebook_set_page(GTK_NOTEBOOK(w),PRIVATE_CHAT_TAB);		/* switch to private chat panel */

	chat_text=get_pchat_text_widget_from_nick(nick,TRUE,&pchat_label,&pchat_num);
	if(chat_text==NULL)
	{
		GString *out;
	
		out=g_string_new("");
	
		g_string_sprintfa(out,_("WARNING: all private chats are busy, close unused one.\nUnable to create a private chat for %s.\n"),nick);

		gnome_app_error(GNOME_APP(main_window),out->str);
		g_string_free(out,TRUE);
	}
}

void
on_user_file_list_clist_click_column   (GtkCList        *clist,
                                        gint             column,
                                        gpointer         user_data)
{
	on_hub_favorite_clist_click_column(clist,column,user_data);
}


gboolean
on_user_file_list_clist_button_press_event
                                        (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	if(event==NULL)
		return TRUE;

	if(event->window != GTK_CLIST(widget)->clist_window)
		return FALSE;

	if(event->button==1)
	{	/* left click */
		gint ret;
		gint row,col;

		ret = gtk_clist_get_selection_info(GTK_CLIST(widget), (gint) event->x, (gint) event->y, &row, &col);
		if(ret && (row < GTK_CLIST(widget)->rows) )
		{
			if(event->type==GDK_2BUTTON_PRESS)
			{	/* double click on a row */
				char *fname;
				char *nick;
				char *size;

				if( (gtk_clist_get_text(GTK_CLIST(widget),row,UFLC_NICK_COL,&nick)) &&
					 (gtk_clist_get_text(GTK_CLIST(widget),row,UFLC_FULL_PATH_COL,&fname)) &&
					 (gtk_clist_get_text(GTK_CLIST(widget),row,UFLC_SIZE_COL,&size)) )
				{
					if((nick!=NULL)&&(strlen(nick))&&(fname!=NULL)&&(strlen(fname)))
					{
						GString *cm;
						cm=g_string_new("/DL |");											/* adapted to new /DL */
						g_string_sprintfa(cm,"%s||%s|%s\n",nick,fname,size);

						send_data_to_dctc(cm->str);
						g_string_free(cm,TRUE);
					}
				}
			}
		}
		return TRUE;
	}
	else if(event->button==3)
	{	/* right-click */
		build_start_dl_popup(USER_FILE_LIST_TAB);
		gtk_menu_popup(GTK_MENU(start_dl_popup),NULL,NULL,NULL,NULL,event->button,event->time);
		return TRUE;
	}

  return FALSE;
}

static void wipe_gtk_text(char *widget_name)
{
	GtkWidget *w;

	w=get_widget_by_widget_name(widget_name);
	if(w==NULL)
		return;

	gtk_editable_set_position(GTK_EDITABLE(w),0);
	gtk_editable_delete_text(GTK_EDITABLE(w),0,-1);
}


void
on_close_pchat_button_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
	int i;
	GtkWidget *w;

	w=get_widget_by_widget_name("chat_notebook");
	if(w)
	{
		GtkWidget *lbl;

		i=gtk_notebook_get_current_page(GTK_NOTEBOOK(w));

		lbl=get_widget_by_widget_name(lbl_chat[i]);
		if(lbl!=NULL)
			gtk_label_set(GTK_LABEL(lbl),_("empty"));

		wipe_gtk_text(chat_text[i]);
	}
}


void
on_pchat_entry_activate                (GtkEditable     *editable,
                                        gpointer         user_data)
{
	int i;
	GtkWidget *w;

	w=get_widget_by_widget_name("chat_notebook");
	if(w)
	{
		GtkWidget *lbl;

		i=gtk_notebook_get_current_page(GTK_NOTEBOOK(w));

		lbl=get_widget_by_widget_name(lbl_chat[i]);
		if(lbl!=NULL)
		{
			char *nick;
			gtk_label_get(GTK_LABEL(lbl),&nick);
			
			lbl=get_widget_by_widget_name("pchat_entry");
			if(lbl!=NULL)
			{
				GString *out;
				char *msg;

				msg=gtk_editable_get_chars(GTK_EDITABLE(lbl),0,-1);

				out=g_string_new("/PRIV ");
				g_string_sprintfa(out,"|%s|%s\n",nick,msg);
				translate_char(out,strlen(nick)+2+6);	/* translate the message */
				send_data_to_dctc(out->str);
				g_string_free(out,TRUE);

				g_free(msg);

				gtk_editable_set_position(GTK_EDITABLE(lbl),0);
				gtk_editable_delete_text(GTK_EDITABLE(lbl),0,-1);
			}
		}
	}
}

/*************************************************/
/* check if the given string is inside the array */
/*************************************************/
/* output: 1=yes, 0=no */
/***********************/
static int in_array(char *str,GPtrArray *array)
{
	int i;

	if(array==NULL)
		return 0;
	for(i=0;i<array->len;i++)
	{
		char *t;
		t=g_ptr_array_index(array,i);
		if(!strcmp(str,t))
			return 1;
	}
	return 0;
}

void
on_apply_pref_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
	const char *var_var;
	const char *text_var;

	struct
	{
		char *widget_name;
		char *var_name;
		char *cmd_name;
	} lnk[]={{"user_description_entry","user_desc","/DESC "},
				{"cnx_type_entry","cnx_type","/CNX "},
				{"e_mail_entry","email","/EMAIL "},
				{"incoming_port_number_entry","com_port","/PORT "},
				{"xfer_host_ip_entry","hostip","/IP "},
				{"dl_dir_entry","dl_path","/LPATH "},
				{"unodeport_entry","unode_port","/UNODEPORT "},
				{"min_gdl_wake_up_delay_entry","min_gdl_wake_up_delay","/DFLAG min_gdl_wake_up_delay "},
				{"vshare_dir_entry","vshare_dir","/VSHARE "},
				{NULL,NULL,NULL}};
	int i;
	GString *out;
	gfloat nflt;
	char *t;
	const char *ct;

	if(current_dctc==NULL)
		gnome_app_error(GNOME_APP(main_window),_("You are not connected to a running DCTC,\nit is not necessary to press this button."));

	var_var=get_var("nickname");
	text_var=gtk_entry_get_text(GTK_ENTRY(get_widget_by_widget_name("nickname_entry")));
	
	if(var_var&&text_var&&(strcmp(var_var,text_var)))
	{
		gnome_app_error(GNOME_APP(main_window),_("Due to a direct connect limitation, it is not\npossible to change your nickname on a running client."));
		
	}

	out=g_string_new("");
	i=0;

	/* first, the strings, easy */
	while(lnk[i].widget_name!=NULL)
	{
		var_var=get_var(lnk[i].var_name);
		text_var=gtk_entry_get_text(GTK_ENTRY(get_widget_by_widget_name(lnk[i].widget_name)));
	
		if( (var_var&&text_var&&(strcmp(var_var,text_var))) ||
			 ((var_var==NULL)&&(text_var!=NULL)) ||
			 ((var_var!=NULL)&&(text_var==NULL)) 
			)
		{
			g_string_sprintf(out,"%s%s\n",lnk[i].cmd_name,text_var);
			send_data_to_dctc(out->str);
		}
		i++;
	}

	/* the #download slot slider */
	var_var=get_var("dl_slot");
	nflt=gtk_range_get_adjustment(GTK_RANGE(get_widget_by_widget_name("sim_dl_hscale")))->value;
	if(var_var==NULL)
		var_var="0";
	if(strtod(var_var,NULL)!=nflt)
	{
		g_string_sprintf(out,"/SLOT %u\n",(unsigned)nflt);
		send_data_to_dctc(out->str);
	}

	/* the reconnection delay slider */
	var_var=get_var("recon_delay");
	nflt=gtk_range_get_adjustment(GTK_RANGE(get_widget_by_widget_name("reconnect_delay_scale")))->value;
	if(var_var==NULL)
		var_var="0";
	if(strtod(var_var,NULL)!=nflt)
	{
		g_string_sprintf(out,"/RECOND %u\n",(unsigned)nflt);
		send_data_to_dctc(out->str);
	}

	/* the rebuild database delay slider */
	var_var=get_var("auto_rebuild_delay");
	nflt=gtk_range_get_adjustment(GTK_RANGE(get_widget_by_widget_name("rebuild_delay_scale")))->value;
	if(var_var==NULL)
		var_var="0";
	if(strtod(var_var,NULL)!=nflt)
	{
		g_string_sprintf(out,"/REBUILD %u\n",60*(unsigned)nflt);
		send_data_to_dctc(out->str);
	}

	{
		int i;
		struct
		{
			const char *toggle_widget_name;
			char *cmd_if_true;
			char *cmd_if_false;
		} tbl_toggled_cmd[]={
									{"active_mode_radio_button",		"/ACTIVE\n",		"/PASSIVE\n"}, 		/* the firewall flag */
									{"enable_upload_checkbutton",		"/DLON\n",			"/DLOFF\n"}, 			/* the dl flag */
									{"ddl_checkbutton",					"/DDL\n",			"/NODDL\n"},			/* the DDL flag */
									{"dctclink_checkbutton",			"/LINK\n",			"/NOLINK\n"},			/* the DCTCLINK flag */
									{"grabip_checkbutton",				"/GBANIP\n",		"/NOGBANIP\n"},		/* the GRABIP flag */
									{"use_done_dir_checkbutton",		"/DONE\n",			"/UNDONE\n"},			/* the when_done flag */
									{"follow_forcemove_checkbutton",	"/FOLLOWFORCE\n",	"/UNFOLLOWFORCE\n"},	/* the followforcemove flag */
									{"force_dl_checkbutton",			"/DLFORCE\n",		"/NODLFORCE\n"},		/* the force download flag */
									{"hide_abscheckbutton",				"/HIDE_ABS\n",		"/SHOW_ABS\n"},		/* the hide abs flag */
									{"abort_upload_checkbutton",		"/ABORTLEAVED\n",	"/NOABORTLEAVED\n"},	/* the abort upload flag */
									{"hide_kick_checkbutton",			"/HIDE_KICK\n",	"/SHOW_KICK\n"},		/* the hide kick message flag */
									{"lazykc_checkbutton",				"/LAZYKC\n",		"/NOLAZYKC\n"},		/* the lazy key check flag */
									{"incoming_wake_up_checkbutton",	"/DFLAG with_incoming_wake_up 1\n",		"/DFLAG with_incoming_wake_up 0\n"},/* the incoming wake up flag */
									{"sr_wake_up_checkbutton",			"/DFLAG with_sr_wake_up 1\n",				"/DFLAG with_sr_wake_up 0\n"},		/* the incoming wake up flag */
									{NULL,NULL,NULL}
									};

		i=0;
		while(tbl_toggled_cmd[i].toggle_widget_name!=NULL)
		{
			if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(get_widget_by_widget_name(tbl_toggled_cmd[i].toggle_widget_name)))==TRUE)
				send_data_to_dctc(tbl_toggled_cmd[i].cmd_if_true);
			else
				send_data_to_dctc(tbl_toggled_cmd[i].cmd_if_false);
			i++;
		}
	}

	/* set xbl values */
	{
		char buf[512];
		struct
		{
			char *cmd_name;
			char *check_widget;
			char *val_widget;
		} sema_bl[]={	{"/UBL","ubl_checkbutton","ubl_entry"},
							{"/DBL","dbl_checkbutton","dbl_entry"},
							{"/GBL","gbl_checkbutton","gbl_entry"},
							{NULL,NULL,NULL}};

		i=0;
		while(sema_bl[i].cmd_name!=NULL)
		{
			if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(get_widget_by_widget_name(sema_bl[i].check_widget)))==FALSE)
			{
				sprintf(buf,"%s %d\n",sema_bl[i].cmd_name,SEMVMX);
			}
			else
			{
				sprintf(buf,"%s %s\n",sema_bl[i].cmd_name,gtk_entry_get_text(GTK_ENTRY(get_widget_by_widget_name(sema_bl[i].val_widget))));
			}
			send_data_to_dctc(buf);

			i++;
		}
	}

	{
		char buf[512];
		sprintf(buf,"/MAXRUNGDLSRC %u\n",(unsigned int)gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(get_widget_by_widget_name("maxrunspinbutton"))));
		send_data_to_dctc(buf);
		sprintf(buf,"/GDLASOFFAFT %u\n",(unsigned int)gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(get_widget_by_widget_name("maxasoffspinbutton"))));
		send_data_to_dctc(buf);
	}


	/* the shared files list. the harder. We must remove no more shared directories and add newly shared ones */
	{
		GStringChunk *sc;
		GPtrArray *local,*remote,*to_add,*to_remove;

		sc=g_string_chunk_new(128);
		local=g_ptr_array_new();
		remote=g_ptr_array_new();
		to_add=g_ptr_array_new();
		to_remove=g_ptr_array_new();

		/* fill the local array using shared_dir_clist */
		{
			GtkWidget *w;
			w=get_widget_by_widget_name("shared_dir_clist");
			if(w!=NULL)
			{
				GtkCList *clst;

				clst=GTK_CLIST(w);
				for(i=0;i<clst->rows;i++)
				{
					gtk_clist_get_text(clst,i,0,&t);
					if(t!=NULL)
					{
						g_ptr_array_add(local,g_string_chunk_insert(sc,t));
					}
				}
			}
		}

		/* fill the remote array using ul_path var */
		ct=get_var("ul_path");
		if(ct!=NULL)
		{
			char *dpl;
	
			dpl=strdup(ct);
			if(dpl)
			{
				char *cur;
				char *nxt;

				cur=strtok_r(dpl,"|",&nxt);
				while(cur!=NULL)
				{
					g_ptr_array_add(remote,g_string_chunk_insert(sc,cur));
					cur=strtok_r(NULL,"|",&nxt);
				}
				free(dpl);
			}
		}

		/* now, all strings of local which do not exist in remote are put into to_add */
		for(i=0;i<local->len;i++)
		{
			t=g_ptr_array_index(local,i);
			if(!in_array(t,remote))
			{
				g_ptr_array_add(to_add,t);
			}
		}

		/* and, all strings of remote which do not exist in all are put into to_remove */
		for(i=0;i<remote->len;i++)
		{
			t=g_ptr_array_index(remote,i);
			if(!in_array(t,local))
			{
				g_ptr_array_add(to_remove,t);
			}
		}

		/* send command to add new shared dir */
		for(i=0;i<to_add->len;i++)
		{
			t=g_ptr_array_index(to_add,i);
			g_string_sprintf(out,"/SHARE %s\n",t);
			send_data_to_dctc(out->str);
		}
		
		/* send command to remove shared dir */
		for(i=0;i<to_remove->len;i++)
		{
			t=g_ptr_array_index(to_remove,i);
			g_string_sprintf(out,"/UNSHARE %s\n",t);
			send_data_to_dctc(out->str);
		}
		
		/* it is not necessary to free string of to_add and to_remove because they are the same string */
		/* as in local and remote (same ptr) */
		g_ptr_array_free(local,TRUE);
		g_ptr_array_free(remote,TRUE);
		g_ptr_array_free(to_add,TRUE);
		g_ptr_array_free(to_remove,TRUE);
		g_string_chunk_free(sc);
	}

	/* and now, the offset */
	ct=get_var("offset");
	if(ct==NULL)
		ct="0";

	{
		double val;
		double scale[4]={1.0,1024.0, 1024.0*1024.0, 1024.0*1024.0*1024.0};
		char *unit_name[4]={_("Bytes"), _("KBytes"), _("MBytes"), _("GBytes")};
		int i=0;
		char buf[512];
		char *u;
		char *v;

		val=strtod(ct,NULL);

		while(i<3)
		{
			double res,ent;

			res=modf(val/scale[i+1],&ent);
			if(res!=0.0)
				break;
			i++;
		}
		sprintf(buf,"%.0f",val/scale[i]);

		u=gtk_entry_get_text(GTK_ENTRY(get_widget_by_widget_name("size_offset_unit_entry")));
		v=gtk_entry_get_text(GTK_ENTRY(get_widget_by_widget_name("size_offset_entry")));
		if((strcmp(u,unit_name[i]))||(strcmp(v,buf)))
		{
			for(i=0;i<4;i++)
			{
				if(!strcmp(u,unit_name[i]))
					break;
			}
			if(i==4)
				i=0;
			g_string_sprintf(out,"/OFFSET %lf\n",strtod(v,NULL)*scale[i]);
			send_data_to_dctc(out->str);
		}
	}

	g_string_free(out,TRUE);

	send_data_to_dctc("/VARS\n");
}


void
on_reload_pref_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
	fix_pref_window();
}


void
on_dl_dir_select_ok_button_clicked     (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w;
	gchar *selected_filename;

	w=get_widget_by_widget_name("dl_dir_fileselection");

	selected_filename=gtk_file_selection_get_filename(GTK_FILE_SELECTION(w));
	if(selected_filename!=NULL)
	{
		char *path;

		path=strdup(selected_filename);
		if(path!=NULL)
		{
			struct stat st;

			/* verify if the given name is a valid directory */
			if(stat(path,&st)==-1)
			{
				err:
				gnome_app_error(GNOME_APP(main_window),_("invalid dir name"));
			}
			else
			{
				if(!S_ISDIR(st.st_mode))
				{	/* it exists but it is not a directory, remove the filename and retry */
					char *t;
					t=strrchr(path,'/');
					if(t==path)
						goto err;
					t[1]='\0';		/* keep the trailing / */

					if(stat(path,&st)==-1)
						goto err;
					if(!S_ISDIR(st.st_mode))
						goto err;
				}
				printf("'%s'\n",path);
				
				{
					GtkWidget *dl_dir_ent;

					dl_dir_ent=get_widget_by_widget_name("dl_dir_entry");
					if(dl_dir_ent!=NULL)
					{
						gtk_entry_set_text(GTK_ENTRY(dl_dir_ent),path);
					}
				}
			}
			free(path);
		}
	}
	widget_unlog(w);
	gtk_widget_destroy(w);
}


void
on_dl_dir_cancel_button_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w;

	w=get_widget_by_widget_name("dl_dir_fileselection");
	widget_unlog(w);
	gtk_widget_destroy(w);
}


void
on_shared_dir_fs_ok_button_clicked     (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w;
	gchar *selected_filename;

	w=get_widget_by_widget_name("shared_dir_fileselection");

	selected_filename=gtk_file_selection_get_filename(GTK_FILE_SELECTION(w));
	if(selected_filename!=NULL)
	{
		char *path;

		path=strdup(selected_filename);
		if(path!=NULL)
		{
			struct stat st;

			/* verify if the given name is a valid directory */
			if(stat(path,&st)==-1)
			{
				err:
				gnome_app_error(GNOME_APP(main_window),_("invalid dir name"));
			}
			else
			{
				GtkWidget *clst;

				if(!S_ISDIR(st.st_mode))
				{	/* it exists but it is not a directory, remove the filename and retry */
					char *t;
					t=strrchr(path,'/');
					if(t==path)
						goto err;
					t[1]='\0';		/* keep the trailing / */

					if(stat(path,&st)==-1)
						goto err;
					if(!S_ISDIR(st.st_mode))
						goto err;
				}
				
				clst=get_widget_by_widget_name("shared_dir_clist");
				if(clst!=NULL)
				{
					gtk_clist_append(GTK_CLIST(clst),&path);
				}
			}
			free(path);
		}
	}
}


void
on_shared_dir_fs_cancel_button_clicked (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w;
	GString *str;
	GtkCList *clst;
	int i;

	w=get_widget_by_widget_name("shared_dir_fileselection");
	widget_unlog(w);
	gtk_widget_destroy(w);

	str=g_string_new("");
	w=get_widget_by_widget_name("shared_dir_clist");
	clst=GTK_CLIST(w);
	for(i=0;i<clst->rows;i++)
	{
		char *t=NULL;

		gtk_clist_get_text(clst,i,0,&t);
		if(t!=NULL)
		{
			if(str->len!=0)
				str=g_string_append_c(str,'|');
		
			str=g_string_append(str,t);
		}
	}

	w=get_widget_by_widget_name("hidden_shared_dir_entry");
	if(w!=NULL)
	{
		gtk_entry_set_text(GTK_ENTRY(w),str->str);
	}
	g_string_free(str,TRUE);
}


void
on_download_selected_files1_activate   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *w;

	w=get_widget_by_widget_name("main_notebook");
	if(w==NULL)
		return;

	switch(gtk_notebook_get_current_page(GTK_NOTEBOOK(w)))
	{
		case FIND_TAB:		/* find */
					start_download_from_clist("find_result",0,1,5,2);
					break;

		case USER_FILE_LIST_TAB:	/* user file list */
					start_download_from_clist("user_file_list_clist",UFLC_NICK_COL,UFLC_FULL_PATH_COL,-1,UFLC_SIZE_COL);
					break;

		default:
					break;
	}
}


void
on_unselect_files1_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *w;

	w=get_widget_by_widget_name("main_notebook");
	if(w==NULL)
		return;

	switch(gtk_notebook_get_current_page(GTK_NOTEBOOK(w)))
	{
		case FIND_TAB:		/* find */
					w=get_widget_by_widget_name("find_result");
					break;

		case USER_FILE_LIST_TAB:	/* user file list */
					w=get_widget_by_widget_name("user_file_list_clist");
					break;

		default:
					w=NULL;
					break;
	}

	if(w!=NULL)
		gtk_clist_unselect_all(GTK_CLIST(w));
}

/* localfname_col can be ==-1 if no localfname column exists */
/* if text(clist_name,localfname_col)==NULL or has length ==0, it works like if ==-1 */
/* fsize_col cannot be ==-1 */
static void start_download_from_clist(char *clist_name, int nick_col, int filename_col, int localfname_col, int fsize_col)
{
	GtkWidget *w;
	GString *dl;
	GtkCList *clst;
	GtkCListRow *clist_row;
	int row;

	w=get_widget_by_widget_name(clist_name);
	if(w==NULL)
		return;

	clst=GTK_CLIST(w);
	
	dl=g_string_new("");
	for(row=0;row<clst->rows;row++)
	{
		clist_row=g_list_nth(clst->row_list,row)->data;

		if(clist_row->state==GTK_STATE_SELECTED)
		{
			char *col;
			char *lfn;

			dl=g_string_assign(dl,"/DL |");							/* adapted to new /DL */

			gtk_clist_get_text(clst,row,nick_col,&col);

			if(localfname_col==-1)
				lfn="";
			else
			{
				gtk_clist_get_text(clst,row,localfname_col,&lfn);
				if(lfn==NULL)
					lfn="";
			}
			g_string_sprintfa(dl,"%s|%s|",col,lfn);

			gtk_clist_get_text(clst,row,filename_col,&col);
			g_string_sprintfa(dl,"%s|",col);

			gtk_clist_get_text(clst,row,fsize_col,&col);
			g_string_sprintfa(dl,"%s\n",col);

			send_data_to_dctc(dl->str);
		}
	}
	g_string_free(dl,TRUE);
}

gboolean
on_find_result_key_press_event         (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
	if(event==NULL)
		return FALSE;

	switch(event->keyval)
	{
		case GDK_d:	/* 'd' pressed */
		case GDK_D:
						start_download_from_clist("find_result",0,1,5,2);
						break;
	}


  return FALSE;
}


gboolean
on_user_file_list_clist_key_press_event
                                        (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
	static char strbuf[256] = { 0 };
	static GString search_string;
	static time_t last_key = 0;
	gint cur_row, num_rows;
	gchar *keyname;
	
	if(event==NULL)
		return FALSE;

	search_string.str = strbuf;
	search_string.len = 0;

	switch(event->keyval)
	{
		case GDK_Return:
			start_download_from_clist("user_file_list_clist",UFLC_NICK_COL,UFLC_FULL_PATH_COL,-1,UFLC_SIZE_COL);
			break;

		case GDK_Left:
		case GDK_Right:
		case GDK_Up:
		case GDK_Down:
		case GDK_Escape:
			strbuf[0] = 0;
			search_string.len = 0;
			break;

		default:
			/* Reset search-string if we waited more than 3 seconds between keypresses. */
			if (time (NULL) - last_key > 3)
			{
				strbuf[0] = 0;
				search_string.len = 0;
			}

			last_key = time (NULL);

			keyname = gdk_keyval_name (gdk_keyval_to_lower (event->keyval));
			if (keyname && strlen (keyname) != 1)
				break;
			else
			{
				strncat (strbuf, keyname, 255);
				search_string.len = strlen (strbuf);
			}

			/* Where are we in the CList? */
			cur_row = GPOINTER_TO_INT (GTK_CLIST (widget)->selection->data);

			/* And how many rows are there? */
			num_rows = GTK_CLIST (widget)->rows;

			/* Find the filename. */
			while (cur_row < num_rows)
			{
				char *filename = NULL;

				gtk_clist_get_text (GTK_CLIST (widget), cur_row, UFLC_FULL_PATH_COL, &filename);
	/* initialize search_string GString */
				if (filename)
				{
					if (my_strcasestr (&search_string, filename))
					{
						gtk_clist_unselect_all (GTK_CLIST (widget));
						gtk_clist_moveto (GTK_CLIST (widget), cur_row, 0, 0.2, 0.0);
						gtk_clist_select_row (GTK_CLIST (widget), cur_row, 0);
						GTK_CLIST (widget)->focus_row = cur_row;
						break;
					}
				}

				cur_row++;
			}
			break;
	}

  return FALSE;
}


void
on_clear_global_list_button_clicked    (GtkButton       *button,
                                        gpointer         user_data)
{
	GString *str;

	str=g_string_new(dctc_dir->str);
	g_string_sprintfa(str,"/done+exited");
	unlink(str->str);										/* erase global list */

	str=g_string_assign(str,dctc_dir->str);
	if(strlen(last_known_running_dctc_name))
	{
		g_string_sprintfa(str,"/%s.done",last_known_running_dctc_name);
	}	/* if the last_kn... is empty, load_done_xfer will fail but it has cleared the list */
	load_done_xfer(str->str,1);
	g_string_free(str,TRUE);
}


void
on_clear_local_list_button_clicked     (GtkButton       *button,
                                        gpointer         user_data)
{
	GString *str;

	str=g_string_new(dctc_dir->str);

	if(strlen(last_known_running_dctc_name))
	{
		g_string_sprintfa(str,"/%s.done",last_known_running_dctc_name);
		unlink(str->str);										/* erase global list */
	}

	str=g_string_assign(str,dctc_dir->str);
	g_string_sprintfa(str,"/done+exited");
	load_done_xfer(str->str,1);
	g_string_free(str,TRUE);
}


void
on_clear_user_file_list_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w;

	w=get_widget_by_widget_name("user_file_list_clist");
	if(w!=NULL)
	{
		gtk_clist_clear(GTK_CLIST(w));
	}
}


void
on_clear_recent_list_button_clicked    (GtkButton       *button,
                                        gpointer         user_data)
{
	GString *s;
	char *path;

	s=g_string_new(NULL);
	path=getenv("HOME");
	g_string_sprintf(s,"%s/.dctc/recent",(path!=NULL)?path:".");
	unlink(s->str);
	g_string_free(s,TRUE);
	fill_recent_hub_clist();
}


void
on_away_togglebutton_toggled           (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	GtkWidget *w;

	w=get_widget_by_widget_name("away_togglebutton");
	if(w!=NULL)
	{
		if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w))==TRUE)
			send_data_to_dctc("/AWAY\n");
		else
			send_data_to_dctc("/HERE\n");
	}
}

static void do_a_csearch(char *filename)
{
	const char *cur_dir;
	GtkWidget *w;

	w=get_widget_by_widget_name("find_result");
	if(w!=NULL)
	{
		gtk_clist_freeze(GTK_CLIST(w));
		gtk_clist_clear(GTK_CLIST(w));
		gtk_clist_thaw(GTK_CLIST(w));
	}


	cur_dir=get_var("dl_path");
	if(cur_dir!=NULL)
	{
		unsigned long fsize;
		GString *cmd;

		fsize=get_file_size(cur_dir,filename);

		if(fsize>0)
			fsize--;
		
		cmd=g_string_sized_new(512);
		g_string_sprintf(cmd,"/CSRCH |%s|1|L|%lu\n",filename,fsize);
		send_data_to_dctc(cmd->str);
		g_string_free(cmd,TRUE);

		w=get_widget_by_widget_name("main_notebook");
		gtk_notebook_set_page(GTK_NOTEBOOK(w),FIND_TAB);
	}
}

gboolean
on_csearch_clist_button_press_event    (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	if(event==NULL)
		return TRUE;

	if(event->window != GTK_CLIST(widget)->clist_window)
		return FALSE;

	if(event->button==1)
	{	/* left click */
		gint ret;
		gint row,col;

		ret = gtk_clist_get_selection_info(GTK_CLIST(widget), (gint) event->x, (gint) event->y, &row, &col);
		if(ret && (row < GTK_CLIST(widget)->rows) )
		{
			if(event->type==GDK_2BUTTON_PRESS)
			{	/* double click on a row */
				char *col;

				if(gtk_clist_get_text(GTK_CLIST(widget),row,0,&col))
					do_a_csearch(col);
			}
		}
		return TRUE;
	}


  return FALSE;
}


void
on_csearch_clist_click_column          (GtkCList        *clist,
                                        gint             column,
                                        gpointer         user_data)
{
	on_hub_favorite_clist_click_column(clist,column,user_data);
}

static void csearch_selected_entry(void)
{
	GtkWidget *w;
	GtkCList *clist;
	GtkCListRow *clist_row;
	int row;

	w=get_widget_by_widget_name("csearch_clist");
	if(w==NULL)
		return;

	clist=GTK_CLIST(w);
	row=0;
	while(row<clist->rows)
	{
		clist_row=g_list_nth(clist->row_list,row)->data;

		if(clist_row->state==GTK_STATE_SELECTED)
		{
			char *col;
			if(gtk_clist_get_text(clist,row,0,&col))
				do_a_csearch(col);
			break;
		}
		row++;
	}
}

gboolean
on_csearch_clist_key_press_event       (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
	if(event==NULL)
		return FALSE;

	switch(event->keyval)
	{
		case GDK_d:	/* 'd' pressed */
		case GDK_D:
						csearch_selected_entry();
						break;
	}


  return FALSE;
}


void
on_csearch_start_button_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
	csearch_selected_entry();
}


void
on_refresh_csearch_list_button_clicked (GtkButton       *button,
                                        gpointer         user_data)
{
	fill_content_search_clist();
}


void
on_main_notebook_switch_page           (GtkNotebook     *notebook,
                                        GtkNotebookPage *page,
                                        gint             page_num,
                                        gpointer         user_data)
{
#if 0
	switch(gtk_notebook_get_current_page(GTK_NOTEBOOK(get_widget_by_widget_name("main_notebook"))))
#else
	switch(page_num)
#endif
	{
		case CONTENT_SEARCH_TAB:
					fill_content_search_clist();
					break;

		case PRIVATE_CHAT_TAB:
					blink_off("private_chat_page");
					break;

		case FLAGGED_USER_TAB:
					reload_flagged_user_clist(1);
					break;

		case UADDR_TAB:
					reload_unode_clist(1);
					break;

		default:
	}
}


void
on_kick_user_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_enter_a_password_menu_entry_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	if(current_dctc!=NULL)
	{	/* connected to something */
		enter_passwd_fnc(NULL);
	}
}


void
on_get_file_list_of_selected_users1_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *w;
	int nick_column;

	w=get_widget_by_widget_name("main_notebook");
	if(w==NULL)
		return;

	switch(gtk_notebook_get_current_page(GTK_NOTEBOOK(w)))
	{
		case FIND_TAB:		/* find */
					w=get_widget_by_widget_name("find_result");
					nick_column=0;
					break;

		case USER_FILE_LIST_TAB:	/* user file list */
					w=get_widget_by_widget_name("user_file_list_clist");
					nick_column=UFLC_NICK_COL;
					break;

		default:
					w=NULL;
					nick_column=-1;
					break;
	}

	if(w!=NULL)
	{
		/* foreach selected row, a /LS nickname is sent */
		GtkCList *clist;
		GtkCListRow *clist_row;
		int row;

		clist=GTK_CLIST(w);

		for(row=0;row<clist->rows;row++)
		{
			clist_row=g_list_nth(clist->row_list,row)->data;

			if(clist_row->state==GTK_STATE_SELECTED)
			{
				char *t;
				char buf[512];

				gtk_clist_get_text(clist,row,nick_column,&t);

				sprintf(buf,"/LS %s\n",t);
				send_data_to_dctc(buf);
			}
		}
	}
}


void
on_contact_selected_running_client1_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_kill_selected_unning_clients1_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}

void
on_save_default_profile_button_clicked (GtkButton       *button,
                                        gpointer         user_data)
{
	gui_full_save(get_widget_by_widget_name("user_pref_notebook"),"default_profil.");
}


void
on_load_default_profil_button_clicked  (GtkButton       *button,
                                        gpointer         user_data)
{
	gui_full_restore(get_widget_by_widget_name("user_pref_notebook"),"default_profil.");
}


void
on_gdl_ctree_click_column              (GtkCList        *clist,
                                        gint             column,
                                        gpointer         user_data)
{
	/* code from ctree_click_column of testgtk.c */
	if (column == clist->sort_column)
	{
		if (clist->sort_type == GTK_SORT_ASCENDING)
			clist->sort_type = GTK_SORT_DESCENDING;
		else
			clist->sort_type = GTK_SORT_ASCENDING;
	}
	else
		gtk_clist_set_sort_column (clist, column);

	gtk_ctree_sort_recursive (GTK_CTREE(clist), NULL);
}


gboolean
on_gdl_ctree_button_press_event        (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	if(event==NULL)
		return TRUE;

	if(event->window!=GTK_CLIST(widget)->clist_window)
		return FALSE;

	if(event->button==3)
	{	/* right-click */
		build_gdl_popup();
		gtk_menu_popup(GTK_MENU(gdl_popup),NULL,NULL,NULL,NULL,event->button,event->time);
		return TRUE;
	}

  return FALSE;
}


gboolean
on_gdl_ctree_key_press_event           (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
	if(event==NULL)
		return FALSE;

	switch(event->keyval)
	{
		case GDK_d:	/* 'd' pressed */
		case GDK_D:
						kill_selected_gdl_entry();
						break;
	}

	return FALSE;
}


void
on_cancel_gdl_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	kill_selected_gdl_entry();
}


void
on_do_reconnect_now_button_clicked     (GtkButton       *button,
                                        gpointer         user_data)
{
	send_data_to_dctc("/RECON\n");
}


static void go_to_another_hub_clist_selected(char *clist_name, int address_column)
{
	GtkWidget *w;

	w=get_widget_by_widget_name(clist_name);
	if(w!=NULL)
	{
		GtkCList *clist;
		
		clist=GTK_CLIST(w);
		if(clist->selection)
		{
			gint row;
			gchar *name;

			row=GPOINTER_TO_INT (clist->selection->data);

			if(gtk_clist_get_text(clist,row,address_column,&name))
			{
				if(name&&(strlen(name)>3))		/* if a valid name exist, use it */
					go_to_another_hub(name);
			}
		}
	}
}

void
on_do_goto_button_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w;

	w=get_widget_by_widget_name("connect_entry");
	if(w!=NULL)
	{
		char *name;
		name=gtk_entry_get_text(GTK_ENTRY(w));

		if(name&&(strlen(name)>3))		/* if a valid name exist, use it */
			go_to_another_hub(name);
		else
		{
			/* else use the selected site in the currently visible hub list */
			switch(gtk_notebook_get_current_page(GTK_NOTEBOOK(get_widget_by_widget_name("connect_notebook"))))
			{
				case RUNNING_HUB_TAB:
							go_to_another_hub_clist_selected("running_hub_clist",0);
							break;
		
				case PUBLIC_HUB_TAB:	
							go_to_another_hub_clist_selected("hub_public_clist",3);
							break;

				case RECENT_HUB_TAB:
							go_to_another_hub_clist_selected("hub_recent_clist",3);
							break;

				case SEEN_PUBLIC_HUB_TAB:
							go_to_another_hub_clist_selected("seen_hub_clist",3);
							break;

				default:
			}
		}
	}
}


void
on_dctc_cmd_entry_activate             (GtkEditable     *editable,
                                        gpointer         user_data)
{
	GString *str;
	char *param;

	param=gtk_entry_get_text(GTK_ENTRY(editable));
	if(strlen(param)<1)
		return;

	str=g_string_new(param);
	if(str->str[str->len-1]!='\n')
	{
		str=g_string_append_c(str,'\n');
	}

	send_data_to_dctc(str->str);
	g_string_free(str,TRUE);
}


void
on_stop_and_detach1_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	detach_selected_gdl_entry();
}


void
on_attach_autoscan_pattern_to_selected_gdl1_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	create_autoscan_window_for_selected_gdl_entry();
}


void
on_add_as_to_gdl_button_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w1,*w2,*w3;
	gchar *gid;
	char *pattern;
	unsigned int ftype;
	GString *str;

	w1=get_widget_by_widget_name("as_gid_label");
	w2=get_widget_by_widget_name("as_fname_label");
	w3=get_widget_by_widget_name("gdl_as_pattern_entry");

	if((w1==NULL)||(w2==NULL)||(w3==NULL))
		return;

	gtk_label_get(GTK_LABEL(w1),&gid);
	if(strlen(gid)==0)
		return;

	pattern=gtk_entry_get_text(GTK_ENTRY(w3));
	if(strlen(pattern)==0)
		return;

	ftype=gtk_entry_to_number("gdl_as_filetype_entry",ftype_str);

	str=g_string_new("");
	g_string_sprintf(str,"/GDLAS+ %s|%u|%s\n",gid,ftype+1,pattern);
	send_data_to_dctc(str->str);
	g_string_free(str,TRUE);
}


void
on_add_new_uaddr_full_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w1,*w2;
	char *nick,*addr;
	GString *str;

	w1=get_widget_by_widget_name("uaddr_nick_entry");
	w2=get_widget_by_widget_name("uaddr_hostipport_entry");

	if((w1==NULL)||(w2==NULL))
		return;

	nick=gtk_entry_get_text(GTK_ENTRY(w1));
	if(strlen(nick)==0)
		return;

	addr=gtk_entry_get_text(GTK_ENTRY(w2));
	if(strlen(addr)==0)
		return;

	str=g_string_new("");
	if(strchr(addr,':')!=NULL)
		g_string_sprintf(str,"/UADDRUADD %s|%s\n",nick,addr);
	else
		g_string_sprintf(str,"/UADDRUADD %s|%s:412\n",nick,addr);

	send_data_to_dctc(str->str);
	g_string_free(str,TRUE);

	send_data_to_dctc("/UADDRLST\n");
}


void
on_add_new_uaddr_host_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w2;
	char *addr;
	GString *str;

	w2=get_widget_by_widget_name("uaddr_hostipport_entry");

	if(w2==NULL)
		return;

	addr=gtk_entry_get_text(GTK_ENTRY(w2));
	if(strlen(addr)==0)
		return;

	str=g_string_new("");
	if(strchr(addr,':')!=NULL)
		g_string_sprintf(str,"/UADDRIPADD %s\n",addr);
	else
		g_string_sprintf(str,"/UADDRIPADD %s:412\n",addr);

	send_data_to_dctc(str->str);
	g_string_free(str,TRUE);

	send_data_to_dctc("/UADDRLST\n");
}


void
on_uaddr_view_file_list_activate       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *w;
	GtkCList *clist;
	GtkCListRow *clist_row;

	int row;
	char buf[512];

	w=get_widget_by_widget_name("uaddr_clist");
	if(w==NULL)
		return;
	clist=GTK_CLIST(w);

	for(row=0;row<clist->rows;row++)
	{
		clist_row=g_list_nth(clist->row_list,row)->data;

		if(clist_row->state==GTK_STATE_SELECTED)
		{
			char *nick;

			gtk_clist_get_text(clist,row,0,&nick);

			if((nick!=NULL)&&(strlen(nick)!=0))
			{
				sprintf(buf,"/LS %s\n",nick);
				send_data_to_dctc(buf);
			}
		}
	}
}


void
on_delete_uaddr_entries_activate       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *w;
	GtkCList *clist;
	GtkCListRow *clist_row;

	int row;
	char buf[512];

	w=get_widget_by_widget_name("uaddr_clist");
	if(w==NULL)
		return;
	clist=GTK_CLIST(w);

	for(row=0;row<clist->rows;row++)
	{
		clist_row=g_list_nth(clist->row_list,row)->data;

		if(clist_row->state==GTK_STATE_SELECTED)
		{
			char *nick;
			char *ipport;

			gtk_clist_get_text(clist,row,0,&nick);
			gtk_clist_get_text(clist,row,1,&ipport);

			if((nick==NULL)||(strlen(nick)==0))
			{
				sprintf(buf,"/UADDRIPDEL %s\n",ipport);
			}
			else
			{
				sprintf(buf,"/UADDRUDEL %s\n",nick);
			}
			send_data_to_dctc(buf);
		}
	}

	send_data_to_dctc("/UADDRLST\n");
}


void
on_refresh_uaddr_list_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	send_data_to_dctc("/UADDRLST\n");
}


gboolean
on_uaddr_clist_button_press_event      (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{

	if(event==NULL)
		return TRUE;

	if(event->window!=GTK_CLIST(widget)->clist_window)
		return FALSE;

	if(event->button==3)
	{	/* right-click */
		gtk_menu_popup(GTK_MENU(uaddr_popup),NULL,NULL,NULL,NULL,event->button,event->time);
		return TRUE;
	}

  return FALSE;
  return FALSE;
}

/************************************************************************/
/* check if the given pattern exists inside filename (case insensitive) */
/************************************************************************/
/* output: address of the pattern or NULL */
/******************************************/
char *my_strcasestr(GString *pattern, char *filename)
{
	int max_pos;
	int i;

	max_pos=strlen(filename)-pattern->len;
	if(max_pos<0)				  /* filename length < pattern length ? */
		return NULL;				/* no match */

	for(i=0;i<=max_pos;i++)
	{
		if(!strncasecmp(pattern->str,filename+i,pattern->len))
			return filename+i;
	}

	return NULL;					/* no match */
}


void
on_find_uaddr_by_nick_button_clicked   (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w1,*w2;
	char *nick;
	GtkCList *clst;
	int first_row=-1;
	int row;
	GString *nck;

	w1=get_widget_by_widget_name("uaddr_nick_entry");
	w2=get_widget_by_widget_name("uaddr_clist");

	if((w1==NULL)||(w2==NULL))
		return;

	nick=gtk_entry_get_text(GTK_ENTRY(w1));
	if(strlen(nick)==0)
		return;

	nck=g_string_new(nick);
	clst=GTK_CLIST(w2);
	gtk_clist_freeze(clst);
	gtk_clist_unselect_all(clst);

	/* select all rows matching the given nickname */
	for(row=0;row<clst->rows;row++)
	{
		char *t;

		gtk_clist_get_text(clst,row,0,&t);

		if((t!=NULL)&&(my_strcasestr(nck,t)!=NULL))
		{	/* we have found a row containing a similar nickname */
			gtk_clist_select_row(clst,row,0);
			if(first_row==-1)
				first_row=row;
		}
	}

	gtk_clist_thaw(clst);
	if(first_row!=-1)
	{
		gtk_clist_moveto(clst,first_row,0,0,0);
	}
	g_string_free(nck,TRUE);
}

void
on_find_uaddr_by_addr_button_clicked   (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w1,*w2;
	char *ip;
	GtkCList *clst;
	int first_row=-1;
	int row;
	int len_ip;

	w1=get_widget_by_widget_name("uaddr_hostipport_entry");
	w2=get_widget_by_widget_name("uaddr_clist");

	if((w1==NULL)||(w2==NULL))
		return;

	ip=gtk_entry_get_text(GTK_ENTRY(w1));
	if((len_ip=strlen(ip))==0)
		return;

	clst=GTK_CLIST(w2);
	gtk_clist_freeze(clst);
	gtk_clist_unselect_all(clst);

	/* select all rows matching the given ip */
	for(row=0;row<clst->rows;row++)
	{
		char *t;

		gtk_clist_get_text(clst,row,1,&t);

		if((t!=NULL)&&(!strncmp(ip,t,len_ip)))
		{	/* we have found a row containing a similar ip */
			gtk_clist_select_row(clst,row,1);
			if(first_row==-1)
				first_row=row;
		}
	}

	gtk_clist_thaw(clst);
	if(first_row!=-1)
	{
		/* move the first selected row into the visible area */
		gtk_clist_moveto(clst,first_row,0,0,0);
	}
}


void
on_unselect_uaddr_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *w;

	w=get_widget_by_widget_name("uaddr_clist");
	if(w==NULL)
		return;
	gtk_clist_unselect_all(GTK_CLIST(w));
}



gboolean
on_hub_favorite_clist_key_press_event  (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{

  return FALSE;
}

/***********************************************************************/
/* add the selected entries of the given clist to the bookmark address */
/***********************************************************************/
static void add_bm_entries(char *clist_name,int hubname_col,int description_col, int address_col)
{
	GtkWidget *w;
	GtkCList *clst;
	GtkCListRow *clist_row;
	int row;

	w=get_widget_by_widget_name(clist_name);
	if(w==NULL)
		return;

	clst=GTK_CLIST(w);

   for(row=0;row<clst->rows;row++)
   {
      clist_row=g_list_nth(clst->row_list,row)->data;

      if(clist_row->state==GTK_STATE_SELECTED)
      {
			char *hubname;
			char *description;
			char *address;

			if(hubname_col!=-1)
			{
				gtk_clist_get_text(clst,row,hubname_col,&hubname);
				if((hubname==NULL)||(strlen(hubname)==0))
					hubname="No name";
			}
			else
				hubname="No name";

			if(description_col!=-1)
			{
				gtk_clist_get_text(clst,row,description_col,&description);
				if((description==NULL)||(strlen(description)==0))
					description="No description";
			}
			else
				description="No description";

			if(address_col!=-1)
			{
				gtk_clist_get_text(clst,row,address_col,&address);
				if((address==NULL)||(strlen(address)==0))
					address="No address";
			}
			else
				address="No address";

			add_entry_to_bookmark(hubname,description,address,1);		/* add without reload */
		}
	}

	reload_bookmark();
}

void
on_bookmark_button_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
	switch(gtk_notebook_get_current_page(GTK_NOTEBOOK(get_widget_by_widget_name("connect_notebook"))))
	{
		case RUNNING_HUB_TAB:
					add_bm_entries("running_hub_clist",2,-1,0);
					break;
		
		case PUBLIC_HUB_TAB:	
					add_bm_entries("hub_public_clist",0,2,3);
					break;

		case RECENT_HUB_TAB:
					add_bm_entries("hub_recent_clist",0,2,3);
					break;

		case SEEN_PUBLIC_HUB_TAB:	
					add_bm_entries("seen_hub_clist",0,2,3);
					break;

		default:
	}
}


void
on_delete_selected_bookmark_button_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w;
	GtkCList *clst;
	GtkCListRow *clist_row;
	int row;
	int hubname_col=0;
	int description_col=1;
	int address_col=2;

	w=get_widget_by_widget_name("hub_favorite_clist");
	if(w==NULL)
		return;

	clst=GTK_CLIST(w);

   for(row=0;row<clst->rows;row++)
   {
      clist_row=g_list_nth(clst->row_list,row)->data;

      if(clist_row->state==GTK_STATE_SELECTED)
      {
			char *hubname;
			char *description;
			char *address;

			if(hubname_col!=-1)
			{
				gtk_clist_get_text(clst,row,hubname_col,&hubname);
				if((hubname==NULL)||(strlen(hubname)==0))
					hubname="No name";
			}
			else
				hubname="No name";

			if(description_col!=-1)
			{
				gtk_clist_get_text(clst,row,description_col,&description);
				if((description==NULL)||(strlen(description)==0))
					description="No description";
			}
			else
				description="No description";

			if(address_col!=-1)
			{
				gtk_clist_get_text(clst,row,address_col,&address);
				if((address==NULL)||(strlen(address)==0))
					address="No address";
			}
			else
				address="No address";

			delete_entry_from_bookmark(hubname,description,address,1);		/* add without reload */
		}
	}

	reload_bookmark();
}


void
on_chat_notebook_switch_page           (GtkNotebook     *notebook,
                                        GtkNotebookPage *page,
                                        gint             page_num,
                                        gpointer         user_data)
{
	blink_off(lbl_chat[page_num]);
}


void
on_start_dctc_selected_hub_button_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w;
	GtkCList *clst;
	GtkCListRow *clist_row;
	const char *clist_name;
	int col_num;
	int row;

	switch(gtk_notebook_get_current_page(GTK_NOTEBOOK(get_widget_by_widget_name("connect_notebook"))))
	{
		case FAVORITE_HUB_TAB:
					clist_name="hub_favorite_clist";
					col_num=2;
					break;
		
		case PUBLIC_HUB_TAB:	
					clist_name="hub_public_clist";
					col_num=3;
					break;

		case RECENT_HUB_TAB:
					clist_name="hub_recent_clist";
					col_num=3;
					break;

		case SEEN_PUBLIC_HUB_TAB:	
					clist_name="seen_hub_clist";
					col_num=3;
					break;

		default:
					return;
	}

	w=get_widget_by_widget_name(clist_name);
	if(w==NULL)
		return;

	clst=GTK_CLIST(w);

   for(row=0;row<clst->rows;row++)
   {
      clist_row=g_list_nth(clst->row_list,row)->data;

      if(clist_row->state==GTK_STATE_SELECTED)
      {
			char *address;
			gtk_clist_get_text(clst,row,col_num,&address);
			if((address!=NULL)&&(strlen(address)!=0))
			{
				start_a_new_dctc(address,1);		/* start without waiting */
			}
		}
	}
}


void
on_seen_hub_clist_click_column         (GtkCList        *clist,
                                        gint             column,
                                        gpointer         user_data)
{
	on_hub_favorite_clist_click_column(clist,column,user_data);
}


gboolean
on_seen_hub_clist_button_press_event   (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	if(event==NULL)
		return TRUE;

	if(event->window != GTK_CLIST(widget)->clist_window)
		return FALSE;

	if(event->button==1)
	{	/* left click */
		gint ret;
		gint row,col;

		ret = gtk_clist_get_selection_info(GTK_CLIST(widget), (gint) event->x, (gint) event->y, &row, &col);
		if(ret && (row < GTK_CLIST(widget)->rows) )
		{
			if(event->type==GDK_2BUTTON_PRESS)
			{	/* double click on a row */
				char *col;

				if(gtk_clist_get_text(GTK_CLIST(widget),row,3,&col))
					start_a_new_dctc(col,0);
			}
		}
		return TRUE;
	}

  return FALSE;
}


void
on_expand_all_gdl_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	on_expand_all_ctree(menuitem,"gdl_ctree");
#if 0
	GtkWidget *w;

	w=get_widget_by_widget_name("gdl_ctree");
	if(w!=NULL)
	{
		GtkCTreeNode *work;

		work=GTK_CTREE_NODE (GTK_CLIST (w)->row_list);

		while(work!=NULL)
		{
			gtk_ctree_expand_recursive(GTK_CTREE(w),work);
			work = GTK_CTREE_ROW (work)->sibling;
		}
	}
#endif
}


void
on_shrink_all_gdl_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	on_shrink_all_ctree(menuitem,"gdl_ctree");
#if 0
	GtkWidget *w;

	w=get_widget_by_widget_name("gdl_ctree");
	if(w!=NULL)
	{
		GtkCTreeNode *work;

		work=GTK_CTREE_NODE (GTK_CLIST (w)->row_list);

		while(work!=NULL)
		{
			gtk_ctree_collapse_recursive(GTK_CTREE(w),work);
			work = GTK_CTREE_ROW (work)->sibling;
		}
	}
#endif
}

void
on_clear_globalchat_button_clicked     (GtkButton       *button,
                                        gpointer         user_data)
{
	wipe_gtk_text("chat_output");
}

void
on_clear_private_chat_button_clicked   (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w;
	w=get_widget_by_widget_name("chat_notebook");
	if(w)
	{
		wipe_gtk_text(chat_text[gtk_notebook_get_current_page(GTK_NOTEBOOK(w))]);
	}
}


static struct
			{
				const char *widget_name;
				const char *option_name;
				const char *autoflag_widget_name;
			} opt_list[]={ {"user_flag_ignore_pmsg_togglebutton","IGNORE_PMSG","autoflag_user_flag_ignore_pmsg_togglebutton"},
								{"user_flag_ignore_srch_togglebutton","IGNORE_SRCH","autoflag_user_flag_ignore_srch_togglebutton"},
								{"user_flag_ignore_sr_togglebutton","IGNORE_SREP","autoflag_user_flag_ignore_sr_togglebutton"},
								{"user_flag_no_xfer_togglebutton","IGNORE_XFER","autoflag_user_flag_no_xfer_togglebutton"},
								{"user_flag_ignore_dl_limit_togglebutton","IGNORE_SLOT_LIMIT","autoflag_user_flag_ignore_dl_limit_togglebutton"},
								{NULL,NULL}};


/**************************************************************************/
/* update the given nickname in flagged user list (this includes removal) */
/**************************************************************************/
static void update_flag_user_list1(char *nickname)
{
	char *data_val=NULL;
	int data_len=0;
	int ret;
	int row;
	GtkWidget *w;
	char buf[8192];

	w=get_widget_by_widget_name("flagged_user_clist");
	if(w==NULL)
		return;
		
	ret=get_key_data(unwanted_user,nickname,strlen(nickname),(void*)&data_val,&data_len);

	/* find the row of this user */
	row=row_num(GTK_CLIST(w),0,nickname);

	if(ret!=0)
	{
		/* user not found, delete its row */
		gtk_clist_remove(GTK_CLIST(w),row);
	}
	else
	{	/* user found, add/update its row */
		strncpy_max(buf,data_val,MIN(data_len+1,sizeof(buf)));
		
		if(row!=-1)
			gtk_clist_set_text(GTK_CLIST(w),row,1,buf);
		else
		{
			char *nw[2];
			nw[0]=nickname;
			nw[1]=buf;
			gtk_clist_append(GTK_CLIST(w),nw);
			gtk_clist_sort(GTK_CLIST(w));
		}

		if(data_val!=NULL)
			free(data_val);
	}
}

/************************************************************/
/* check if the given flag list contains the following flag */
/************************************************************/
/* output: 1= yes, the flag is here */
/*         0= no                    */
/************************************/
int flag_in_flag_list(char *data_val,const char *flag)
{
	int data_len;
	int ret;
	char *pos;
	int flag_len;

	ret=0;
	data_len=strlen(data_val);
	flag_len=strlen(flag);
	pos=data_val;

	while(flag_len<data_len)
	{
		if(!strncmp(flag,pos,flag_len))
		{  /* the beginning of flag match */
			if(pos[flag_len]=='|')	  /* and the current flag immediatly ends with a pipe */
			{
				ret=1;
				break;
			}
		}
		pos++;
		data_len--;
	}

	/* check the last flag if not yet found, last chance */
	if((ret==0)&&(flag_len==data_len))
	{
		if(!strncmp(flag,pos,flag_len))
			ret=1;
	}

	return ret;
}

void
on_flagged_user_clist_select_row       (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	GtkWidget *w;
	w=get_widget_by_widget_name("flagged_user_label");
	if(w)
	{
		char *t;

		gtk_clist_get_text(clist,row,0,&t);
		if((t!=NULL)&&(strlen(t)))
		{
			char *flag_list;
			int i=0;

			gtk_label_set(GTK_LABEL(w),t);

			gtk_clist_get_text(clist,row,1,&flag_list);

			while(opt_list[i].widget_name!=NULL)
			{
				w=get_widget_by_widget_name(opt_list[i].widget_name);
				if(w!=NULL)
				{
					if(flag_in_flag_list(flag_list,opt_list[i].option_name))
						gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(w),TRUE);
					else
						gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(w),FALSE);
				}
				i++;
			}
		}
	}
}


void
on_add_modify_flag_user_button_clicked (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w;
	w=get_widget_by_widget_name("flagged_user_label");
	if(w)
	{
		gchar *lbl;

		gtk_label_get(GTK_LABEL(w),&lbl);

		if((lbl!=NULL)&&(strlen(lbl)))
		{
			GString *flags;
			int i;

			flags=g_string_new("");

			i=0;
			while(opt_list[i].widget_name!=NULL)
			{
				w=get_widget_by_widget_name(opt_list[i].widget_name);
				if(w!=NULL)
				{
					if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w))==TRUE)
					{
						if(flags->len!=0)
							flags=g_string_append_c(flags,'|');
						flags=g_string_append(flags,opt_list[i].option_name);
					}
				}
				i++;
			}

			if(flags->len!=0)
				set_key_data(unwanted_user,lbl,strlen(lbl),flags->str,flags->len);
			else
				del_key_data(unwanted_user,lbl,strlen(lbl));
			g_string_free(flags,TRUE);

			update_flag_user_list1(lbl);
		}
	}
}


void
on_delete_flag_user_button_clicked     (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w;
	w=get_widget_by_widget_name("flagged_user_label");
	if(w)
	{
		gchar *lbl;

		gtk_label_get(GTK_LABEL(w),&lbl);

		if((lbl!=NULL)&&(strlen(lbl)))
		{
			del_key_data(unwanted_user,lbl,strlen(lbl));
			update_flag_user_list1(lbl);
		}
	}
}


static void reload_flagged_user_clist(int only_if_empty)
{
	GtkWidget *w;
	w=get_widget_by_widget_name("flagged_user_clist");
	if(w)
	{
		GtkCList *clst;

		clst=GTK_CLIST(w);
		if( (only_if_empty==0) || ( (only_if_empty&&(clst->rows==0) ) ) )
		{
			DBC *cursor;
			int ret;
			gtk_clist_freeze(clst);
			gtk_clist_clear(clst);

			ret=unwanted_user->cursor(unwanted_user,NULL,&cursor,0);
			if(ret==0)
			{

				DBT key;
				DBT data;
				char buf1[8192];
				char buf2[8192];
				char *row[2];

				memset(&key,0,sizeof(key));
				memset(&data,0,sizeof(data));

				key.data=buf1;
				key.ulen=sizeof(buf1)-1;
				key.flags=DB_DBT_USERMEM;

				data.data=buf2;
				data.ulen=sizeof(buf2)-1;
				data.flags=DB_DBT_USERMEM;

				row[0]=buf1;
				row[1]=buf2;

				ret=cursor->c_get(cursor,&key,&data,DB_FIRST);
				while(ret==0)
				{
					buf1[key.size]='\0';
					buf2[data.size]='\0';
			
					gtk_clist_append(clst,row);

					ret=cursor->c_get(cursor,&key,&data,DB_NEXT);
				}

				/* end of scan, destroy the cursor */
				cursor->c_close(cursor);
			}

			gtk_clist_sort(clst);
			gtk_clist_thaw(clst);
		}
	}
}

void
on_reload_flagged_user_list_button_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
	reload_flagged_user_clist(0);		/* force reload ... always */
}


static void flag_a_user(char *clist_name, int clist_column)
{
	GtkWidget *w;
	char *nick;
	GList *glst;
	int row;
	int fl_row;
	GtkWidget *fl_w;

	/* get the nickname of the remote side of the private chat */
	w=get_widget_by_widget_name(clist_name);
	glst=GTK_CLIST(w)->selection;
	if(glst==NULL)
		return;			/* no one is selected */

	row=(int)(glst->data);
	gtk_clist_get_text(GTK_CLIST(w),row,clist_column,&nick);
	if(nick==NULL)
		return;

	fl_w=get_widget_by_widget_name("flagged_user_clist");
	if(fl_w==NULL)
		return;

	fl_row=row_num(GTK_CLIST(fl_w),0,nick);
	if(fl_row!=-1)
	{
		/* the user is already flagged */
		gtk_clist_select_row(GTK_CLIST(fl_w),fl_row,0);
	}
	else
	{
		int i;

		w=get_widget_by_widget_name("flagged_user_label");
		if(w)
		{
			gtk_label_set(GTK_LABEL(w),nick);

			i=0;
			while(opt_list[i].widget_name!=NULL)
			{
				w=get_widget_by_widget_name(opt_list[i].widget_name);
				if(w!=NULL)
				{
					gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(w),TRUE);
				}
				i++;
			}

		}
	}

	w=get_widget_by_widget_name("main_notebook");
	gtk_notebook_set_page(GTK_NOTEBOOK(w),FLAGGED_USER_TAB);
}

void
on_flag_user_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	flag_a_user("user_clist",1);
}


void
on_flag_user2_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	flag_a_user("download_clist",0);
}


void
on_flag_user3_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	flag_a_user("find_result",0);
}

void
on_flag_pchat_user_button_clicked      (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w;
	w=get_widget_by_widget_name("chat_notebook");
	if(w)
	{
		int i;

		i=gtk_notebook_get_current_page(GTK_NOTEBOOK(w));

		w=get_widget_by_widget_name(lbl_chat[i]);
		if(w!=NULL)
		{
			char *nick;

			gtk_label_get(GTK_LABEL(w),&nick);
			auto_flag_user(nick);
		}
	}
}

void do_nick_completion(GtkEditable *w)
{
	gchar *str;
	char *beg;

	int cur_pos=gtk_editable_get_position(w);

	if(cur_pos<2)		/* at least 2 characters to perform a completion */
		return;

	str=gtk_editable_get_chars(w,0,cur_pos);
	beg=strrchr(str,' ');
	if(beg==NULL)
		beg=str;
	else
		beg++;

	if(strlen(beg)>1)
	{
		/* now, beg is the beginning of a string which can be the beginning of a nickname */
		GtkWidget *cl;
		GtkCList *clst;
		int i;
		int ln;
		int fnd=-1;
		gchar *t;

		ln=strlen(beg);

		cl=get_widget_by_widget_name("user_clist");
		clst=GTK_CLIST(cl);
		
		for(i=0;i<clst->rows;i++)
		{
			gtk_clist_get_text(clst,i,1,&t);

			if(!strncmp(t,beg,ln))		/* pattern matched ? */
			{
				if(fnd==-1)
					fnd=i;
				else
				{
					fnd=-1;
					break;					/* more than one nickname matched, abort */
				}
			}
		}

		if(fnd!=-1)
		{
			int ln2;

			gtk_clist_get_text(clst,fnd,1,&t);
			ln2=strlen(t);

			if(ln2!=ln)
			{
				gtk_editable_insert_text(w,t+ln,ln2-ln,&cur_pos);
			}
			gtk_editable_insert_text(w," ",1,&cur_pos);
			gtk_editable_set_position(w,cur_pos);
		}
	}
	
	g_free(str);
}


gboolean
on_chat_input_key_press_event          (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
	if(event==NULL)
		return FALSE;

	switch(event->keyval)
	{
		case GDK_Tab:	/* tab pressed */
						do_nick_completion(GTK_EDITABLE(widget));
						return TRUE;
	}

	return TRUE;
}


gboolean
on_pchat_entry_key_press_event         (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
	if(event==NULL)
		return FALSE;

	switch(event->keyval)
	{
		case GDK_Tab:	/* tab pressed */
						do_nick_completion(GTK_EDITABLE(widget));
						return TRUE;
	}

	return TRUE;
}

static void try_to_attach_this_gdl(const char *dir1, const char *dir2)
{
	GString *str;
	int fd;

	str=g_string_new("");
	g_string_sprintf(str,"%s/%s/.lock",dir1,dir2);

	fd=open(str->str,O_RDWR);
	if(fd!=-1)
	{
		if(lockf(fd,F_TEST,1)==0)
		{
			/* .lock file exists and is lockable, so nobody uses this entry */

			/* create and send the GDL attachment query */
			g_string_sprintf(str,"/GDLATTACH %s\n",dir2);
			send_data_to_dctc(str->str);
		}
		close(fd);
	}
	g_string_free(str,TRUE);
}


void
on_attach_all_unattached_gdl_activate  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	DIR *dir;
	struct dirent *obj;
	const char *t;

	t=get_var("dl_path");
	if((t!=NULL)&&(strlen(t)))
	{
		GString *st1;

		st1=g_string_new(t);
		st1=g_string_append(st1,"/GDL");
		dir=opendir(st1->str);
		if(dir!=NULL)
		{
			while((obj=readdir(dir))!=NULL)
			{
				try_to_attach_this_gdl(st1->str,obj->d_name);
			}
			closedir(dir);
		}
		g_string_free(st1,TRUE);
	}
}

/***************************************************************/
/* send a /QUIT\n to the DCTC having the given socket filename */
/***************************************************************/
static void send_quit_command_to_client(char *unx_sock_name)
{
	GString *cur_udp_path;
	struct sockaddr_un name;

	if(local_udp_socket==-1)
		return;

	cur_udp_path=g_string_new(dctc_dir->str);
	g_string_sprintfa(cur_udp_path,"/%s.udp",unx_sock_name);

	name.sun_family=AF_UNIX;
	strcpy(name.sun_path,cur_udp_path->str);
	if(sendto(local_udp_socket,"/FORCEQUIT\n",strlen("/FORCEQUIT\n"),MSG_NOSIGNAL|MSG_DONTWAIT,(void*)&name,sizeof(struct sockaddr_un))!=strlen("/FORCEQUIT\n"))
	{
		perror("send_quit_command_to_client");
	}
	
	g_string_free(cur_udp_path,TRUE);
}

/******************************************************/
/* terminate selected DCTC with more or less violence */
/******************************************************/
static void terminate_selected_dctc_entries(int kill_it)
{
	GtkWidget *w;
	GtkCList *clst;
	GtkCListRow *clist_row;
	int row;
	GArray *ga=NULL;
	int nb=0;

	w=get_widget_by_widget_name("running_hub_clist");
	if(w==NULL)
		return;

	if(kill_it)
		ga=g_array_new(FALSE,FALSE,sizeof(pid_t));

	clst=GTK_CLIST(w);

   for(row=0;row<clst->rows;row++)
   {
      clist_row=g_list_nth(clst->row_list,row)->data;

      if(clist_row->state==GTK_STATE_SELECTED)
      {
			char *unx_sock_name;

			gtk_clist_get_text(clst,row,1,&unx_sock_name);
			if((unx_sock_name==NULL)||(strlen(unx_sock_name)==0))
				continue;

			send_quit_command_to_client(unx_sock_name);
			nb++;

			if(kill_it)
			{
				pid_t num;
				int num_int;

				sscanf(unx_sock_name+5,"%08X",&num_int);
				num=num_int;
				ga=g_array_append_val(ga,num);
			}
		}
	}

	if((kill_it)&&(ga->len!=0))
	{
		int i;
		sleep(3);		/* wait a little before killing everybody */
		for(i=0;i<ga->len;i++)
		{
			pid_t num;

			num=g_array_index(ga,pid_t,i);

			kill(num,SIGKILL);
		}
	}

	if(ga!=NULL)
		g_array_free(ga,TRUE);

	if(nb!=0)
	{
		if(kill_it)
		{
			sleep(1);
		}
		else
		{
			sleep(2);
		}
		on_refresh_sitelist_button_clicked(NULL,NULL);
	}
}

void
on_terminate_selected_dctcs_button_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
	terminate_selected_dctc_entries(0);
}


void
on_kill_selected_dctcs_button_clicked  (GtkButton       *button,
                                        gpointer         user_data)
{
	terminate_selected_dctc_entries(1);
}


void
on_flag_user_from_gdl_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	cmd_selected_gdl_user(flag_user_of_this_gdl_entry);
}


void
on_gdl_view_file_list_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	cmd_selected_gdl_user(view_user_file_list_of_this_gdl_entry);
}


void
on_unode_addr_entry_activate           (GtkEditable     *editable,
                                        gpointer         user_data)
{
	UNODE_DATA und;
	char *param;

	param=gtk_entry_get_text(GTK_ENTRY(editable));
	if(strlen(param)<1)
		return;

	memset(&und,0,sizeof(und));
	und.entry_enabled=1;
	und.dynamic_ip=1;

	set_key_data(unode_db,param,strlen(param),&und,sizeof(und));
	reload_unode_clist(0);

	gtk_editable_set_position(GTK_EDITABLE(editable),0);
	gtk_editable_delete_text(GTK_EDITABLE(editable),0,-1);
}


void
on_addr_unode_button_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w;

	w=get_widget_by_widget_name("unode_addr_entry");
	if(w!=NULL)
	{
		on_unode_addr_entry_activate(GTK_EDITABLE(w),NULL);
	}
}


void
on_del_selected_unode_button_clicked   (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w;
	w=get_widget_by_widget_name("unode_clist");
	if(w)
	{
		GtkCList *clst;
		GtkCListRow *clist_row;
		int row;
		int changed=0;

		clst=GTK_CLIST(w);
	
		for(row=0;row<clst->rows;row++)
		{
			clist_row=g_list_nth(clst->row_list,row)->data;
	
			if(clist_row->state==GTK_STATE_SELECTED)
			{
				char *unode;

				if(gtk_clist_get_text(clst,row,0,&unode))
				{
					if((unode!=NULL)&&(strlen(unode)))
					{
						del_key_data(unode_db,unode,strlen(unode));
						changed=1;
					}
				}
			}
		}
		if(changed)
			reload_unode_clist(0);
	}
}

static void reload_unode_clist(int only_if_empty)
{
	GtkWidget *w;
	w=get_widget_by_widget_name("unode_clist");
	if(w)
	{
		GtkCList *clst;

		clst=GTK_CLIST(w);
		if( (only_if_empty==0) || ( (only_if_empty&&(clst->rows==0) ) ) )
		{
			DBC *cursor;
			int ret;
			gtk_clist_freeze(clst);
			gtk_clist_clear(clst);

			ret=unwanted_user->cursor(unode_db,NULL,&cursor,0);
			if(ret==0)
			{

				DBT key;
				DBT data;
				char buf1[8192];
				UNODE_DATA buf2;
				char *row[1];

				memset(&key,0,sizeof(key));
				memset(&data,0,sizeof(data));

				key.data=buf1;
				key.ulen=sizeof(buf1)-1;
				key.flags=DB_DBT_USERMEM;

				data.data=&buf2;
				data.ulen=sizeof(buf2);
				data.flags=DB_DBT_USERMEM;

				row[0]=buf1;

				ret=cursor->c_get(cursor,&key,&data,DB_FIRST);
				while(ret==0)
				{
					buf1[key.size]='\0';
			
					gtk_clist_append(clst,row);

					ret=cursor->c_get(cursor,&key,&data,DB_NEXT);
				}

				/* end of scan, destroy the cursor */
				cursor->c_close(cursor);
			}

			gtk_clist_sort(clst);
			gtk_clist_thaw(clst);
		}
	}
}


void
on_reload_unode_address_list_button_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
	reload_unode_clist(0);
}


void
on_save_share_list_button_clicked      (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_load_share_list_button_clicked      (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_locate_user_clist_click_column      (GtkCList        *clist,
                                        gint             column,
                                        gpointer         user_data)
{

}


gboolean
on_locate_user_clist_button_press_event
                                        (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{

  return FALSE;
}


void
on_locate_user_entry_activate          (GtkEditable     *editable,
                                        gpointer         user_data)
{
	char *pattern;

	pattern=gtk_entry_get_text(GTK_ENTRY(get_widget_by_widget_name("locate_user_entry")));
	if((pattern!=NULL)&&(strlen(pattern)))
	{
		GString *str;

		gtk_label_set_text(GTK_LABEL(get_widget_by_widget_name("currently_searched_user_label")),pattern);

		str=g_string_new("");
		g_string_sprintf(str,"/LOCATEUSER %s\n",pattern);
		send_data_to_dctc(str->str);
		g_string_free(str,TRUE);

		gtk_clist_clear(GTK_CLIST(get_widget_by_widget_name("locate_user_clist")));
	}
}

static void input_this_in_locate_user_entry(char *content)
{
	GtkWidget *w;
	w=get_widget_by_widget_name("locate_user_entry");
	if(w==NULL)
		return;

	gtk_entry_set_text(GTK_ENTRY(w),content);
	gtk_button_clicked(GTK_BUTTON(get_widget_by_widget_name("search_user_button")));

	/* and switch to the find page */
	on_show_search_user_side_button_clicked(NULL,NULL);
	gtk_notebook_set_page(GTK_NOTEBOOK(get_widget_by_widget_name("main_notebook")),FIND_TAB);
}

static void search_for_selected_user_in_clist(char *clist_name, int column)
{
	GtkWidget *w;
	GtkCList *clist;
	GtkCListRow *clist_row;

	int row;

	w=get_widget_by_widget_name(clist_name);
	if(w==NULL)
		return;
	clist=GTK_CLIST(w);

	for(row=0;row<clist->rows;row++)
	{
		clist_row=g_list_nth(clist->row_list,row)->data;

		if(clist_row->state==GTK_STATE_SELECTED)
		{
			char *t;

			gtk_clist_get_text(clist,row,column,&t);
			input_this_in_locate_user_entry(t);
			break;
		}
	}
}


void
on_search_user_of_dl_clist_activate	 (GtkMenuItem	  *menuitem,
                                        gpointer         user_data)
{
	search_for_selected_user_in_clist("user_clist",0);
}


void
on_search_user_of_user_clist_activate  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	search_for_selected_user_in_clist("user_clist",1);
}

static void search_for_selected_user_in_ctree(char *clist_name, int column)
{
	GtkWidget *w;
	GtkCList *clist;
	GtkCListRow *clist_row;

	int row;

	w=get_widget_by_widget_name(clist_name);
	if(w==NULL)
		return;
	clist=GTK_CLIST(w);

	for(row=0;row<clist->rows;row++)
	{
		clist_row=g_list_nth(clist->row_list,row)->data;

		if(clist_row->state==GTK_STATE_SELECTED)
		{
			char *t;

			if(column!=0)
				gtk_clist_get_text(clist,row,column,&t);
			else
				gtk_clist_get_pixtext(clist,row,0,&t,NULL,NULL,NULL);
			input_this_in_locate_user_entry(t);
			break;
		}
	}
}

void
on_search_user_of_gdl_clist_activate   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	search_for_selected_user_in_ctree("user_ctree",0);
}


void
on_search_user_button_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
	on_locate_user_entry_activate(NULL,NULL);
}


void
on_show_search_user_side_button_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
	gtk_widget_show(get_widget_by_widget_name("user_search_vbox"));
	gtk_widget_show(get_widget_by_widget_name("hide_search_user_button"));
	gtk_widget_hide(get_widget_by_widget_name("show_search_user_side_button"));
}


void
on_hide_search_user_button_clicked     (GtkButton       *button,
                                        gpointer         user_data)
{
	gtk_widget_hide(get_widget_by_widget_name("user_search_vbox"));
	gtk_widget_hide(get_widget_by_widget_name("hide_search_user_button"));
	gtk_widget_show(get_widget_by_widget_name("show_search_user_side_button"));
}


void
on_do_browse_vshare_dir_button_clicked (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w;

	w=create_vshare_dir_fileselection();
	{
		GtkWidget *dl_dir_ent;

		dl_dir_ent=get_widget_by_widget_name("vshare_dir_entry");
		if(dl_dir_ent!=NULL)
		{
			char *t;

			t=gtk_entry_get_text(GTK_ENTRY(dl_dir_ent));
			gtk_file_selection_set_filename(GTK_FILE_SELECTION(w),t);
		}
	}
	gtk_widget_show(w);
	widget_log(w);			/* for an unknown reason, widget_log is not called for the widget containing widgets created by create_* functions */
								/* so we must manually register it */
}


void
on_vshare_dir_select_ok_button_clicked (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w;
	gchar *selected_filename;

	w=get_widget_by_widget_name("vshare_dir_fileselection");

	selected_filename=gtk_file_selection_get_filename(GTK_FILE_SELECTION(w));
	if(selected_filename!=NULL)
	{
		char *path;

		path=strdup(selected_filename);
		if(path!=NULL)
		{
			struct stat st;

			/* verify if the given name is a valid directory */
			if(stat(path,&st)==-1)
			{
				err:
				gnome_app_error(GNOME_APP(main_window),_("invalid dir name"));
			}
			else
			{
				if(!S_ISDIR(st.st_mode))
				{	/* it exists but it is not a directory, remove the filename and retry */
					char *t;
					t=strrchr(path,'/');
					if(t==path)
						goto err;
					t[1]='\0';		/* keep the trailing / */

					if(stat(path,&st)==-1)
						goto err;
					if(!S_ISDIR(st.st_mode))
						goto err;
				}
				printf("'%s'\n",path);
				
				{
					GtkWidget *dl_dir_ent;

					dl_dir_ent=get_widget_by_widget_name("vshare_dir_entry");
					if(dl_dir_ent!=NULL)
					{
						gtk_entry_set_text(GTK_ENTRY(dl_dir_ent),path);
					}
				}
			}
			free(path);
		}
	}
	widget_unlog(w);
	gtk_widget_destroy(w);

}


void
on_vshare_dir_cancel_button_clicked    (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w;

	w=get_widget_by_widget_name("vshare_dir_fileselection");
	widget_unlog(w);
	gtk_widget_destroy(w);
}

