/*
 *  methods for unit-testing utiltities for cryptmount
 *  $Revision: 130 $, $Date: 2006-10-15 11:42:36 +0100 (Sun, 15 Oct 2006) $
 *  Copyright 2006 RW Penney
 */

/*
    This file is part of cryptmount

    cryptmount is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    As a special exemption, permission is granted to link cryptmount
    with the OpenSSL project's "OpenSSL" library and distribute
    the linked code without invoking clause 2(b) of the GNU GPL version 2.

    cryptmount is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with cryptmount; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifdef TESTING

#include <config.h>

#include <stdio.h>

#include "cmtesting.h"


int cm_tests_run;
int cm_tests_stat[CM_TEST_LAST];
const char *cm_test_ident=NULL;

void cm_tests_init();
int cm_tests_close();


void cm_tests_init()
{   int i;

    cm_tests_run = 0;
    for (i=0; i<CM_TEST_LAST; ++i) {
        cm_tests_stat[i] = 0;
    }
}


int cm_tests_close()
{   int i,nt;

    for (i=0,nt=0; i<CM_TEST_LAST; ++i) {
        nt += cm_tests_stat[i];
    }

    if (nt != cm_tests_run) {
        fprintf(stderr, "mismatch in test-statistics (%d != %d)\n",
                nt, cm_tests_run);
    }

    if (cm_tests_stat[CM_TEST_PASSED] == cm_tests_run) {
        fprintf(stderr, "++++ all %d tests PASSED ++++\n", cm_tests_run);
    } else {
        fprintf(stderr, "!!!! %2d tests FAILED !!!!\n",
            cm_tests_stat[CM_TEST_FAILED]);
        fprintf(stderr, "!!!! %2d tests passed !!!!\n",
            cm_tests_stat[CM_TEST_PASSED]);
        fprintf(stderr, "!!!! %2d tests aborted !!!!\n",
            cm_tests_stat[CM_TEST_ABORTED]);
    }

    return (cm_tests_stat[CM_TEST_PASSED] != cm_tests_run);
}


int cm_run_tests()
    /* front-end to self-testing routines */
{
    cm_tests_init();

#if HAVE_OPENSSL
    kmssl_init_algs();
    kmssl_test_hash();
    kmssl_test_getalgos();
    kmssl_free_algs();
#endif

#if HAVE_LIBGCRYPT
    kmgcry_test_hash();
    kmgcry_test_getalgos();
#endif

    km_test_keyrw();

    return cm_tests_close();
}

#else   /* !TESTING */

int _keep_ansi_pedantic_quiet = 0;

#endif  /* TESTING */

/*
 *  (C)Copyright 2006, RW Penney
 */
