#include "cp_types.h"
#include "cp_proto.h"

/* Write 'light' pack data to open filepointer fp. If flag set,
then want 'raw' data, ie., no keywords, etc. Return 0 on error. */

extern char buf[];

int write_light(FILE *fp,struct p_light *pl,int flag)
{
  int i,n,tick,digits,count,num,vert=1;
  char format_buf[32];

  count=pl->counts[0];
  if (!flag)
    {
      fprintf(fp,"VERTCOUNT:   %d\n",count);
      if (pl->counts[1]<0) sprintf(buf,"hyperbolic");
      else if (pl->counts[1]>0) sprintf(buf,"spherical");
      else sprintf(buf,"euclidean");
      fprintf(fp,"GEOMETRY:   %s\n",buf);
      fprintf(fp,"VARIABLE_COUNT:   %d\n",pl->counts[2]);
      if (pl->counts[4]) /* parent nodecount */
	fprintf(fp,"CHECK_COUNT:   %d\n",pl->counts[4]);
      if (pl->counts[5]) /* aims specified? */
	fprintf(fp,"AIM_COUNT:   %d\n",pl->counts[5]);
    }
  else for (n=0;n<12;n++) fprintf(fp,"%d ",pl->counts[n]);
     /* note: only first 6 spots currently in use. */

  fprintf(fp,"\n");
  if (!flag)
    fprintf(fp,"FLOWERS_OF_VARIABLE_VERTS: \n"); /* interior flowers */
  tick=1;
  for (n=1;n<=pl->counts[2];n++) 
    {
      if (!flag) fprintf(fp,"\n%d ",vert++);
      num=pl->var_indices[tick++];
      fprintf(fp,"%d  ",num);
      for (i=0;i<=num;i++)
	fprintf(fp,"%d ",pl->var_indices[tick+i]);
      tick +=(num+1);
    }

  digits=1;
  while ((pow(10,(double)digits))*toler < 0.1 
	 && digits<MAX_ACCUR) digits++;
  sprintf(format_buf,"%% .%de ",digits);

  fprintf(fp,"\n");
  if (!flag) 
    fprintf(fp,"\nORIG_INDICES: \n  "); /* original packing indices */
  for (i=1;i<=count;i++)
    {
      fprintf(fp,"%d  ",pl->orig_indices[i]);
      if (!flag && (i % 10)==0) fprintf(fp,"\n");
    }

  fprintf(fp,"\n");
  if (!flag) 
    fprintf(fp,"\nRADII:\n"); /* radii for all */

  for (i=1;i<=count;i++)
    {
      fprintf(fp,format_buf,radius_pl(pl,i));
      if (!flag && (i % 4)==0) fprintf(fp,"\n");
    }
  fprintf(fp,"\n");

  if (pl->counts[5]) /* have non-default aims? */
    {
      fprintf(fp,"\n");
      if (!flag) fprintf(fp,"\nAIM_INDICES: %d \n",pl->counts[5]);
      for (i=1;i<=pl->counts[5];i++)
	fprintf(fp,"%d  ",pl->aim_indices[i]);
      fprintf(fp,"\n");
      if (!flag) fprintf(fp,"\nAIMS:\n");
      for (i=1;i<=pl->counts[5];i++)
	fprintf(fp,format_buf,pl->aims[i]);
    }

  if (!flag) fprintf(fp,"\n\nEND\n");

  return 1;
} /* write_light */
