#include "cp_types.h"
#include "cp_proto.h"

/* called only by 'split_flips'; put deg-4 vertex in <v,w>;
face data not updated between calls. */

int split_edge(struct p_data *p,int v,int w)
{
  int j,ind_v,ind_w,bflag=0,new,lv,rv=0,*newflower;
  double *newol;
  struct K_data *pK_ptr;
  struct R_data *pR_ptr;

  pK_ptr=p->packK_ptr;pR_ptr=p->packR_ptr;
  if (pK_ptr[v].bdry_flag && pK_ptr[w].bdry_flag)
    {
      if (pK_ptr[v].flower[0]==w) bflag=1;
      else if (pK_ptr[w].flower[0]==v) /* swap v, w */
	{
	  bflag=1;
	  v=w;
	  w=pK_ptr[v].flower[0];
	}
    }
  if ((ind_v=nghb(p,v,w))<0 || (ind_w=nghb(p,w,v))<0) /* not nghbs */
    return 0;
  lv=pK_ptr[v].flower[ind_v+1];
  if (!bflag) rv=pK_ptr[w].flower[ind_w+1];
  /* put in new vertex */
  new=p->nodecount+1;
  pK_ptr[new].flower=(int *)calloc((size_t)(5-2*bflag),sizeof(int));
  if (p->overlap_status)
    pK_ptr[new].overlaps=(double *)calloc((size_t)(5-2*bflag),sizeof(double));
  p->nodecount++;
  if (bflag) 
    {
      pK_ptr[new].num=2;
      pK_ptr[new].flower[0]=w;
      pK_ptr[new].flower[1]=lv;
      pK_ptr[new].flower[2]=v;
      if (p->overlap_status)
	pK_ptr[new].overlaps[0]
	  =pK_ptr[new].overlaps[1]
	  =pK_ptr[new].overlaps[2]=1.0;
      pK_ptr[new].bdry_flag=1;
      pK_ptr[new].mark=0;
      pK_ptr[new].color=FG_COLOR;
      pR_ptr[new].rad=pR_ptr[v].rad;
      pR_ptr[new].aim=-.1;
    }
  else
    {
      pK_ptr[new].num=4;
      pK_ptr[new].flower[0]=pK_ptr[new].flower[4]=v;
      pK_ptr[new].flower[1]=rv;
      pK_ptr[new].flower[2]=w;
      pK_ptr[new].flower[3]=lv;
      pK_ptr[new].bdry_flag=0;
      if (p->overlap_status)
	pK_ptr[new].overlaps[0]
	  =pK_ptr[new].overlaps[1]
	  =pK_ptr[new].overlaps[2]
	  =pK_ptr[new].overlaps[3]=1.0;
      pK_ptr[new].mark=0;
      pK_ptr[new].color=FG_COLOR;
      pR_ptr[new].rad=.5*pR_ptr[v].rad;
      pR_ptr[new].aim=2.0*M_PI;
      /* compute packed radius */
      if (p->hes<0) h_riffle_vert(p,new);
      else if (p->hes>0) s_riffle_vert(p,new);
      else e_riffle_vert(p,new);
    }
  if (p->hes<=0) 
    {
      pR_ptr[new].center.re=
	(pR_ptr[v].center.re+pR_ptr[w].center.re)/2.0;
      pR_ptr[new].center.im=
	(pR_ptr[v].center.im+pR_ptr[w].center.im)/2.0;
    }
  else {pR_ptr[new].center.re=0.0;pR_ptr[new].center.re=M_PI;}
  /* adjust nghb flowers */
  ind_v=nghb(p,lv,v);
  newflower=(int *)calloc((size_t)(pK_ptr[lv].num+2),sizeof(int));
  for (j=0;j<=ind_v;j++) newflower[j]=pK_ptr[lv].flower[j];
  for (j=pK_ptr[lv].num;j>ind_v;j--)
    newflower[j+1]=pK_ptr[lv].flower[j];
  newflower[ind_v+1]=new;
  free(pK_ptr[lv].flower);
  pK_ptr[lv].flower=newflower;		
  if (p->overlap_status)
    {
      newol=(double *)calloc((size_t)(pK_ptr[lv].num+2),sizeof(double));
      for (j=0;j<=ind_v;j++) newol[j]=pK_ptr[lv].overlaps[j];
      for (j=pK_ptr[lv].num;j>ind_v;j--)
	newol[j+1]=pK_ptr[lv].overlaps[j];
      newol[ind_v+1]=1.0;
      free(pK_ptr[lv].overlaps);
      pK_ptr[lv].overlaps=newol;
    }
  pK_ptr[lv].num++;
  if (!bflag)
    {
      ind_w=nghb(p,rv,w);
      newflower=(int *)calloc((size_t)(pK_ptr[rv].num+2),
			      sizeof(int));
      for (j=0;j<=ind_w;j++) newflower[j]=pK_ptr[rv].flower[j];
      for (j=pK_ptr[rv].num;j>ind_w;j--)
	newflower[j+1]=pK_ptr[rv].flower[j];
      newflower[ind_w+1]=new;
      free(pK_ptr[rv].flower);
      pK_ptr[rv].flower=newflower;
      if (p->overlap_status)
	{
	  newol=(float *)calloc((size_t)(pK_ptr[rv].num+2),sizeof(double));
	  for (j=0;j<=ind_w;j++) newol[j]=pK_ptr[rv].overlaps[j];
	  for (j=pK_ptr[rv].num;j>ind_w;j--)
	    newol[j+1]=pK_ptr[rv].overlaps[j];
	  newol[ind_w+1]=1.0;
	  free(pK_ptr[rv].overlaps);
	  pK_ptr[rv].overlaps=newol;
	}
      pK_ptr[rv].num++;
    }
  /* adjust v and w */
  ind_v=nghb(p,v,w);
  pK_ptr[v].flower[ind_v]=new;
  if (p->overlap_status) pK_ptr[v].overlaps[ind_v]=1.0;
  if (ind_v==0 && !pK_ptr[v].bdry_flag) 
    pK_ptr[v].flower[pK_ptr[v].num]=new;
  ind_w=nghb(p,w,v);
  pK_ptr[w].flower[ind_w]=new;
  if (p->overlap_status) pK_ptr[w].overlaps[ind_w]=1.0;
  if (ind_w==0 && !pK_ptr[w].bdry_flag) 
    pK_ptr[w].flower[pK_ptr[w].num]=new;
  return 1;
} /* split_edge */
