#include "cp_types.h"
#include "cp_proto.h"

/* recompute centers using drawing order as in draw_in_order. 
Report all locations of vertex v. flag means to place first face. 
Note that this changes center data. */

int layout_report(struct p_data *p,int v,int flag)
{
  int start=0,move=0,j,nf,vert,vflag=1,ck=0,n0,indx;
  complex a,g,w,I,modw,newz,z,y;
  struct Centlist *centlist,*ctmp,*ctrace=NULL;
  struct R_data *pR_ptr=p->packR_ptr;

  centlist=NULL;
  if (v>0 && v<=p->nodecount) vflag=0;
  nf=p->first_face;	
  if (flag) place_face(p,nf,p->faces[nf].index_flag);
  for (j=0;j<3;j++) /* initial location of v */
    if (p->faces[nf].vert[j]==v) /* record first center */
      {
	start=j+1;
	ctmp=(struct Centlist *)calloc(1,sizeof(struct Centlist));
	ctmp->z=pR_ptr[v].center;
	if (!centlist) centlist=ctrace=ctmp;
	else ctrace=ctrace->next=ctmp;
      }
  while ( (nf=p->faces[nf].next_face)!=p->first_face 
	  && ck<2*p->facecount && nf>0 && nf <= p->facecount)
    {
      vert=p->faces[nf].vert[
			     (indx=(p->faces[nf].index_flag + 2) % 3)];
      n0=nghb(p,vert,p->faces[nf].vert[(indx+1)%3]);
      fancy_comp_center(p,vert,n0,n0,1,0,1,1,toler);
      if (!vflag && vert==v) 
	/* record center */
	{
	  move++;
	  ctmp=(struct Centlist *)calloc(1,sizeof(struct Centlist));
	  ctmp->z=pR_ptr[v].center;
	  if (!centlist) centlist=ctrace=ctmp;
	  else ctrace=ctrace->next=ctmp;
	}
      ck++;
    }
  if (nf!=p->first_face) /* some error */
    return 0; 
  if (!vflag && start && move) 
    /* if v in first face and has moved, give final location */
    {
      ctmp=(struct Centlist *)calloc(1,sizeof(struct Centlist));
      ctmp->z=pR_ptr[v].center;
      if (!centlist) centlist=ctrace=ctmp;
      else ctrace=ctrace->next=ctmp;
    }

  /* normalize */
  a=pR_ptr[p->alpha].center;
  g=pR_ptr[p->gamma].center;
  norm_any_pack(p,a,g);

  /* adjust locations reported for v because of normalization */
  if (centlist)
    {
      sprintf(msgbuf,"Locations of vertex %d: ",v);
      msg();
      ctrace=centlist;
      while (ctrace)
	{
	  z=newz=ctrace->z;
	  if (p->hes< 0) /* hyp */
	    newz=mob_norm(z,a,g);
	  else if (p->hes ==0) /* eucl */
	    {
	      w=csub(g,a);
	      I.re=0; I.im=cAbs(w);
	      modw=cdiv(I,w);
	      y=csub(z,a);
	      newz=cmult(modw,y);
	    }
	  sprintf(msgbuf,"% .10e + % .10e i ;",newz.re,newz.im);
	  msg();
	  ctmp=ctrace;
	  ctrace=ctrace->next;
	  free(ctmp);
	}
    }
  return (vflag+start+move); /* error if this is zero */
} /* layout_report */

