#include "cp_types.h"
#include "cp_proto.h"

/* move next string of <256 non-space, non-semicolon
characters from ptr into next, reset ptr to next character location. 
Return 1 if next not empty. Note: changes ptr in calling routine, but not
the contents it originally pointed to.*/

int grab_next(char **ptr,char *next)
{
  int i=0;

  if (*ptr==NULL) return 0;
  while (**ptr == ' ' || **ptr == '\n' || **ptr == '\t' 
	 || **ptr == '\r')
    (*ptr)++;
  if (**ptr=='\0') return 0;
  while (*((*ptr)+i)!='\0' && *((*ptr)+i)!=' ' 
	 && *((*ptr)+i)!='\n' && *((*ptr)+i)!='\r' 
	 && *((*ptr)+i)!=';' && *((*ptr)+i)!='\t' && i<255)
    {
      *(next+i)=*((*ptr)+i);
      i++;
    }
  *(next+i)='\0';
  *ptr += i;
  return i;
} /* grab_next */

int grab_line(char *targ,char **sour,int n)
/* copy next full line (to length n) from source to target, reset 
source pointer after linebreak */
{
  int i=0;

  while((i<=(n-1)) && (**sour)!='\n' && (**sour)!='\0')
    {
      targ[i]=**sour;
      i++;
      (*sour)++;
    }
  targ[i]='\0';
  stripsp(*sour);
  return (strlen(targ));
} /* grab_line */

int stripsp(char *datastr)
/* strip initial 'space' chars, shift rest down. */
{
  int i=0;
  char *ptr;

  ptr=datastr;
  while (*ptr==' ' || *ptr=='\n' || *ptr=='\r' || *ptr=='\t') ptr++;
  if (ptr==datastr) return 1;
  if (*ptr=='\0') 
    {
      *datastr='\0';
      return 1;
    }
  do {*(datastr+i)=*(ptr+i); i++;}
  while (*(ptr+i-1)!='\0');
  return 1;
} /* stripsp */

int notspace(char *ptr)
/* returns number of steps to next nonspace char or to end */
{
  int n=0;
  while (*(ptr+n)==' ' || *(ptr+n)=='\n' || *(ptr+n)=='\r' 
	 || *(ptr+n)=='\t') n++;
  return n;
} /* notspace */

char *after_char(char *datastr,char *target)
     /* looks for target in datastr and returns pointer to
	location AFTER target, returns null if target not found */
{
  int i,n,len;
  char *ptr;

  if (!(n=strlen(target)) || (len=strlen((ptr=datastr)))<n) return NULL;
  for (i=0;i<=(len-n);i++)
    if (!strncmp(ptr+i,target,n)) 
      return ptr+i+n;
  return NULL;
} /* after_char */
					       
      
  



