#include "cp_types.h"
#include "cp_proto.h"

/* running experimental repack procedures; codes will
probably change, but for now:
  -d = adj compatbile verts and incompats too large.
  -u = " too small
  -m = " mixed
  -a = adj all verts
  -c n = test_cycle count (update status after n passes through complex), default 1
  -n m = total passes, default 200 */

int call_test_repack(struct p_data *p,char *datastr)
{
  int cmd=0,cycles=1,passes=200;
  double tol;
  char next[64],*nextpoint;

  nextpoint=datastr;
  while (grab_next(&nextpoint,next) && next[0]=='-')
    {
      if (next[1]=='d') cmd=cmd | 0101; 
      /* adjust cpmpatible verts and large incompats */
      else if (next[1]=='u') cmd=cmd | 0011;
      /* adjust cpmpatible verts and small incompats */
      else if (next[1]=='m') cmd=cmd | 1001;
      /* adjust cpmpatible verts and mixed incompats */
      else if (next[1]=='a') cmd=cmd | 1111;
      /* adjust cpmpatible verts and all incompats */
      else if (next[1]=='c' && grab_next(&nextpoint,next))
	{
	  sscanf(next,"%d",&cycles);
	}
      else if (next[1]=='n' && grab_next(&nextpoint,next))
	{
	  sscanf(next,"%d",&passes);
	}
      else if (next[1]=='t' && grab_next(&nextpoint,next)
	       && sscanf(next,"%lf",&tol))
	{
	  if (tol> .01) tol = .01;
	}
    }
  if (p->hes<0) return (test_riffle(p,passes,cycles,cmd,tol));
  else if (p->hes==0) return (test_riffle(p,passes,cycles,cmd,tol));
  else return 0; /* spherical not yet covered */
} /* call_test_repack */
