#include "cp_types.h"
#include "cp_proto.h"

/* Process a (close) postscript file to find the number of pages
   and correct the page numbering. */

FILE *fp;
char buff[BUFSIZE];

int renumber_ps_Pages(char *filename)
     /* Open a (postscript) file; if there are pages in it,
	find what it claims is the number of pages; open
	"/tmp/<filename>"; move things into it, adjusting page
	total and page counts as you go along. If it all seems
	to work, close and replace original file with the new one.
	Return number of pages or 0 on error. */
{
  int pagecount,c,n=1;
  long stop,start,fptr;
  char name[NAME_MAX],line[BUFSIZE];
  FILE *tmpfp=NULL,*sysfp=NULL;

  sscanf(filename,"%127s",name);
  if (!(fp=fopen(name,"r"))) return 0;
  if ((pagecount=count_Pages(fp))<2) goto BOMB; /* CirclePack-created files 
						  should have "Pages:" and
						  at least one "Page:". */

  /* open tmp file */
  sprintf(buff,"/tmp/%s",name);
  if (!(tmpfp=fopen(buff,"w"))) goto BOMB;

  /* file pointer should be set to 'P'; move to after "%%Pages:" */
  stop=ftell(fp)+6;

  /* transfer first stuff, set pagecount */
  fseek(fp,0,SEEK_SET);
  fptr=(long)0;
  while (fptr<stop && (c=fgetc(fp))!=EOF)
    {
      fputc(c,tmpfp);
      fptr++;
    }
  if (c==EOF) goto BOMB;
  fgets(line,BUFSIZE,fp); /* toss the rest of the line */
  fprintf(tmpfp," %d\n",pagecount);
  
  /* while there are pages, transfer stuff, set page numbers */
  while ((start=find_Page(fp,&fptr,1))>=0)
    {
      start += 5; /* position after ':' */
      fseek(fp,fptr,SEEK_SET);
      while (fptr<start && (c=fgetc(fp))!=EOF)
	{
	  fputc(c,tmpfp);
	  fptr++;
	}
      if (c==EOF) goto BOMB;
      fgets(line,BUFSIZE,fp); /* toss the rest of the line */
      fprintf(tmpfp," %d %d\n",n++,pagecount);
    }
  fseek(fp,fptr,SEEK_SET);
  while ((c=fgetc(fp))!=EOF)
    {
      fputc(c,tmpfp);
      fptr++;
    }
  fclose(fp);
  fclose(tmpfp);

  /* replace filename by tmp file */
  sprintf(buff,"cp -f /tmp/%s %s",name,name);
  sysfp=popen("/bin/sh","w");
  fprintf(sysfp,"%s\n",buff);
  pclose(sysfp);

  return (n-1);

 BOMB:
  fclose(fp);
  if (tmpfp) fclose(tmpfp);
  return 0;
} /* renumber_ps_Pages */
  
long find_Page(FILE *fp,long *start,int flag)
     /* Look in open postscript file starting at current location 
	for next occurance of "%%Pages:" (flag=0) or "%%Page" (flag=1), 
	return file location of the 'P' (or -1 if not found),
	but reset the file pointer to original location. */
{
  int c=0;
  long spot;

  if (!fp) return -1;
  *start=ftell(fp);
  while((c=fgetc(fp))!=EOF)
    if (c=='%' && (c=fgetc(fp))!=EOF && c=='%')
      {
	spot=ftell(fp); /* at 'P' */
	if (fscanf(fp,"%s",buff) 
	    && ((!flag && !strncmp(buff,"Pages:",6))
		|| !strncmp(buff,"Page:",5)))
	  {
	    return spot;
	  }
	else fseek(fp,spot,SEEK_SET); /* reset after %%, continue search */
      }
  return (long)(-1);
} /* find_Page */
	      
int count_Pages(FILE *fp)
     /* See if "%%Pages:" exist; if it does, count occurances 
	of "%%Page:". Return count or 0 on failure. Reset file location. */
{
  int n=0;
  long spot,start,fdum;

  start=ftell(fp);
  if ((spot=find_Page(fp,&fdum,0))>1)
    {
      while (find_Page(fp,&fdum,1)>1) n++;
      fseek(fp,spot,SEEK_SET);
      return n;
    }
  fseek(fp,start,SEEK_SET);
  return 0;
} /* count_Pages */









