/* light_list
This program merely reads the given p_light <filename> (in raw p_light form)
and writes a .q file for CirclePack giving the vlist of original indices
for the 'variable' circles of the light packing. */

#include <stdio.h>
#include "cp_types.h"
#include "cp_proto.h"

char buf[BUFSIZE];
double toler=.000000001;

int main(int argc,char *argv[])
{
  int i;
  struct p_light *pl;
  char outfile[256];
  FILE *packfp=NULL,*outfp=NULL;

  if (!(packfp=fopen(argv[1],"r")) 
      || !read_light(packfp,&pl,1))
    {
      if (packfp) fclose(packfp);
      printf("Error reading %s.\n",argv[1]);
      exit(1);
    }
  if (packfp) fclose(packfp);
  strcpy(outfile,argv[1]);
  strcat(outfile,".ql");
  if (!(outfp=fopen(outfile,"w")))
    {
      printf("Error opening %s.\n",outfile);
      exit(2);
    }
  fprintf(outfp,"CHECKCOUNT: %d\n"
	  "VERT_LIST:\n",pl->counts[4]);
  for (i=1;i<=pl->counts[2];i++) /* store the original indices of interiors */
    {
      fprintf(outfp,"%d\n",pl->orig_indices[i]);
    }
  fprintf(outfp,"(done)\nEND\n");
  fclose(outfp);
  exit(0);
} 







