/***************************************************************************
                          mixer_procedure_interpolated.h  -  description
                             -------------------
    begin                : Wed Apr 18 2001
    copyright            : (C) 2001 by Juan Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MIXER_PROCEDURE_INTERPOLATED_H
#define MIXER_PROCEDURE_INTERPOLATED_H



#include "mixer_procedure.h"
#include<stdio.h>
/**Raw nonintertpolated
  *@author Juan Linietsky
  */
/******************************
 mixer_procedure_interpolated.h
 ----------

simple and nice interpolation.
********************************/


class Mixer_Procedure_Interpolated : public Mixer_Procedure {

        template<class Precision,class Depth >

        void mix_internal() {

        	MIXER_STEP_1_INIT
        	
        	Precision real_index;
	       	Precision sizemax=sample->size-1;
        	
        	MIXER_STEP_2_LOOP_BEGIN
 	        	
           		real_index=aux_index >> FRACBITS;

	        	final_data=data_ptr[real_index];


	        	if (real_index<sizemax) {    	
				
            			
				final_data=final_data+((data_ptr[real_index+1]-final_data)*(aux_index&FRACMASK)>>FRACBITS);
	
			}

        		MIXER_STEP_3_CONVERT_TO_16BITS
	        	MIXER_STEP_3_BIS_PASS_FILTER
        	MIXER_STEP_4_MIX_TO_BUFFER_AND_EXIT
	}
	

public:
	Mixer_Procedure_Interpolated();
	~Mixer_Procedure_Interpolated();

	string get_name() { return "Interpolated"; };

	void register_sample(Sample_Data *p_sample) {};
	void unregister_sample(Sample_Data *p_sample) {};

        Sint64 mix_mono();
	Sint64 mix_stereo();
	Sint64 mix_surround();
};





#endif
