/***************************************************************************
                      loader_wav.h  -  simple wav loader
                             -------------------
    begin                : Tue Apr 24 2001
    copyright            : (C) 2001 by Calvin French
    email                : frenchc@home.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LOADER_WAV_H
#define LOADER_WAV_H

#include "loader.h"

struct Loader_WAV : public Loader  {

   virtual int load_sample(char *p_filename, int p_dest_index);

   // test always returns false
   virtual bool test(char *p_filename);

   // these shouldn't be called (according to reduz) but we implement them anyway
   virtual int load(char *p_filename,bool p_load_patterns);
   virtual int get_amount_of_samples();
   virtual Sample_Data *get_sample_data(int p_sample_index);
   virtual string get_sample_name(int p_sample_index);
   virtual void add_sample_to_song(int p_sample_index,int p_dest_index,bool create_instrument);
   virtual int load_samples_from_instrument(char *p_filename);
   virtual int load_instrument(char *p_filename,int p_dest_index);
   virtual void transfer_data_to_song();
   virtual void free_info(bool free_sampledata=false);
   
   Loader_WAV();
   ~Loader_WAV();
};

#endif
