/***************************************************************************
                          interface_popups_pattern.cpp  -  description
                             -------------------
    begin                : Sun Apr 15 2001
    copyright            : (C) 2001 by Juan Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "interface_popups.h"
#include <stdio.h>
/*************************
	PATTERN PROPERTIES
	***************************/

PopUp_Pattern_Properties::PopUp_Pattern_Properties() {

}

PopUp_Pattern_Properties::PopUp_Pattern_Properties(int p_base_octave,int p_cursor_step,int p_row_hl_minor,int p_row_hl_major,int p_pattern_length,int p_pattern_repeat) : Gtk::Window(GTK_WINDOW_TOPLEVEL), label1("Base Octave: "), label2("Cursor Step:"), label3("Row highlight  minor: "), label4("Row highlight major:"), table1(4, 4, false), frame1("Editor Helpers"), label5("Number of rows in pattern: "), label6("Set previous value in the next:  "), label7(" patterns."), table2(2, 4, false), frame2("Pattern Length"), button_ok("OK"), button_cancel("Cancel")
{

        spinbutton_base_octave_adj = new Gtk::Adjustment(p_base_octave, 0, 8, 1, 10, 10);
        spinbutton_base_octave = new Gtk::SpinButton(*spinbutton_base_octave_adj, 1, 0);
        spinbutton_cursor_step_adj = new Gtk::Adjustment(p_cursor_step, 0, 16, 1, 10, 10);
        spinbutton_cursor_step = new Gtk::SpinButton(*spinbutton_cursor_step_adj, 1, 0);
        spinbutton_row_highlight_minor_adj = new Gtk::Adjustment(p_row_hl_minor, 0, 32, 1, 10, 10);
        spinbutton_row_highlight_minor = new Gtk::SpinButton(*spinbutton_row_highlight_minor_adj, 1, 0);
        spinbutton_row_highlight_major_adj = new Gtk::Adjustment(p_row_hl_major, 0, 128, 1, 10, 10);
        spinbutton_row_highlight_major = new Gtk::SpinButton(*spinbutton_row_highlight_major_adj, 1, 0);
        spinbutton_pattern_length_adj = new Gtk::Adjustment(p_pattern_length, 32, 200, 1, 10, 10);
        spinbutton_pattern_length = new Gtk::SpinButton(*spinbutton_pattern_length_adj, 1, 0);
        spinbutton_repeat_pattern_length_adj = new Gtk::Adjustment(p_pattern_repeat, 1, 200, 1, 10, 10);
        spinbutton_repeat_pattern_length = new Gtk::SpinButton(*spinbutton_repeat_pattern_length_adj, 1, 0);
        hseparator1.set_name("hseparator1");
        hseparator2.set_name("hseparator2");
        hseparator3.set_name("hseparator3");
        hseparator4.set_name("hseparator4");
        hseparator5.set_name("hseparator5");
        hseparator6.set_name("hseparator6");
        hseparator7.set_name("hseparator7");
        hseparator8.set_name("hseparator8");
        label1.set_name("label1");
        label1.set_alignment(0, 0.5);
        label1.set_padding(0, 0);
        label2.set_name("label2");
        label2.set_alignment(0, 0.5);
        label2.set_padding(0, 0);
        label3.set_name("label3");
        label3.set_alignment(0, 0.5);
        label3.set_padding(0, 0);
        label4.set_name("label4");
        label4.set_alignment(0, 0.5);
        label4.set_padding(0, 0);
        spinbutton_base_octave->set_name("spinbutton_base_octave");
        spinbutton_base_octave->set_editable(true);
        spinbutton_cursor_step->set_name("spinbutton_cursor_step");
        spinbutton_cursor_step->set_editable(true);
        spinbutton_row_highlight_minor->set_name("spinbutton_row_highlight_minor");
        spinbutton_row_highlight_minor->set_editable(true);
        spinbutton_row_highlight_major->set_name("spinbutton_row_highlight_major");
        spinbutton_row_highlight_major->set_editable(true);
        table1.set_name("table1");
        table1.set_border_width(9);
        table1.attach(hseparator1, 0, 1, 0, 1, GTK_EXPAND|GTK_FILL, GTK_EXPAND|GTK_FILL, 0, 0);
        table1.attach(hseparator2, 0, 1, 1, 2, GTK_FILL, GTK_EXPAND|GTK_FILL, 0, 0);
        table1.attach(hseparator3, 0, 1, 2, 3, GTK_FILL, GTK_EXPAND|GTK_FILL, 0, 0);
        table1.attach(hseparator4, 0, 1, 3, 4, GTK_FILL, GTK_EXPAND|GTK_FILL, 0, 0);
        table1.attach(hseparator5, 3, 4, 0, 1, GTK_EXPAND|GTK_FILL, GTK_FILL, 0, 0);
        table1.attach(hseparator6, 3, 4, 1, 2, GTK_FILL, GTK_FILL, 0, 0);
        table1.attach(hseparator7, 3, 4, 2, 3, GTK_FILL, GTK_FILL, 0, 0);
        table1.attach(hseparator8, 3, 4, 3, 4, GTK_FILL, GTK_FILL, 0, 0);
        table1.attach(label1, 1, 2, 0, 1, GTK_FILL, 0, 0, 0);
        table1.attach(label2, 1, 2, 1, 2, GTK_FILL, 0, 0, 0);
        table1.attach(label3, 1, 2, 2, 3, GTK_FILL, 0, 0, 0);
        table1.attach(label4, 1, 2, 3, 4, GTK_FILL, 0, 0, 0);
        table1.attach(*spinbutton_base_octave, 2, 3, 0, 1, GTK_FILL, 0, 0, 0);
        table1.attach(*spinbutton_cursor_step, 2, 3, 1, 2, GTK_FILL, 0, 0, 0);
        table1.attach(*spinbutton_row_highlight_minor, 2, 3, 2, 3, GTK_FILL, 0, 0, 0);
        table1.attach(*spinbutton_row_highlight_major, 2, 3, 3, 4, GTK_FILL, 0, 0, 0);
        frame1.set_name("frame1");
        frame1.set_border_width(2);
        frame1.set_label_align(0, 0);
        frame1.set_shadow_type(GTK_SHADOW_ETCHED_IN);
        frame1.add(table1);
        hseparator9.set_name("hseparator9");
        hseparator10.set_name("hseparator10");
        hseparator11.set_name("hseparator11");
        label5.set_name("label5");
        label5.set_alignment(0, 0.5);
        label5.set_padding(0, 0);
        spinbutton_pattern_length->set_name("spinbutton_pattern_length");
        spinbutton_pattern_length->set_editable(true);
        label6.set_name("label6");
        label6.set_alignment(0, 0.5);
        label6.set_padding(0, 0);
        label7.set_name("label7");
        label7.set_alignment(0, 0.5);
        label7.set_padding(0, 0);
        spinbutton_repeat_pattern_length->set_name("spinbutton_repeat_pattern_length");
        spinbutton_repeat_pattern_length->set_editable(true);
        table2.set_name("table2");
        table2.set_border_width(9);
        table2.attach(hseparator9, 0, 1, 0, 1, GTK_EXPAND|GTK_FILL, GTK_EXPAND|GTK_FILL, 0, 0);
        table2.attach(hseparator10, 0, 1, 1, 2, GTK_FILL, GTK_EXPAND|GTK_FILL, 0, 0);
        table2.attach(hseparator11, 3, 4, 0, 1, GTK_EXPAND|GTK_FILL, GTK_FILL, 0, 0);
        table2.attach(label5, 1, 2, 0, 1, GTK_FILL, 0, 0, 0);
        table2.attach(*spinbutton_pattern_length, 2, 3, 0, 1, GTK_FILL, 0, 0, 0);
        table2.attach(label6, 1, 2, 1, 2, GTK_FILL, 0, 0, 0);
        table2.attach(label7, 3, 4, 1, 2, GTK_FILL, 0, 0, 0);
        table2.attach(*spinbutton_repeat_pattern_length, 2, 3, 1, 2, GTK_FILL, 0, 0, 0);
        frame2.set_name("frame2");
        frame2.set_border_width(2);
        frame2.set_label_align(0, 0);
        frame2.set_shadow_type(GTK_SHADOW_ETCHED_IN);
        frame2.add(table2);
        button_ok.set_name("button_ok");
        hseparator13.set_name("hseparator13");
        button_cancel.set_name("button_cancel");
        button_cancel.clicked.connect(slot(this,&PopUp_Pattern_Properties::on_button_cancel_clicked));
        hbox1.set_name("hbox1");
        hbox1.set_border_width(9);
        hbox1.pack_start(button_ok, false, false, 0);
        hbox1.pack_start(hseparator13);
        hbox1.pack_start(button_cancel, false, false, 0);
        frame3.set_name("frame3");
        frame3.set_border_width(2);
        frame3.set_label_align(0, 0);
        frame3.set_shadow_type(GTK_SHADOW_ETCHED_IN);
        frame3.add(hbox1);
        vbox1.set_name("vbox1");
        vbox1.pack_start(frame1, true, true, 1);
        vbox1.pack_start(frame2, true, true, 1);
        vbox1.pack_start(frame3, false, true, 1);
        set_name("PopUp_Pattern_Properties");
        set_title("Pattern Properties");
        set_position(GTK_WIN_POS_CENTER);
        set_policy(false, false, false);
        add(vbox1);
        hseparator1.show();
        hseparator2.show();
        hseparator3.show();
        hseparator4.show();
        hseparator5.show();
        hseparator6.show();
        hseparator7.show();
        hseparator8.show();
        label1.show();
        label2.show();
        label3.show();
        label4.show();
        spinbutton_base_octave->show();
        spinbutton_cursor_step->show();
        spinbutton_row_highlight_minor->show();
        spinbutton_row_highlight_major->show();
        table1.show();
        frame1.show();
        hseparator9.show();
        hseparator10.show();
        hseparator11.show();
        label5.show();
        spinbutton_pattern_length->show();
        label6.show();
        label7.show();
        spinbutton_repeat_pattern_length->show();
        table2.show();
        frame2.show();
        button_ok.show();
        hseparator13.show();
        button_cancel.show();
        hbox1.show();
        frame3.show();
        vbox1.show();
        show();
}

void PopUp_Pattern_Properties::on_button_cancel_clicked() {

	delete this;
}

PopUp_Pattern_Properties::~PopUp_Pattern_Properties()
{

   delete spinbutton_base_octave;
   delete spinbutton_base_octave_adj;
   delete spinbutton_cursor_step;
   delete spinbutton_cursor_step_adj;
   delete spinbutton_row_highlight_minor;
   delete spinbutton_row_highlight_minor_adj;
   delete spinbutton_row_highlight_major;
   delete spinbutton_row_highlight_major_adj;
   delete spinbutton_pattern_length;
   delete spinbutton_pattern_length_adj;
   delete spinbutton_repeat_pattern_length;
   delete spinbutton_repeat_pattern_length_adj;
}

/****************
	UNDO LIST
	*****************/

Popup_Undo_Window::Popup_Undo_Window(
) : Gtk::Window(GTK_WINDOW_TOPLEVEL), clist_undo_actions(3), button_undo("Undo"), button_cancel("Cancel")
{   clist_undo_actions.set_name("clist_undo_actions");
   clist_undo_actions.set_column_title(0, "#");
   clist_undo_actions.set_column_justification(0, GTK_JUSTIFY_CENTER);
   clist_undo_actions.set_column_width(0, 22);
   clist_undo_actions.set_column_title(1, "Pat.");
   clist_undo_actions.set_column_justification(1, GTK_JUSTIFY_CENTER);
   clist_undo_actions.set_column_width(1, 34);
   clist_undo_actions.set_column_title(2, "Action");
   clist_undo_actions.set_column_justification(2, GTK_JUSTIFY_CENTER);
   clist_undo_actions.set_column_width(2, 80);
   clist_undo_actions.column_titles_show();
   clist_undo_actions.select_row.connect(slot(this,&Popup_Undo_Window::on_clist_undo_select_row));
   scrolledwindow1.set_name("scrolledwindow1");
   scrolledwindow1.set_policy(GTK_POLICY_ALWAYS, GTK_POLICY_ALWAYS);
   scrolledwindow1.add(clist_undo_actions);
   button_undo.set_name("button_undo");
   hseparator1.set_name("hseparator1");
   button_cancel.set_name("button_cancel");
   button_cancel.clicked.connect(slot(this,&Popup_Undo_Window::button_cancel_pressed));
   hbox1.set_name("hbox1");
   hbox1.pack_start(button_undo, false, false, 50);
   hbox1.pack_start(hseparator1);
   hbox1.pack_start(button_cancel, false, false, 50);
   hseparator2.set_usize(420, 13);
   hseparator2.set_name("hseparator2");
   vbox1.set_usize(-1, 386);
   vbox1.set_name("vbox1");
   vbox1.pack_start(scrolledwindow1);
   vbox1.pack_start(hbox1, false, false, 8);
   vbox1.pack_start(hseparator2, false, true, 0);
   set_name("Popup_Undo_Window");
   set_title("Undo Action");
   set_position(GTK_WIN_POS_CENTER);
   set_policy(false, false, false);
   add(vbox1);
   clist_undo_actions.show();
   scrolledwindow1.show();
   button_undo.show();
   hseparator1.show();
   button_cancel.show();
   hbox1.show();
   hseparator2.show();
   vbox1.show();
   show();
   selected_row=-1;
  counter=0;
}

void Popup_Undo_Window::add_row(int p_pattern,string p_reason) {

	gchar *empty_strings[3]={"","",""};
	char row_num[3]={'0','0',0};
	char pat_num[5];
	sprintf(pat_num,"%i",p_pattern);

	row_num[0]='0'+(counter+1)/10;
	row_num[1]='0'+(counter+1) % 10;


	clist_undo_actions.append(empty_strings);
	clist_undo_actions.set_text(counter,0,row_num);
	clist_undo_actions.set_text(counter,1,pat_num);
	clist_undo_actions.set_text(counter,2,p_reason);

	counter++;
}

void Popup_Undo_Window::button_cancel_pressed() {

	delete this;
}

void Popup_Undo_Window::on_clist_undo_select_row(gint row, gint column, GdkEvent *event) {

	selected_row=row;
}

Popup_Undo_Window::~Popup_Undo_Window()
{
}
