#! /usr/bin/env python
#
#    Copyright (C) 2007 Marco Ferragina <marco.ferragina@gmail.com>
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


from cGmail.service.mainloop import MainLoop
from cGmail.service.dbusinterface import get_dbus_interface

import gettext
import locale

def setup_locale_and_gettext():
	"""Set up localization with gettext"""
	package_name = "cgmail"
	localedir = "./locale"

	# Install _() builtin for gettext; always returning unicode objects
	# also install ngettext()
	gettext.install(package_name, localedir=None, unicode=True,
			names=("ngettext",))
	# also bind this for gtkbuilder (wtf?)
	locale.bindtextdomain(package_name, localedir)
	# to load in current locale properly for sorting etc
	try:
		locale.setlocale(locale.LC_ALL, "")
	except locale.Error, e:
		pass

setup_locale_and_gettext()

iface = get_dbus_interface()
if iface:
	print "cGmail service is already active"
else:
	MainLoop()
