C-----------------------------------------------------------------------
#include "pdf/pilot.h"
      Subroutine Ctq4RF3 (Iset)
#include "pdf/impdp.inc"
      PARAMETER (MXX = 105, MXQ = 25, MXF = 6)
      PARAMETER (MXPQX = (MXF *2 +2) * MXQ * MXX)
      PARAMETER (NxI = 90, NtI = 13, NfMxI = 3)
      COMMON / W5051IC / Al, XV(0:MXX), QL(0:MXQ), UPD(MXPQX)
      COMMON / W5051ID / Nx, Nt, NfMx
      COMMON / W5051IE / Qini, Qmax, Xmin
      DIMENSION Amass(6)
      PARAMETER (NSETS=13)
      DIMENSION 
     >  XVI(0:MXX),QLI(0:MXQ),UPDI(MXPQX),
     >  AmassI(6)
C
C-----------------------------------------------------------------------
C Parton Distribution Table : CTEQ4F3                                          
        DATA  DrI, FlI, AlI /   2.,   3.,  .3850 /
        DATA  (AmassI(I),I=1,6) /     .000,     .000,     .200,
     +                               1.600,    5.000,  180.000 /
C        DATA  NX,  NT, NfMx /    90,    13,     3 /
        DATA  QINII, QMAXI, (QLI(I), I =0, NTI) /
     +  .160000E+01, .100000E+05,
     +  .160000E+01, .201872E+01, .264549E+01, .362326E+01, .522375E+01,
     +  .799453E+01, .131148E+02, .233244E+02, .455683E+02, .993065E+02,
     +  .245754E+03, .705085E+03, .240258E+04, .100000E+05 /
        DATA  XMINI, (XVI(I), I =0, NXI) /
     +  .100000E-04,
     +  .000000E+00, .999983E-05, .124433E-04, .154836E-04, .192668E-04,
     +  .239740E-04, .298310E-04, .371184E-04, .461852E-04, .574656E-04,
     +  .714994E-04, .889575E-04, .110674E-03, .137686E-03, .171280E-03,
     +  .213055E-03, .264997E-03, .329564E-03, .409809E-03, .509508E-03,
     +  .633332E-03, .787053E-03, .977784E-03, .121428E-02, .150728E-02,
     +  .186993E-02, .231825E-02, .288037E-02, .356397E-02, .440443E-02,
     +  .543508E-02, .669508E-02, .822984E-02, .100851E-01, .123281E-01,
     +  .150167E-01, .182174E-01, .219985E-01, .264278E-01, .315720E-01,
     +  .374800E-01, .442088E-01, .517931E-01, .602576E-01, .696136E-01,
     +  .798586E-01, .909356E-01, .102935E+00, .115681E+00, .129293E+00,
     +  .143599E+00, .158606E+00, .174271E+00, .190550E+00, .207405E+00,
     +  .224796E+00, .242685E+00, .261038E+00, .279820E+00, .299001E+00,
     +  .318550E+00, .338442E+00, .358653E+00, .379067E+00, .399881E+00,
     +  .420953E+00, .442266E+00, .463806E+00, .485559E+00, .507513E+00,
     +  .529656E+00, .551978E+00, .574483E+00, .597187E+00, .619860E+00,
     +  .642828E+00, .665921E+00, .689135E+00, .712467E+00, .735911E+00,
     +  .759464E+00, .783080E+00, .806909E+00, .830741E+00, .854673E+00,
     +  .878696E+00, .902804E+00, .926992E+00, .951257E+00, .975603E+00,
     +  .100000E+01 /
C Parton Distribution Table:                                                   
C
        DATA (UPDI(I),I=1,52) /
     +  .105023E+06, .447532E+05, .347081E+05, .269179E+05,
     +  .208763E+05, .161908E+05, .125570E+05, .973888E+04,
     +  .755331E+04, .585832E+04, .454377E+04, .352428E+04,
     +  .273361E+04, .212040E+04, .164482E+04, .127597E+04,
     +  .989900E+03, .768028E+03, .595943E+03, .462470E+03,
     +  .358942E+03, .278640E+03, .216348E+03, .168027E+03,
     +  .130539E+03, .101454E+03, .788856E+02, .611538E+02,
     +  .476142E+02, .371018E+02, .289378E+02, .225955E+02,
     +  .176663E+02, .138437E+02, .108614E+02, .853983E+01,
     +  .673072E+01, .531891E+01, .421518E+01, .335006E+01,
     +  .267119E+01, .213594E+01, .171270E+01, .137676E+01,
     +  .110907E+01, .894942E+00, .723589E+00, .584630E+00,
     +  .472968E+00, .381904E+00, .308239E+00, .248328E+00 /
        DATA (UPDI(I),I=53,104) /
     +  .199577E+00, .159911E+00, .127665E+00, .101491E+00,
     +  .802973E-01, .631879E-01, .494282E-01, .384117E-01,
     +  .296367E-01, .226874E-01, .172195E-01, .129652E-01,
     +  .964688E-02, .709890E-02, .516124E-02, .370328E-02,
     +  .261903E-02, .182305E-02, .124698E-02, .836602E-03,
     +  .549194E-03, .351688E-03, .220040E-03, .133130E-03,
     +  .778152E-04, .437117E-04, .234465E-04, .119120E-04,
     +  .567278E-05, .250160E-05, .996959E-06, .352619E-06,
     +  .106156E-06, .256481E-07, .450607E-08, .478447E-09,
     +  .202658E-10, .906929E-13, .000000E+00, .100696E+06,
     +  .782180E+05, .599856E+05, .459988E+05, .352783E+05,
     +  .270532E+05, .207486E+05, .159114E+05, .122036E+05,
     +  .935867E+04, .717796E+04, .550471E+04, .422213E+04 /
        DATA (UPDI(I),I=105,156) /
     +  .323799E+04, .248363E+04, .190480E+04, .146113E+04,
     +  .112068E+04, .859735E+03, .659501E+03, .506034E+03,
     +  .388272E+03, .298010E+03, .228746E+03, .175651E+03,
     +  .134910E+03, .103685E+03, .794211E+02, .611170E+02,
     +  .470600E+02, .362779E+02, .279934E+02, .216339E+02,
     +  .167559E+02, .129972E+02, .101030E+02, .787525E+01,
     +  .615510E+01, .482657E+01, .379601E+01, .299683E+01,
     +  .237306E+01, .188535E+01, .150196E+01, .119979E+01,
     +  .960241E+00, .770520E+00, .617933E+00, .496535E+00,
     +  .398289E+00, .319515E+00, .255907E+00, .204568E+00,
     +  .163070E+00, .129584E+00, .102560E+00, .808185E-01,
     +  .633572E-01, .493978E-01, .382695E-01, .294508E-01,
     +  .224932E-01, .170404E-01, .128113E-01, .952288E-02 /
        DATA (UPDI(I),I=157,208) /
     +  .700200E-02, .508911E-02, .365088E-02, .258258E-02,
     +  .179778E-02, .122978E-02, .824140E-03, .539786E-03,
     +  .343410E-03, .212277E-03, .125368E-03, .699702E-04,
     +  .358529E-04, .157979E-04, .476214E-05, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .156100E+06, .120561E+06,
     +  .918475E+05, .699580E+05, .532893E+05, .405826E+05,
     +  .309080E+05, .235339E+05, .179204E+05, .136424E+05,
     +  .103864E+05, .790540E+04, .601747E+04, .457919E+04,
     +  .348497E+04, .265151E+04, .201758E+04, .153481E+04,
     +  .116770E+04, .888188E+03, .675707E+03, .513960E+03,
     +  .391025E+03, .297461E+03, .226357E+03, .172259E+03 /
        DATA (UPDI(I),I=209,260) /
     +  .131171E+03, .995188E+02, .758590E+02, .578495E+02,
     +  .441659E+02, .337472E+02, .258259E+02, .198060E+02,
     +  .152128E+02, .117090E+02, .903880E+01, .699615E+01,
     +  .543420E+01, .423381E+01, .331213E+01, .259931E+01,
     +  .204734E+01, .161731E+01, .128158E+01, .101770E+01,
     +  .810610E+00, .645391E+00, .515103E+00, .410467E+00,
     +  .327250E+00, .260537E+00, .207101E+00, .164201E+00,
     +  .129826E+00, .102255E+00, .802144E-01, .626133E-01,
     +  .486258E-01, .375315E-01, .287873E-01, .219201E-01,
     +  .165633E-01, .124254E-01, .922110E-02, .677239E-02,
     +  .492067E-02, .353187E-02, .250303E-02, .174820E-02,
     +  .120266E-02, .812966E-03, .539515E-03, .350009E-03,
     +  .222858E-03, .137771E-03, .827847E-04, .480293E-04 /
        DATA (UPDI(I),I=261,312) /
     +  .268208E-04, .142489E-04, .714911E-05, .330346E-05,
     +  .136278E-05, .453227E-06, .861905E-07, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .225905E+06, .173735E+06, .131704E+06,
     +  .998116E+05, .756404E+05, .573034E+05, .434103E+05,
     +  .328741E+05, .248942E+05, .188445E+05, .142644E+05,
     +  .107934E+05, .816669E+04, .617682E+04, .467162E+04,
     +  .353182E+04, .267006E+04, .201776E+04, .152481E+04,
     +  .115186E+04, .870172E+03, .657148E+03, .496326E+03,
     +  .374761E+03, .283022E+03, .213716E+03, .161466E+03,
     +  .121511E+03, .918699E+02, .694792E+02, .526000E+02,
     +  .398494E+02, .302331E+02, .229844E+02, .174998E+02,
     +  .133506E+02, .102155E+02, .783742E+01, .603464E+01 /
        DATA (UPDI(I),I=313,364) /
     +  .466095E+01, .361536E+01, .281357E+01, .219803E+01,
     +  .172250E+01, .135441E+01, .106745E+01, .844114E+00,
     +  .667330E+00, .529051E+00, .418832E+00, .331841E+00,
     +  .262603E+00, .207545E+00, .163643E+00, .128703E+00,
     +  .100855E+00, .787325E-01, .611707E-01, .472970E-01,
     +  .363526E-01, .277741E-01, .210709E-01, .158678E-01,
     +  .118669E-01, .878272E-02, .643523E-02, .466726E-02,
     +  .334591E-02, .237043E-02, .165669E-02, .114218E-02,
     +  .775272E-03, .518055E-03, .339725E-03, .219855E-03,
     +  .139285E-03, .868210E-04, .531763E-04, .321957E-04,
     +  .192663E-04, .115321E-04, .689596E-05, .415506E-05,
     +  .249440E-05, .147987E-05, .835518E-06, .431352E-06,
     +  .187324E-06, .545692E-07, .378388E-08, .000000E+00 /
        DATA (UPDI(I),I=365,416) /
     +  .313335E+06, .240110E+06, .181259E+06, .136782E+06,
     +  .103206E+06, .778390E+05, .586993E+05, .442465E+05,
     +  .333474E+05, .251216E+05, .189220E+05, .142456E+05,
     +  .107232E+05, .806779E+04, .606898E+04, .456309E+04,
     +  .343033E+04, .257744E+04, .193635E+04, .145398E+04,
     +  .109168E+04, .819276E+03, .614815E+03, .461192E+03,
     +  .345964E+03, .259458E+03, .194658E+03, .145432E+03,
     +  .109155E+03, .819387E+02, .615631E+02, .462810E+02,
     +  .348377E+02, .262754E+02, .198448E+02, .150171E+02,
     +  .113971E+02, .867250E+01, .662318E+01, .507399E+01,
     +  .390414E+01, .301419E+01, .233638E+01, .181690E+01,
     +  .141798E+01, .110939E+01, .871089E+00, .683894E+00,
     +  .538585E+00, .423617E+00, .333537E+00, .262350E+00 /
        DATA (UPDI(I),I=417,468) /
     +  .206136E+00, .161615E+00, .126416E+00, .985408E-01,
     +  .765351E-01, .591716E-01, .455356E-01, .348399E-01,
     +  .265030E-01, .200235E-01, .150197E-01, .111912E-01,
     +  .825414E-02, .602887E-02, .436048E-02, .311880E-02,
     +  .220583E-02, .154025E-02, .106210E-02, .722066E-03,
     +  .484227E-03, .319553E-03, .208853E-03, .134327E-03,
     +  .855827E-04, .540480E-04, .340935E-04, .214993E-04,
     +  .136914E-04, .875925E-05, .563142E-05, .357624E-05,
     +  .220831E-05, .127695E-05, .663124E-06, .284210E-06,
     +  .802978E-07, .570953E-08, .000000E+00, .422127E+06,
     +  .322423E+06, .242468E+06, .182261E+06, .136976E+06,
     +  .102891E+06, .772707E+05, .580001E+05, .435247E+05,
     +  .326446E+05, .244779E+05, .183440E+05, .137435E+05 /
        DATA (UPDI(I),I=469,520) /
     +  .102908E+05, .770334E+04, .576302E+04, .431022E+04,
     +  .322169E+04, .240741E+04, .179784E+04, .134231E+04,
     +  .100162E+04, .747250E+03, .557185E+03, .415411E+03,
     +  .309587E+03, .230780E+03, .171273E+03, .127687E+03,
     +  .951947E+02, .710219E+02, .530113E+02, .396133E+02,
     +  .296573E+02, .222308E+02, .166951E+02, .125734E+02,
     +  .949391E+01, .719441E+01, .546908E+01, .417581E+01,
     +  .319941E+01, .246128E+01, .189986E+01, .147194E+01,
     +  .114341E+01, .891578E+00, .695216E+00, .543897E+00,
     +  .425039E+00, .332566E+00, .259999E+00, .203084E+00,
     +  .158312E+00, .123143E+00, .954703E-01, .737605E-01,
     +  .567357E-01, .434447E-01, .330807E-01, .250480E-01,
     +  .188397E-01, .140707E-01, .104409E-01, .767041E-02 /
        DATA (UPDI(I),I=521,572) /
     +  .558182E-02, .402347E-02, .286911E-02, .202412E-02,
     +  .141073E-02, .971805E-03, .660788E-03, .443905E-03,
     +  .294098E-03, .193492E-03, .125757E-03, .813316E-04,
     +  .524217E-04, .339245E-04, .220508E-04, .144962E-04,
     +  .956273E-05, .630162E-05, .407249E-05, .253463E-05,
     +  .146516E-05, .753759E-06, .316544E-06, .867907E-07,
     +  .627309E-08, .000000E+00, .556553E+06, .423786E+06,
     +  .317540E+06, .237814E+06, .178053E+06, .133236E+06,
     +  .996680E+05, .745142E+05, .556899E+05, .415959E+05,
     +  .310577E+05, .231747E+05, .172861E+05, .128853E+05,
     +  .960109E+04, .714911E+04, .532122E+04, .395790E+04,
     +  .294271E+04, .218637E+04, .162383E+04, .120520E+04,
     +  .894197E+03, .663018E+03, .491474E+03, .364118E+03 /
        DATA (UPDI(I),I=573,624) /
     +  .269796E+03, .198980E+03, .147407E+03, .109190E+03,
     +  .809256E+02, .599980E+02, .445258E+02, .331031E+02,
     +  .246371E+02, .183691E+02, .137330E+02, .102934E+02,
     +  .774247E+01, .584216E+01, .442766E+01, .336746E+01,
     +  .257163E+01, .197077E+01, .151603E+01, .116945E+01,
     +  .905656E+00, .701452E+00, .545192E+00, .423321E+00,
     +  .329154E+00, .255768E+00, .198593E+00, .153915E+00,
     +  .119046E+00, .917854E-01, .705315E-01, .539674E-01,
     +  .411130E-01, .311490E-01, .234707E-01, .175702E-01,
     +  .130622E-01, .964957E-02, .705869E-02, .511579E-02,
     +  .367351E-02, .261048E-02, .183606E-02, .127652E-02,
     +  .877861E-03, .596524E-03, .401036E-03, .266408E-03,
     +  .176141E-03, .115410E-03, .755010E-04, .494124E-04 /
        DATA (UPDI(I),I=625,676) /
     +  .325640E-04, .216010E-04, .144787E-04, .971438E-05,
     +  .647460E-05, .420855E-05, .261646E-05, .150220E-05,
     +  .762463E-06, .313163E-06, .833855E-07, .611426E-08,
     +  .000000E+00, .721426E+06, .547683E+06, .408929E+06,
     +  .305165E+06, .227646E+06, .169715E+06, .126477E+06,
     +  .941938E+05, .701215E+05, .521663E+05, .387914E+05,
     +  .288254E+05, .214098E+05, .158903E+05, .117880E+05,
     +  .873807E+04, .647401E+04, .479280E+04, .354638E+04,
     +  .262200E+04, .193763E+04, .143075E+04, .105598E+04,
     +  .778795E+03, .574131E+03, .422971E+03, .311604E+03,
     +  .228448E+03, .168219E+03, .123842E+03, .912076E+02,
     +  .671878E+02, .495340E+02, .365816E+02, .270404E+02,
     +  .200219E+02, .148637E+02, .110622E+02, .826141E+01 /
        DATA (UPDI(I),I=677,728) /
     +  .618919E+01, .465706E+01, .351668E+01, .266650E+01,
     +  .202912E+01, .155006E+01, .118751E+01, .913460E+00,
     +  .702805E+00, .542703E+00, .418705E+00, .323535E+00,
     +  .249873E+00, .192859E+00, .148601E+00, .114278E+00,
     +  .876171E-01, .669592E-01, .509598E-01, .386175E-01,
     +  .291083E-01, .218227E-01, .162566E-01, .120277E-01,
     +  .884402E-02, .644015E-02, .464737E-02, .332354E-02,
     +  .235293E-02, .164937E-02, .114353E-02, .784783E-03,
     +  .532718E-03, .358241E-03, .238476E-03, .158327E-03,
     +  .104454E-03, .689933E-04, .457181E-04, .305571E-04,
     +  .205732E-04, .139694E-04, .946766E-05, .634185E-05,
     +  .412389E-05, .255071E-05, .145023E-05, .724802E-06,
     +  .290904E-06, .752759E-07, .559535E-08, .000000E+00 /
        DATA (UPDI(I),I=729,780) /
     +  .922082E+06, .697955E+06, .519323E+06, .386186E+06,
     +  .287055E+06, .213229E+06, .158316E+06, .117463E+06,
     +  .871084E+05, .645511E+05, .478099E+05, .353835E+05,
     +  .261723E+05, .193436E+05, .142882E+05, .105452E+05,
     +  .777810E+04, .573212E+04, .422172E+04, .310656E+04,
     +  .228460E+04, .167864E+04, .123268E+04, .904419E+03,
     +  .663219E+03, .485962E+03, .356029E+03, .259523E+03,
     +  .189995E+03, .139048E+03, .101786E+03, .745184E+02,
     +  .545911E+02, .400580E+02, .294155E+02, .216357E+02,
     +  .159530E+02, .117918E+02, .874541E+01, .650639E+01,
     +  .486164E+01, .364567E+01, .274512E+01, .207460E+01,
     +  .157398E+01, .119771E+01, .915201E+00, .699528E+00,
     +  .536702E+00, .411453E+00, .315957E+00, .242539E+00 /
        DATA (UPDI(I),I=781,832) /
     +  .186079E+00, .142538E+00, .108984E+00, .830868E-01,
     +  .631447E-01, .477957E-01, .360258E-01, .270127E-01,
     +  .201474E-01, .149333E-01, .109940E-01, .804524E-02,
     +  .583106E-02, .418902E-02, .298306E-02, .210363E-02,
     +  .146943E-02, .101581E-02, .695592E-03, .471622E-03,
     +  .317205E-03, .211561E-03, .140999E-03, .936110E-04,
     +  .623645E-04, .417697E-04, .282412E-04, .192316E-04,
     +  .131754E-04, .898260E-05, .602461E-05, .390680E-05,
     +  .239844E-05, .134804E-05, .662578E-06, .259739E-06,
     +  .653617E-07, .492332E-08, .000000E+00, .116435E+07,
     +  .878771E+06, .651614E+06, .482878E+06, .357656E+06,
     +  .264719E+06, .195827E+06, .144756E+06, .106943E+06,
     +  .789455E+05, .582425E+05, .429335E+05, .316282E+05 /
        DATA (UPDI(I),I=833,884) /
     +  .232799E+05, .171236E+05, .125839E+05, .924138E+04,
     +  .678032E+04, .497110E+04, .364114E+04, .266510E+04,
     +  .194881E+04, .142404E+04, .103959E+04, .758427E+03,
     +  .552806E+03, .402827E+03, .292005E+03, .212576E+03,
     +  .154685E+03, .112569E+03, .819200E+02, .596460E+02,
     +  .434955E+02, .317365E+02, .231923E+02, .169883E+02,
     +  .124739E+02, .918911E+01, .679038E+01, .503938E+01,
     +  .375333E+01, .280700E+01, .210708E+01, .158791E+01,
     +  .120030E+01, .911174E+00, .691936E+00, .527495E+00,
     +  .401852E+00, .306677E+00, .233988E+00, .178446E+00,
     +  .135890E+00, .103300E+00, .783066E-01, .591789E-01,
     +  .445482E-01, .333962E-01, .249081E-01, .184807E-01,
     +  .136281E-01, .998264E-02, .726944E-02, .524363E-02 /
        DATA (UPDI(I),I=885,936) /
     +  .374986E-02, .265879E-02, .186753E-02, .129988E-02,
     +  .895965E-03, .612196E-03, .414622E-03, .278937E-03,
     +  .186408E-03, .124716E-03, .833061E-04, .559431E-04,
     +  .378257E-04, .258221E-04, .177403E-04, .122277E-04,
     +  .836170E-05, .560106E-05, .361438E-05, .219888E-05,
     +  .122022E-05, .589305E-06, .225570E-06, .552383E-07,
     +  .421555E-08, .000000E+00, .145449E+07, .109458E+07,
     +  .808863E+06, .597336E+06, .440877E+06, .325154E+06,
     +  .239662E+06, .176508E+06, .129913E+06, .955391E+05,
     +  .702124E+05, .515545E+05, .378275E+05, .277301E+05,
     +  .203126E+05, .148650E+05, .108698E+05, .794036E+04,
     +  .579574E+04, .422598E+04, .307889E+04, .224080E+04,
     +  .162953E+04, .118378E+04, .859297E+03, .623119E+03 /
        DATA (UPDI(I),I=937,988) /
     +  .451688E+03, .325652E+03, .235775E+03, .170612E+03,
     +  .123451E+03, .893176E+02, .646450E+02, .468564E+02,
     +  .339772E+02, .246740E+02, .179581E+02, .131008E+02,
     +  .958775E+01, .703834E+01, .518875E+01, .383894E+01,
     +  .285193E+01, .212666E+01, .159210E+01, .119560E+01,
     +  .901751E+00, .680391E+00, .515420E+00, .390203E+00,
     +  .295956E+00, .224446E+00, .170148E+00, .128812E+00,
     +  .973524E-01, .733778E-01, .551426E-01, .412807E-01,
     +  .307779E-01, .228327E-01, .168515E-01, .123627E-01,
     +  .900972E-02, .652862E-02, .468661E-02, .333617E-02,
     +  .235525E-02, .164779E-02, .114293E-02, .785554E-03,
     +  .535670E-03, .362470E-03, .243974E-03, .163406E-03,
     +  .109768E-03, .737642E-04, .499095E-04, .340337E-04 /
        DATA (UPDI(I),I=989,1040) /
     +  .234223E-04, .162011E-04, .112097E-04, .767163E-05,
     +  .512251E-05, .328416E-05, .197758E-05, .108249E-05,
     +  .513339E-06, .191830E-06, .457450E-07, .353656E-08,
     +  .000000E+00, .179912E+07, .135005E+07, .994248E+06,
     +  .731716E+06, .538171E+06, .395505E+06, .290467E+06,
     +  .213146E+06, .156298E+06, .114511E+06, .838334E+05,
     +  .613174E+05, .448135E+05, .327198E+05, .238699E+05,
     +  .173959E+05, .126668E+05, .921348E+04, .669560E+04,
     +  .486043E+04, .352507E+04, .255369E+04, .184831E+04,
     +  .133627E+04, .965229E+03, .696425E+03, .502241E+03,
     +  .360183E+03, .259385E+03, .186677E+03, .134323E+03,
     +  .966333E+02, .695339E+02, .501034E+02, .361125E+02,
     +  .260641E+02, .188515E+02, .136659E+02, .993741E+01 /
        DATA (UPDI(I),I=1041,1092) /
     +  .724809E+01, .530871E+01, .390217E+01, .288000E+01,
     +  .213364E+01, .158697E+01, .118408E+01, .887373E+00,
     +  .665301E+00, .500839E+00, .376818E+00, .284059E+00,
     +  .214130E+00, .161364E+00, .121447E+00, .912553E-01,
     +  .683908E-01, .511059E-01, .380473E-01, .282120E-01,
     +  .208169E-01, .152824E-01, .111536E-01, .808717E-02,
     +  .583120E-02, .416585E-02, .295196E-02, .207510E-02,
     +  .144619E-02, .999720E-03, .685309E-03, .466483E-03,
     +  .315468E-03, .212517E-03, .142701E-03, .962680E-04,
     +  .650816E-04, .443491E-04, .304718E-04, .211120E-04,
     +  .146762E-04, .101747E-04, .695625E-05, .462309E-05,
     +  .294108E-05, .175127E-05, .944874E-06, .439748E-06,
     +  .160422E-06, .372781E-07, .291929E-08, .000000E+00 /
        DATA (UPDI(I),I=1093,1144) /
     +  .220510E+07, .164998E+07, .121101E+07, .888190E+06,
     +  .650983E+06, .476728E+06, .348867E+06, .255074E+06,
     +  .186355E+06, .136024E+06, .992054E+05, .722824E+05,
     +  .526209E+05, .382681E+05, .278051E+05, .201810E+05,
     +  .146335E+05, .105990E+05, .766931E+04, .554290E+04,
     +  .400208E+04, .288610E+04, .207923E+04, .149612E+04,
     +  .107549E+04, .772162E+03, .554067E+03, .395290E+03,
     +  .283180E+03, .202719E+03, .145072E+03, .103788E+03,
     +  .742590E+02, .532005E+02, .381188E+02, .273477E+02,
     +  .196593E+02, .141638E+02, .102351E+02, .741820E+01,
     +  .539877E+01, .394308E+01, .289158E+01, .212855E+01,
     +  .157308E+01, .116627E+01, .868535E+00, .647100E+00,
     +  .484126E+00, .362009E+00, .271243E+00, .203249E+00 /
        DATA (UPDI(I),I=1145,1196) /
     +  .152259E+00, .113928E+00, .851112E-01, .634239E-01,
     +  .471282E-01, .348921E-01, .257311E-01, .188844E-01,
     +  .137905E-01, .100128E-01, .722306E-02, .518257E-02,
     +  .368484E-02, .259939E-02, .181963E-02, .126342E-02,
     +  .870607E-03, .595372E-03, .404671E-03, .273608E-03,
     +  .184546E-03, .124279E-03, .842168E-04, .572733E-04,
     +  .392890E-04, .271750E-04, .189295E-04, .132038E-04,
     +  .915724E-05, .624477E-05, .412570E-05, .260172E-05,
     +  .153079E-05, .813587E-06, .371461E-06, .132291E-06,
     +  .299769E-07, .237770E-08, .000000E+00, .267943E+07,
     +  .199922E+07, .146238E+07, .106889E+07, .780714E+06,
     +  .569732E+06, .415445E+06, .302661E+06, .220314E+06,
     +  .160217E+06, .116411E+06, .844961E+05, .612744E+05 /
        DATA (UPDI(I),I=1197,1248) /
     +  .443867E+05, .321222E+05, .232201E+05, .167680E+05,
     +  .120943E+05, .871410E+04, .627082E+04, .450774E+04,
     +  .323622E+04, .232084E+04, .166223E+04, .118924E+04,
     +  .849701E+03, .606702E+03, .430641E+03, .306927E+03,
     +  .218574E+03, .155585E+03, .110706E+03, .787691E+02,
     +  .561142E+02, .399748E+02, .285115E+02, .203739E+02,
     +  .145901E+02, .104787E+02, .754793E+01, .545898E+01,
     +  .396214E+01, .288729E+01, .211207E+01, .155111E+01,
     +  .114279E+01, .845773E+00, .626242E+00, .465657E+00,
     +  .346084E+00, .257754E+00, .191998E+00, .142986E+00,
     +  .106370E+00, .790089E-01, .585436E-01, .432585E-01,
     +  .318508E-01, .233603E-01, .170528E-01, .123874E-01,
     +  .894784E-02, .642226E-02, .458562E-02, .324512E-02 /
        DATA (UPDI(I),I=1249,1300) /
     +  .227916E-02, .158902E-02, .109939E-02, .755353E-03,
     +  .515471E-03, .349976E-03, .236672E-03, .159896E-03,
     +  .108027E-03, .735452E-04, .503061E-04, .347216E-04,
     +  .241526E-04, .168935E-04, .118063E-04, .817942E-05,
     +  .555665E-05, .364558E-05, .227695E-05, .132296E-05,
     +  .692296E-06, .309992E-06, .107787E-06, .238339E-07,
     +  .191460E-08, .000000E+00, .903304E+05, .895354E+05,
     +  .694400E+05, .538552E+05, .417685E+05, .323948E+05,
     +  .251251E+05, .194870E+05, .151144E+05, .117232E+05,
     +  .909313E+04, .705333E+04, .547131E+04, .424433E+04,
     +  .329270E+04, .255460E+04, .198213E+04, .153809E+04,
     +  .119368E+04, .926519E+03, .719282E+03, .558518E+03,
     +  .433799E+03, .337036E+03, .261957E+03, .203696E+03 /
        DATA (UPDI(I),I=1301,1352) /
     +  .158481E+03, .122948E+03, .958087E+02, .747317E+02,
     +  .583582E+02, .456342E+02, .357418E+02, .280672E+02,
     +  .220769E+02, .174119E+02, .137747E+02, .109345E+02,
     +  .871243E+01, .696899E+01, .559902E+01, .451687E+01,
     +  .365893E+01, .297551E+01, .242832E+01, .198785E+01,
     +  .163255E+01, .134156E+01, .110495E+01, .909301E+00,
     +  .748512E+00, .615427E+00, .505031E+00, .413335E+00,
     +  .337144E+00, .273875E+00, .221422E+00, .178044E+00,
     +  .142296E+00, .112961E+00, .890112E-01, .695721E-01,
     +  .538986E-01, .414065E-01, .314279E-01, .235835E-01,
     +  .174785E-01, .127796E-01, .920652E-02, .652564E-02,
     +  .454360E-02, .310186E-02, .207132E-02, .134885E-02,
     +  .857814E-03, .527424E-03, .313183E-03, .178667E-03 /
        DATA (UPDI(I),I=1353,1404) /
     +  .972989E-04, .501728E-04, .242445E-04, .108451E-04,
     +  .438335E-05, .157185E-05, .479644E-06, .117433E-06,
     +  .209022E-07, .224795E-08, .964222E-10, .436873E-12,
     +  .000000E+00, .157046E+06, .122420E+06, .942674E+05,
     +  .725873E+05, .558997E+05, .430473E+05, .331536E+05,
     +  .255331E+05, .196665E+05, .151474E+05, .116682E+05,
     +  .898789E+04, .692418E+04, .533425E+04, .410999E+04,
     +  .316672E+04, .244034E+04, .188063E+04, .144958E+04,
     +  .111741E+04, .861578E+03, .664407E+03, .512530E+03,
     +  .395461E+03, .305267E+03, .235734E+03, .182160E+03,
     +  .140331E+03, .108608E+03, .841292E+02, .652484E+02,
     +  .506697E+02, .394151E+02, .307390E+02, .240148E+02,
     +  .188108E+02, .147816E+02, .116544E+02, .922447E+01 /
        DATA (UPDI(I),I=1405,1456) /
     +  .732930E+01, .585006E+01, .468844E+01, .377346E+01,
     +  .304883E+01, .247243E+01, .201111E+01, .164143E+01,
     +  .134040E+01, .109730E+01, .897492E+00, .734385E+00,
     +  .600224E+00, .489691E+00, .398469E+00, .323186E+00,
     +  .261069E+00, .209910E+00, .167872E+00, .133456E+00,
     +  .105388E+00, .826189E-01, .642521E-01, .495305E-01,
     +  .378669E-01, .286039E-01, .213622E-01, .157579E-01,
     +  .114673E-01, .822237E-02, .580000E-02, .401834E-02,
     +  .272842E-02, .181132E-02, .117098E-02, .738050E-03,
     +  .448181E-03, .261274E-03, .144730E-03, .749083E-04,
     +  .351378E-04, .138485E-04, .349774E-05, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=1457,1508) /
     +  .211740E+06, .164206E+06, .125696E+06, .962108E+05,
     +  .736502E+05, .563747E+05, .431561E+05, .330340E+05,
     +  .252889E+05, .193579E+05, .148197E+05, .113444E+05,
     +  .868520E+04, .664880E+04, .509060E+04, .389732E+04,
     +  .298426E+04, .228500E+04, .174995E+04, .134017E+04,
     +  .102663E+04, .786482E+03, .602717E+03, .461959E+03,
     +  .354232E+03, .271709E+03, .208561E+03, .159572E+03,
     +  .122668E+03, .943740E+02, .726988E+02, .560703E+02,
     +  .433200E+02, .335542E+02, .260367E+02, .202560E+02,
     +  .158102E+02, .123813E+02, .973460E+01, .768307E+01,
     +  .609220E+01, .485049E+01, .387863E+01, .311357E+01,
     +  .250890E+01, .202783E+01, .164479E+01, .133475E+01,
     +  .108603E+01, .882855E+00, .718090E+00, .583421E+00 /
        DATA (UPDI(I),I=1509,1560) /
     +  .473207E+00, .382832E+00, .308743E+00, .248003E+00,
     +  .198304E+00, .157725E+00, .124719E+00, .979695E-01,
     +  .764071E-01, .591216E-01, .453494E-01, .345037E-01,
     +  .259409E-01, .192849E-01, .141635E-01, .102644E-01,
     +  .733211E-02, .515458E-02, .356143E-02, .241363E-02,
     +  .160148E-02, .103658E-02, .656071E-03, .401868E-03,
     +  .238125E-03, .135757E-03, .740580E-04, .383171E-04,
     +  .186201E-04, .836170E-05, .337322E-05, .116168E-05,
     +  .298007E-06, .199332E-07, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .280854E+06,
     +  .216837E+06, .165132E+06, .125738E+06, .957480E+05,
     +  .728990E+05, .555060E+05, .422559E+05, .321709E+05,
     +  .244888E+05, .186424E+05, .141895E+05, .108010E+05 /
        DATA (UPDI(I),I=1561,1612) /
     +  .822050E+04, .625710E+04, .476196E+04, .362454E+04,
     +  .275846E+04, .209966E+04, .159807E+04, .121659E+04,
     +  .926150E+03, .705260E+03, .537096E+03, .409195E+03,
     +  .311824E+03, .237795E+03, .180725E+03, .138011E+03,
     +  .105469E+03, .807028E+02, .618250E+02, .474444E+02,
     +  .365009E+02, .281324E+02, .217385E+02, .168534E+02,
     +  .131096E+02, .102385E+02, .802696E+01, .632302E+01,
     +  .500127E+01, .397325E+01, .316896E+01, .253728E+01,
     +  .203776E+01, .164256E+01, .132462E+01, .107122E+01,
     +  .865510E+00, .699768E+00, .565165E+00, .455723E+00,
     +  .366560E+00, .293940E+00, .234784E+00, .186694E+00,
     +  .147678E+00, .116146E+00, .907503E-01, .704077E-01,
     +  .542005E-01, .413646E-01, .313167E-01, .234307E-01 /
        DATA (UPDI(I),I=1613,1664) /
     +  .173362E-01, .126740E-01, .914473E-02, .650548E-02,
     +  .455619E-02, .313773E-02, .212103E-02, .140524E-02,
     +  .909515E-03, .576953E-03, .355450E-03, .213031E-03,
     +  .123908E-03, .699723E-04, .383520E-04, .205448E-04,
     +  .108325E-04, .570311E-05, .303391E-05, .163919E-05,
     +  .873254E-06, .437822E-06, .187999E-06, .545978E-07,
     +  .378403E-08, .000000E+00, .367607E+06, .282681E+06,
     +  .214275E+06, .162389E+06, .123065E+06, .932423E+05,
     +  .706457E+05, .535125E+05, .405342E+05, .306961E+05,
     +  .232458E+05, .175995E+05, .133248E+05, .100861E+05,
     +  .763471E+04, .577787E+04, .437286E+04, .330884E+04,
     +  .250394E+04, .189454E+04, .143368E+04, .108482E+04,
     +  .821040E+03, .621401E+03, .470463E+03, .356245E+03 /
        DATA (UPDI(I),I=1665,1716) /
     +  .269941E+03, .203818E+03, .154635E+03, .117400E+03,
     +  .892402E+02, .679120E+02, .517682E+02, .395616E+02,
     +  .302870E+02, .232465E+02, .179018E+02, .138319E+02,
     +  .107307E+02, .835702E+01, .653969E+01, .513879E+01,
     +  .405599E+01, .321409E+01, .255700E+01, .204058E+01,
     +  .163458E+01, .130997E+01, .105290E+01, .845524E+00,
     +  .679512E+00, .545550E+00, .437332E+00, .349733E+00,
     +  .278847E+00, .221472E+00, .175127E+00, .137766E+00,
     +  .107762E+00, .837481E-01, .646321E-01, .494961E-01,
     +  .375801E-01, .283082E-01, .210743E-01, .155166E-01,
     +  .112900E-01, .810877E-02, .574339E-02, .400612E-02,
     +  .274890E-02, .185256E-02, .122480E-02, .792057E-03,
     +  .502988E-03, .311131E-03, .188054E-03, .111039E-03 /
        DATA (UPDI(I),I=1717,1768) /
     +  .642860E-04, .366251E-04, .207691E-04, .118214E-04,
     +  .682303E-05, .398699E-05, .232814E-05, .130498E-05,
     +  .667865E-06, .284698E-06, .803184E-07, .570964E-08,
     +  .000000E+00, .475733E+06, .364472E+06, .275079E+06,
     +  .207554E+06, .156591E+06, .118105E+06, .890703E+05,
     +  .671521E+05, .506230E+05, .381504E+05, .287483E+05,
     +  .216566E+05, .163130E+05, .122841E+05, .924962E+04,
     +  .696268E+04, .524098E+04, .394391E+04, .296785E+04,
     +  .223282E+04, .167994E+04, .126375E+04, .950799E+03,
     +  .715291E+03, .538254E+03, .405065E+03, .305026E+03,
     +  .228838E+03, .172512E+03, .130130E+03, .982751E+02,
     +  .742988E+02, .562636E+02, .427132E+02, .324826E+02,
     +  .247657E+02, .189448E+02, .145404E+02, .112054E+02 /
        DATA (UPDI(I),I=1769,1820) /
     +  .866905E+01, .673930E+01, .526103E+01, .412552E+01,
     +  .324815E+01, .256761E+01, .203607E+01, .162078E+01,
     +  .129081E+01, .103115E+01, .823018E+00, .657452E+00,
     +  .524705E+00, .418154E+00, .332457E+00, .263553E+00,
     +  .208138E+00, .163661E+00, .128033E+00, .996010E-01,
     +  .769866E-01, .590968E-01, .450189E-01, .340023E-01,
     +  .254816E-01, .188736E-01, .138268E-01, .100114E-01,
     +  .715638E-02, .504584E-02, .350455E-02, .239541E-02,
     +  .160897E-02, .106113E-02, .685311E-03, .435384E-03,
     +  .270137E-03, .164398E-03, .982678E-04, .580176E-04,
     +  .340193E-04, .200458E-04, .119410E-04, .721750E-05,
     +  .438475E-05, .262464E-05, .148595E-05, .757229E-06,
     +  .316898E-06, .868055E-07, .627318E-08, .000000E+00 /
        DATA (UPDI(I),I=1821,1872) /
     +  .609502E+06, .465319E+06, .349751E+06, .262796E+06,
     +  .197428E+06, .148263E+06, .111323E+06, .835537E+05,
     +  .627008E+05, .470339E+05, .352755E+05, .264464E+05,
     +  .198238E+05, .148538E+05, .111282E+05, .833382E+04,
     +  .624034E+04, .467106E+04, .349608E+04, .261582E+04,
     +  .195715E+04, .146395E+04, .109509E+04, .819039E+03,
     +  .612673E+03, .458296E+03, .343011E+03, .255727E+03,
     +  .191578E+03, .143600E+03, .107755E+03, .809417E+02,
     +  .608954E+02, .459282E+02, .346978E+02, .262803E+02,
     +  .199705E+02, .152264E+02, .116566E+02, .895879E+01,
     +  .691894E+01, .536610E+01, .418066E+01, .327042E+01,
     +  .256875E+01, .202409E+01, .160118E+01, .126727E+01,
     +  .100614E+01, .798160E+00, .633760E+00, .502789E+00 /
        DATA (UPDI(I),I=1873,1924) /
     +  .398331E+00, .314855E+00, .248162E+00, .194868E+00,
     +  .152363E+00, .118530E+00, .916994E-01, .704923E-01,
     +  .538198E-01, .407807E-01, .306382E-01, .228409E-01,
     +  .168301E-01, .122670E-01, .883765E-02, .628673E-02,
     +  .441200E-02, .305084E-02, .207689E-02, .139017E-02,
     +  .914380E-03, .589634E-03, .374646E-03, .233058E-03,
     +  .142690E-03, .862120E-04, .517473E-04, .310499E-04,
     +  .188203E-04, .115572E-04, .717694E-05, .444540E-05,
     +  .268392E-05, .151759E-05, .764998E-06, .313418E-06,
     +  .833961E-07, .611433E-08, .000000E+00, .773725E+06,
     +  .588706E+06, .440744E+06, .329840E+06, .246783E+06,
     +  .184558E+06, .137988E+06, .103122E+06, .770460E+05,
     +  .575372E+05, .429570E+05, .320566E+05, .239160E+05 /
        DATA (UPDI(I),I=1925,1976) /
     +  .178344E+05, .132960E+05, .990797E+04, .738159E+04,
     +  .549696E+04, .409273E+04, .304597E+04, .226665E+04,
     +  .168614E+04, .125424E+04, .932740E+03, .693693E+03,
     +  .515852E+03, .383790E+03, .284378E+03, .211737E+03,
     +  .157727E+03, .117613E+03, .877866E+02, .656218E+02,
     +  .491746E+02, .369089E+02, .277728E+02, .209663E+02,
     +  .158810E+02, .120781E+02, .922210E+01, .707591E+01,
     +  .545231E+01, .422043E+01, .328041E+01, .256021E+01,
     +  .200464E+01, .157591E+01, .123951E+01, .978083E+00,
     +  .771170E+00, .608644E+00, .479989E+00, .378026E+00,
     +  .297064E+00, .232787E+00, .181749E+00, .141301E+00,
     +  .109309E+00, .840955E-01, .642916E-01, .488186E-01,
     +  .367922E-01, .274937E-01, .203885E-01, .149443E-01 /
        DATA (UPDI(I),I=1977,2028) /
     +  .108362E-01, .776733E-02, .549813E-02, .384028E-02,
     +  .264361E-02, .179229E-02, .119543E-02, .784160E-03,
     +  .504876E-03, .320822E-03, .200078E-03, .123202E-03,
     +  .751793E-04, .457908E-04, .280130E-04, .173567E-04,
     +  .108917E-04, .687896E-05, .430302E-05, .260113E-05,
     +  .146160E-05, .726649E-06, .291088E-06, .752836E-07,
     +  .559540E-08, .000000E+00, .973735E+06, .738472E+06,
     +  .550746E+06, .410557E+06, .305956E+06, .227888E+06,
     +  .169685E+06, .126281E+06, .939472E+05, .698554E+05,
     +  .519239E+05, .385745E+05, .286473E+05, .212634E+05,
     +  .157773E+05, .117004E+05, .867423E+04, .642735E+04,
     +  .476110E+04, .352508E+04, .260936E+04, .193068E+04,
     +  .142831E+04, .105630E+04, .781148E+03, .577549E+03 /
        DATA (UPDI(I),I=2029,2080) /
     +  .427188E+03, .314635E+03, .232858E+03, .172406E+03,
     +  .127765E+03, .947706E+02, .703953E+02, .524173E+02,
     +  .390904E+02, .292249E+02, .219197E+02, .164956E+02,
     +  .124640E+02, .945515E+01, .720783E+01, .551822E+01,
     +  .424406E+01, .327779E+01, .254198E+01, .197785E+01,
     +  .154519E+01, .120781E+01, .947242E+00, .742307E+00,
     +  .582338E+00, .456511E+00, .357414E+00, .279226E+00,
     +  .217541E+00, .168872E+00, .130543E+00, .100418E+00,
     +  .768243E-01, .584080E-01, .441079E-01, .330618E-01,
     +  .245727E-01, .181253E-01, .132151E-01, .953235E-02,
     +  .679783E-02, .478796E-02, .332827E-02, .228086E-02,
     +  .154003E-02, .102357E-02, .669661E-03, .430541E-03,
     +  .273657E-03, .171119E-03, .105977E-03, .652887E-04 /
        DATA (UPDI(I),I=2081,2132) /
     +  .403035E-04, .250720E-04, .158103E-04, .100797E-04,
     +  .643409E-05, .404186E-05, .243600E-05, .135640E-05,
     +  .663920E-06, .259871E-06, .653672E-07, .492336E-08,
     +  .000000E+00, .121536E+07, .918786E+06, .682648E+06,
     +  .506947E+06, .376322E+06, .279196E+06, .207055E+06,
     +  .153464E+06, .113696E+06, .841837E+05, .623052E+05,
     +  .460846E+05, .340723E+05, .251756E+05, .185940E+05,
     +  .137245E+05, .101261E+05, .746667E+04, .550355E+04,
     +  .405424E+04, .298562E+04, .219752E+04, .161705E+04,
     +  .118940E+04, .874724E+03, .643099E+03, .472957E+03,
     +  .346299E+03, .254782E+03, .187513E+03, .138119E+03,
     +  .101823E+03, .751645E+02, .556194E+02, .412161E+02,
     +  .306185E+02, .228181E+02, .170617E+02, .128090E+02 /
        DATA (UPDI(I),I=2133,2184) /
     +  .965458E+01, .731271E+01, .556280E+01, .425112E+01,
     +  .326249E+01, .251419E+01, .194399E+01, .150934E+01,
     +  .117250E+01, .913944E+00, .711862E+00, .555099E+00,
     +  .432570E+00, .336672E+00, .261484E+00, .202538E+00,
     +  .156322E+00, .120153E+00, .919035E-01, .699160E-01,
     +  .528606E-01, .396988E-01, .295946E-01, .218763E-01,
     +  .160499E-01, .116395E-01, .835188E-02, .592543E-02,
     +  .415272E-02, .287293E-02, .196003E-02, .131807E-02,
     +  .873084E-03, .569805E-03, .365908E-03, .232709E-03,
     +  .145950E-03, .909283E-04, .565449E-04, .353442E-04,
     +  .223111E-04, .142709E-04, .920420E-05, .591223E-05,
     +  .371589E-05, .222677E-05, .122635E-05, .590276E-06,
     +  .225664E-06, .552422E-07, .421558E-08, .000000E+00 /
        DATA (UPDI(I),I=2185,2236) /
     +  .150487E+07, .113410E+07, .839510E+06, .621105E+06,
     +  .459311E+06, .339451E+06, .250749E+06, .185108E+06,
     +  .136583E+06, .100712E+06, .742241E+05, .546660E+05,
     +  .402408E+05, .296018E+05, .217644E+05, .159910E+05,
     +  .117432E+05, .861787E+04, .632128E+04, .463367E+04,
     +  .339517E+04, .248619E+04, .181993E+04, .133153E+04,
     +  .973963E+03, .712118E+03, .520787E+03, .379124E+03,
     +  .277322E+03, .202909E+03, .148570E+03, .108870E+03,
     +  .798758E+02, .587430E+02, .432600E+02, .319358E+02,
     +  .236497E+02, .175719E+02, .131084E+02, .981761E+01,
     +  .738908E+01, .558538E+01, .424146E+01, .323466E+01,
     +  .247717E+01, .190347E+01, .146879E+01, .113398E+01,
     +  .878550E+00, .680151E+00, .527193E+00, .408385E+00 /
        DATA (UPDI(I),I=2237,2288) /
     +  .315976E+00, .243977E+00, .187881E+00, .144176E+00,
     +  .110185E+00, .838022E-01, .633946E-01, .476631E-01,
     +  .355977E-01, .263921E-01, .194026E-01, .141585E-01,
     +  .102130E-01, .728986E-02, .514543E-02, .358820E-02,
     +  .247065E-02, .167820E-02, .112414E-02, .742240E-03,
     +  .483347E-03, .310128E-03, .197429E-03, .124246E-03,
     +  .778903E-04, .488875E-04, .309159E-04, .197669E-04,
     +  .127890E-04, .831649E-05, .535820E-05, .336019E-05,
     +  .199823E-05, .108697E-05, .514040E-06, .191898E-06,
     +  .457477E-07, .353658E-08, .000000E+00, .184887E+07,
     +  .138907E+07, .102451E+07, .755188E+06, .556374E+06,
     +  .409623E+06, .301416E+06, .221638E+06, .162884E+06,
     +  .119619E+06, .877945E+05, .643896E+05, .471961E+05 /
        DATA (UPDI(I),I=2289,2340) /
     +  .345677E+05, .253032E+05, .185076E+05, .135290E+05,
     +  .988219E+04, .721427E+04, .526275E+04, .383713E+04,
     +  .279576E+04, .203610E+04, .148196E+04, .107826E+04,
     +  .784126E+03, .570307E+03, .412831E+03, .300269E+03,
     +  .218439E+03, .159009E+03, .115832E+03, .844747E+02,
     +  .617506E+02, .451967E+02, .331602E+02, .244040E+02,
     +  .180195E+02, .133583E+02, .994218E+01, .743599E+01,
     +  .558573E+01, .421524E+01, .319470E+01, .243142E+01,
     +  .185679E+01, .142401E+01, .109269E+01, .841446E+00,
     +  .647500E+00, .498888E+00, .384172E+00, .295494E+00,
     +  .226832E+00, .173666E+00, .132502E+00, .100685E+00,
     +  .761436E-01, .572771E-01, .428236E-01, .318062E-01,
     +  .234519E-01, .171470E-01, .124452E-01, .892926E-02 /
        DATA (UPDI(I),I=2341,2392) /
     +  .634016E-02, .445229E-02, .308959E-02, .211746E-02,
     +  .143216E-02, .955752E-03, .629194E-03, .408965E-03,
     +  .262291E-03, .167220E-03, .105643E-03, .666614E-04,
     +  .422227E-04, .269911E-04, .174494E-04, .113915E-04,
     +  .744824E-05, .480103E-05, .299784E-05, .176650E-05,
     +  .948140E-06, .440253E-06, .160470E-06, .372801E-07,
     +  .291930E-08, .000000E+00, .225423E+07, .168851E+07,
     +  .124089E+07, .911367E+06, .668957E+06, .490668E+06,
     +  .359677E+06, .263458E+06, .192857E+06, .141066E+06,
     +  .103116E+06, .753155E+05, .549731E+05, .400924E+05,
     +  .292199E+05, .212782E+05, .154845E+05, .112590E+05,
     +  .818114E+04, .593985E+04, .430994E+04, .312486E+04,
     +  .226441E+04, .163975E+04, .118689E+04, .858564E+03 /
        DATA (UPDI(I),I=2393,2444) /
     +  .621096E+03, .447110E+03, .323400E+03, .233944E+03,
     +  .169322E+03, .122631E+03, .889075E+02, .646064E+02,
     +  .470028E+02, .342767E+02, .250717E+02, .183991E+02,
     +  .135557E+02, .100269E+02, .745306E+01, .556401E+01,
     +  .417295E+01, .314321E+01, .237755E+01, .180455E+01,
     +  .137556E+01, .104911E+01, .803032E+00, .614234E+00,
     +  .470446E+00, .360135E+00, .275382E+00, .210164E+00,
     +  .159974E+00, .121355E+00, .916892E-01, .689485E-01,
     +  .515732E-01, .383442E-01, .283217E-01, .207683E-01,
     +  .151021E-01, .109022E-01, .778055E-02, .549580E-02,
     +  .383986E-02, .265174E-02, .180913E-02, .121860E-02,
     +  .810380E-03, .532073E-03, .345323E-03, .221482E-03,
     +  .141482E-03, .897702E-04, .570288E-04, .364433E-04 /
        DATA (UPDI(I),I=2445,2496) /
     +  .235280E-04, .153538E-04, .100918E-04, .661893E-05,
     +  .425959E-05, .264395E-05, .154198E-05, .815958E-06,
     +  .371822E-06, .132325E-06, .299783E-07, .237771E-08,
     +  .000000E+00, .272793E+07, .203727E+07, .149188E+07,
     +  .109178E+07, .798461E+06, .583496E+06, .426118E+06,
     +  .310939E+06, .226734E+06, .165195E+06, .120272E+06,
     +  .874903E+05, .635964E+05, .461875E+05, .335187E+05,
     +  .243031E+05, .176078E+05, .127456E+05, .921910E+04,
     +  .666242E+04, .481139E+04, .347168E+04, .250341E+04,
     +  .180379E+04, .129901E+04, .934802E+03, .672692E+03,
     +  .481631E+03, .346477E+03, .249258E+03, .179395E+03,
     +  .129190E+03, .931231E+02, .672769E+02, .486572E+02,
     +  .352724E+02, .256453E+02, .187067E+02, .136988E+02 /
        DATA (UPDI(I),I=2497,2548) /
     +  .100713E+02, .744045E+01, .552079E+01, .411531E+01,
     +  .308096E+01, .231632E+01, .174744E+01, .132402E+01,
     +  .100372E+01, .763705E+00, .580674E+00, .442114E+00,
     +  .336461E+00, .255778E+00, .194072E+00, .146874E+00,
     +  .110780E+00, .832232E-01, .622290E-01, .462859E-01,
     +  .342217E-01, .251373E-01, .183323E-01, .132583E-01,
     +  .952003E-02, .675826E-02, .474912E-02, .330166E-02,
     +  .226928E-02, .154140E-02, .103420E-02, .685518E-03,
     +  .449047E-03, .291125E-03, .186819E-03, .119636E-03,
     +  .762684E-04, .487856E-04, .314416E-04, .204796E-04,
     +  .134681E-04, .889504E-05, .584032E-05, .374602E-05,
     +  .230828E-05, .133117E-05, .694012E-06, .310251E-06,
     +  .107811E-06, .238349E-07, .191461E-08, .000000E+00 /
        DATA (UPDI(I),I=2549,2600) /
     +  .902718E+05, .895163E+05, .694228E+05, .538398E+05,
     +  .417547E+05, .323824E+05, .251139E+05, .194770E+05,
     +  .151054E+05, .117152E+05, .908591E+04, .704685E+04,
     +  .546550E+04, .423911E+04, .328800E+04, .255039E+04,
     +  .197834E+04, .153469E+04, .119061E+04, .923763E+03,
     +  .716801E+03, .556283E+03, .431784E+03, .335217E+03,
     +  .260312E+03, .202207E+03, .157130E+03, .121721E+03,
     +  .946896E+02, .737079E+02, .574182E+02, .447674E+02,
     +  .349390E+02, .273199E+02, .213779E+02, .167548E+02,
     +  .131540E+02, .103457E+02, .815196E+01, .643418E+01,
     +  .508805E+01, .402876E+01, .319336E+01, .253271E+01,
     +  .200892E+01, .159269E+01, .126244E+01, .997468E+00,
     +  .787335E+00, .618650E+00, .484712E+00, .378102E+00 /
        DATA (UPDI(I),I=2601,2652) /
     +  .293451E+00, .226449E+00, .173626E+00, .132179E+00,
     +  .998377E-01, .747625E-01, .554599E-01, .407193E-01,
     +  .295615E-01, .211974E-01, .149943E-01, .104657E-01,
     +  .716808E-02, .481834E-02, .317092E-02, .203675E-02,
     +  .127189E-02, .768158E-03, .445418E-03, .245276E-03,
     +  .125929E-03, .582055E-04, .225380E-04, .521380E-05,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .157023E+06,
     +  .122399E+06, .942485E+05, .725704E+05, .558845E+05,
     +  .430336E+05, .331414E+05, .255221E+05, .196566E+05,
     +  .151386E+05, .116602E+05, .898075E+04, .691777E+04 /
        DATA (UPDI(I),I=2653,2704) /
     +  .532849E+04, .410482E+04, .316207E+04, .243617E+04,
     +  .187688E+04, .144621E+04, .111438E+04, .858849E+03,
     +  .661949E+03, .510314E+03, .393461E+03, .303461E+03,
     +  .234098E+03, .180677E+03, .138986E+03, .107383E+03,
     +  .830097E+02, .642221E+02, .497255E+02, .385429E+02,
     +  .299297E+02, .232606E+02, .181050E+02, .141182E+02,
     +  .110287E+02, .863248E+01, .676823E+01, .531782E+01,
     +  .418382E+01, .329584E+01, .259815E+01, .204895E+01,
     +  .161527E+01, .127358E+01, .100109E+01, .786489E+00,
     +  .615213E+00, .480072E+00, .373085E+00, .288625E+00,
     +  .222100E+00, .169919E+00, .129140E+00, .974508E-01,
     +  .729571E-01, .541626E-01, .398351E-01, .290093E-01,
     +  .208961E-01, .148763E-01, .104728E-01, .725600E-02 /
        DATA (UPDI(I),I=2705,2756) /
     +  .494973E-02, .332060E-02, .218592E-02, .140966E-02,
     +  .887371E-03, .543758E-03, .322103E-03, .183224E-03,
     +  .980971E-04, .484619E-04, .200964E-04, .492824E-05,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .211714E+06, .164183E+06,
     +  .125676E+06, .961922E+05, .736335E+05, .563597E+05,
     +  .431427E+05, .330220E+05, .252781E+05, .193482E+05,
     +  .148110E+05, .113366E+05, .867818E+04, .664250E+04,
     +  .508495E+04, .389224E+04, .297970E+04, .228090E+04,
     +  .174626E+04, .133686E+04, .102365E+04, .783799E+03,
     +  .600299E+03, .459778E+03, .352262E+03, .269927E+03 /
        DATA (UPDI(I),I=2757,2808) /
     +  .206947E+03, .158109E+03, .121337E+03, .931596E+02,
     +  .715875E+02, .550502E+02, .423801E+02, .326847E+02,
     +  .252293E+02, .195035E+02, .151063E+02, .117209E+02,
     +  .911337E+01, .709799E+01, .554087E+01, .433144E+01,
     +  .339090E+01, .265677E+01, .208288E+01, .163260E+01,
     +  .128026E+01, .100100E+01, .782543E+00, .609229E+00,
     +  .473322E+00, .366333E+00, .282354E+00, .216549E+00,
     +  .165198E+00, .125245E+00, .943338E-01, .705300E-01,
     +  .523310E-01, .384947E-01, .280668E-01, .202635E-01,
     +  .144791E-01, .102472E-01, .715293E-02, .492806E-02,
     +  .335053E-02, .224474E-02, .148212E-02, .962655E-03,
     +  .615629E-03, .386822E-03, .239224E-03, .145034E-03,
     +  .870511E-04, .511934E-04, .297317E-04, .169204E-04 /
        DATA (UPDI(I),I=2809,2860) /
     +  .947838E-05, .512450E-05, .266852E-05, .127220E-05,
     +  .534116E-06, .154049E-06, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .280826E+06, .216812E+06, .165109E+06,
     +  .125718E+06, .957297E+05, .728826E+05, .554914E+05,
     +  .422428E+05, .321591E+05, .244782E+05, .186329E+05,
     +  .141810E+05, .107934E+05, .821365E+04, .625094E+04,
     +  .475644E+04, .361958E+04, .275400E+04, .209566E+04,
     +  .159448E+04, .121335E+04, .923237E+03, .702637E+03,
     +  .534731E+03, .407060E+03, .309895E+03, .236048E+03,
     +  .179144E+03, .136573E+03, .104160E+03, .795070E+02,
     +  .607296E+02, .464377E+02, .355725E+02, .272732E+02,
     +  .209409E+02, .161107E+02, .124162E+02, .958993E+01 /
        DATA (UPDI(I),I=2861,2912) /
     +  .741984E+01, .575456E+01, .446966E+01, .347718E+01,
     +  .270763E+01, .211013E+01, .164436E+01, .128232E+01,
     +  .997178E+00, .775578E+00, .600836E+00, .464647E+00,
     +  .358052E+00, .274859E+00, .210017E+00, .159679E+00,
     +  .120699E+00, .906779E-01, .676541E-01, .501200E-01,
     +  .368325E-01, .268488E-01, .193949E-01, .138794E-01,
     +  .984816E-02, .690172E-02, .478127E-02, .327531E-02,
     +  .221624E-02, .148252E-02, .979256E-03, .640045E-03,
     +  .413618E-03, .265169E-03, .168443E-03, .107248E-03,
     +  .680620E-04, .435296E-04, .280012E-04, .182826E-04,
     +  .120115E-04, .800377E-05, .531225E-05, .351602E-05,
     +  .226630E-05, .141098E-05, .818851E-06, .428437E-06,
     +  .187014E-06, .545558E-07, .378381E-08, .000000E+00 /
        DATA (UPDI(I),I=2913,2964) /
     +  .367577E+06, .282654E+06, .214250E+06, .162366E+06,
     +  .123046E+06, .932245E+05, .706298E+05, .534982E+05,
     +  .405214E+05, .306846E+05, .232355E+05, .175903E+05,
     +  .133165E+05, .100786E+05, .762804E+04, .577189E+04,
     +  .436748E+04, .330402E+04, .249961E+04, .189065E+04,
     +  .143018E+04, .108167E+04, .818205E+03, .618847E+03,
     +  .468160E+03, .354164E+03, .268060E+03, .202117E+03,
     +  .153091E+03, .115995E+03, .879598E+02, .667417E+02,
     +  .506954E+02, .385751E+02, .293774E+02, .224053E+02,
     +  .171219E+02, .131074E+02, .100566E+02, .772967E+01,
     +  .595590E+01, .459636E+01, .355321E+01, .274974E+01,
     +  .213005E+01, .165013E+01, .127955E+01, .989526E+00,
     +  .765584E+00, .590082E+00, .454130E+00, .348344E+00 /
        DATA (UPDI(I),I=2965,3016) /
     +  .266254E+00, .202620E+00, .153481E+00, .115617E+00,
     +  .865921E-01, .644309E-01, .476236E-01, .349342E-01,
     +  .254325E-01, .183593E-01, .131382E-01, .932929E-02,
     +  .654912E-02, .454944E-02, .312910E-02, .212909E-02,
     +  .143479E-02, .956869E-03, .633117E-03, .415500E-03,
     +  .271492E-03, .176569E-03, .115569E-03, .757878E-04,
     +  .502857E-04, .336906E-04, .229395E-04, .157348E-04,
     +  .109145E-04, .752512E-05, .513881E-05, .340238E-05,
     +  .215645E-05, .126456E-05, .660987E-06, .283986E-06,
     +  .802881E-07, .570948E-08, .000000E+00, .475700E+06,
     +  .364442E+06, .275052E+06, .207530E+06, .156570E+06,
     +  .118086E+06, .890530E+05, .671366E+05, .506091E+05,
     +  .381380E+05, .287372E+05, .216466E+05, .163040E+05 /
        DATA (UPDI(I),I=3017,3068) /
     +  .122760E+05, .924242E+04, .695621E+04, .523518E+04,
     +  .393871E+04, .296318E+04, .222862E+04, .167617E+04,
     +  .126035E+04, .947747E+03, .712544E+03, .535778E+03,
     +  .402831E+03, .303008E+03, .227015E+03, .170860E+03,
     +  .128630E+03, .969099E+02, .730538E+02, .551252E+02,
     +  .416696E+02, .315235E+02, .238823E+02, .181292E+02,
     +  .137864E+02, .105076E+02, .802323E+01, .614191E+01,
     +  .470947E+01, .361760E+01, .278220E+01, .214211E+01,
     +  .164962E+01, .127181E+01, .978017E+00, .752609E+00,
     +  .577052E+00, .441884E+00, .337332E+00, .256665E+00,
     +  .194483E+00, .146720E+00, .110105E+00, .821756E-01,
     +  .609497E-01, .449220E-01, .328707E-01, .238808E-01,
     +  .172117E-01, .123033E-01, .873172E-02, .613037E-02 /
        DATA (UPDI(I),I=3069,3120) /
     +  .426233E-02, .293687E-02, .200399E-02, .135599E-02,
     +  .909341E-03, .606022E-03, .401395E-03, .265267E-03,
     +  .174947E-03, .116349E-03, .777242E-04, .526012E-04,
     +  .359876E-04, .249971E-04, .174780E-04, .123143E-04,
     +  .860254E-05, .592247E-05, .394017E-05, .249565E-05,
     +  .145597E-05, .752194E-06, .316382E-06, .867837E-07,
     +  .627305E-08, .000000E+00, .609466E+06, .465287E+06,
     +  .349722E+06, .262770E+06, .197405E+06, .148242E+06,
     +  .111304E+06, .835370E+05, .626858E+05, .470205E+05,
     +  .352635E+05, .264356E+05, .198141E+05, .148452E+05,
     +  .111204E+05, .832685E+04, .623409E+04, .466545E+04,
     +  .349105E+04, .261131E+04, .195309E+04, .146031E+04,
     +  .109182E+04, .816092E+03, .610020E+03, .455904E+03 /
        DATA (UPDI(I),I=3121,3172) /
     +  .340853E+03, .253780E+03, .189816E+03, .142003E+03,
     +  .106305E+03, .796220E+02, .596919E+02, .448281E+02,
     +  .336903E+02, .253559E+02, .191207E+02, .144445E+02,
     +  .109367E+02, .829621E+01, .630966E+01, .480703E+01,
     +  .366913E+01, .280424E+01, .214589E+01, .164265E+01,
     +  .125907E+01, .962702E+00, .736758E+00, .561881E+00,
     +  .428054E+00, .325159E+00, .246230E+00, .185731E+00,
     +  .139513E+00, .104269E+00, .775205E-01, .572912E-01,
     +  .420858E-01, .307030E-01, .222464E-01, .159970E-01,
     +  .114130E-01, .808790E-02, .567276E-02, .394263E-02,
     +  .271736E-02, .185624E-02, .125853E-02, .846633E-03,
     +  .566693E-03, .377550E-03, .251371E-03, .167342E-03,
     +  .112491E-03, .760870E-04, .521684E-04, .361757E-04 /
        DATA (UPDI(I),I=3173,3224) /
     +  .254350E-04, .179818E-04, .127682E-04, .896907E-05,
     +  .618343E-05, .410809E-05, .258722E-05, .149539E-05,
     +  .761320E-06, .313045E-06, .833805E-07, .611423E-08,
     +  .000000E+00, .773686E+06, .588671E+06, .440713E+06,
     +  .329812E+06, .246758E+06, .184535E+06, .137968E+06,
     +  .103104E+06, .770299E+05, .575227E+05, .429441E+05,
     +  .320450E+05, .239056E+05, .178251E+05, .132877E+05,
     +  .990049E+04, .737488E+04, .549095E+04, .408733E+04,
     +  .304113E+04, .226231E+04, .168224E+04, .125074E+04,
     +  .929589E+03, .690858E+03, .513299E+03, .381489E+03,
     +  .282305E+03, .209863E+03, .156032E+03, .116077E+03,
     +  .863924E+02, .643536E+02, .480190E+02, .358541E+02,
     +  .268087E+02, .200839E+02, .150729E+02, .113379E+02 /
        DATA (UPDI(I),I=3225,3276) /
     +  .854450E+01, .645643E+01, .488733E+01, .370676E+01,
     +  .281532E+01, .214114E+01, .162914E+01, .124139E+01,
     +  .943712E+00, .718196E+00, .544742E+00, .412813E+00,
     +  .311987E+00, .235096E+00, .176496E+00, .131975E+00,
     +  .982080E-01, .727130E-01, .535288E-01, .391775E-01,
     +  .284839E-01, .205737E-01, .147523E-01, .104983E-01,
     +  .742356E-02, .519752E-02, .360771E-02, .248469E-02,
     +  .169721E-02, .115151E-02, .775926E-03, .520767E-03,
     +  .348344E-03, .233175E-03, .156323E-03, .105946E-03,
     +  .723457E-04, .500944E-04, .350852E-04, .248796E-04,
     +  .177167E-04, .126321E-04, .889076E-05, .611889E-05,
     +  .404782E-05, .252884E-05, .144521E-05, .723968E-06,
     +  .290820E-06, .752723E-07, .559533E-08, .000000E+00 /
        DATA (UPDI(I),I=3277,3328) /
     +  .973694E+06, .738435E+06, .550712E+06, .410527E+06,
     +  .305929E+06, .227864E+06, .169663E+06, .126261E+06,
     +  .939298E+05, .698399E+05, .519100E+05, .385621E+05,
     +  .286361E+05, .212534E+05, .157684E+05, .116924E+05,
     +  .866703E+04, .642090E+04, .475532E+04, .351990E+04,
     +  .260471E+04, .192651E+04, .142456E+04, .105293E+04,
     +  .778126E+03, .574830E+03, .424741E+03, .312434E+03,
     +  .230872E+03, .170613E+03, .126143E+03, .933019E+02,
     +  .690631E+02, .512071E+02, .379896E+02, .282226E+02,
     +  .210062E+02, .156629E+02, .117052E+02, .876428E+01,
     +  .657985E+01, .494894E+01, .372972E+01, .281508E+01,
     +  .212778E+01, .160918E+01, .121893E+01, .921250E+00,
     +  .697142E+00, .525850E+00, .396357E+00, .297993E+00 /
        DATA (UPDI(I),I=3329,3380) /
     +  .223417E+00, .166911E+00, .124219E+00, .920176E-01,
     +  .678327E-01, .497288E-01, .362519E-01, .262585E-01,
     +  .188996E-01, .135081E-01, .958407E-02, .675893E-02,
     +  .472106E-02, .327074E-02, .224940E-02, .153525E-02,
     +  .104149E-02, .702342E-03, .472209E-03, .316811E-03,
     +  .212984E-03, .143623E-03, .980131E-04, .674688E-04,
     +  .471008E-04, .332533E-04, .237329E-04, .169837E-04,
     +  .121331E-04, .853741E-05, .585439E-05, .384938E-05,
     +  .238213E-05, .134434E-05, .661972E-06, .259678E-06,
     +  .653592E-07, .492330E-08, .000000E+00, .121532E+07,
     +  .918746E+06, .682612E+06, .506915E+06, .376293E+06,
     +  .279171E+06, .207031E+06, .153443E+06, .113678E+06,
     +  .841671E+05, .622902E+05, .460713E+05, .340603E+05 /
        DATA (UPDI(I),I=3381,3432) /
     +  .251649E+05, .185844E+05, .137159E+05, .101184E+05,
     +  .745977E+04, .549737E+04, .404870E+04, .298065E+04,
     +  .219307E+04, .161306E+04, .118582E+04, .871510E+03,
     +  .640211E+03, .470361E+03, .343967E+03, .252682E+03,
     +  .185621E+03, .136411E+03, .100281E+03, .737690E+02,
     +  .543555E+02, .400706E+02, .295795E+02, .218752E+02,
     +  .162063E+02, .120334E+02, .895221E+01, .667793E+01,
     +  .499079E+01, .373752E+01, .280339E+01, .210590E+01,
     +  .158297E+01, .119196E+01, .895593E+00, .673860E+00,
     +  .505445E+00, .378901E+00, .283361E+00, .211351E+00,
     +  .157107E+00, .116354E+00, .857864E-01, .629521E-01,
     +  .459496E-01, .333563E-01, .240647E-01, .172550E-01,
     +  .122888E-01, .868985E-02, .610961E-02, .425576E-02 /
        DATA (UPDI(I),I=3433,3484) /
     +  .294148E-02, .201916E-02, .137634E-02, .933116E-03,
     +  .629445E-03, .423735E-03, .285007E-03, .192338E-03,
     +  .130389E-03, .895431E-04, .620841E-04, .436523E-04,
     +  .310251E-04, .222533E-04, .159770E-04, .114179E-04,
     +  .801928E-05, .547153E-05, .357118E-05, .218676E-05,
     +  .121750E-05, .588866E-06, .225527E-06, .552365E-07,
     +  .421554E-08, .000000E+00, .150482E+07, .113405E+07,
     +  .839471E+06, .621071E+06, .459279E+06, .339423E+06,
     +  .250725E+06, .185086E+06, .136563E+06, .100694E+06,
     +  .742082E+05, .546517E+05, .402280E+05, .295904E+05,
     +  .217541E+05, .159818E+05, .117350E+05, .861051E+04,
     +  .631469E+04, .462777E+04, .338988E+04, .248146E+04,
     +  .181569E+04, .132772E+04, .970551E+03, .709056E+03 /
        DATA (UPDI(I),I=3485,3536) /
     +  .518039E+03, .376659E+03, .275107E+03, .200916E+03,
     +  .146776E+03, .107253E+03, .784178E+02, .574267E+02,
     +  .420712E+02, .308618E+02, .226793E+02, .166955E+02,
     +  .123178E+02, .910556E+01, .674920E+01, .501221E+01,
     +  .372998E+01, .278036E+01, .207576E+01, .155085E+01,
     +  .116082E+01, .867070E+00, .648654E+00, .483792E+00,
     +  .360671E+00, .268279E+00, .199052E+00, .147209E+00,
     +  .108480E+00, .795953E-01, .581351E-01, .422416E-01,
     +  .305304E-01, .219338E-01, .156640E-01, .111135E-01,
     +  .783052E-02, .548720E-02, .381062E-02, .262692E-02,
     +  .179933E-02, .122460E-02, .829527E-03, .559612E-03,
     +  .377136E-03, .254267E-03, .172228E-03, .117351E-03,
     +  .810737E-04, .565883E-04, .400426E-04, .286201E-04 /
        DATA (UPDI(I),I=3537,3588) /
     +  .206060E-04, .148222E-04, .105825E-04, .740910E-05,
     +  .502427E-05, .325178E-05, .196860E-05, .108051E-05,
     +  .513022E-06, .191799E-06, .457437E-07, .353656E-08,
     +  .000000E+00, .184882E+07, .138903E+07, .102447E+07,
     +  .755151E+06, .556340E+06, .409593E+06, .301389E+06,
     +  .221614E+06, .162862E+06, .119599E+06, .877774E+05,
     +  .643743E+05, .471824E+05, .345555E+05, .252922E+05,
     +  .184978E+05, .135202E+05, .987434E+04, .720725E+04,
     +  .525646E+04, .383150E+04, .279073E+04, .203160E+04,
     +  .147792E+04, .107465E+04, .780888E+03, .567404E+03,
     +  .410232E+03, .297938E+03, .216346E+03, .157129E+03,
     +  .114142E+03, .829553E+02, .603834E+02, .439663E+02,
     +  .320530E+02, .234080E+02, .171242E+02, .125546E+02 /
        DATA (UPDI(I),I=3589,3640) /
     +  .922228E+01, .679272E+01, .501293E+01, .370724E+01,
     +  .274633E+01, .203778E+01, .151326E+01, .112594E+01,
     +  .836060E+00, .621849E+00, .461165E+00, .341893E+00,
     +  .252932E+00, .186668E+00, .137335E+00, .100690E+00,
     +  .735153E-01, .534366E-01, .386472E-01, .278064E-01,
     +  .198902E-01, .141453E-01, .999637E-02, .701686E-02,
     +  .489987E-02, .339184E-02, .233173E-02, .159346E-02,
     +  .108268E-02, .732712E-03, .494328E-03, .333511E-03,
     +  .225404E-03, .153251E-03, .104949E-03, .729291E-04,
     +  .512221E-04, .364523E-04, .261756E-04, .188965E-04,
     +  .136015E-04, .969057E-05, .675564E-05, .454884E-05,
     +  .291688E-05, .174464E-05, .943426E-06, .439521E-06,
     +  .160400E-06, .372772E-07, .291928E-08, .000000E+00 /
        DATA (UPDI(I),I=3641,3692) /
     +  .225417E+07, .168846E+07, .124085E+07, .911327E+06,
     +  .668921E+06, .490636E+06, .359649E+06, .263433E+06,
     +  .192835E+06, .141046E+06, .103098E+06, .752992E+05,
     +  .549585E+05, .400793E+05, .292082E+05, .212678E+05,
     +  .154752E+05, .112506E+05, .817366E+04, .593317E+04,
     +  .430396E+04, .311952E+04, .225963E+04, .163548E+04,
     +  .118307E+04, .855145E+03, .618036E+03, .444376E+03,
     +  .320951E+03, .231750E+03, .167356E+03, .120869E+03,
     +  .873281E+02, .631898E+02, .457326E+02, .331383E+02,
     +  .240520E+02, .174869E+02, .127410E+02, .930104E+01,
     +  .680809E+01, .499309E+01, .366971E+01, .270183E+01,
     +  .199253E+01, .147072E+01, .108779E+01, .802968E+00,
     +  .593787E+00, .437844E+00, .322791E+00, .237495E+00 /
        DATA (UPDI(I),I=3693,3744) /
     +  .174335E+00, .127589E+00, .930643E-01, .676072E-01,
     +  .489021E-01, .352000E-01, .252093E-01, .179524E-01,
     +  .127126E-01, .894731E-02, .625611E-02, .435295E-02,
     +  .300332E-02, .205876E-02, .140362E-02, .952111E-03,
     +  .643788E-03, .434408E-03, .293460E-03, .198856E-03,
     +  .135729E-03, .934229E-04, .652891E-04, .461230E-04,
     +  .329879E-04, .237759E-04, .171920E-04, .123686E-04,
     +  .878466E-05, .609197E-05, .406975E-05, .258370E-05,
     +  .152591E-05, .812535E-06, .371297E-06, .132275E-06,
     +  .299762E-07, .237770E-08, .000000E+00, .272787E+07,
     +  .203722E+07, .149184E+07, .109173E+07, .798422E+06,
     +  .583461E+06, .426088E+06, .310911E+06, .226709E+06,
     +  .165173E+06, .120252E+06, .874729E+05, .635808E+05 /
        DATA (UPDI(I),I=3745,3796) /
     +  .461735E+05, .335062E+05, .242919E+05, .175979E+05,
     +  .127367E+05, .921116E+04, .665533E+04, .480506E+04,
     +  .346602E+04, .249836E+04, .179928E+04, .129498E+04,
     +  .931198E+03, .669473E+03, .478759E+03, .343911E+03,
     +  .246964E+03, .177345E+03, .127357E+03, .914852E+02,
     +  .658127E+02, .473492E+02, .341048E+02, .246041E+02,
     +  .177796E+02, .128750E+02, .934124E+01, .679546E+01,
     +  .495321E+01, .361807E+01, .264756E+01, .194068E+01,
     +  .142383E+01, .104687E+01, .768218E+00, .564809E+00,
     +  .414099E+00, .303576E+00, .222132E+00, .162177E+00,
     +  .118064E+00, .856705E-01, .619210E-01, .445677E-01,
     +  .319258E-01, .227575E-01, .161333E-01, .113746E-01,
     +  .797255E-02, .555257E-02, .384937E-02, .264706E-02 /
        DATA (UPDI(I),I=3797,3848) /
     +  .180939E-02, .123077E-02, .833563E-03, .563227E-03,
     +  .380191E-03, .257227E-03, .174804E-03, .119800E-03,
     +  .828799E-04, .582391E-04, .413615E-04, .297084E-04,
     +  .214712E-04, .155350E-04, .111593E-04, .789360E-05,
     +  .544063E-05, .360357E-05, .226357E-05, .131938E-05,
     +  .691534E-06, .309875E-06, .107776E-06, .238335E-07,
     +  .191460E-08, .000000E+00, .216037E+07, .166399E+07,
     +  .126383E+07, .959913E+06, .729082E+06, .553763E+06,
     +  .420606E+06, .319471E+06, .242658E+06, .184316E+06,
     +  .140004E+06, .106348E+06, .807854E+05, .613694E+05,
     +  .466220E+05, .354205E+05, .269123E+05, .204495E+05,
     +  .155404E+05, .118114E+05, .897861E+04, .682662E+04,
     +  .519170E+04, .394953E+04, .300570E+04, .228847E+04 /
        DATA (UPDI(I),I=3849,3900) /
     +  .174338E+04, .132394E+04, .101028E+04, .771726E+03,
     +  .590246E+03, .452134E+03, .346981E+03, .267085E+03,
     +  .206009E+03, .159425E+03, .123850E+03, .966396E+02,
     +  .757852E+02, .597552E+02, .474130E+02, .378584E+02,
     +  .304322E+02, .246302E+02, .200708E+02, .164649E+02,
     +  .136030E+02, .112925E+02, .943596E+01, .791436E+01,
     +  .667039E+01, .564179E+01, .478535E+01, .406758E+01,
     +  .346245E+01, .294959E+01, .251295E+01, .213982E+01,
     +  .182001E+01, .154530E+01, .130899E+01, .110558E+01,
     +  .930476E+00, .780502E+00, .650887E+00, .539851E+00,
     +  .445010E+00, .364300E+00, .295924E+00, .238305E+00,
     +  .190053E+00, .149934E+00, .116835E+00, .897605E-01,
     +  .680503E-01, .505995E-01, .368786E-01, .262644E-01 /
        DATA (UPDI(I),I=3901,3952) /
     +  .182081E-01, .122289E-01, .790792E-02, .488839E-02,
     +  .284756E-02, .154648E-02, .763995E-03, .331650E-03,
     +  .119372E-03, .319516E-04, .498086E-05, .206948E-06,
     +  .000000E+00, .322553E+07, .248143E+07, .188180E+07,
     +  .142662E+07, .108160E+07, .819767E+06, .621342E+06,
     +  .470790E+06, .356728E+06, .270207E+06, .204675E+06,
     +  .154981E+06, .117353E+06, .888279E+05, .672365E+05,
     +  .508744E+05, .384940E+05, .291155E+05, .220222E+05,
     +  .166511E+05, .125904E+05, .951686E+04, .719431E+04,
     +  .543722E+04, .411000E+04, .310623E+04, .234844E+04,
     +  .176878E+04, .133838E+04, .101312E+04, .767656E+03,
     +  .582192E+03, .442219E+03, .336707E+03, .256819E+03,
     +  .196418E+03, .150763E+03, .116171E+03, .899470E+02 /
        DATA (UPDI(I),I=3953,4004) /
     +  .699909E+02, .547986E+02, .431604E+02, .342199E+02,
     +  .273103E+02, .219450E+02, .177487E+02, .144587E+02,
     +  .118332E+02, .974966E+01, .806276E+01, .670124E+01,
     +  .558966E+01, .467632E+01, .392095E+01, .329274E+01,
     +  .276761E+01, .232673E+01, .195527E+01, .164137E+01,
     +  .137560E+01, .115023E+01, .959092E+00, .796837E+00,
     +  .659894E+00, .543230E+00, .444763E+00, .361866E+00,
     +  .292370E+00, .234350E+00, .186195E+00, .146463E+00,
     +  .113939E+00, .875281E-01, .662613E-01, .494801E-01,
     +  .362184E-01, .259668E-01, .181799E-01, .123771E-01,
     +  .815628E-02, .516660E-02, .312490E-02, .177676E-02,
     +  .939957E-03, .450742E-03, .189277E-03, .655074E-04,
     +  .167728E-04, .251230E-05, .106343E-06, .000000E+00 /
        DATA (UPDI(I),I=4005,4056) /
     +  .467520E+07, .358850E+07, .271396E+07, .205158E+07,
     +  .155082E+07, .117172E+07, .885245E+06, .668468E+06,
     +  .504738E+06, .380905E+06, .287426E+06, .216765E+06,
     +  .163456E+06, .123184E+06, .928208E+05, .698988E+05,
     +  .526291E+05, .396011E+05, .297933E+05, .224001E+05,
     +  .168390E+05, .126505E+05, .950272E+04, .713410E+04,
     +  .535558E+04, .401823E+04, .301523E+04, .225298E+04,
     +  .169093E+04, .126913E+04, .953209E+03, .716306E+03,
     +  .538951E+03, .406337E+03, .306798E+03, .232188E+03,
     +  .176308E+03, .134356E+03, .102856E+03, .791125E+02,
     +  .612152E+02, .476391E+02, .373153E+02, .294168E+02,
     +  .233470E+02, .186479E+02, .150028E+02, .121242E+02,
     +  .986478E+01, .805547E+01, .661147E+01, .544597E+01 /
        DATA (UPDI(I),I=4057,4108) /
     +  .449942E+01, .372585E+01, .309024E+01, .256546E+01,
     +  .213034E+01, .176837E+01, .146639E+01, .121403E+01,
     +  .100281E+01, .826052E+00, .677944E+00, .554617E+00,
     +  .450952E+00, .364650E+00, .292980E+00, .233729E+00,
     +  .184948E+00, .145034E+00, .112569E+00, .863848E-01,
     +  .654413E-01, .488301E-01, .359260E-01, .258933E-01,
     +  .182659E-01, .125737E-01, .840822E-02, .543689E-02,
     +  .337407E-02, .199659E-02, .110806E-02, .570884E-03,
     +  .265671E-03, .107859E-03, .358748E-04, .878121E-05,
     +  .126202E-05, .539006E-07, .000000E+00, .659657E+07,
     +  .504894E+07, .380575E+07, .286700E+07, .215951E+07,
     +  .162563E+07, .122353E+07, .920311E+06, .692097E+06,
     +  .520126E+06, .390795E+06, .293415E+06, .220242E+06 /
        DATA (UPDI(I),I=4109,4160) /
     +  .165195E+06, .123869E+06, .928092E+05, .695148E+05,
     +  .520251E+05, .389223E+05, .290954E+05, .217418E+05,
     +  .162332E+05, .121164E+05, .903636E+04, .673738E+04,
     +  .501917E+04, .373887E+04, .277233E+04, .206448E+04,
     +  .153702E+04, .114480E+04, .852890E+03, .636025E+03,
     +  .475158E+03, .355389E+03, .266368E+03, .200262E+03,
     +  .151066E+03, .114454E+03, .871059E+02, .666788E+02,
     +  .513271E+02, .397611E+02, .309958E+02, .243236E+02,
     +  .192074E+02, .152771E+02, .122037E+02, .981529E+01,
     +  .792216E+01, .642678E+01, .523254E+01, .427296E+01,
     +  .349736E+01, .286713E+01, .235271E+01, .193108E+01,
     +  .158445E+01, .129868E+01, .106275E+01, .867694E+00,
     +  .706477E+00, .573040E+00, .463325E+00, .372266E+00 /
        DATA (UPDI(I),I=4161,4212) /
     +  .297434E+00, .236092E+00, .186046E+00, .145391E+00,
     +  .112575E+00, .862480E-01, .653145E-01, .488117E-01,
     +  .359124E-01, .260426E-01, .184887E-01, .128383E-01,
     +  .869268E-02, .571228E-02, .362595E-02, .220581E-02,
     +  .127774E-02, .692652E-03, .347813E-03, .157251E-03,
     +  .618030E-04, .197963E-04, .464635E-05, .642293E-06,
     +  .271846E-07, .000000E+00, .909041E+07, .693587E+07,
     +  .520880E+07, .390919E+07, .293310E+07, .219922E+07,
     +  .164849E+07, .123478E+07, .924593E+06, .691796E+06,
     +  .517425E+06, .386690E+06, .288870E+06, .215610E+06,
     +  .160857E+06, .119900E+06, .893283E+05, .664886E+05,
     +  .494632E+05, .367614E+05, .273068E+05, .202635E+05,
     +  .150292E+05, .111360E+05, .824731E+04, .610162E+04 /
        DATA (UPDI(I),I=4213,4264) /
     +  .451299E+04, .332157E+04, .245488E+04, .181355E+04,
     +  .134000E+04, .990156E+03, .732165E+03, .542271E+03,
     +  .401986E+03, .298559E+03, .222377E+03, .166159E+03,
     +  .124670E+03, .939479E+02, .711968E+02, .542494E+02,
     +  .415925E+02, .320866E+02, .249150E+02, .194657E+02,
     +  .153178E+02, .121041E+02, .963016E+01, .768806E+01,
     +  .616883E+01, .496763E+01, .401214E+01, .324783E+01,
     +  .263326E+01, .213701E+01, .173466E+01, .140756E+01,
     +  .114091E+01, .923287E+00, .745430E+00, .600152E+00,
     +  .481311E+00, .384765E+00, .305604E+00, .241348E+00,
     +  .189329E+00, .147425E+00, .113819E+00, .870458E-01,
     +  .658513E-01, .492279E-01, .363052E-01, .263464E-01,
     +  .188380E-01, .131781E-01, .901095E-02, .600366E-02 /
        DATA (UPDI(I),I=4265,4316) /
     +  .387869E-02, .241804E-02, .144279E-02, .818610E-03,
     +  .433791E-03, .212486E-03, .934421E-04, .356025E-04,
     +  .110068E-04, .248449E-05, .330969E-06, .135321E-07,
     +  .000000E+00, .122682E+08, .932962E+07, .697930E+07,
     +  .521727E+07, .389869E+07, .291115E+07, .217289E+07,
     +  .162055E+07, .120808E+07, .899827E+06, .669899E+06,
     +  .498274E+06, .370419E+06, .275108E+06, .204201E+06,
     +  .151417E+06, .112206E+06, .830616E+05, .614457E+05,
     +  .454049E+05, .335282E+05, .247301E+05, .182280E+05,
     +  .134203E+05, .987395E+04, .725588E+04, .532970E+04,
     +  .389452E+04, .285736E+04, .209514E+04, .153618E+04,
     +  .112621E+04, .826036E+03, .606757E+03, .445977E+03,
     +  .328368E+03, .242416E+03, .179500E+03, .133443E+03 /
        DATA (UPDI(I),I=4317,4368) /
     +  .996200E+02, .747791E+02, .564316E+02, .428437E+02,
     +  .327264E+02, .251586E+02, .194584E+02, .151572E+02,
     +  .118543E+02, .933469E+01, .737489E+01, .585599E+01,
     +  .466649E+01, .372941E+01, .298722E+01, .239641E+01,
     +  .192423E+01, .154536E+01, .124061E+01, .994842E+00,
     +  .796453E+00, .636106E+00, .506595E+00, .401842E+00,
     +  .317719E+00, .249544E+00, .194859E+00, .151120E+00,
     +  .116313E+00, .887439E-01, .670563E-01, .501084E-01,
     +  .369903E-01, .269299E-01, .192829E-01, .135994E-01,
     +  .937791E-02, .631721E-02, .414350E-02, .263312E-02,
     +  .161308E-02, .944665E-03, .525374E-03, .272397E-03,
     +  .130297E-03, .558120E-04, .206518E-04, .617815E-05,
     +  .134543E-05, .172982E-06, .658443E-08, .000000E+00 /
        DATA (UPDI(I),I=4369,4420) /
     +  .162505E+08, .123162E+08, .917679E+07, .683222E+07,
     +  .508432E+07, .378050E+07, .280961E+07, .208624E+07,
     +  .154826E+07, .114795E+07, .850624E+06, .629691E+06,
     +  .465833E+06, .344256E+06, .254227E+06, .187536E+06,
     +  .138233E+06, .101774E+06, .748697E+05, .550109E+05,
     +  .403851E+05, .296107E+05, .216922E+05, .158713E+05,
     +  .116023E+05, .846993E+04, .617961E+04, .448403E+04,
     +  .326661E+04, .237791E+04, .173055E+04, .125908E+04,
     +  .916290E+03, .667712E+03, .486775E+03, .355429E+03,
     +  .260162E+03, .190976E+03, .140723E+03, .104115E+03,
     +  .774433E+02, .579043E+02, .435513E+02, .329532E+02,
     +  .250911E+02, .192191E+02, .148257E+02, .114810E+02,
     +  .895173E+01, .700187E+01, .550423E+01, .434216E+01 /
        DATA (UPDI(I),I=4421,4472) /
     +  .343518E+01, .272368E+01, .216276E+01, .171889E+01,
     +  .136630E+01, .108557E+01, .861520E+00, .682560E+00,
     +  .539455E+00, .425115E+00, .333637E+00, .260987E+00,
     +  .202771E+00, .156606E+00, .120109E+00, .914074E-01,
     +  .689451E-01, .514899E-01, .380193E-01, .277249E-01,
     +  .199329E-01, .140888E-01, .980489E-02, .666803E-02,
     +  .442733E-02, .286038E-02, .178910E-02, .107779E-02,
     +  .620009E-03, .338311E-03, .171824E-03, .803723E-04,
     +  .335933E-04, .120989E-04, .351324E-05, .740811E-06,
     +  .920492E-07, .308769E-08, .000000E+00, .211642E+08,
     +  .159855E+08, .118627E+08, .879579E+07, .651817E+07,
     +  .482611E+07, .357114E+07, .264005E+07, .195044E+07,
     +  .143954E+07, .106171E+07, .782225E+06, .575865E+06 /
        DATA (UPDI(I),I=4473,4524) /
     +  .423472E+06, .311147E+06, .228345E+06, .167428E+06,
     +  .122608E+06, .897016E+05, .655404E+05, .478394E+05,
     +  .348714E+05, .253931E+05, .184654E+05, .134140E+05,
     +  .972958E+04, .705203E+04, .508221E+04, .367689E+04,
     +  .265775E+04, .192024E+04, .138681E+04, .100161E+04,
     +  .724276E+03, .523842E+03, .379420E+03, .275441E+03,
     +  .200504E+03, .146486E+03, .107444E+03, .792182E+02,
     +  .587055E+02, .437561E+02, .328069E+02, .247498E+02,
     +  .187813E+02, .143525E+02, .110091E+02, .850216E+01,
     +  .658624E+01, .512752E+01, .400575E+01, .313812E+01,
     +  .246379E+01, .193713E+01, .152436E+01, .119965E+01,
     +  .943668E+00, .741406E+00, .581491E+00, .454929E+00,
     +  .354859E+00, .275639E+00, .213396E+00, .164059E+00 /
        DATA (UPDI(I),I=4525,4576) /
     +  .125367E+00, .951199E-01, .716026E-01, .534105E-01,
     +  .394396E-01, .287874E-01, .207465E-01, .147366E-01,
     +  .102867E-01, .706796E-02, .474316E-02, .310608E-02,
     +  .197806E-02, .121871E-02, .722613E-03, .408763E-03,
     +  .219101E-03, .109166E-03, .500227E-04, .204473E-04,
     +  .718785E-05, .203328E-05, .416844E-06, .501259E-07,
     +  .136038E-08, .000000E+00, .271396E+08, .204287E+08,
     +  .150986E+08, .111492E+08, .822759E+07, .606594E+07,
     +  .446913E+07, .328942E+07, .241930E+07, .177748E+07,
     +  .130486E+07, .956840E+06, .701023E+06, .512989E+06,
     +  .375035E+06, .273834E+06, .199738E+06, .145497E+06,
     +  .105872E+06, .769293E+05, .558361E+05, .404670E+05,
     +  .292945E+05, .211748E+05, .152877E+05, .110188E+05 /
        DATA (UPDI(I),I=4577,4628) /
     +  .793522E+04, .568065E+04, .408222E+04, .293051E+04,
     +  .210242E+04, .150750E+04, .108077E+04, .775674E+03,
     +  .556713E+03, .400080E+03, .288123E+03, .208036E+03,
     +  .150735E+03, .109634E+03, .801460E+02, .588817E+02,
     +  .435042E+02, .323303E+02, .241726E+02, .181779E+02,
     +  .137655E+02, .104617E+02, .800502E+01, .614333E+01,
     +  .473797E+01, .366665E+01, .284533E+01, .221273E+01,
     +  .172316E+01, .134301E+01, .104677E+01, .815474E+00,
     +  .634483E+00, .492788E+00, .381762E+00, .294858E+00,
     +  .226760E+00, .173806E+00, .132272E+00, .100044E+00,
     +  .751229E-01, .559577E-01, .412972E-01, .301654E-01,
     +  .217759E-01, .155172E-01, .108957E-01, .751562E-02,
     +  .510166E-02, .338074E-02, .218523E-02, .137292E-02 /
        DATA (UPDI(I),I=4629,4680) /
     +  .834038E-03, .487280E-03, .271400E-03, .143115E-03,
     +  .700790E-04, .315248E-04, .126355E-04, .434933E-05,
     +  .120341E-05, .240930E-06, .280832E-07, .531654E-09,
     +  .000000E+00, .343068E+08, .257359E+08, .189442E+08,
     +  .139317E+08, .102381E+08, .751637E+07, .551392E+07,
     +  .404073E+07, .295865E+07, .216395E+07, .158127E+07,
     +  .115412E+07, .841530E+06, .612833E+06, .445818E+06,
     +  .323885E+06, .235036E+06, .170318E+06, .123273E+06,
     +  .890893E+05, .643039E+05, .463413E+05, .333535E+05,
     +  .239670E+05, .171994E+05, .123204E+05, .881677E+04,
     +  .627066E+04, .447662E+04, .319211E+04, .227438E+04,
     +  .161939E+04, .115266E+04, .821245E+03, .585014E+03,
     +  .417221E+03, .298135E+03, .213567E+03, .153500E+03 /
        DATA (UPDI(I),I=4681,4732) /
     +  .110735E+03, .802813E+02, .584872E+02, .428457E+02,
     +  .315679E+02, .233978E+02, .174411E+02, .130913E+02,
     +  .986036E+01, .747746E+01, .568655E+01, .434591E+01,
     +  .333260E+01, .256244E+01, .197442E+01, .152340E+01,
     +  .117633E+01, .908344E+00, .701037E+00, .540343E+00,
     +  .415732E+00, .319030E+00, .244071E+00, .185909E+00,
     +  .141131E+00, .106363E+00, .796603E-01, .592252E-01,
     +  .436744E-01, .319055E-01, .230657E-01, .164768E-01,
     +  .116163E-01, .806814E-02, .550327E-02, .369340E-02,
     +  .241889E-02, .154470E-02, .958436E-03, .574761E-03,
     +  .331315E-03, .181968E-03, .945653E-04, .456020E-04,
     +  .201874E-04, .795692E-05, .269113E-05, .731312E-06,
     +  .143604E-06, .162562E-07, .152104E-09, .000000E+00 /
        DATA (UPDI(I),I=4733,4784) /
     +  .427915E+08, .319929E+08, .234554E+08, .171792E+08,
     +  .125724E+08, .919148E+07, .671399E+07, .489892E+07,
     +  .357124E+07, .260035E+07, .189152E+07, .137420E+07,
     +  .997294E+06, .722804E+06, .523260E+06, .378269E+06,
     +  .273117E+06, .196900E+06, .141766E+06, .101909E+06,
     +  .731569E+05, .524295E+05, .375218E+05, .268067E+05,
     +  .191236E+05, .136161E+05, .968406E+04, .684361E+04,
     +  .485426E+04, .343872E+04, .243365E+04, .172095E+04,
     +  .121637E+04, .860467E+03, .608482E+03, .430737E+03,
     +  .305461E+03, .217132E+03, .154839E+03, .110814E+03,
     +  .796905E+02, .575829E+02, .418342E+02, .305651E+02,
     +  .224632E+02, .166017E+02, .123545E+02, .922459E+01,
     +  .693460E+01, .522739E+01, .395986E+01, .300976E+01 /
        DATA (UPDI(I),I=4785,4836) /
     +  .229369E+01, .175164E+01, .133946E+01, .102506E+01,
     +  .784441E+00, .599976E+00, .458285E+00, .349415E+00,
     +  .265712E+00, .201434E+00, .152030E+00, .114356E+00,
     +  .853867E-01, .633540E-01, .466596E-01, .340819E-01,
     +  .246595E-01, .176545E-01, .124877E-01, .871622E-02,
     +  .599268E-02, .404534E-02, .268656E-02, .174056E-02,
     +  .109931E-02, .674397E-03, .399750E-03, .227686E-03,
     +  .123519E-03, .633787E-04, .301637E-04, .131731E-04,
     +  .512063E-05, .170723E-05, .457330E-06, .884121E-07,
     +  .974130E-08, .000000E+00, .000000E+00, .527113E+08,
     +  .392783E+08, .286821E+08, .209228E+08, .152494E+08,
     +  .111024E+08, .807563E+07, .586730E+07, .425858E+07,
     +  .308717E+07, .223556E+07, .161676E+07, .116789E+07 /
        DATA (UPDI(I),I=4837,4888) /
     +  .842468E+06, .606965E+06, .436646E+06, .313701E+06,
     +  .225018E+06, .161178E+06, .115257E+06, .822968E+05,
     +  .586592E+05, .417469E+05, .296564E+05, .210341E+05,
     +  .148877E+05, .105246E+05, .739121E+04, .520969E+04,
     +  .366684E+04, .257807E+04, .181088E+04, .127116E+04,
     +  .892972E+03, .626965E+03, .440601E+03, .310145E+03,
     +  .218804E+03, .154838E+03, .109953E+03, .784494E+02,
     +  .562345E+02, .405250E+02, .293674E+02, .214054E+02,
     +  .156885E+02, .115778E+02, .857162E+01, .638941E+01,
     +  .477539E+01, .358663E+01, .270278E+01, .204211E+01,
     +  .154614E+01, .117215E+01, .889305E+00, .674693E+00,
     +  .511589E+00, .387401E+00, .292820E+00, .220750E+00,
     +  .165899E+00, .124122E+00, .925536E-01, .685019E-01 /
        DATA (UPDI(I),I=4889,4940) /
     +  .503786E-01, .367753E-01, .266230E-01, .190902E-01,
     +  .135438E-01, .949277E-02, .656475E-02, .447147E-02,
     +  .298987E-02, .196671E-02, .126179E-02, .789059E-03,
     +  .479201E-03, .281145E-03, .158462E-03, .850537E-04,
     +  .431693E-04, .203190E-04, .877408E-05, .337209E-05,
     +  .111126E-05, .294269E-06, .561602E-07, .603697E-08,
     +  .000000E+00, .000000E+00, .641711E+08, .476610E+08,
     +  .346664E+08, .251875E+08, .182834E+08, .132568E+08,
     +  .960253E+07, .694725E+07, .502079E+07, .362390E+07,
     +  .261263E+07, .188099E+07, .135256E+07, .971161E+06,
     +  .696381E+06, .498573E+06, .356443E+06, .254409E+06,
     +  .181309E+06, .128986E+06, .916163E+05, .649533E+05,
     +  .459742E+05, .324780E+05, .229045E+05, .161173E+05 /
        DATA (UPDI(I),I=4941,4992) /
     +  .113266E+05, .790576E+04, .553804E+04, .387345E+04,
     +  .270583E+04, .188818E+04, .131654E+04, .918552E+03,
     +  .640428E+03, .446869E+03, .312281E+03, .218692E+03,
     +  .153603E+03, .108249E+03, .766401E+02, .545103E+02,
     +  .389734E+02, .280186E+02, .202587E+02, .147281E+02,
     +  .107810E+02, .791629E+01, .585267E+01, .433814E+01,
     +  .323138E+01, .241498E+01, .180959E+01, .135877E+01,
     +  .102161E+01, .768690E+00, .578379E+00, .434947E+00,
     +  .326656E+00, .244877E+00, .183091E+00, .136470E+00,
     +  .101266E+00, .748926E-01, .549743E-01, .400968E-01,
     +  .290284E-01, .208408E-01, .148200E-01, .104267E-01,
     +  .724687E-02, .496938E-02, .335616E-02, .222491E-02,
     +  .145101E-02, .922842E-03, .572049E-03, .344338E-03 /
        DATA (UPDI(I),I=4993,5044) /
     +  .200220E-03, .111832E-03, .594799E-04, .299114E-04,
     +  .139480E-04, .596628E-05, .227133E-05, .741236E-06,
     +  .194363E-06, .366759E-07, .385549E-08, .000000E+00,
     +  .000000E+00, .772596E+08, .571968E+08, .414407E+08,
     +  .299911E+08, .216832E+08, .156584E+08, .112955E+08,
     +  .813813E+07, .585656E+07, .420904E+07, .302126E+07,
     +  .216558E+07, .155020E+07, .110800E+07, .790813E+06,
     +  .563514E+06, .400937E+06, .284772E+06, .201938E+06,
     +  .142936E+06, .101002E+06, .712317E+05, .501482E+05,
     +  .352335E+05, .247093E+05, .172883E+05, .120791E+05,
     +  .838042E+04, .583509E+04, .405610E+04, .281559E+04,
     +  .195217E+04, .135222E+04, .937161E+03, .648944E+03,
     +  .449667E+03, .312014E+03, .216935E+03, .151256E+03 /
        DATA (UPDI(I),I=5045,5096) /
     +  .105806E+03, .743482E+02, .524790E+02, .372331E+02,
     +  .265604E+02, .190546E+02, .137439E+02, .998148E+01,
     +  .727094E+01, .533301E+01, .392143E+01, .289776E+01,
     +  .214844E+01, .159709E+01, .118971E+01, .887425E+00,
     +  .662465E+00, .494537E+00, .368986E+00, .274956E+00,
     +  .204518E+00, .151732E+00, .112223E+00, .826323E-01,
     +  .606447E-01, .441745E-01, .319731E-01, .229705E-01,
     +  .163658E-01, .115492E-01, .806364E-02, .556184E-02,
     +  .378483E-02, .253667E-02, .166874E-02, .108001E-02,
     +  .681602E-03, .419256E-03, .250413E-03, .144476E-03,
     +  .800657E-04, .422506E-04, .210786E-04, .975041E-05,
     +  .413664E-05, .156170E-05, .505180E-06, .131256E-06,
     +  .245025E-07, .252442E-08, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=5097,5148) /
     +  .902718E+05, .899010E+05, .697681E+05, .541497E+05,
     +  .420328E+05, .326320E+05, .253380E+05, .196781E+05,
     +  .152860E+05, .118772E+05, .923139E+04, .717747E+04,
     +  .558279E+04, .434444E+04, .338262E+04, .263538E+04,
     +  .205471E+04, .160333E+04, .125233E+04, .979270E+03,
     +  .766744E+03, .601243E+03, .472282E+03, .371722E+03,
     +  .293245E+03, .231945E+03, .184013E+03, .146021E+03,
     +  .116719E+03, .937136E+02, .756205E+02, .613647E+02,
     +  .501089E+02, .412251E+02, .341571E+02, .285347E+02,
     +  .240466E+02, .204496E+02, .175532E+02, .152069E+02,
     +  .132966E+02, .117269E+02, .104263E+02, .933797E+01,
     +  .841736E+01, .762960E+01, .694977E+01, .635009E+01,
     +  .582135E+01, .534419E+01, .491348E+01, .451970E+01 /
        DATA (UPDI(I),I=5149,5200) /
     +  .415694E+01, .382063E+01, .350727E+01, .321420E+01,
     +  .293941E+01, .268136E+01, .243891E+01, .221118E+01,
     +  .199748E+01, .179728E+01, .161014E+01, .143644E+01,
     +  .127404E+01, .112371E+01, .985137E+00, .857978E+00,
     +  .741887E+00, .636494E+00, .541403E+00, .456188E+00,
     +  .380347E+00, .313346E+00, .255236E+00, .204614E+00,
     +  .161352E+00, .124856E+00, .945211E-01, .697426E-01,
     +  .499132E-01, .344513E-01, .226764E-01, .141128E-01,
     +  .814461E-02, .424063E-02, .190241E-02, .674526E-03,
     +  .155710E-03, .125879E-04, .000000E+00, .157488E+06,
     +  .122817E+06, .946232E+05, .729066E+05, .561862E+05,
     +  .433044E+05, .333844E+05, .257403E+05, .198524E+05,
     +  .153143E+05, .118180E+05, .912236E+04, .704492E+04 /
        DATA (UPDI(I),I=5201,5252) /
     +  .544266E+04, .420735E+04, .325416E+04, .251890E+04,
     +  .195122E+04, .151303E+04, .117445E+04, .912890E+03,
     +  .710579E+03, .554101E+03, .432911E+03, .339030E+03,
     +  .266199E+03, .209676E+03, .165175E+03, .131103E+03,
     +  .104524E+03, .837720E+02, .675230E+02, .547812E+02,
     +  .447830E+02, .368793E+02, .306247E+02, .256604E+02,
     +  .216989E+02, .185242E+02, .159613E+02, .138827E+02,
     +  .121789E+02, .107716E+02, .959618E+01, .860456E+01,
     +  .775779E+01, .702909E+01, .638804E+01, .582492E+01,
     +  .531859E+01, .486372E+01, .444986E+01, .407078E+01,
     +  .372139E+01, .339792E+01, .309737E+01, .281748E+01,
     +  .255646E+01, .231294E+01, .208581E+01, .187420E+01,
     +  .167739E+01, .149468E+01, .132630E+01, .116997E+01 /
        DATA (UPDI(I),I=5253,5304) /
     +  .102628E+01, .894740E+00, .774890E+00, .666236E+00,
     +  .568290E+00, .480535E+00, .402456E+00, .333483E+00,
     +  .272983E+00, .220904E+00, .175882E+00, .137705E+00,
     +  .105765E+00, .794413E-01, .581320E-01, .412326E-01,
     +  .281894E-01, .183602E-01, .112956E-01, .643451E-02,
     +  .330104E-02, .145522E-02, .505274E-03, .114157E-03,
     +  .932547E-05, .000000E+00, .212216E+06, .164634E+06,
     +  .126081E+06, .965557E+05, .739596E+05, .566524E+05,
     +  .434054E+05, .332577E+05, .254896E+05, .195380E+05,
     +  .149814E+05, .114895E+05, .881547E+04, .676574E+04,
     +  .519560E+04, .399160E+04, .306894E+04, .236107E+04,
     +  .181830E+04, .140160E+04, .108186E+04, .836163E+03,
     +  .647426E+03, .502213E+03, .390500E+03, .304414E+03 /
        DATA (UPDI(I),I=5305,5356) /
     +  .238075E+03, .186195E+03, .146749E+03, .116181E+03,
     +  .924772E+02, .740365E+02, .596717E+02, .484683E+02,
     +  .396673E+02, .327408E+02, .272742E+02, .229327E+02,
     +  .194701E+02, .166857E+02, .144364E+02, .125984E+02,
     +  .110850E+02, .982430E+01, .876374E+01, .786042E+01,
     +  .708541E+01, .640571E+01, .581084E+01, .527804E+01,
     +  .480157E+01, .437015E+01, .397711E+01, .361688E+01,
     +  .328539E+01, .297928E+01, .269603E+01, .243360E+01,
     +  .219038E+01, .196504E+01, .175651E+01, .156387E+01,
     +  .138622E+01, .122360E+01, .107362E+01, .936701E+00,
     +  .812197E+00, .699523E+00, .598061E+00, .507223E+00,
     +  .426389E+00, .354969E+00, .292333E+00, .237775E+00,
     +  .191156E+00, .151156E+00, .117500E+00, .895674E-01 /
        DATA (UPDI(I),I=5357,5408) /
     +  .667381E-01, .484236E-01, .340324E-01, .230391E-01,
     +  .148430E-01, .902266E-02, .507009E-02, .256067E-02,
     +  .110793E-02, .376053E-03, .829673E-04, .685750E-05,
     +  .000000E+00, .281368E+06, .217299E+06, .165546E+06,
     +  .126110E+06, .960814E+05, .731981E+05, .557744E+05,
     +  .424967E+05, .323870E+05, .246827E+05, .188164E+05,
     +  .143456E+05, .109412E+05, .834628E+04, .637001E+04,
     +  .486332E+04, .371555E+04, .284018E+04, .217307E+04,
     +  .166402E+04, .127586E+04, .979433E+03, .753185E+03,
     +  .580219E+03, .448021E+03, .346810E+03, .269340E+03,
     +  .209152E+03, .163693E+03, .128697E+03, .101740E+03,
     +  .809031E+02, .647764E+02, .522764E+02, .425169E+02,
     +  .348800E+02, .288861E+02, .241497E+02, .203905E+02 /
        DATA (UPDI(I),I=5409,5460) /
     +  .173803E+02, .149584E+02, .129863E+02, .113678E+02,
     +  .100236E+02, .889621E+01, .793877E+01, .711991E+01,
     +  .640412E+01, .578001E+01, .522325E+01, .472758E+01,
     +  .428092E+01, .387611E+01, .350711E+01, .316951E+01,
     +  .285960E+01, .257458E+01, .231216E+01, .207048E+01,
     +  .184801E+01, .164345E+01, .145572E+01, .128368E+01,
     +  .112723E+01, .983867E+00, .853838E+00, .736368E+00,
     +  .630757E+00, .536279E+00, .452256E+00, .377983E+00,
     +  .312807E+00, .256049E+00, .206950E+00, .165298E+00,
     +  .129824E+00, .100203E+00, .758148E-01, .560467E-01,
     +  .403270E-01, .280866E-01, .188300E-01, .120016E-01,
     +  .720956E-02, .399722E-02, .198791E-02, .844490E-03,
     +  .280398E-03, .604828E-04, .505636E-05, .000000E+00 /
        DATA (UPDI(I),I=5461,5512) /
     +  .368160E+06, .283178E+06, .214720E+06, .162788E+06,
     +  .123424E+06, .935639E+05, .709343E+05, .537713E+05,
     +  .407664E+05, .309044E+05, .234327E+05, .177672E+05,
     +  .134753E+05, .102211E+05, .775586E+04, .588659E+04,
     +  .447044E+04, .339643E+04, .258259E+04, .196517E+04,
     +  .149712E+04, .114182E+04, .872277E+03, .667473E+03,
     +  .511915E+03, .393566E+03, .303561E+03, .234081E+03,
     +  .181945E+03, .142066E+03, .111546E+03, .881065E+02,
     +  .700797E+02, .561935E+02, .454170E+02, .370330E+02,
     +  .304892E+02, .253450E+02, .212819E+02, .180428E+02,
     +  .154475E+02, .133419E+02, .116200E+02, .101944E+02,
     +  .900255E+01, .799355E+01, .713339E+01, .638412E+01,
     +  .573326E+01, .515500E+01, .464246E+01, .418279E+01 /
        DATA (UPDI(I),I=5513,5564) /
     +  .376829E+01, .339248E+01, .305055E+01, .273847E+01,
     +  .245316E+01, .219204E+01, .195304E+01, .173439E+01,
     +  .153460E+01, .135240E+01, .118646E+01, .103651E+01,
     +  .899965E+00, .776908E+00, .666444E+00, .567768E+00,
     +  .480064E+00, .402573E+00, .334523E+00, .275209E+00,
     +  .223913E+00, .179840E+00, .142718E+00, .111334E+00,
     +  .853246E-01, .640794E-01, .470000E-01, .335363E-01,
     +  .231473E-01, .153689E-01, .969134E-02, .575340E-02,
     +  .314756E-02, .154158E-02, .643131E-03, .208999E-03,
     +  .441191E-04, .372989E-05, .000000E+00, .476327E+06,
     +  .365005E+06, .275557E+06, .207983E+06, .156976E+06,
     +  .118451E+06, .893799E+05, .674298E+05, .508721E+05,
     +  .383738E+05, .289488E+05, .218363E+05, .164742E+05 /
        DATA (UPDI(I),I=5565,5616) /
     +  .124287E+05, .937938E+04, .707908E+04, .534542E+04,
     +  .403762E+04, .305196E+04, .230830E+04, .174771E+04,
     +  .132460E+04, .100546E+04, .764408E+03, .582410E+03,
     +  .444785E+03, .340771E+03, .260977E+03, .201478E+03,
     +  .156255E+03, .121864E+03, .956170E+02, .755565E+02,
     +  .601988E+02, .483511E+02, .391872E+02, .320740E+02,
     +  .265115E+02, .221393E+02, .186698E+02, .159013E+02,
     +  .136640E+02, .118408E+02, .103365E+02, .908290E+01,
     +  .802512E+01, .712640E+01, .634633E+01, .567127E+01,
     +  .507398E+01, .454688E+01, .407639E+01, .365422E+01,
     +  .327347E+01, .292891E+01, .261620E+01, .233195E+01,
     +  .207334E+01, .183804E+01, .162407E+01, .142975E+01,
     +  .125363E+01, .109420E+01, .951018E+00, .821438E+00 /
        DATA (UPDI(I),I=5617,5668) /
     +  .705390E+00, .601870E+00, .509981E+00, .428829E+00,
     +  .357588E+00, .295433E+00, .241618E+00, .195395E+00,
     +  .155950E+00, .122961E+00, .952729E-01, .725000E-01,
     +  .540440E-01, .393285E-01, .278283E-01, .190349E-01,
     +  .125163E-01, .780848E-02, .458117E-02, .247304E-02,
     +  .119285E-02, .488777E-03, .155517E-03, .321539E-04,
     +  .274856E-05, .000000E+00, .610139E+06, .465891E+06,
     +  .350264E+06, .263257E+06, .197841E+06, .148633E+06,
     +  .111654E+06, .838513E+05, .629677E+05, .472732E+05,
     +  .354902E+05, .266388E+05, .199964E+05, .150086E+05,
     +  .112669E+05, .845826E+04, .635195E+04, .477115E+04,
     +  .358587E+04, .269636E+04, .202942E+04, .152880E+04,
     +  .115330E+04, .871304E+03, .659617E+03, .500485E+03 /
        DATA (UPDI(I),I=5669,5720) /
     +  .380937E+03, .289786E+03, .222233E+03, .171208E+03,
     +  .132642E+03, .103392E+03, .811722E+02, .642650E+02,
     +  .512981E+02, .413267E+02, .336287E+02, .276406E+02,
     +  .229567E+02, .192570E+02, .163171E+02, .139507E+02,
     +  .120292E+02, .104494E+02, .913721E+01, .803374E+01,
     +  .709939E+01, .629133E+01, .559472E+01, .498089E+01,
     +  .444156E+01, .396239E+01, .353453E+01, .315063E+01,
     +  .280507E+01, .249319E+01, .221128E+01, .195627E+01,
     +  .172561E+01, .151710E+01, .132886E+01, .115928E+01,
     +  .100669E+01, .870486E+00, .747968E+00, .638919E+00,
     +  .542246E+00, .456971E+00, .382135E+00, .316857E+00,
     +  .260273E+00, .211605E+00, .170087E+00, .134895E+00,
     +  .105671E+00, .813210E-01, .614441E-01, .454613E-01 /
        DATA (UPDI(I),I=5721,5772) /
     +  .328222E-01, .230300E-01, .156106E-01, .101651E-01,
     +  .627380E-02, .363739E-02, .193748E-02, .920345E-03,
     +  .370420E-03, .115428E-03, .233904E-04, .202147E-05,
     +  .000000E+00, .774408E+06, .589319E+06, .441294E+06,
     +  .330333E+06, .247225E+06, .184954E+06, .138343E+06,
     +  .103441E+06, .773317E+05, .577933E+05, .431866E+05,
     +  .322624E+05, .241005E+05, .179998E+05, .134443E+05,
     +  .100409E+05, .750071E+04, .560374E+04, .418846E+04,
     +  .313179E+04, .234361E+04, .175515E+04, .131614E+04,
     +  .988263E+03, .743517E+03, .560584E+03, .423956E+03,
     +  .320402E+03, .244115E+03, .186842E+03, .143814E+03,
     +  .111378E+03, .868849E+02, .683597E+02, .542339E+02,
     +  .434334E+02, .351402E+02, .287229E+02, .237274E+02 /
        DATA (UPDI(I),I=5773,5824) /
     +  .197999E+02, .166919E+02, .142002E+02, .121842E+02,
     +  .105326E+02, .916545E+01, .801967E+01, .705285E+01,
     +  .621976E+01, .550430E+01, .487648E+01, .432724E+01,
     +  .384153E+01, .340992E+01, .302463E+01, .267962E+01,
     +  .236993E+01, .209155E+01, .184116E+01, .161597E+01,
     +  .141360E+01, .123198E+01, .106933E+01, .923843E+00,
     +  .794749E+00, .679331E+00, .577228E+00, .487268E+00,
     +  .408408E+00, .339634E+00, .280025E+00, .228687E+00,
     +  .184822E+00, .147653E+00, .116362E+00, .905597E-01,
     +  .692160E-01, .519248E-01, .381302E-01, .273111E-01,
     +  .190015E-01, .127631E-01, .822964E-02, .502466E-02,
     +  .287864E-02, .151288E-02, .707714E-03, .279795E-03,
     +  .854108E-04, .169736E-04, .148296E-05, .000000E+00 /
        DATA (UPDI(I),I=5825,5876) /
     +  .974467E+06, .739129E+06, .551335E+06, .411085E+06,
     +  .306429E+06, .228312E+06, .170065E+06, .126621E+06,
     +  .942527E+05, .701293E+05, .521693E+05, .387944E+05,
     +  .288444E+05, .214399E+05, .159355E+05, .118422E+05,
     +  .880122E+04, .654112E+04, .486304E+04, .361641E+04,
     +  .269119E+04, .200401E+04, .149402E+04, .111519E+04,
     +  .833946E+03, .624900E+03, .469653E+03, .352671E+03,
     +  .266994E+03, .203053E+03, .155295E+03, .119511E+03,
     +  .926458E+02, .724467E+02, .571317E+02, .454879E+02,
     +  .365945E+02, .297485E+02, .244447E+02, .202938E+02,
     +  .170226E+02, .144106E+02, .123048E+02, .105858E+02,
     +  .916769E+01, .798330E+01, .698736E+01, .613232E+01,
     +  .540083E+01, .476160E+01, .420477E+01, .371462E+01 /
        DATA (UPDI(I),I=5877,5928) /
     +  .328115E+01, .289614E+01, .255317E+01, .224695E+01,
     +  .197320E+01, .172836E+01, .150940E+01, .131376E+01,
     +  .113920E+01, .983794E+00, .845591E+00, .723691E+00,
     +  .615357E+00, .520101E+00, .436686E+00, .364013E+00,
     +  .301032E+00, .246788E+00, .200371E+00, .160971E+00,
     +  .127810E+00, .100083E+00, .773797E-01, .587362E-01,
     +  .437465E-01, .318821E-01, .226536E-01, .156272E-01,
     +  .104007E-01, .664037E-02, .401045E-02, .227018E-02,
     +  .117712E-02, .542235E-03, .210581E-03, .629857E-04,
     +  .122825E-04, .108477E-05, .000000E+00, .121615E+07,
     +  .919490E+06, .683278E+06, .507512E+06, .376829E+06,
     +  .279650E+06, .207461E+06, .153828E+06, .114023E+06,
     +  .844762E+05, .625672E+05, .463194E+05, .342825E+05 /
        DATA (UPDI(I),I=5929,5980) /
     +  .253639E+05, .187626E+05, .138756E+05, .102614E+05,
     +  .758775E+04, .561197E+04, .415131E+04, .307253E+04,
     +  .227534E+04, .168672E+04, .125178E+04, .930591E+03,
     +  .693145E+03, .517782E+03, .386391E+03, .290709E+03,
     +  .219714E+03, .166991E+03, .127717E+03, .984016E+02,
     +  .764870E+02, .599634E+02, .474703E+02, .379778E+02,
     +  .307078E+02, .251020E+02, .207345E+02, .173067E+02,
     +  .145803E+02, .123903E+02, .106089E+02, .914422E+01,
     +  .792517E+01, .690364E+01, .602987E+01, .528521E+01,
     +  .463714E+01, .407505E+01, .358254E+01, .314904E+01,
     +  .276592E+01, .242638E+01, .212484E+01, .185672E+01,
     +  .161824E+01, .140617E+01, .121777E+01, .105063E+01,
     +  .902700E+00, .771905E+00, .657217E+00, .555900E+00 /
        DATA (UPDI(I),I=5981,6032) /
     +  .467348E+00, .390276E+00, .323542E+00, .266067E+00,
     +  .216877E+00, .175055E+00, .139789E+00, .110307E+00,
     +  .858227E-01, .659166E-01, .496888E-01, .367403E-01,
     +  .265724E-01, .187291E-01, .128093E-01, .844673E-02,
     +  .533939E-02, .318957E-02, .178383E-02, .912471E-03,
     +  .413883E-03, .157896E-03, .462841E-04, .886120E-05,
     +  .791061E-06, .000000E+00, .150571E+07, .113485E+07,
     +  .840185E+06, .621710E+06, .459852E+06, .339936E+06,
     +  .251184E+06, .185497E+06, .136931E+06, .101024E+06,
     +  .745038E+05, .549164E+05, .404650E+05, .298025E+05,
     +  .219440E+05, .161518E+05, .118871E+05, .874661E+04,
     +  .643648E+04, .473674E+04, .348737E+04, .256867E+04,
     +  .189371E+04, .139752E+04, .103299E+04, .764933E+03 /
        DATA (UPDI(I),I=6033,6084) /
     +  .568029E+03, .421316E+03, .315070E+03, .236682E+03,
     +  .178795E+03, .135921E+03, .104096E+03, .804405E+02,
     +  .627007E+02, .493608E+02, .392765E+02, .315918E+02,
     +  .256934E+02, .211183E+02, .175419E+02, .147084E+02,
     +  .124403E+02, .106020E+02, .909551E+01, .784599E+01,
     +  .680257E+01, .591334E+01, .515841E+01, .450411E+01,
     +  .393904E+01, .344617E+01, .301441E+01, .263471E+01,
     +  .229991E+01, .200414E+01, .174257E+01, .151119E+01,
     +  .130658E+01, .112582E+01, .966387E+00, .826082E+00,
     +  .702747E+00, .595233E+00, .500816E+00, .418789E+00,
     +  .347828E+00, .286761E+00, .234494E+00, .190043E+00,
     +  .152493E+00, .121037E+00, .949161E-01, .733710E-01,
     +  .559785E-01, .419033E-01, .307578E-01, .220751E-01 /
        DATA (UPDI(I),I=6085,6136) /
     +  .154332E-01, .104640E-01, .683622E-02, .427817E-02,
     +  .252758E-02, .139650E-02, .704667E-03, .314709E-03,
     +  .117943E-03, .338892E-04, .637330E-05, .575073E-06,
     +  .000000E+00, .184976E+07, .138988E+07, .102523E+07,
     +  .755834E+06, .556952E+06, .410141E+06, .301880E+06,
     +  .222054E+06, .163256E+06, .119952E+06, .880927E+05,
     +  .646565E+05, .474350E+05, .347814E+05, .254943E+05,
     +  .186786E+05, .136819E+05, .100189E+05, .733654E+04,
     +  .537205E+04, .393483E+04, .288308E+04, .211413E+04,
     +  .155167E+04, .114055E+04, .839785E+03, .620023E+03,
     +  .457163E+03, .339866E+03, .253802E+03, .190594E+03,
     +  .144040E+03, .109672E+03, .842669E+02, .653161E+02,
     +  .511406E+02, .404781E+02, .323923E+02, .262137E+02 /
        DATA (UPDI(I),I=6137,6188) /
     +  .214420E+02, .177266E+02, .147941E+02, .124549E+02,
     +  .105655E+02, .902231E+01, .774669E+01, .668517E+01,
     +  .578382E+01, .502153E+01, .436356E+01, .379774E+01,
     +  .330646E+01, .287811E+01, .250326E+01, .217442E+01,
     +  .188542E+01, .163120E+01, .140755E+01, .121086E+01,
     +  .103808E+01, .886544E+00, .753953E+00, .638068E+00,
     +  .537636E+00, .449959E+00, .374241E+00, .309135E+00,
     +  .253447E+00, .206080E+00, .166050E+00, .132452E+00,
     +  .104490E+00, .814282E-01, .625354E-01, .473921E-01,
     +  .352269E-01, .256674E-01, .182794E-01, .126752E-01,
     +  .851936E-02, .551375E-02, .341581E-02, .199579E-02,
     +  .108926E-02, .542151E-03, .238391E-03, .877687E-04,
     +  .247255E-04, .456996E-05, .416757E-06, .000000E+00 /
        DATA (UPDI(I),I=6189,6240) /
     +  .225519E+07, .168938E+07, .124167E+07, .912057E+06,
     +  .669575E+06, .491221E+06, .360173E+06, .263902E+06,
     +  .193254E+06, .141422E+06, .103434E+06, .755998E+05,
     +  .552273E+05, .403197E+05, .294231E+05, .214599E+05,
     +  .156469E+05, .114041E+05, .831078E+04, .605564E+04,
     +  .441334E+04, .321719E+04, .234682E+04, .171330E+04,
     +  .125253E+04, .917136E+03, .673337E+03, .493619E+03,
     +  .364868E+03, .270910E+03, .202271E+03, .151992E+03,
     +  .115073E+03, .879275E+02, .677833E+02, .527926E+02,
     +  .415715E+02, .331022E+02, .266589E+02, .217036E+02,
     +  .178599E+02, .148373E+02, .124345E+02, .105002E+02,
     +  .892559E+01, .762837E+01, .655260E+01, .564247E+01,
     +  .487569E+01, .421656E+01, .365216E+01, .316433E+01 /
        DATA (UPDI(I),I=6241,6292) /
     +  .274097E+01, .237231E+01, .205052E+01, .176919E+01,
     +  .152302E+01, .130763E+01, .111924E+01, .954679E+00,
     +  .811162E+00, .686303E+00, .577798E+00, .484308E+00,
     +  .403171E+00, .333517E+00, .273986E+00, .223378E+00,
     +  .180598E+00, .144672E+00, .114712E+00, .899420E-01,
     +  .696497E-01, .531397E-01, .400003E-01, .295223E-01,
     +  .213519E-01, .150878E-01, .103761E-01, .691297E-02,
     +  .443199E-02, .271781E-02, .157029E-02, .846542E-03,
     +  .415579E-03, .179908E-03, .650739E-04, .179772E-04,
     +  .326717E-05, .301108E-06, .000000E+00, .272896E+07,
     +  .203819E+07, .149271E+07, .109251E+07, .799121E+06,
     +  .584086E+06, .426647E+06, .311412E+06, .227157E+06,
     +  .165574E+06, .120610E+06, .877928E+05, .638668E+05 /
        DATA (UPDI(I),I=6293,6344) /
     +  .464292E+05, .337346E+05, .244960E+05, .177801E+05,
     +  .128994E+05, .935641E+04, .678497E+04, .492072E+04,
     +  .356919E+04, .259036E+04, .188130E+04, .136808E+04,
     +  .996353E+03, .727506E+03, .530349E+03, .389837E+03,
     +  .287835E+03, .213708E+03, .159698E+03, .120243E+03,
     +  .913858E+02, .700786E+02, .543014E+02, .425471E+02,
     +  .337161E+02, .270259E+02, .219015E+02, .179414E+02,
     +  .148383E+02, .123797E+02, .104072E+02, .880655E+01,
     +  .749229E+01, .640614E+01, .549054E+01, .472210E+01,
     +  .406424E+01, .350333E+01, .302070E+01, .260381E+01,
     +  .224255E+01, .192880E+01, .165592E+01, .141841E+01,
     +  .121170E+01, .103190E+01, .875712E+00, .740263E+00,
     +  .623089E+00, .521843E+00, .435111E+00, .360280E+00 /
        DATA (UPDI(I),I=6345,6396) /
     +  .296422E+00, .242172E+00, .196335E+00, .157827E+00,
     +  .125691E+00, .990654E-01, .771960E-01, .594009E-01,
     +  .450219E-01, .336599E-01, .246661E-01, .177069E-01,
     +  .124142E-01, .846676E-02, .559113E-02, .355059E-02,
     +  .215509E-02, .123123E-02, .655581E-03, .317413E-03,
     +  .135280E-03, .480756E-04, .130270E-04, .232915E-05,
     +  .216916E-06, .000000E+00, .903304E+05, .897092E+05,
     +  .695968E+05, .539967E+05, .418963E+05, .325102E+05,
     +  .252293E+05, .195812E+05, .151996E+05, .118003E+05,
     +  .916298E+04, .711662E+04, .552871E+04, .429641E+04,
     +  .333999E+04, .259758E+04, .202121E+04, .157368E+04,
     +  .122610E+04, .956088E+03, .746276E+03, .583187E+03,
     +  .456367E+03, .357704E+03, .280906E+03, .221088E+03 /
        DATA (UPDI(I),I=6397,6448) /
     +  .174462E+03, .137631E+03, .109330E+03, .871975E+02,
     +  .698620E+02, .562600E+02, .455647E+02, .371564E+02,
     +  .304904E+02, .252031E+02, .209912E+02, .176187E+02,
     +  .149020E+02, .126974E+02, .108969E+02, .941109E+01,
     +  .817420E+01, .713448E+01, .625199E+01, .549596E+01,
     +  .484487E+01, .427415E+01, .377657E+01, .333493E+01,
     +  .294506E+01, .259837E+01, .228934E+01, .201345E+01,
     +  .176699E+01, .154681E+01, .135024E+01, .117497E+01,
     +  .101895E+01, .880370E+00, .757579E+00, .649083E+00,
     +  .553515E+00, .469981E+00, .396471E+00, .332467E+00,
     +  .276989E+00, .229136E+00, .188082E+00, .153070E+00,
     +  .123407E+00, .984580E-01, .776325E-01, .603923E-01,
     +  .463935E-01, .349911E-01, .258974E-01, .187535E-01 /
        DATA (UPDI(I),I=6449,6500) /
     +  .132395E-01, .907112E-02, .599684E-02, .379926E-02,
     +  .227560E-02, .127564E-02, .653845E-03, .296563E-03,
     +  .112670E-03, .323474E-04, .556971E-05, .274632E-06,
     +  .000000E+00, .157258E+06, .122611E+06, .944398E+05,
     +  .727429E+05, .560402E+05, .431742E+05, .332683E+05,
     +  .256368E+05, .197603E+05, .152323E+05, .117451E+05,
     +  .905754E+04, .698733E+04, .539154E+04, .416200E+04,
     +  .321396E+04, .248329E+04, .191970E+04, .148516E+04,
     +  .114983E+04, .891145E+03, .691394E+03, .537186E+03,
     +  .418005E+03, .325901E+03, .254636E+03, .199491E+03,
     +  .156216E+03, .123199E+03, .975405E+02, .775860E+02,
     +  .620261E+02, .498752E+02, .403794E+02, .329015E+02,
     +  .270036E+02, .223351E+02, .186166E+02, .156393E+02 /
        DATA (UPDI(I),I=6501,6552) /
     +  .132353E+02, .112833E+02, .968059E+01, .835403E+01,
     +  .724467E+01, .630873E+01, .551136E+01, .482899E+01,
     +  .423441E+01, .371950E+01, .326538E+01, .286720E+01,
     +  .251543E+01, .220401E+01, .192783E+01, .168274E+01,
     +  .146522E+01, .127229E+01, .110135E+01, .950159E+00,
     +  .816703E+00, .699181E+00, .595993E+00, .505627E+00,
     +  .427123E+00, .358445E+00, .299008E+00, .247793E+00,
     +  .203885E+00, .166441E+00, .134705E+00, .107981E+00,
     +  .856464E-01, .671272E-01, .518939E-01, .396092E-01,
     +  .296733E-01, .218063E-01, .156739E-01, .109780E-01,
     +  .745867E-02, .488576E-02, .306503E-02, .181655E-02,
     +  .100761E-02, .510200E-03, .228211E-03, .852799E-04,
     +  .240225E-04, .406522E-05, .203642E-06, .000000E+00 /
        DATA (UPDI(I),I=6553,6604) /
     +  .211971E+06, .164415E+06, .125885E+06, .963810E+05,
     +  .738039E+05, .565135E+05, .432817E+05, .331475E+05,
     +  .253916E+05, .194508E+05, .149038E+05, .114206E+05,
     +  .875429E+04, .671146E+04, .514747E+04, .394895E+04,
     +  .303117E+04, .232765E+04, .178875E+04, .137550E+04,
     +  .105881E+04, .815822E+03, .629485E+03, .486398E+03,
     +  .376560E+03, .292126E+03, .227241E+03, .176653E+03,
     +  .138318E+03, .108718E+03, .858553E+02, .681407E+02,
     +  .543991E+02, .437268E+02, .353769E+02, .288305E+02,
     +  .236810E+02, .196025E+02, .163563E+02, .137494E+02,
     +  .116449E+02, .992613E+01, .851155E+01, .733498E+01,
     +  .634813E+01, .551215E+01, .480109E+01, .418519E+01,
     +  .365521E+01, .319070E+01, .278604E+01, .243083E+01 /
        DATA (UPDI(I),I=6605,6656) /
     +  .211838E+01, .184306E+01, .160029E+01, .138618E+01,
     +  .119744E+01, .103126E+01, .885173E+00, .756999E+00,
     +  .644800E+00, .546881E+00, .461617E+00, .387981E+00,
     +  .323931E+00, .268825E+00, .221617E+00, .181383E+00,
     +  .147275E+00, .118540E+00, .944884E-01, .745127E-01,
     +  .580570E-01, .446064E-01, .338322E-01, .251783E-01,
     +  .183752E-01, .131122E-01, .911348E-02, .614197E-02,
     +  .398819E-02, .247884E-02, .145353E-02, .796104E-03,
     +  .397446E-03, .174978E-03, .642102E-04, .177119E-04,
     +  .293960E-05, .149904E-06, .000000E+00, .281107E+06,
     +  .217065E+06, .165337E+06, .125924E+06, .959155E+05,
     +  .730504E+05, .556429E+05, .423797E+05, .322828E+05,
     +  .245901E+05, .187341E+05, .142725E+05, .108763E+05 /
        DATA (UPDI(I),I=6657,6708) /
     +  .828874E+04, .631900E+04, .481814E+04, .367555E+04,
     +  .280480E+04, .214179E+04, .163639E+04, .125145E+04,
     +  .957896E+03, .734185E+03, .563462E+03, .433243E+03,
     +  .333773E+03, .257835E+03, .199007E+03, .154719E+03,
     +  .120742E+03, .946702E+02, .745986E+02, .591294E+02,
     +  .471912E+02, .379103E+02, .306785E+02, .250249E+02,
     +  .205733E+02, .170511E+02, .142385E+02, .119809E+02,
     +  .101473E+02, .864663E+01, .740540E+01, .637031E+01,
     +  .549845E+01, .476127E+01, .412652E+01, .358369E+01,
     +  .311082E+01, .270145E+01, .234432E+01, .203215E+01,
     +  .175877E+01, .151920E+01, .130920E+01, .112521E+01,
     +  .964175E+00, .823444E+00, .700699E+00, .593878E+00,
     +  .501197E+00, .420945E+00, .352036E+00, .292435E+00 /
        DATA (UPDI(I),I=6709,6760) /
     +  .241451E+00, .198023E+00, .161225E+00, .130211E+00,
     +  .104236E+00, .826245E-01, .647853E-01, .501833E-01,
     +  .383224E-01, .288844E-01, .213555E-01, .154786E-01,
     +  .109660E-01, .756404E-02, .505690E-02, .325527E-02,
     +  .200474E-02, .116372E-02, .630445E-03, .310960E-03,
     +  .135104E-03, .488344E-04, .132672E-04, .218480E-05,
     +  .114346E-06, .000000E+00, .367881E+06, .282929E+06,
     +  .214498E+06, .162590E+06, .123248E+06, .934069E+05,
     +  .707946E+05, .536470E+05, .406558E+05, .308062E+05,
     +  .233454E+05, .176898E+05, .134066E+05, .101601E+05,
     +  .770186E+04, .583878E+04, .442812E+04, .335901E+04,
     +  .254951E+04, .193594E+04, .147131E+04, .111904E+04,
     +  .852176E+03, .649738E+03, .496266E+03, .379751E+03 /
        DATA (UPDI(I),I=6761,6812) /
     +  .291359E+03, .223312E+03, .172407E+03, .133602E+03,
     +  .104014E+03, .813816E+02, .640492E+02, .507575E+02,
     +  .404893E+02, .325376E+02, .263591E+02, .215233E+02,
     +  .177196E+02, .146996E+02, .122894E+02, .103428E+02,
     +  .875861E+01, .745563E+01, .637520E+01, .547034E+01,
     +  .470972E+01, .405861E+01, .350514E+01, .302588E+01,
     +  .261350E+01, .225594E+01, .194527E+01, .167487E+01,
     +  .143932E+01, .123408E+01, .105531E+01, .899769E+00,
     +  .764625E+00, .647432E+00, .546026E+00, .458548E+00,
     +  .383217E+00, .318898E+00, .263577E+00, .216522E+00,
     +  .176666E+00, .143089E+00, .114951E+00, .915233E-01,
     +  .721455E-01, .562475E-01, .433164E-01, .328781E-01,
     +  .246266E-01, .180887E-01, .130213E-01, .915915E-02 /
        DATA (UPDI(I),I=6813,6864) /
     +  .626998E-02, .415826E-02, .265376E-02, .161935E-02,
     +  .930589E-03, .498685E-03, .243030E-03, .104209E-03,
     +  .371265E-04, .994257E-05, .162493E-05, .872864E-07,
     +  .000000E+00, .476030E+06, .364741E+06, .275321E+06,
     +  .207773E+06, .156789E+06, .118284E+06, .892317E+05,
     +  .672980E+05, .507550E+05, .382697E+05, .288563E+05,
     +  .217543E+05, .164015E+05, .123642E+05, .932227E+04,
     +  .702852E+04, .530069E+04, .399807E+04, .301699E+04,
     +  .227742E+04, .172044E+04, .130052E+04, .984211E+03,
     +  .745652E+03, .565852E+03, .430159E+03, .327843E+03,
     +  .249558E+03, .191355E+03, .147263E+03, .113854E+03,
     +  .884589E+02, .691320E+02, .544042E+02, .430967E+02,
     +  .343945E+02, .276737E+02, .224450E+02, .183564E+02 /
        DATA (UPDI(I),I=6865,6916) /
     +  .151291E+02, .125680E+02, .105111E+02, .884661E+01,
     +  .748523E+01, .636271E+01, .542793E+01, .464665E+01,
     +  .398173E+01, .341983E+01, .293615E+01, .252244E+01,
     +  .216585E+01, .185788E+01, .159140E+01, .136063E+01,
     +  .116074E+01, .987635E+00, .837891E+00, .708525E+00,
     +  .596979E+00, .501003E+00, .418674E+00, .348166E+00,
     +  .288299E+00, .237092E+00, .193780E+00, .157300E+00,
     +  .126741E+00, .101279E+00, .802020E-01, .628710E-01,
     +  .487384E-01, .373152E-01, .281513E-01, .209547E-01,
     +  .152911E-01, .109323E-01, .763464E-02, .518684E-02,
     +  .341237E-02, .215901E-02, .130537E-02, .742651E-03,
     +  .393662E-03, .189561E-03, .802228E-04, .281744E-04,
     +  .743838E-05, .120584E-05, .664025E-07, .000000E+00 /
        DATA (UPDI(I),I=6917,6968) /
     +  .609824E+06, .465610E+06, .350013E+06, .263033E+06,
     +  .197642E+06, .148457E+06, .111497E+06, .837117E+05,
     +  .628436E+05, .471630E+05, .353923E+05, .265521E+05,
     +  .199194E+05, .149404E+05, .112066E+05, .840484E+04,
     +  .630469E+04, .472937E+04, .354895E+04, .266374E+04,
     +  .200061E+04, .150337E+04, .113085E+04, .851480E+03,
     +  .642109E+03, .485011E+03, .367252E+03, .277689E+03,
     +  .211502E+03, .161669E+03, .124138E+03, .957873E+02,
     +  .743432E+02, .581036E+02, .457116E+02, .362334E+02,
     +  .289570E+02, .233301E+02, .189556E+02, .155228E+02,
     +  .128139E+02, .106507E+02, .890972E+01, .749380E+01,
     +  .633277E+01, .537135E+01, .457234E+01, .389621E+01,
     +  .332813E+01, .284199E+01, .242858E+01, .207434E+01 /
        DATA (UPDI(I),I=6969,7020) /
     +  .177017E+01, .150852E+01, .128325E+01, .108923E+01,
     +  .922175E+00, .778484E+00, .655047E+00, .549209E+00,
     +  .458652E+00, .381404E+00, .315606E+00, .260046E+00,
     +  .212785E+00, .173032E+00, .139738E+00, .112004E+00,
     +  .890278E-01, .701183E-01, .546612E-01, .421328E-01,
     +  .320694E-01, .240466E-01, .177873E-01, .128947E-01,
     +  .915583E-02, .634809E-02, .428007E-02, .279318E-02,
     +  .175200E-02, .104955E-02, .591130E-03, .309947E-03,
     +  .147473E-03, .616006E-04, .213296E-04, .555246E-05,
     +  .892591E-06, .503487E-07, .000000E+00, .774073E+06,
     +  .589021E+06, .441028E+06, .330096E+06, .247014E+06,
     +  .184767E+06, .138177E+06, .103293E+06, .772003E+05,
     +  .576767E+05, .430832E+05, .321707E+05, .240192E+05 /
        DATA (UPDI(I),I=7021,7072) /
     +  .179278E+05, .133805E+05, .998442E+04, .745081E+04,
     +  .555962E+04, .414947E+04, .309735E+04, .231319E+04,
     +  .172829E+04, .129242E+04, .967321E+03, .725015E+03,
     +  .544225E+03, .409480E+03, .307599E+03, .232751E+03,
     +  .176734E+03, .134798E+03, .103312E+03, .796404E+02,
     +  .618237E+02, .483097E+02, .380364E+02, .301963E+02,
     +  .241696E+02, .195112E+02, .158767E+02, .130247E+02,
     +  .107599E+02, .894713E+01, .748104E+01, .628545E+01,
     +  .530090E+01, .448721E+01, .380255E+01, .323054E+01,
     +  .274385E+01, .233234E+01, .198176E+01, .168246E+01,
     +  .142647E+01, .120732E+01, .101966E+01, .858983E+00,
     +  .721554E+00, .604153E+00, .504049E+00, .418873E+00,
     +  .346614E+00, .285400E+00, .233992E+00, .190504E+00 /
        DATA (UPDI(I),I=7073,7124) /
     +  .154127E+00, .123829E+00, .987336E-01, .780619E-01,
     +  .611470E-01, .474018E-01, .363283E-01, .274890E-01,
     +  .204861E-01, .150583E-01, .108444E-01, .764701E-02,
     +  .526365E-02, .352186E-02, .227980E-02, .141762E-02,
     +  .841398E-03, .469135E-03, .243310E-03, .114392E-03,
     +  .471639E-04, .161033E-04, .413408E-05, .658962E-06,
     +  .380538E-07, .000000E+00, .974112E+06, .738812E+06,
     +  .551053E+06, .410834E+06, .306206E+06, .228114E+06,
     +  .169889E+06, .126465E+06, .941137E+05, .700059E+05,
     +  .520599E+05, .386974E+05, .287584E+05, .213638E+05,
     +  .158682E+05, .117826E+05, .874853E+04, .649455E+04,
     +  .482189E+04, .358007E+04, .265909E+04, .197566E+04,
     +  .146899E+04, .109308E+04, .814403E+03, .607614E+03 /
        DATA (UPDI(I),I=7125,7176) /
     +  .454352E+03, .339132E+03, .254972E+03, .192355E+03,
     +  .145751E+03, .110970E+03, .849753E+02, .655284E+02,
     +  .508650E+02, .397849E+02, .313783E+02, .249542E+02,
     +  .200168E+02, .161867E+02, .131977E+02, .108373E+02,
     +  .895827E+01, .744688E+01, .622099E+01, .521701E+01,
     +  .439181E+01, .370131E+01, .312764E+01, .264228E+01,
     +  .223421E+01, .188854E+01, .159509E+01, .134552E+01,
     +  .113308E+01, .952170E+00, .798144E+00, .667135E+00,
     +  .555836E+00, .461457E+00, .381594E+00, .314212E+00,
     +  .257436E+00, .210016E+00, .170122E+00, .136934E+00,
     +  .109448E+00, .868082E-01, .682659E-01, .531813E-01,
     +  .409956E-01, .312380E-01, .234976E-01, .174039E-01,
     +  .127118E-01, .909388E-02, .636818E-02, .435154E-02 /
        DATA (UPDI(I),I=7177,7228) /
     +  .288926E-02, .185511E-02, .114351E-02, .672414E-03,
     +  .371142E-03, .190394E-03, .884517E-04, .359987E-04,
     +  .121219E-04, .306964E-05, .485163E-06, .286715E-07,
     +  .000000E+00, .121577E+07, .919154E+06, .682979E+06,
     +  .507246E+06, .376592E+06, .279440E+06, .207275E+06,
     +  .153663E+06, .113876E+06, .843458E+05, .624515E+05,
     +  .462169E+05, .341917E+05, .252835E+05, .186915E+05,
     +  .138127E+05, .102058E+05, .753861E+04, .556855E+04,
     +  .411296E+04, .303866E+04, .224543E+04, .166031E+04,
     +  .122844E+04, .909960E+03, .674891E+03, .501619E+03,
     +  .372086E+03, .278003E+03, .208406E+03, .156901E+03,
     +  .118689E+03, .902954E+02, .691796E+02, .533501E+02,
     +  .414596E+02, .324899E+02, .256752E+02, .204669E+02 /
        DATA (UPDI(I),I=7229,7280) /
     +  .164494E+02, .133311E+02, .108821E+02, .894287E+01,
     +  .739150E+01, .613985E+01, .512030E+01, .428681E+01,
     +  .359318E+01, .302007E+01, .253788E+01, .213473E+01,
     +  .179513E+01, .150843E+01, .126598E+01, .106073E+01,
     +  .886924E+00, .739760E+00, .615276E+00, .510099E+00,
     +  .421401E+00, .346753E+00, .284113E+00, .231618E+00,
     +  .188011E+00, .151525E+00, .121340E+00, .964799E-01,
     +  .761188E-01, .595377E-01, .461265E-01, .353570E-01,
     +  .267856E-01, .200287E-01, .147428E-01, .106996E-01,
     +  .760329E-02, .528725E-02, .358649E-02, .236294E-02,
     +  .150478E-02, .919459E-03, .535636E-03, .292663E-03,
     +  .148500E-03, .681721E-04, .273896E-04, .909745E-05,
     +  .227294E-05, .356238E-06, .215370E-07, .000000E+00 /
        DATA (UPDI(I),I=7281,7332) /
     +  .150531E+07, .113449E+07, .839868E+06, .621428E+06,
     +  .459602E+06, .339713E+06, .250987E+06, .185322E+06,
     +  .136776E+06, .100886E+06, .743815E+05, .548081E+05,
     +  .403691E+05, .297176E+05, .218690E+05, .160854E+05,
     +  .118284E+05, .869476E+04, .639067E+04, .469628E+04,
     +  .345164E+04, .253712E+04, .186584E+04, .137290E+04,
     +  .101122E+04, .745669E+03, .550970E+03, .406214E+03,
     +  .301655E+03, .224743E+03, .168143E+03, .126393E+03,
     +  .955451E+02, .727380E+02, .557379E+02, .430420E+02,
     +  .335186E+02, .263245E+02, .208564E+02, .166618E+02,
     +  .134234E+02, .108937E+02, .890101E+01, .731534E+01,
     +  .604270E+01, .501154E+01, .417302E+01, .347895E+01,
     +  .290857E+01, .243131E+01, .203445E+01, .170200E+01 /
        DATA (UPDI(I),I=7333,7384) /
     +  .142289E+01, .118815E+01, .990516E+00, .824079E+00,
     +  .683927E+00, .566023E+00, .466948E+00, .383849E+00,
     +  .314293E+00, .256242E+00, .207853E+00, .167874E+00,
     +  .134607E+00, .107238E+00, .848216E-01, .665656E-01,
     +  .517837E-01, .398972E-01, .304086E-01, .229028E-01,
     +  .170229E-01, .124522E-01, .897930E-02, .633799E-02,
     +  .437647E-02, .294683E-02, .192646E-02, .121673E-02,
     +  .736936E-03, .425294E-03, .230024E-03, .115444E-03,
     +  .523717E-04, .207733E-04, .680722E-05, .167838E-05,
     +  .260882E-06, .161305E-07, .000000E+00, .184934E+07,
     +  .138950E+07, .102490E+07, .755536E+06, .556687E+06,
     +  .409906E+06, .301671E+06, .221868E+06, .163091E+06,
     +  .119806E+06, .879635E+05, .645421E+05, .473337E+05 /
        DATA (UPDI(I),I=7385,7436) /
     +  .346918E+05, .254151E+05, .186085E+05, .136200E+05,
     +  .996425E+04, .728823E+04, .532938E+04, .389715E+04,
     +  .284981E+04, .208474E+04, .152571E+04, .111759E+04,
     +  .819468E+03, .602029E+03, .441235E+03, .325718E+03,
     +  .241213E+03, .179365E+03, .134000E+03, .100668E+03,
     +  .761647E+02, .580018E+02, .445144E+02, .344531E+02,
     +  .268950E+02, .211812E+02, .168217E+02, .134736E+02,
     +  .108720E+02, .883311E+01, .721914E+01, .593041E+01,
     +  .489165E+01, .405134E+01, .335946E+01, .279390E+01,
     +  .232322E+01, .193395E+01, .160963E+01, .133882E+01,
     +  .111231E+01, .922641E+00, .763779E+00, .630733E+00,
     +  .519413E+00, .426376E+00, .348763E+00, .284151E+00,
     +  .230516E+00, .186047E+00, .149507E+00, .119267E+00 /
        DATA (UPDI(I),I=7437,7488) /
     +  .945249E-01, .743738E-01, .580548E-01, .449171E-01,
     +  .344141E-01, .260800E-01, .195276E-01, .144268E-01,
     +  .104870E-01, .751346E-02, .526750E-02, .361162E-02,
     +  .241384E-02, .156572E-02, .980727E-03, .588765E-03,
     +  .336597E-03, .180208E-03, .894572E-04, .401050E-04,
     +  .157064E-04, .507867E-05, .123600E-05, .190563E-06,
     +  .120471E-07, .000000E+00, .225474E+07, .168897E+07,
     +  .124131E+07, .911741E+06, .669294E+06, .490972E+06,
     +  .359951E+06, .263706E+06, .193080E+06, .141268E+06,
     +  .103298E+06, .754789E+05, .551204E+05, .402252E+05,
     +  .293395E+05, .213860E+05, .155816E+05, .113464E+05,
     +  .825984E+04, .601067E+04, .437363E+04, .318212E+04,
     +  .231585E+04, .168594E+04, .122833E+04, .895723E+03 /
        DATA (UPDI(I),I=7489,7540) /
     +  .654375E+03, .476835E+03, .349963E+03, .257651E+03,
     +  .190451E+03, .141431E+03, .105610E+03, .794222E+02,
     +  .601171E+02, .458609E+02, .352834E+02, .273808E+02,
     +  .214380E+02, .169277E+02, .134814E+02, .108173E+02,
     +  .873996E+01, .710387E+01, .580404E+01, .476166E+01,
     +  .392275E+01, .323560E+01, .267684E+01, .221430E+01,
     +  .183379E+01, .151848E+01, .125660E+01, .103874E+01,
     +  .857298E+00, .706148E+00, .580242E+00, .475464E+00,
     +  .388365E+00, .316097E+00, .256257E+00, .206850E+00,
     +  .166107E+00, .132809E+00, .105403E+00, .831023E-01,
     +  .650415E-01, .504977E-01, .388563E-01, .296039E-01,
     +  .223061E-01, .166034E-01, .121921E-01, .880677E-02,
     +  .626870E-02, .436496E-02, .297157E-02, .197128E-02 /
        DATA (UPDI(I),I=7541,7592) /
     +  .126864E-02, .788054E-03, .468917E-03, .265560E-03,
     +  .140734E-03, .691016E-04, .306163E-04, .118398E-04,
     +  .377839E-05, .907871E-06, .138859E-06, .897295E-08,
     +  .000000E+00, .272848E+07, .203777E+07, .149233E+07,
     +  .109218E+07, .798823E+06, .583822E+06, .426413E+06,
     +  .311204E+06, .226973E+06, .165411E+06, .120466E+06,
     +  .876653E+05, .637540E+05, .463294E+05, .336464E+05,
     +  .244180E+05, .177112E+05, .128386E+05, .930272E+04,
     +  .673756E+04, .487887E+04, .353224E+04, .255772E+04,
     +  .185247E+04, .134259E+04, .973802E+03, .707540E+03,
     +  .512681E+03, .374153E+03, .273889E+03, .201284E+03,
     +  .148606E+03, .110316E+03, .824755E+02, .620612E+02,
     +  .470674E+02, .360013E+02, .277774E+02, .216247E+02 /
        DATA (UPDI(I),I=7593,7644) /
     +  .169792E+02, .134473E+02, .107306E+02, .862268E+01,
     +  .697075E+01, .566480E+01, .462274E+01, .378830E+01,
     +  .310829E+01, .255820E+01, .210521E+01, .173452E+01,
     +  .142897E+01, .117655E+01, .967675E+00, .794651E+00,
     +  .651282E+00, .532498E+00, .434176E+00, .352881E+00,
     +  .285789E+00, .230533E+00, .185156E+00, .147935E+00,
     +  .117679E+00, .929139E-01, .728733E-01, .567333E-01,
     +  .438097E-01, .335248E-01, .253982E-01, .190268E-01,
     +  .140786E-01, .102751E-01, .737502E-02, .521533E-02,
     +  .360668E-02, .243784E-02, .160512E-02, .102487E-02,
     +  .631327E-03, .372330E-03, .208874E-03, .109571E-03,
     +  .532157E-04, .233030E-04, .889946E-05, .280347E-05,
     +  .665202E-06, .100949E-06, .666580E-08, .000000E+00 /
C-----------------------------------------------------------------------
C
      Dr = DrI
      Fl = FlI
      Al = AlI
      DO I=1,6
         Amass(I) = AmassI(I)
      ENDDO
      Iorder = Nint(Dr)
      Nfl = Nint(Fl)
      Alambda = Al
C
      NX = NxI
      NT = NTI
      NfMx = NfMxI
C
      QINI = QINII
      QMAX = QMAXI
      DO I=0,NT
         QL(I) = QLI(I)
      ENDDO
C
      XMIN = XMINI
      DO I=0,NX
         XV(I) = XVI(I)
      ENDDO
C
      Do 11 Iq = 0, NT
         QL(Iq) = Log (QL(Iq) /Al)
   11 Continue
C
C                  Since quark = anti-quark for nfl>2 at this stage, 
C                  we Read  out only the non-redundent data points
C     No of flavors = NfMx (sea) + 1 (gluon) + 2 (valence) 

      Nblk = (NX+1) * (NT+1)
      Npts =  Nblk  * (NfMx+3)
      DO I=1,Npts
         UPD(I) = UPDI(I)
      ENDDO
C
      Return
C                        ****************************
      End
