/*
cdcd - Command Driven CD player
Copyright (C) 1998-99 Tony Arcieri
Copyright (C) 2001 Fabrice BAUZAC

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef CONF_H
#define CONF_H

#include "cdcd.h"

struct cdcdrc {
  /* FIXME: use dynamically allocated strings.  */
  char device[CDCDRC_DEVICE_LEN];
  int verbosity;
};

int cdcdrc_data_mod (const char *var,
		     const char *value,
		     struct cdcdrc *conf);
void cdcdrc_manual_configuration (struct cdcdrc *conf);
int cdcdrc_process_line (char *line, struct cdcdrc *conf);
int cdcdrc_read (struct cdcdrc *conf);
void cdcdrc_write (const struct cdcdrc *conf);

/* Not sure about the need to export these.  */
int file_exists (char *filename);
char *cdcdrc_location_a (void);

#endif /* CONF_H */
