#
#   Copyright (C) 1998, 1999, 2000, 2001 Loic Dachary
#
#   This program is free software; you can redistribute it and/or modify it
#   under the terms of the GNU General Public License as published by the
#   Free Software Foundation; either version 2, or (at your option) any
#   later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software 
#   Foundation, Inc. 59 Temple Place, Suite 330, Boston, 
#   MA  02111-1307  USA.
#
# $Header: /cvsroot/catalog/catalog/lib/Catalog/dmoz.pm,v 1.16 2001/07/11 10:28:08 loic Exp $
#
package Catalog::dmoz;

use strict;
use vars qw(@ISA @tablelist_theme %default_templates $head);

use Catalog;
use Catalog::tools::tools;

@ISA = qw(Catalog);

@tablelist_theme = qw(catalog_related catalog_newsgroup);

$head = "
<body bgcolor=#ffffff>
";

#
# Built in templates
#
%default_templates
    = (
       'hook_search.html' => template_parse('inline hook_search', "$head
<title>Searching _QUERYTEXT_</title>

<h3>_QUERYTEXT_</h3>

<center>
<form action=_SCRIPT_ method=POST>
_HIDDEN_
<input type=text size=40 name=text value='_QUERYTEXT_'>
<input type=submit value='search'><br>
<a href=_SCRIPT_?context=hsearch_form&querymode=advanced&_PARAMS_>Advanced Search</a>
<br>
Example: <b>+catalog senga -query</b>
</form>
</center>

<table>
<!-- start entry -->

<!-- start catalog_category_dmoz -->
<tr>_DEFAULTROW_</tr>
<!-- end catalog_category_dmoz -->

<!-- start dmozrecords -->
<tr><td><a href=_URL_>_TITLE_</a></td><td>_DESCRIPTION_</td></tr>
<!-- rowid=_ROWID_ -->
<!-- end dmozrecords -->

<!-- end entry -->
</table>
<!-- start pager -->
Number of pages _MAXPAGES_
<p>
_PAGES_
<!-- end pager -->
"),
       'cimport.html' => template_parse('inline cimport', "$head
<title>Load a DMOZ catalog</title>

<center><h1>Load a DMOZ catalog</h1></center>

<center><h3><font color=red>_COMMENT_</font></h3></center>

Follow the instructions below to build your own DMOZ catalog. We do
not use the XML loader for two reasons : the dmoz data is not really
XML (needs to be patched to comply to XML syntax checker) and directly
loading into the database using the <i>load data infile</i> is much
faster.

<p>
<ul>
<li> Load files content.rdf.u8.gz and structure.rdf.u8.gz from <a href=http://dmoz.org/rdf.html>http://dmoz.org/rdf.html</a>
and make sure they are in the same directory (let's say ~/dmoz).
<li> cd ~/dmoz
<li> convert_dmoz --encoding ISO-8859-1 --exclude '^/Adult' content.rdf.u8.gz structure.rdf.u8.gz
<li> It prints a dot from time to time to show that it does not hang.
<li> It creates the following files:
     <ul>
     <li> category.txt (table catalog_category_dmoz)
     <li> entry2category.txt (table catalog_entry2category_dmoz)
     <li> category2category.txt (table catalog_category2category_dmoz)
     <li> path.txt (table catalog_path_dmoz)
     <li> newsgroup.txt (table catalog_newsgroup_dmoz)
     <li> dmozrecords.txt (table dmozrecords)
     <li> category_count.sql (SQL statements to update the category counts)
     </ul>
<li> Load the files into the database using the following command
<pre>
convert_dmoz --load all
</pre>
</ul>
<p>
You are now ready to browse the DMOZ catalog.
</form>
"),
);

sub initialize {
    my($self) = @_;

    $self->SUPER::initialize();

    my($templates) = $self->{'templates'};
    %$templates = ( %$templates, %default_templates );

    my($db) = $self->{'db'};
    $db->resources_load('dmoz_schema', 'Catalog::dmoz::schema');
}

sub cbuild_theme {
    my($self, $name, $rowid) = @_;

    my($ret) = $self->SUPER::cbuild_theme($name, $rowid);

    #
    # Create catalog tables
    #
    my($table);
    foreach $table (@tablelist_theme) {
	my($schema) = $self->db()->schema('dmoz_schema', $table);
	$schema =~ s/NAME/$name/g;
	$self->db()->exec($schema);
    }

    return $ret;
}

sub cdestroy_real {
    my($self, $name) = @_;

    my($ret) = $self->SUPER::cdestroy_real($name);

    my($tables) = $self->db()->tables();

    my($table);
    foreach $table (@tablelist_theme) {
	my($real) = "${table}_$name";
	if(grep(/^$real$/, @$tables)) {
	    $self->db()->exec("drop table $real");
	}
    }
    
    return $ret;
}

#
# Create needed structures for a catalog to work
#
sub csetup_api {
    my($self) = @_;

    $self->SUPER::csetup_api();

    $self->db()->exec($self->db()->schema('dmoz_schema', 'dmozrecords'));
    $self->cbuild_api('name' => 'dmoz',
		      'tablename' => 'dmozrecords',
		      'navigation' => 'theme');

    $self->cinfo_clear();
}

#
# Display dmoz specific informations
#
sub cedit_hook {
    my($self, $template, $id) = @_;

    if(exists($template->{'children'}->{'newsgroup'})) {
	my($cgi) = $self->{'cgi'};

	my($name) = $cgi->param('name');

	my($newsgroup_template) = $template->{'children'}->{'newsgroup'};

	my(%context) = (
			'context' => 'newsgroup entries',
			'expand' => 'yes',
			'url' => $cgi->script_name(),
			'template' => $newsgroup_template,
			'table' => "catalog_newsgroup_$name",
			'where' => "category = $id",
			'order' => "url",
			);

	return $self->searcher(\%context);
    }
}

#
# Implement specific actions when loading/unloading
#
package Catalog::dmoz::external;

use strict;
use vars qw(@ISA);

@ISA = qw(Catalog::external);

sub Related {
    my($self, $element) = @_;

    my($record) = $self->torecord($element);
    
    my($catalog) = $self->{'catalog'};
    my($name) = $self->{'name'};

    $catalog->db()->insert("catalog_related_$name",
			   %$record);
}

sub Newsgroup {
    my($self, $element) = @_;

    my($record) = $self->torecord($element);
    
    my($catalog) = $self->{'catalog'};
    my($name) = $self->{'name'};

    $catalog->db()->insert("catalog_newsgroup_$name",
			   %$record);
}

1;
# Local Variables: ***
# mode: perl ***
# End: ***
