#
#   Copyright (C) 1998, 1999, 2000, 2001 Loic Dachary
#
#   This program is free software; you can redistribute it and/or modify it
#   under the terms of the GNU General Public License as published by the
#   Free Software Foundation; either version 2, or (at your option) any
#   later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software 
#   Foundation, Inc. 59 Temple Place, Suite 330, Boston, 
#   MA  02111-1307  USA.
#
# 
# $Header: /cvsroot/catalog/catalog/conf/mifluz.pl,v 1.3 2001/07/11 10:28:08 loic Exp $

require 5.005;
use strict;

require "./lib.pl";

conf_env(
	      'mifluz_dir' => 'MIFLUZ_DIR',
	      );

sub fulltext_real_ask {
    my($mifluz_conf) = load_config("mifluz.conf");

    if(!$ENV{'USE_DEFAULTS'}) {
	print "
You will now be prompted for the parameters for the Mifluz
full text inverted index.

";
    }

    getparam('mifluz_dir', $mifluz_conf,
	     {
		 'prompt' => "Directory in which the inverted index files will be created.",
		 'mandatory' => 1,
		 'directory' => 1,
		 'directory_create' => 1,
		 'absolute' => 1,
	     });

    unload_config($mifluz_conf, "mifluz.conf", "mifluz.conf", ":");
}

version_check('DBD::Mifluz', '0.03', 'require DBI; require DBD::Mifluz;');

1;
