    #include "monitor.ih"

//KILL
    void Monitor::killChild(map<int, Child *>::value_type it)
    {
        if (kill(it.second->pid(), SIGTERM))
            cerr << "Couldn't kill process " << it.second->pid() << endl;
    }
//=
//EXIT
    void Monitor::exiting(int value, string const &msg)
    {
        for_each(d_child.begin(), d_child.end(), killChild);
        if (msg.length())
            cerr << msg << endl;
        throw value;
    }
//=
//INIT
    void (Monitor::*Monitor::s_handler[sizeofCommands])(int, string const &);

    void Monitor::initialize()
    {
        if (s_handler[UNKNOWN] != 0)    // already initialized
            return;

        s_handler[UNKNOWN] =    &Monitor::unknown;
        s_handler[START] =      &Monitor::createNewChild;
        s_handler[EXIT] =       &Monitor::exiting;
        s_handler[STOP] =       &Monitor::stopChild;
        s_handler[TEXT] =       &Monitor::sendChild;
    }
//=
