/*=====================================================================*/
/*    serrano/prgm/project/bigloo/runtime/Clib/inline-alloc.c          */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Wed Sep 21 15:33:10 1994                          */
/*    Last change :  Wed Oct 12 09:02:51 2005 (serrano)                */
/*    -------------------------------------------------------------    */
/*    On fait des fonctions d'allocations specialisees pour les cons   */
/*    et les flottants.                                                */
/*=====================================================================*/
#ifndef GC_PRIVATE_H
#  include <private/gc_priv.h>
#endif
#undef abs

#include <bigloo.h>

#if( (BGL_GC == BGL_BOEHM_GC) && !defined( GC_THREADS ))
#  define NUMBER_OF_CONS_WORDS (long)ALIGNED_WORDS( PAIR_SIZE )
#  define NUMBER_OF_FLOAT_WORDS (long)ALIGNED_WORDS( REAL_SIZE )
#  define NUMBER_OF_CELL_WORDS (long)ALIGNED_WORDS( CELL_SIZE )

/*---------------------------------------------------------------------*/
/*    alloc_make_pair ...                                              */
/*---------------------------------------------------------------------*/
static obj_t 
alloc_make_pair( obj_t car, obj_t cdr ) {
   obj_t pair;

   pair = (obj_t)GC_generic_malloc_words_small( NUMBER_OF_CONS_WORDS, NORMAL );

#if( !defined( TAG_PAIR ) )
   pair->pair_t.header = MAKE_HEADER( PAIR_TYPE, PAIR_SIZE );
#endif
   pair->pair_t.car = car;
   pair->pair_t.cdr = cdr;
   
   return BPAIR( pair );
}   

/*---------------------------------------------------------------------*/
/*    make_pair ...                                                    */
/*---------------------------------------------------------------------*/
GC_API
obj_t 
make_pair( obj_t car, obj_t cdr ) {
   obj_t pair;
   ptr_t op;
   ptr_t *opp;
   DCL_LOCK_STATE;

   opp = &(GC_objfreelist[ NUMBER_OF_CONS_WORDS ]);
   FASTLOCK();
   if( !FASTLOCK_SUCCEEDED() || (op = *opp) == 0 ) {
      FASTUNLOCK();
      return alloc_make_pair( car, cdr );
   } else {
      *opp = obj_link( op );
      GC_words_allocd += NUMBER_OF_CONS_WORDS;
      FASTUNLOCK();

      pair = (obj_t)op;

#if( !defined( TAG_PAIR ) )
      pair->pair_t.header = MAKE_HEADER( PAIR_TYPE, PAIR_SIZE );
#endif
      pair->pair_t.car = car;
      pair->pair_t.cdr = cdr;
   
      return BPAIR( pair );
   }
}

/*---------------------------------------------------------------------*/
/*    alloc_make_cell ...                                              */
/*---------------------------------------------------------------------*/
static obj_t 
alloc_make_cell( obj_t val ) {
   obj_t cell;

   cell = (obj_t)GC_generic_malloc_words_small( NUMBER_OF_CELL_WORDS, NORMAL );

#if( !defined( TAG_CELL ) )
   cell->cell_t.header = MAKE_HEADER( CELL_TYPE, CELL_SIZE );
#endif
   cell->cell_t.val = val;
   
   return BCELL( cell );
}   

/*---------------------------------------------------------------------*/
/*    make_cell ...                                                    */
/*---------------------------------------------------------------------*/
GC_API
obj_t 
make_cell( obj_t val ) {
   obj_t cell;
   ptr_t op;
   ptr_t *opp;
   DCL_LOCK_STATE;
   
   opp = &(GC_objfreelist[ NUMBER_OF_CONS_WORDS ]);
   FASTLOCK();
   if( !FASTLOCK_SUCCEEDED() || (op = *opp) == 0 ) {
      FASTUNLOCK();
      return alloc_make_cell( val );
   } else {
      *opp = obj_link( op );
      GC_words_allocd += NUMBER_OF_CONS_WORDS;
      FASTUNLOCK();

      cell = (obj_t)op;

#if( !defined( TAG_CELL ) )
      cell->cell_t.header = MAKE_HEADER( CELL_TYPE, CELL_SIZE );
#endif
      cell->cell_t.val = val;
   
      return BCELL( cell );
   }
}

/*---------------------------------------------------------------------*/
/*    alloc_make_real ...                                              */
/*---------------------------------------------------------------------*/
static obj_t
alloc_make_real( double d ) {
   obj_t real;

   real = (obj_t)GC_generic_malloc_words_small(NUMBER_OF_FLOAT_WORDS, PTRFREE);
   
#if( !defined( TAG_REAL ) || defined( BUMPY_GC ) )
   real->real_t.header = MAKE_HEADER( REAL_TYPE, REAL_SIZE );
#endif
   real->real_t.real = d;

   return BREAL( real );
}

/*---------------------------------------------------------------------*/
/*    make_real ...                                                    */
/*---------------------------------------------------------------------*/
GC_API
obj_t
make_real( double d ) {
   obj_t real;
   ptr_t op;
   ptr_t *opp;
   DCL_LOCK_STATE;
   
   opp = &(GC_aobjfreelist[ NUMBER_OF_FLOAT_WORDS ]);

   FASTLOCK();

   if( !FASTLOCK_SUCCEEDED() || (op = *opp) == 0 ) {
      FASTUNLOCK();
      return alloc_make_real( d );
   } else {
      *opp = obj_link(op);
      GC_words_allocd += NUMBER_OF_FLOAT_WORDS;
      FASTUNLOCK();

      real = (obj_t)op;

#if( !defined( TAG_REAL ) )
      real->real_t.header = MAKE_HEADER( REAL_TYPE, REAL_SIZE );
#endif
      real->real_t.real = d;

      return BREAL( real );
   }
}

#else

/*---------------------------------------------------------------------*/
/*    make_pair ...                                                    */
/*---------------------------------------------------------------------*/
GC_API
obj_t
make_pair( obj_t car, obj_t cdr ) {
   obj_t pair;

#if( defined( GC_THREADS ) && defined( THREAD_LOCAL_ALLOC ) )
   pair = GC_THREAD_MALLOC( PAIR_SIZE );
#else      
   pair = GC_MALLOC( PAIR_SIZE );
#endif      
#if( !defined( TAG_PAIR ) )
   pair->pair_t.header = MAKE_HEADER( PAIR_TYPE, PAIR_SIZE );
#endif
   pair->pair_t.car = car;
   pair->pair_t.cdr = cdr;
   
   return BPAIR( pair );
}

/*---------------------------------------------------------------------*/
/*    make_cell ...                                                    */
/*---------------------------------------------------------------------*/
GC_API
obj_t
make_cell( obj_t val ) {
   obj_t cell;

#if( defined( GC_THREADS ) && defined( THREAD_LOCAL_ALLOC ) )
   cell = GC_THREAD_MALLOC( CELL_SIZE );
#else      
   cell = GC_MALLOC( CELL_SIZE );
#endif      
#if( !defined( TAG_CELL ) )
   cell->cell_t.header = MAKE_HEADER( CELL_TYPE, CELL_SIZE );
#endif
   cell->cell_t.val = val;
   
   return BCELL( cell );
}

/*---------------------------------------------------------------------*/
/*    make_real ...                                                    */
/*---------------------------------------------------------------------*/
GC_API
obj_t
make_real( double real ) {
   obj_t a_real;

#if( defined( GC_THREADS ) && defined( THREAD_LOCAL_ALLOC ) )
   a_real = GC_THREAD_MALLOC_ATOMIC( REAL_SIZE );
#else
   a_real = GC_MALLOC_ATOMIC( REAL_SIZE );
#endif
   
#if( !defined( TAG_REAL ) )
   a_real->real_t.header = MAKE_HEADER( REAL_TYPE, REAL_SIZE );
#endif
   a_real->real_t.real = real;
	
   return BREAL( a_real );
}
#endif
