;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Engine/link.scm             */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Jan 15 11:16:02 1994                          */
;*    Last change :  Wed Jan 10 13:30:11 2001 (serrano)                */
;*    Copyright   :  1994-2001 Manuel Serrano, see LICENSE file        */
;*    -------------------------------------------------------------    */
;*    On link quand l'utilisateur n'a passe que des `.o'               */
;*    -------------------------------------------------------------    */
;*    Pour ce faire on essaye de trouver des `.scm' correspondants.    */
;*    On genere un petit fichier `.scm' qui les initialise puis on     */
;*    le compile normalement ou alors, on se contente d'invoquer le    */
;*    linker `*ld*'.                                                   */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module engine_link
   (export (link)
	   (unprof-src-name name)
	   (find-src-file prefix bname))
   (import cc_ld
	   read_reader
	   engine_compiler
	   engine_param
	   bdb_setting
	   init_setrc
	   module_alibrary
	   tools_error
	   jvm_ld
	   read_jvm
	   module_module))

;*---------------------------------------------------------------------*/
;*    *tmp-main-file-name* ...                                         */
;*---------------------------------------------------------------------*/
(define *tmp-main-file-name* "<unknown-yet>")
(define *link-module* #unspecified)
(define *link-package* #unspecified)

;*---------------------------------------------------------------------*/
;*    setup-tmp-main-file-name! ...                                    */
;*---------------------------------------------------------------------*/
(define (setup-tmp-main-file-name!)
   (define (jvm-setup-tmp-file-name!)
      (let ((pref "JVMMAIN"))
	 (set! *link-package* pref)
	 (set! *link-module* (string->symbol *link-package*))
	 (set! *tmp-main-file-name* (string-append pref ".bgl"))
	 (if (file-exists? *tmp-main-file-name*)
	     (error "link"
		    "Can't write tmp file (because it already exists)"
		    *tmp-main-file-name*))))
   (define (c-setup-tmp-file-name!)
      (set! *tmp-main-file-name*
	    (make-file-name *bigloo-tmp*
			    (string-append "main-tmp"
					   "@"
					   (let ((user (getenv "USER")))
					      (if (not (string? user))
						  ""
						  user))
					   "."
					   (car *src-suffix*))))
      (set! *link-module* (gensym 'module))
      (set! *link-package* (symbol->string *link-module*)))
   (if (eq? *target-language* 'jvm)
       (jvm-setup-tmp-file-name!)
       (c-setup-tmp-file-name!)))
			      
;*---------------------------------------------------------------------*/
;*    link ...                                                         */
;*---------------------------------------------------------------------*/
(define (link)
   ;; prepare the temporary filename
   (setup-tmp-main-file-name!)
   ;; we set bdb options
   (if (>fx *bdb-debug* 0)
       (bdb-setting!))
   ;; we start by looking for the source files
   (let loop ((o-files   *o-files*)
	      (scm-files '()))
      (if (null? o-files)
	  ;; and with launch the linking process
	  (link-with scm-files)
	  (let* ((pref     (unprof-src-name (prefix (car o-files))))
		 (bpref    (basename pref))
		 (scm-file (find-src-file pref bpref)))
	     (if (string? scm-file)
		 (loop (cdr o-files) (cons scm-file scm-files))
		 (begin
		    (if (and (number? *warning*) (>=fx *warning* 2))
			(warning  "link"
				  "No Bigloo module found for -- "
				  (car o-files)))
		    (loop (cdr o-files) scm-files)))))))

;*---------------------------------------------------------------------*/
;*    unprof-src-name ...                                              */
;*---------------------------------------------------------------------*/
(define (unprof-src-name name)
   (if (not *profile-mode*)
       name
       (let ((len (string-length name)))
	  (if (and (>fx len 2)
		   (char=? (string-ref name (-fx len 1)) #\p)
		   (char=? (string-ref name (-fx len 2)) #\_))
	      (substring name 0 (-fx len 2))
	      name))))

;*---------------------------------------------------------------------*/
;*    find-file-for-link ...                                           */
;*---------------------------------------------------------------------*/
(define (find-file-for-link file)
   (if (file-exists? file)
       file
       (find-file/path file *load-path*)))

;*---------------------------------------------------------------------*/
;*    find-src-file ...                                                */
;*---------------------------------------------------------------------*/
(define (find-src-file prefix bname)
   (let loop ((suffix *src-suffix*))
      (if (null? suffix)
	  #f
	  (let* ((suf (car suffix))
		 (f   (find-file-for-link (string-append prefix "." suf))))
	     (if (string? f)
		 f
		 (let ((f (find-file-for-link (string-append bname "." suf))))
		    (if (string? f)
			f
			(loop (cdr suffix)))))))))

;*---------------------------------------------------------------------*/
;*    link-with ...                                                    */
;*---------------------------------------------------------------------*/
(define (link-with scm-files)
   (define (do-link first)
      (case *target-language*
	 ((c)
	  (set! *o-files* (cdr *o-files*))
	  (ld first #f))
	 ((jvm)
	  (jvm-ld))
	 (else
	  (error "linker"
		 "Unimplemented target language"
		 *target-language*))))
   (if (null? scm-files)
       (let ((first (prefix (car *o-files*))))
	  (warning "link" "No source file found" " -- " *o-files*)
	  ;; we load the library init files.
	  (load-library-init)
	  (do-link first))
       ;; on construit la clause du module
       (let loop ((scm-files scm-files)
		  (cls       '())
		  (main      #f)
		  (fmain     "")
		  (libraries '()))
	  (if (null? scm-files)
	      (if main
		  ;; ce n'est pas la peine de generer un main, il y en a
		  ;; deja un
		  (let ((first (prefix (car *o-files*))))
		     ;; if libraries are used by some module we add them
		     ;; to the link
		     (for-each (lambda (lib)
				  (use-library! (make-library-name lib) 'now))
			       libraries)
		     ;; we load the library init files.
		     (load-library-init)
		     (set! *src-files* (list fmain))
		     (do-link first))
		  ;; on genere un main puis on link.
		  (begin
		     (make-tmp-main cls main libraries)
		     (set! *src-files* (list *tmp-main-file-name*))
		     ;; we have to remove extra mco files before compiler
		     ;; otherwise the compiler will warn about that files.
		     (let loop ((ra  *rest-args*)
				(res '()))
			(cond
			   ((null? ra)
			    (set! *rest-args* (reverse! res)))
			   ((member (suffix (car ra)) *mco-suffix*)
			    (loop (cdr ra) res))
			   (else
			    (loop (cdr ra) (cons (car ra) res)))))
		     (unwind-protect
			(compiler)
			;; we load the library init files.
			(load-library-init)
			(let* ((scm-file *tmp-main-file-name*)
			       (pre        (prefix scm-file))
			       (c-file     (string-append pre ".c"))
			       (o-file     (string-append pre ".o"))
			       (class-file (string-append pre ".class")))
			   (if (eq? *target-language* 'jvm)
			       (if (file-exists? scm-file)
				   (delete-file scm-file))
			       (for-each (lambda (f)
					    (if (file-exists? f)
						(delete-file f)))
					 (list scm-file
					       c-file
					       o-file
					       class-file)))))
		     0))
	      (let ((port (open-input-file (car scm-files))))
		 (if (not (input-port? port))
		     (error "" "Illegal file" (car scm-files))
		     (let ((exp (compiler-read port)))
			(close-input-port port)
			(match-case exp
			   ((module ?name ??- (main ?new-main) . ?-)
			    (if main
				(error ""
				       (string-append
					"Redeclaration of the main (files "
					fmain
					" and "
					(car scm-files) ")")
				       (cons main new-main)))
			    (loop (cdr scm-files)
				  (cons (list name
					      (string-append
					       "\""
					       (car scm-files)
					       "\""))
					cls)
				  new-main
				  (car scm-files)
				  (append (find-libraries (cddr exp))
					  libraries)))
			   ((module ?name . ?-)
			    (loop (cdr scm-files)
				  (cons (list name
					      (string-append
					       "\""
					       (car scm-files)
					       "\""))
					cls)
				  main
				  fmain
				  (append (find-libraries (cddr exp))
					  libraries)))
			   (else
			    ;; ah, ce n'etait pas un fichier bigloo,
			    ;; on saute (en meprisant :-)
			    (loop (cdr scm-files)
				  cls
				  main
				  fmain
				  libraries))))))))))

;*---------------------------------------------------------------------*/
;*    find-libraries ...                                               */
;*---------------------------------------------------------------------*/
(define (find-libraries clauses)
   (let loop ((clauses   clauses)
	      (libraries '()))
      (match-case clauses
	 (()
	  (reverse! libraries))
	 (((library . ?libs) . ?rest)
	  (loop rest (append libs libraries)))
	 (else
	  (loop (cdr clauses) libraries)))))

;*---------------------------------------------------------------------*/
;*    make-tmp-main ...                                                */
;*---------------------------------------------------------------------*/
(define (make-tmp-main clauses main libraries)
   (let ((pout (open-output-file *tmp-main-file-name*))
	 (generate-main? (and (eq? *target-language* 'jvm) (not main))))
      (if (not (output-port? pout))
	  (error ""
		 "Can't open output file"
		 *tmp-main-file-name*)
	  (begin
	     (fprint pout ";; " *bigloo-name*)
	     (fprint pout ";; !!! generated file, don't edit !!!")
	     (fprint pout ";; ==================================")
	     (newline pout)
	     (let* ((libs   (if (and #f (>fx *bdb-debug* 0))
				(cons 'bdb libraries)
				libraries))
		    (module `(module ,*link-module*
				(import ,@(reverse clauses))
				,@(if generate-main?
				      '((main main))
				      '())
				,@(if (pair? libs)
				      `((library ,@libs))
				      '()))))
		(fprint pout module)
		(newline pout))
	     (if generate-main?
		 (fprint pout '(define (main argv) #unspecified)))
	     (if main
		 (begin
		    (fprint pout "(main *the-command-line*)")
		    (newline pout)))
	     (set! *module* *link-module*)
	     (close-output-port pout)))))
	  
	  

