#!/bin/sh
# -*- mode: sh; coding: utf-8 -*-
# test .orig file support in baz
# Copyright © 2003 Colin Walters <walters@verbum.org>
# Copyright © 2005 Canonical Limited
#	Authors: Robert Collins <robert.collins@canonical.com>
#
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.

set -e

arg0="$0"
srcdir=`dirname "$arg0"`

. ${srcdir}/test-framework

setup_with_trivial_archives

setup () {
  :
}  

cleanup () {
  cd ${WORKDIR}
}

test_class "do .orig files work as expected"

begin_test_savectx ".orig files in inventory are moved before applying changesets"
setup
tla get jane@example.com--2003/hello-world--mainline--1.0 orig
cd orig
echo -e "foo\nfan" > foo
tla add foo
tla commit -s 'add foo'
echo -e "foo\nbar" > foo
tla undo 
echo -e "salmon\nhater" > foo
tla undo
echo "gam" > foo
tla redo && test_fail "no conflict occurred"
test -f "foo.orig" || test_fail "no .orig file was created"
tla resolved --all
tla redo && test_fail "no conflict occurred on second redo"
test -f "foo.orig" || test_fail "no .orig file exists after second conflict"
test -f "foo.orig.bak" && test_fail "foo.orig.bak was created after second conflict"
tla resolved --all
rm foo.orig
rm foo.rej
rm -rf ./+remove*
cleanup
end_test_savectx

begin_test_savectx "foo.orig can be added"
setup
cd orig
echo "yippee" > foo.orig
echo "source foo\.orig" > .arch-inventory
tla add foo.orig
tla add .arch-inventory
tla commit -s 'add foo.orig'
cleanup
end_test_savectx

begin_test_savectx "foo.orig can be built-by-patching"
setup
tla get jane@example.com--2003/hello-world--mainline--1.0--patch-1 orig-p2
cd orig-p2
tla replay
file_matches 'yippee' foo.orig
tla status
cleanup
end_test_savectx 

begin_test_savectx "conflicts on patches to foo create foo,.orig and foo,.rej when foo.orig is in the inventory"
setup
cd orig
tla undo -n
tla status
echo "gargle" > foo
tla undo
echo "frazzle" > foo
tla redo && test_fail "no conflict occured"
test -f "foo,.orig" || test_fail "foo,.orig was not created"
#FIXME this should be foo,.rej 
test -f "foo.rej" || test_fail "foo,.rej was not created"
file_matches 'yippee' foo.orig || "foo.orig had its content overwritten"
cleanup
end_test_savectx

clean_workdir
