/* partable.c: utilities for scanning the in-core partition table
 *
 * Copyright (C) 1995-97 Roman Hodek <Roman.Hodek@informatik.uni-erlangen.de>
 *               1996-97 Michael Schlueter <schlue00@marvin.informatik.uni-dortmund.de>
 *
 * This program is free software.  You can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation: either version 2 or
 * (at your option) any later version.
 *
 */

#ifndef _partable_h
#define _partable_h

/* $Id: partable.h,v 1.4 1997/07/08 18:59:05 rnhodek Exp $
 *
 * $Log: partable.h,v $
 * Revision 1.4  1997/07/08 18:59:05  rnhodek
 * Ouch, too many changes without commits in between...
 * Implemented moving of partitions
 * Implemented checking of "extended start condition" (great changes in
 *   new_partition())
 * Some more tests in verify()
 *
 * Revision 1.3  1997/06/21 20:47:48  rnhodek
 * Added RCS keywords
 *
 * Revision 1.2  1997/06/13 12:51:23  rnhodek
 * Bug fixes and improvements to new_partition; little fixes in verify
 * 
 * Revision 1.1  1997/06/11 14:36:36  rnhodek
 * Initial revision
 * 
 * Revision 1.1.1.1  1997/06/11 14:36:36  rnhodek
 * Started using CVS for atafdisk
 *
 */

#include "fdisk.h"

enum check_ext_cond_code {
	NONE, ADD, DEL, CHANGE
};

/***************************** Prototypes *****************************/

int inside_part( PARTITION *p, unsigned long sec );
int n_primary( void );
int XGM_slot( void );
void XGM_boundary( unsigned long *start, unsigned long *size );
void table_infos( int *n_prim, int *n_ext, int *first_ext, int *last_ext );
int canonical_number( unsigned long start );
int primary_possible( int new_num, int n_prim, int n_ext, int first_ext,
                      int last_ext, char **why );
int extended_possible( int new_num, int n_prim, int n_ext, int first_ext,
                       int last_ext, unsigned long start, char **why );
unsigned long lowest_ars( void );
int check_ext_start_condition( enum check_ext_cond_code code, int part,
                               unsigned long rootsec );
int free_sectors_at( unsigned long sec );
int free_sectors_before( unsigned long sec );
int allocated_sectors_at( unsigned long sec );
int allocated_sectors_before( unsigned long sec );

/************************* End of Prototypes **************************/

#endif  /* _partable_h */
