------------------------------------------------------------------------------
--                                                                          --
--                            GNATPP COMPONENTS                             --
--                                                                          --
--                        G N A T P P . C O M M O N                         --
--                                                                          --
--                                 B o d y
--                                                                          --
--                    Copyright (C) 2001-2006, AdaCore                      --
--                                                                          --
-- GNATPP is free software; you can redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNATPP is  distributed in the  hope that it will  be  useful, but --
-- WITHOUT ANY WARRANTY; without even the implied warranty of  MERCHANTABI- --
-- LITY or  FITNESS  FOR A  PARTICULAR  PURPOSE. See the GNU General Public --
-- License  for more details. You  should  have  received a copy of the GNU --
-- General Public License  distributed with GNAT; see file COPYING. If not, --
-- write to the Free Software Foundation,  51 Franklin Street, Fifth Floor, --
-- Boston, MA 02110-1301, USA.                                              --
--                                                                          --
-- GNATPP is maintained by AdaCore (http://www.adacore.com).                --
--                                                                          --
------------------------------------------------------------------------------

with Ada.Strings.Fixed; use Ada.Strings.Fixed;

with ASIS_UL.Common;

package body GNATPP.Common is

   -----------
   -- Image --
   -----------

   function Image (Val : Natural) return String is
   begin
      return Trim (Integer'Image (Val), Ada.Strings.Left);
   end Image;

   ---------------------------------------
   -- Non_Implemented_ASIS_2005_Feature --
   ---------------------------------------

   procedure Non_Implemented_ASIS_2005_Feature
     (Element :        Asis.Element;
      Control : in out Traverse_Control;
      State   : in out Source_Traversal_State)
   is
   begin
      raise ASIS_UL.Common.Fatal_Error;
   end Non_Implemented_ASIS_2005_Feature;

   -------------------
   -- Nothing_To_Do --
   -------------------

   procedure Nothing_To_Do
     (Element :        Asis.Element;
      Control : in out Traverse_Control;
      State   : in out Source_Traversal_State)
   is
   begin
      pragma Unreferenced (Element);
      pragma Unreferenced (Control);
      pragma Unreferenced (State);
      null;
   end Nothing_To_Do;

end GNATPP.Common;
