/*
   ArrayUtil, program to check and configure a SmartArray controller
   Copyright (C) 1999  Hugo Trippaers

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
   $Header: /home/cvs/cvsroot/array-util/interface.c,v 1.4 2001/08/30 12:27:54 spark Exp $
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "menubar.h"

GtkWidget*
create_mainwindow (void)
{
  GtkWidget *mainwindow;
  GtkWidget *vbox1;
  GtkWidget *menubar;
  GtkWidget *hbox1;
  GtkWidget *cntrltree;
  GtkWidget *scrolledwindow2;
  GtkWidget *infobox;
  GtkWidget *scrolledwindow1;
  GtkWidget *eventlist;
  GtkWidget *status;
  GtkWidget *datetime;
  GtkWidget *description;
  GtkWidget *statusbar;

  mainwindow = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (mainwindow), "mainwindow", mainwindow);
  gtk_window_set_title (GTK_WINDOW (mainwindow), "Array-Util@...");
  gtk_window_set_default_size (GTK_WINDOW (mainwindow), 600, 350);
  gtk_widget_set_usize (mainwindow, 600, 350);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox1);
  gtk_object_set_data_full (GTK_OBJECT (mainwindow), "vbox1", vbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (mainwindow), vbox1);

  get_main_menu (mainwindow, &menubar);
  gtk_widget_ref (menubar);
  gtk_object_set_data_full (GTK_OBJECT (mainwindow), "menubar", menubar,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (menubar);
  gtk_box_pack_start (GTK_BOX (vbox1), menubar, FALSE, FALSE, 0);

  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox1);
  gtk_object_set_data_full (GTK_OBJECT (mainwindow), "hbox1", hbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox1);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox1, TRUE, TRUE, 0);

  cntrltree = gtk_tree_new ();
  gtk_widget_ref (cntrltree);
  gtk_object_set_data_full (GTK_OBJECT (mainwindow), "cntrltree", cntrltree,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (cntrltree);
  gtk_box_pack_start (GTK_BOX (hbox1), cntrltree, TRUE, TRUE, 0);

  scrolledwindow2 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_ref (scrolledwindow2);
  gtk_object_set_data_full (GTK_OBJECT (mainwindow), "scrolledwindow2", scrolledwindow2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (scrolledwindow2);
  gtk_box_pack_start (GTK_BOX (hbox1), scrolledwindow2, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow2), GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);

  infobox = gtk_text_new (NULL, NULL);
  gtk_widget_ref (infobox);
  gtk_object_set_data_full (GTK_OBJECT (mainwindow), "infobox", infobox,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (infobox);
  gtk_container_add (GTK_CONTAINER (scrolledwindow2), infobox);

  scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_ref (scrolledwindow1);
  gtk_object_set_data_full (GTK_OBJECT (mainwindow), "scrolledwindow1", scrolledwindow1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (scrolledwindow1);
  gtk_box_pack_start (GTK_BOX (vbox1), scrolledwindow1, TRUE, TRUE, 0);

  eventlist = gtk_clist_new (3);
  gtk_widget_ref (eventlist);
  gtk_object_set_data_full (GTK_OBJECT (mainwindow), "eventlist", eventlist,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (eventlist);
  gtk_container_add (GTK_CONTAINER (scrolledwindow1), eventlist);
  gtk_clist_set_column_width (GTK_CLIST (eventlist), 0, 30);
  gtk_clist_set_column_resizeable(GTK_CLIST (eventlist), 0, FALSE);
  gtk_clist_set_column_justification(GTK_CLIST (eventlist), 0, GTK_JUSTIFY_CENTER);
  gtk_clist_set_column_width (GTK_CLIST (eventlist), 1, 160);
  gtk_clist_set_column_resizeable(GTK_CLIST (eventlist), 1, FALSE);
  gtk_clist_set_column_justification(GTK_CLIST (eventlist), 1, GTK_JUSTIFY_CENTER);
  gtk_clist_set_column_width (GTK_CLIST (eventlist), 2, 80);
  gtk_clist_column_titles_show (GTK_CLIST (eventlist));

  status = gtk_label_new ("Type");
  gtk_widget_ref (status);
  gtk_object_set_data_full (GTK_OBJECT (mainwindow), "status", status,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (status);
  gtk_clist_set_column_widget (GTK_CLIST (eventlist), 0, status);

  datetime = gtk_label_new ("Date / Time");
  gtk_widget_ref (datetime);
  gtk_object_set_data_full (GTK_OBJECT (mainwindow), "datetime", datetime,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (datetime);
  gtk_clist_set_column_widget (GTK_CLIST (eventlist), 1, datetime);

  description = gtk_label_new ("Description");
  gtk_widget_ref (description);
  gtk_object_set_data_full (GTK_OBJECT (mainwindow), "description", description,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (description);
  gtk_clist_set_column_widget (GTK_CLIST (eventlist), 2, description);

  statusbar = gtk_statusbar_new ();
  gtk_widget_ref (statusbar);
  gtk_object_set_data_full (GTK_OBJECT (mainwindow), "statusbar", statusbar,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (statusbar);
  gtk_box_pack_start (GTK_BOX (vbox1), statusbar, FALSE, FALSE, 0);

  return mainwindow;
}

GtkWidget*
create_about (void)
{
  GtkWidget *about;
  GtkWidget *aboutframe;
  GtkWidget *label1;

  about = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (about), "about", about);
  gtk_window_set_title (GTK_WINDOW (about), "About Array-Util");
  gtk_window_set_default_size (GTK_WINDOW (about), 150, 150);

  aboutframe = gtk_frame_new ("Array-Util");
  gtk_widget_ref (aboutframe);
  gtk_object_set_data_full (GTK_OBJECT (about), "aboutframe", aboutframe,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (aboutframe);
  gtk_container_add (GTK_CONTAINER (about), aboutframe);
  gtk_container_set_border_width (GTK_CONTAINER (aboutframe), 5);
  gtk_window_set_policy (GTK_WINDOW (about), FALSE, FALSE, FALSE);

  label1 = gtk_label_new ("Written by\nHugo Trippaers\n\n(c) Hugo Trippaers\n1999-2001\n\nhtrippaers@energis.nl\nhttp://starbreeze.knoware.nl/~hugo/compaq");
  gtk_widget_ref (label1);
  gtk_object_set_data_full (GTK_OBJECT (about), "label1", label1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label1);
  gtk_container_add (GTK_CONTAINER (aboutframe), label1);
  gtk_misc_set_padding (GTK_MISC (label1), 10, 10);

  return about;
}


void show_about (void)
{
  GtkWidget *about;

  about = create_about();
  gtk_widget_show (about);
}
