/**********************************************************************
 * options.h                                                 March 2001
 * Horms                                             horms@vergenet.net
 *
 * Read in command line options
 * Code based on man getopt(3), later translated to libpopt.
 *
 * aggregate
 * CIDR network aggregation and filtering
 * Copyright (C) 2001  Horms
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307  USA
 *
 **********************************************************************/


#ifndef AGGREGATE_OPT_STIX
#define AGGREGATE_OPT_STIX

#include "cidr_net.h"

#define DEFAULT_MAXIMUM_PREFIX (prefix_t) -1
#define DEFAULT_MINIMUM_PREFIX (prefix_t) -1
#define DEFAULT_INPUT_FORMAT   CIDR_NET_PREFIX
#define DEFAULT_OUTPUT_FORMAT  CIDR_NET_PREFIX

typedef struct {
  prefix_t             maximum_prefix;
  prefix_t             minimum_prefix;
  int                  output_format;
  int                  input_format;
} options_t;


/**********************************************************************
 * options
 * Read in command line options
 * pre: argc: number or elements in argv
 *      argv: array of strings with command line-options
 *      flag: see options.h for flag values
 *            ignores errors otherwise
 * post: global opt is seeded with values according to argc and argv
 **********************************************************************/

int options(int argc, char **argv);


/**********************************************************************
 * usage
 * Display usage information
 * Printed to stdout if exit_status=0, stderr otherwise
 **********************************************************************/

void usage(int exit_status);

#endif
