
#ifndef	__UTILITIES_H
#define	__UTILITIES_H __UTILITIES_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <x_types.h>

#define	NO_ERROR	0

#define RET_ON_ERROR(function) \
	{	Int32 errfl; \
		errfl = (Int32)(function); \
		if(errfl != NO_ERROR) \
			return(errfl); \
	}

#define	ISSPACE(chr)	((chr) == '\0' || isspace(chr))
#define ishnchr(c)	(isalnum(c) || (c) == '-')
#define	isfqhnchr(c)	(ishnchr(c) || (c) == '.')

#define	NEWP(type, num)		(type *) malloc((num) * sizeof(type))
#define	RENEWP(old, type, num)	(type *) realloc(old, (num) * sizeof(type))
#define	SNEWP(type, num)	(type *) seg_malloc((num) * sizeof(type))
#define	SRENEWP(old, type, num, onum)	(type *) seg_realloc(old,	\
						sizeof(type) * (num),	\
						sizeof(type) * (onum))

#define	ZRENEWP(old, type, num)	\
		((old) ? RENEWP(old, type, num) : NEWP(type, num))
#define	ZSRENEWP(old, type, num)	\
		((old) ? SRENEWP(old, type, num) : SNEWP(type, num))
#define	ZFREE(ptr)	{ if(ptr) { free(ptr); ptr = NULL; } }

#define	forever	for(;;)
#define	SETZERO(var)	memset(&(var), 0, sizeof(var))
#define	COPYVAL(dest, src)	memcpy(&(dest), &(src), sizeof(src))

#ifdef	__cplusplus
extern	"C" {
#endif

extern	void *	MALLOC_SAFE(Int32);
extern	void *	REALLOC_SAFE(void  *, Int32);
extern	UChar *	STRDUP_SAFE(UChar *);
extern	Int32	FSEEK_SAFE(FILE *, Int32, Int32);
extern	FILE *	FOPEN_SAFE(UChar *, UChar *);
extern	UChar *	strapp(UChar *, UChar *);
extern	UChar *	strchain(UChar *, ...);
#ifndef	HAVE_STRRSTR
extern	UChar *	strrstr(UChar *, UChar *);
#endif
#ifndef	HAVE_STRCASESTR
extern	UChar *	strcasestr(UChar *, UChar *);
#endif
extern	UChar *	strword(UChar *, Int32);
extern	Int32	str2words(UChar ***, UChar *);
extern	Int32	str2wordsq(UChar ***, UChar *);
extern	Int32	cmd2argv(char ***, char *);
extern	Int32	cmd2argvq(char ***, char *);
extern	Int32	cmd2argvf(char ***, char *);
extern	Int32	cmd2argvqf(char ***, char *);
extern	void	repl_esc_seq(UChar *, UChar);
extern	UChar * mk_esc_seq(UChar *, UChar, UChar *);
extern	UChar *	repl_substring(UChar *, UChar *, UChar *);
extern	Int32	existfile(UChar *);
extern	Int32	memswap(void *, void *, Int32);
extern	UChar *	memfind(UChar *, Int32, UChar *, Int32);
extern	Int32	memrepl(UChar *, Int32,
				UChar *, Int32, UChar *, Int32);
extern	void *	mem_move(void *, void *, size_t);
extern	void *	mem_move2(void *, void *, size_t);
extern	void *	mem_move3(void *, void *, size_t);
extern	void *	mem_move4(void *, void *, size_t);
extern	Int32	fscanword(FILE *, UChar *);
extern	Int32	fscanwordq(FILE *, UChar *);
extern	UChar *	sscanword(UChar *, UChar *);
extern	UChar *	sscanwordq(UChar *, UChar *);
extern	Int32	fprintwordq(FILE *, UChar *);
extern	Int32	ffindword(FILE *, UChar *);
extern	Int32	ffindwordb(FILE *, UChar *);
extern	Int32	ishn(UChar *);
extern	Int32	isfqhn(UChar *);
extern	Int32	minmax(Real64 *, Int32, Real64 *, Real64 *);
extern	Int32	ffindchr(FILE *, UChar);
extern	Int32	getinchr(UChar *, Uns32);
extern 	Int32	word_count(UChar *);
extern	Int32	empty_string(UChar *);
extern	UChar *	first_space(UChar *);
extern	UChar *	first_nospace(UChar *);
extern	UChar *	sscancstr(UChar *, UChar *);
extern	void	sscancchars(UChar *, UChar *);
extern	void	massage_string(UChar *);
extern	UChar **read_asc_file(UChar *, Int32 *);
extern	void	free_asc_file(UChar **, Int32);
extern	void	q_sort(void *, Uns32, Uns32, Int32 (*)(void *, void *));
extern	void	*b_search(void *, void *, Uns32, Uns32,
					Int32 (*)(void *, void *));
extern	void	*ba_search(void *, void *, Uns32, Uns32,
					Int32 (*)(void *, void *));
extern	void	*l_search(void *, void *, Uns32 *, Uns32,
					Int32 (*)(void *, void *));
extern	void	*l_find(void *, void *, Uns32 *, Uns32,
					Int32 (*)(void *, void *));
extern	void	*seg_malloc(Int32);
extern	void	*seg_realloc(void *, Int32, Int32);
extern	Int32	__internal_sm_import(void ***, Int8 **, Int32 *,
					Int8, void *);
extern	void	*__internal_sm_malloc(void ***, Int8 **, Int32 *,
					Int8, size_t);
extern	void	*__internal_sm_realloc(void ***, Int8 **, Int32 *,
					void *, Int8, size_t);
extern	void	__internal_sm_freeall(void **, Int8 *, Int32, Int8);
extern	void	__internal_sm_free(void **, Int8 *, Int32 *, void *);
extern	UChar	*__internal_sm_strdup(void ***, Int8 **, Int32 *,
					Int8, UChar *);
extern	UChar	*__internal_sm_strapp(void ***, Int8 **, Int32 *,
					Int8, UChar *, UChar *);
extern	UChar	*__internal_sm_strchain(void ***, Int8 **, Int32 *,
					Int8, ...);
extern	UChar	*fget_alloc_str(FILE *);
extern	Int32	find_zero(Real64 (*)(Real64), Real64, Real64, Real64,
					Real64, Real64 *);
extern	Real64	num_integ(Real64 (*)(Real64), Real64, Real64, Real64);
extern	Real64	Real64_precision();

extern	Real64	drandom();

extern	void	ms_sleep(Int32);

extern	Int32	goptions(Int32, UChar **, UChar *, ...);

extern	double	r_int(double);
extern	int	is_nan(float);

extern	int	fd_system_fork(char *, int *);
extern	int	fp_system_fork(char *, FILE **);

extern	int	detach_from_tty();

#ifdef	__cplusplus
}
#endif

#ifndef	HAVE_MEMMOVE
#define	HAVE_MEMMOVE	1
#define	memmove	mem_move
#endif
#ifndef	HAVE_QSORT
#define	HAVE_QSORT	1
#define	qsort	q_sort
#endif
#ifndef	HAVE_BSEARCH
#define	HAVE_BSEARCH	1
#define	bsearch	b_search
#endif
#ifndef	HAVE_LSEARCH
#define	HAVE_LSEARCH	1
#define	lsearch	l_search
#endif
#ifndef	HAVE_LFIND
#define	lfind	l_find
#define	HAVE_LFIND	1
#endif
#if	!defined(HAVE_ISNAN) && !defined(isnan)
#define	HAVE_ISNAN	1
#define	isnan	is_nan
#endif
#ifndef	HAVE_RINT
#define	HAVE_RINT	1
#define	rint	r_int
#endif

#define	sm_list	void ** __local_memlist = NULL; 		\
				Int8 * __local_smflags = NULL;	\
				Int32 __num_memptrs = 0
#define	sm_import(ptr)	__internal_sm_import(& __local_memlist,		\
		& __local_smflags, & __num_memptrs, 0, ptr)
#define	sm_import_tmp(ptr)	__internal_sm_import(& __local_memlist,	\
		& __local_smflags, & __num_memptrs, 1, ptr)
#define	sm_malloc(size)	__internal_sm_malloc(& __local_memlist,		\
		& __local_smflags, & __num_memptrs, 0, (size))
#define	sm_malloc_tmp(size)	__internal_sm_malloc(& __local_memlist,	\
		& __local_smflags, & __num_memptrs, 1, (size))
#define	sm_realloc(ptr, size)	__internal_sm_realloc(			\
		& __local_memlist,& __local_smflags, & __num_memptrs, 	\
		(ptr), 0, (size))
#define	sm_realloc_tmp(ptr, size)	__internal_sm_realloc(	\
		& __local_memlist, & __local_smflags, & __num_memptrs, 	\
		(ptr), 1, (size))
#define	sm_return(arg)	{ __internal_sm_freeall(__local_memlist,	\
		__local_smflags, __num_memptrs, 1); return(arg); }
#define	sm_return_err(arg)	{ __internal_sm_freeall(__local_memlist, \
		__local_smflags, __num_memptrs, 0); return(arg); }
#define	sm_return_void	{ __internal_sm_freeall(__local_memlist,	\
		__local_smflags, __num_memptrs, 1); return; }
#define	sm_return_err_void	{ __internal_sm_freeall(__local_memlist, \
		__local_smflags, __num_memptrs, 0); return; }
#define	sm_free(ptr)	__internal_sm_free(__local_memlist,	\
		__local_smflags, & __num_memptrs, ptr)
#define	sm_strdup(str)	__internal_sm_strdup(& __local_memlist,		\
		& __local_smflags, & __num_memptrs, 0, (str))
#define	sm_strdup_tmp(str)	__internal_sm_strdup(& __local_memlist,	\
		& __local_smflags, & __num_memptrs, 1, (str))
#define	sm_strapp(s1, s2)	__internal_sm_strapp(& __local_memlist,	\
		& __local_smflags, & __num_memptrs, 0, (s1), (s2))
#define	sm_strapp_tmp(s1, s2)	__internal_sm_strapp(& __local_memlist,	\
		& __local_smflags, & __num_memptrs, 1, (s1), (s2))

#define	NEWSP(type, num)	(type *) sm_malloc((num) * sizeof(type))
#define	NEWSTP(type, num)	(type *) sm_malloc_tmp((num) * sizeof(type))
#define	RENEWSP(old, type, num)	(type *) sm_realloc(old, (num) * sizeof(type))
#define	RENEWSTP(old, type, num)	(type *)		\
				sm_realloc_tmp(old, (num) * sizeof(type))
#define	ZRENEWSP(old, type, num)	\
		((old) ? RENEWSP(old, type, num) : NEWSP(type, num))
#define	ZRENEWSTP(old, type, num)	\
		((old) ? RENEWSTP(old, type, num) : NEWSTP(type, num))

#define	free_string_array	free_asc_file

#ifndef	bzero
#define	bzero(mem, size)	memset((mem), 0, (size))
#endif
#ifndef	bcopy
#define	bcopy(mem1, mem2, size)	memcpy((mem2), (mem1), (size))
#endif
#ifndef	bcmp
#define	bcmp(mem1, mem2, size)	memcmp((mem1), (mem2), (size))
#endif
#define	bswap(mem1, mem2, size)	memswap((mem1), (mem2), (size))

#define	UnsN_to_xref(p, v, n)	{ Uns32 va_; UChar *buf_;	\
				buf_ = (p) + ((n - 1) >> 3);	\
				va_ = (v); while(buf_ >= (p)){		\
				*(buf_--) = (va_ & 0xff); va_ >>= 8;}}
#define	xref_to_UnsN(v, p, n)	{ UChar *endb_, *buf_; buf_ = (p);	\
				endb_ = buf_ + ((n - 1) >> 3) + 1;	\
				*(v) = 0; while(buf_ < endb_)	\
				*(v) = (*(v) << 8) | *(buf_++); }
#define	Uns32_to_xref(p, v)	UnsN_to_xref(p, v, 32)
#define	xref_to_Uns32(v, p)	xref_to_UnsN(v, p, 32)

#endif	/* !__UTILITIES_H */

/************ end of $RCSfile$ ******************/
