<?php
/*******************************************************************************
** Basic Analysis and Security Engine (BASE)
** Copyright (C) 2004 BASE Project Team
** Copyright (C) 2000 Carnegie Mellon University
**
** (see the file 'base_main.php' for license details)
**
** Project Leads: Kevin Johnson <kjohnson@secureideas.net>
**                Sean Muller <samwise_diver@users.sourceforge.net>
** Built upon work by Roman Danyliw <rdd@cert.org>, <roman@danyliw.com>
**
** Purpose: Turkish language file
**      To translate into another language, copy this file and
**          translate each variable into your chosen language.
**          Leave any variable not translated so that the system will have
**          something to display.
********************************************************************************
** Authors:
********************************************************************************
** Kevin Johnson <kjohnson@secureideas.net>
** Joel Esler <joelesler@users.sourceforge.net>
********************************************************************************
*/

//locale
DEFINE('_LOCALESTR1', 'tur_TUR.ISO8859-9');
DEFINE('_LOCALESTR2', 'tur_TUR.utf-8');
DEFINE('_LOCALESTR3', 'turkish');
DEFINE('_STRFTIMEFORMAT','%a %B %d, %Y %H:%M:%S'); //see strftime() sintax

//common phrases
DEFINE('_CHARSET','iso-8859-9');
DEFINE('_TITLE','Basic Analysis and Security Engine (BASE) '.$BASE_installID);
DEFINE('_FRMLOGIN','Oturum A:');
DEFINE('_FRMPWD','Parola:');
DEFINE('_SOURCE','Kaynak');
DEFINE('_SOURCENAME','Kaynak Ad');
DEFINE('_DEST','Var');
DEFINE('_DESTNAME','Var Ad');
DEFINE('_SORD','Kaynak veya Var');
DEFINE('_EDIT','Dzenle');
DEFINE('_DELETE','Sil');
DEFINE('_ID','ID');
DEFINE('_NAME','Ad');
DEFINE('_INTERFACE','Arabirim');
DEFINE('_FILTER','Szge');
DEFINE('_DESC','Betimleme');
DEFINE('_LOGIN','Oturum A');
DEFINE('_ROLEID','Rol ID');
DEFINE('_ENABLED','Seilir Klnm');
DEFINE('_SUCCESS','Baarl');
DEFINE('_SENSOR','Alglayc');
DEFINE('_SENSORS','Alglayclar');
DEFINE('_SIGNATURE','mza');
DEFINE('_TIMESTAMP','Zaman Damgas');
DEFINE('_NBSOURCEADDR','Kaynak Adresi');
DEFINE('_NBDESTADDR','Var Adresi');
DEFINE('_NBLAYER4','4. Katman Protokol');
DEFINE('_PRIORITY','ncelik');
DEFINE('_EVENTTYPE','olay tr');
DEFINE('_JANUARY','Ocak');
DEFINE('_FEBRUARY','ubat');
DEFINE('_MARCH','Mart');
DEFINE('_APRIL','Nisan');
DEFINE('_MAY','Mays');
DEFINE('_JUNE','Haziran');
DEFINE('_JULY','Temmuz');
DEFINE('_AUGUST','Austos');
DEFINE('_SEPTEMBER','Eyll');
DEFINE('_OCTOBER','Ekim');
DEFINE('_NOVEMBER','Kasm');
DEFINE('_DECEMBER','Aralk');
DEFINE('_LAST','Son');
DEFINE('_FIRST','lk');
DEFINE('_TOTAL','Toplam');
DEFINE('_ALERT','Uyar');
DEFINE('_ADDRESS','Adres');
DEFINE('_UNKNOWN','bilinmeyen');
DEFINE('_AND','VE');
DEFINE('_OR','YA DA');
DEFINE('_IS','is');
DEFINE('_ON','zerinde');
DEFINE('_IN','iinde');
DEFINE('_ANY','herhangibir');
DEFINE('_NONE','hibiri');
DEFINE('_HOUR','Saat');
DEFINE('_DAY','Gn');
DEFINE('_MONTH','Ay');
DEFINE('_YEAR','Yl');
DEFINE('_ALERTGROUP','Uyar Grubu');
DEFINE('_ALERTTIME','Uyar Zaman');
DEFINE('_CONTAINS','kapsar');
DEFINE('_DOESNTCONTAIN','kapsamaz');
DEFINE('_SOURCEPORT','kaynak portu');
DEFINE('_DESTPORT','var portu');
DEFINE('_HAS','sahip');
DEFINE('_HASNOT','sahip deil');
DEFINE('_PORT','Port');
DEFINE('_FLAGS','Bayraklar');
DEFINE('_MISC','Misc');
DEFINE('_BACK','Geri');
DEFINE('_DISPYEAR','{ yl }');
DEFINE('_DISPMONTH','{ ay }');
DEFINE('_DISPHOUR','{ saat }');
DEFINE('_DISPDAY','{ gn }');
DEFINE('_DISPTIME','{ zaman }');
DEFINE('_ADDADDRESS','Adres EKLE');
DEFINE('_ADDIPFIELD','IP Alan EKLE');
DEFINE('_ADDTIME','ZAMAN EKLE');
DEFINE('_ADDTCPPORT','TCP Portu EKLE');
DEFINE('_ADDTCPFIELD','TCP Alan EKLE');
DEFINE('_ADDUDPPORT','UDP Portu EKLE');
DEFINE('_ADDUDPFIELD','UDP Alan EKLE');
DEFINE('_ADDICMPFIELD','ICMP Alan EKLE');
DEFINE('_ADDPAYLOAD','Payload EKLE');
DEFINE('_MOSTFREQALERTS','En Sk Uyarlar');
DEFINE('_MOSTFREQPORTS','En Sk Portlar');
DEFINE('_MOSTFREQADDRS','En Sk IP adresleri');
DEFINE('_LASTALERTS','Son Uyarlar');
DEFINE('_LASTPORTS','Son Portlar');
DEFINE('_LASTTCP','Son TCP Uyarlar');
DEFINE('_LASTUDP','Son UDP Uyarlar');
DEFINE('_LASTICMP','Son ICMP Uyarlar');
DEFINE('_QUERYDB','Sorgu DB');
DEFINE('_QUERYDBP','Sorgu+DB'); //_QUERYDB 'ye eit, boluklar '+' lardr. 
                                //Bunun gibi bir ey olmas gerekli: DEFINE('_QUERYDBP',str_replace(" ", "+", _QUERYDB));
DEFINE('_SELECTED','Seilmi');
DEFINE('_ALLONSCREEN','HEPS Ekranda');
DEFINE('_ENTIREQUERY','Btn Sorgu');
DEFINE('_OPTIONS','Seenekler');
DEFINE('_LENGTH','uzunluk');
DEFINE('_CODE','kod');
DEFINE('_DATA','veri');
DEFINE('_TYPE','tr');
DEFINE('_NEXT','Sonraki');
DEFINE('_PREVIOUS','nceki');

//Menu items
DEFINE('_HOME','Ev');
DEFINE('_SEARCH','Ara');
DEFINE('_AGMAINT','Uyar Grubu Bakm');
DEFINE('_USERPREF','Kullanc Yelenenleri');
DEFINE('_CACHE','nbellek & Durum');
DEFINE('_ADMIN','Ynetim');
DEFINE('_GALERTD','izge Uyar Verisi');
DEFINE('_GALERTDT','izge Uyars Alglama Zaman');
DEFINE('_USERMAN','Kullanc Ynetimi');
DEFINE('_LISTU','Kullanclar Listele');
DEFINE('_CREATEU','Bir Kullanc Yarat');
DEFINE('_ROLEMAN','Rol Ynetimi');
DEFINE('_LISTR','Rolleri Listele');
DEFINE('_CREATER','Bir Rol Yarat');
DEFINE('_LISTALL','Hepsini Listele');
DEFINE('_CREATE','Yarat');
DEFINE('_VIEW','Grnm');
DEFINE('_CLEAR','Temizle');
DEFINE('_LISTGROUPS','Gruplar Listele');
DEFINE('_CREATEGROUPS','Grup Yarat');
DEFINE('_VIEWGROUPS','Grup Grntle');
DEFINE('_EDITGROUPS','Grup Dzenle');
DEFINE('_DELETEGROUPS','Grup Sil');
DEFINE('_CLEARGROUPS','Grup Temizle');
DEFINE('_CHNGPWD','Parola Deitir');
DEFINE('_DISPLAYU','Kullanc Grntle');

//base_footer.php
DEFINE('_FOOTER',' (by <A class="largemenuitem" href="mailto:base@secureideas.net">Kevin Johnson</A> and the <A class="largemenuitem" href="http://sourceforge.net/project/memberlist.php?group_id=103348">BASE Project Team</A><BR>Built on ACID by Roman Danyliw )');

//index.php --Log in Page
DEFINE('_LOGINERROR','Kullanc geerli deil ya da parolanz yanl!<br>Ltfen tekrar deneyin');

// base_main.php
DEFINE('_MOSTRECENT','En sondaki ');
DEFINE('_MOSTFREQUENT','En sk ');
DEFINE('_ALERTS',' Uyarlar:');
DEFINE('_ADDRESSES',' Adresler');
DEFINE('_ANYPROTO','herhangibir protokol');
DEFINE('_UNI','benzersiz');
DEFINE('_LISTING','listeleme');
DEFINE('_TALERTS','Bugn\'n uyarlar: ');
DEFINE('_SOURCEIP','Kaynak IP');
DEFINE('_DESTIP','Var IP');
DEFINE('_L24ALERTS','Son 24 Saatin uyarlar: ');
DEFINE('_L72ALERTS','Son 72 Saatin uyarlar: ');
DEFINE('_UNIALERTS',' Benzersiz Uyarlar');
DEFINE('_LSOURCEPORTS','Son Kaynak Portlar: ');
DEFINE('_LDESTPORTS','Son Var Portlar: ');
DEFINE('_FREGSOURCEP','En Sk Kaynak Portlar: ');
DEFINE('_FREGDESTP','En Sk Var Portlar: ');
DEFINE('_QUERIED','Sorguland');
DEFINE('_DATABASE','Veritaban:');
DEFINE('_SCHEMAV','ema Srm:');
DEFINE('_TIMEWIN','Zaman Penceresi:');
DEFINE('_NOALERTSDETECT','hibir uyar alglanmad');
DEFINE('_USEALERTDB','Uyar Veritabann Kullan');
DEFINE('_USEARCHIDB','Ariv Veritabann Kullan');
DEFINE('_TRAFFICPROBPRO','Protokole Gre Trafik Profili');

//base_auth.inc.php
DEFINE('_ADDEDSF','Baarl Biimde Eklendi');
DEFINE('_NOPWDCHANGE','Parolanz deitirmek olanaksz: ');
DEFINE('_NOUSER','Kullanc geerli deil!');
DEFINE('_OLDPWD','Girilen Eski parola kaytlarmzla elemiyor!');
DEFINE('_PWDCANT','Parolanz deitirmek olanaksz: ');
DEFINE('_PWDDONE','Parolanz deitirildi!');
DEFINE('_ROLEEXIST','Rol Zaten Var');
DEFINE('_ROLEIDEXIST','Rol ID Zaten Var');
DEFINE('_ROLEADDED','Rol Baarl Biimde Eklendi');

//base_roleadmin.php
DEFINE('_ROLEADMIN','BASE Rol Ynetimi');
DEFINE('_FRMROLEID','Rol ID:');
DEFINE('_FRMROLENAME','Rol Ad:');
DEFINE('_FRMROLEDESC','Betimleme:');
DEFINE('_UPDATEROLE','Rol Gncelle');

//base_useradmin.php
DEFINE('_USERADMIN','BASE Kullanc Ynetimi');
DEFINE('_FRMFULLNAME','Tm Ad:');
DEFINE('_FRMROLE','Rol:');
DEFINE('_FRMUID','Kullanc ID:');
DEFINE('_SUBMITQUERY','Sorguyu Sun');
DEFINE('_UPDATEUSER','Kullancy Gncelle');

//admin/index.php
DEFINE('_BASEADMIN','BASE Ynetimi');
DEFINE('_BASEADMINTEXT','Ltfen soldan bir seenek seiniz.');

//base_action.inc.php
DEFINE('_NOACTION','Uyarlarda hibir eylem belirlenmemi');
DEFINE('_INVALIDACT',' geersiz bir eylemdir');
DEFINE('_ERRNOAG','Hibir UG belirlenmedii iin uyarlar ekleyemedi');
DEFINE('_ERRNOEMAIL','Email adresi belirlenmedii iin uyarlar gnderemedi');
DEFINE('_ACTION','EYLEM');
DEFINE('_CONTEXT','balam');
DEFINE('_ADDAGID','UG\'na EKLE (ID yoluyla)');
DEFINE('_ADDAG','Yeni-UG-EKLE');
DEFINE('_ADDAGNAME','UG\'na EKLE (Ad yoluyla)');
DEFINE('_CREATEAG','UG Yarat (Ad yoluyla)');
DEFINE('_CLEARAG','UG\'dan Temizle');
DEFINE('_DELETEALERT','Uyar(lar) sil');
DEFINE('_EMAILALERTSFULL','Uyar(lar) Email\'e gnder (tm)');
DEFINE('_EMAILALERTSSUMM','Uyar(lar) Email\'e gnder (zet)');
DEFINE('_EMAILALERTSCSV','Uyar(lar) Email\'e gnder (csv)');
DEFINE('_ARCHIVEALERTSCOPY','Uyar(lar) arivle (kopyala)');
DEFINE('_ARCHIVEALERTSMOVE','Uyar(lar) arivle (ta)');
DEFINE('_IGNORED','Yoksayld ');
DEFINE('_DUPALERTS',' uyar(lar) oalt');
DEFINE('_ALERTSPARA',' uyar(lar)');
DEFINE('_NOALERTSSELECT','Hibir uyar seilmemi ya da');
DEFINE('_NOTSUCCESSFUL','baarl deildi');
DEFINE('_ERRUNKAGID','Bilinmeyen UG ID belirlenmi (UG muhtemelen geerli deil)');
DEFINE('_ERRREMOVEFAIL','Yeni UG\'nu karmak baarsz oldu');
DEFINE('_GENBASE','BASE tarafndan retildi');
DEFINE('_ERRNOEMAILEXP','DIARI AKTARIM HATASI: Dar aktarlm uyarlar gnderemedi');
DEFINE('_ERRNOEMAILPHP','PHP\'deki mail yaplandrmasn kontrol et.');
DEFINE('_ERRDELALERT','Uyar Silme Hatas');
DEFINE('_ERRARCHIVE','Ariv hatas:');
DEFINE('_ERRMAILNORECP','MAIL HATASI: Alc Belirlenmemi');

//base_cache.inc.php
DEFINE('_ADDED','Ekledi ');
DEFINE('_HOSTNAMESDNS',' host isimlerini IP DNS nbelleine');
DEFINE('_HOSTNAMESWHOIS',' host isimlerini Whois nbelleine');
DEFINE('_ERRCACHENULL','nbellee Alma HATASI: NULL olay sras bulundu?');
DEFINE('_ERRCACHEERROR','OLAYI NBELLEE ALMA HATASI:');
DEFINE('_ERRCACHEUPDATE','Olay nbelleini gncelleyemedi');
DEFINE('_ALERTSCACHE',' uyar(lar) Uyar nbelleine');

//base_db.inc.php
DEFINE('_ERRSQLTRACE','SQL iz dosyasn amak olanaksz');
DEFINE('_ERRSQLCONNECT','DB balant hatas :');
DEFINE('_ERRSQLCONNECTINFO','<P><I>base_conf.php</I> dosyasndaki DB balant deikenlerini kontrol edin.  
              <PRE>
               = $alert_dbname   : uyarlarn depoland MySQL veritaban ad 
               = $alert_host     : veritabannn depoland host
               = $alert_port     : veritabannn depoland port
               = $alert_user     : veritaban iindeki kullancad
               = $alert_password : kullancad iin parola
              </PRE>
              <P>');
DEFINE('_ERRSQLPCONNECT','DB (p)balant hatas :');
DEFINE('_ERRSQLDB','Veritaban HATASI:');
DEFINE('_DBALCHECK','DB soyutlama kitapl kontrol ediliyor');
DEFINE('_ERRSQLDBALLOAD1','<P><B>DB soyutlama kitapl ykleme hatas: </B> from ');
DEFINE('_ERRSQLDBALLOAD2','<P><CODE>base_conf.php</CODE> dosyasndaki <CODE>$DBlib_path</CODE> DB soyutlama kitapl deikenini kontrol edin 
            <P>
            Yrrlkte kullanlan temel veritaban kitapl ADODB\'dir,
            <A HREF="http://adodb.sourceforge.net/">http://adodb.sourceforge.net/</A> ten indirilebilir');
DEFINE('_ERRSQLDBTYPE','Geersiz Veritaban Tipi Belirlenmi');
DEFINE('_ERRSQLDBTYPEINFO1','<CODE>base_conf.php</CODE> dosyasndaki <CODE>\$DBtype</CODE> deikeni tanmlanmam veritaban tipinde ayarlanm ');
DEFINE('_ERRSQLDBTYPEINFO2','Yalnzca aadaki veritabanlar desteklenmektedir: <PRE>
                MySQL         : \'mysql\'
                PostgreSQL    : \'postgres\'
                MS SQL Server : \'mssql\'
                Oracle        : \'oci8\'
             </PRE>');

//base_log_error.inc.php
DEFINE('_ERRBASEFATAL','BASE ONARILAMAZ HATA:');

//base_log_timing.inc.php
DEFINE('_LOADEDIN','Yklendi');
DEFINE('_SECONDS','saniyede');

//base_net.inc.php
DEFINE('_ERRRESOLVEADDRESS','Adresi zmek olanaksz');

//base_output_query.inc.php
DEFINE('_QUERYRESULTSHEADER','Sorgu Sonular Sayfa Bal k');

//base_signature.inc.php
DEFINE('_ERRSIGNAMEUNK','Bilinmeyen mzasmi');
DEFINE('_ERRSIGPROIRITYUNK','Bilinmeyen mzancelii');
DEFINE('_UNCLASS','snflandrlmam');

//base_state_citems.inc.php
DEFINE('_DENCODED','veri ifrelenmi');
DEFINE('_NODENCODED','(veri dntrme yok, DB yerel ifrelemedeki lt sanlyor)');
DEFINE('_SHORTJAN','Oca');
DEFINE('_SHORTFEB','ub');
DEFINE('_SHORTMAR','Mar');
DEFINE('_SHORTAPR','Nis');
DEFINE('_SHORTMAY','May');
DEFINE('_SHORTJUN','Haz');
DEFINE('_SHORTJLY','Tem');
DEFINE('_SHORTAUG','Au');
DEFINE('_SHORTSEP','Eyl');
DEFINE('_SHORTOCT','Eki');
DEFINE('_SHORTNOV','Kas');
DEFINE('_SHORTDEC','Ara');
DEFINE('_DISPSIG','{ imza }');
DEFINE('_DISPANYCLASS','{ herhangibir Snflandrma }');
DEFINE('_DISPANYPRIO','{ herhangibir ncelik }');
DEFINE('_DISPANYSENSOR','{ herhangibir Sensor }');
DEFINE('_DISPADDRESS','{ adres }');
DEFINE('_DISPFIELD','{ alan }');
DEFINE('_DISPPORT','{ port }');
DEFINE('_DISPENCODING','{ ifreleme }');
DEFINE('_DISPCONVERT2','{ Dntr }');
DEFINE('_DISPANYAG','{ herhangibir Uyar Grubu }');
DEFINE('_DISPPAYLOAD','{ payload }');
DEFINE('_DISPFLAGS','{ bayraklar }');
DEFINE('_SIGEXACTLY','tam olarak');
DEFINE('_SIGROUGHLY','yaklak olarak');
DEFINE('_SIGCLASS','mza Snflandrma');
DEFINE('_SIGPRIO','mza ncelii');
DEFINE('_SHORTSOURCE','Kaynak');
DEFINE('_SHORTDEST','Var');
DEFINE('_SHORTSOURCEORDEST','Kaynak ya da Var');
DEFINE('_NOLAYER4','4.katman yok');
DEFINE('_INPUTCRTENC','Girdi lt ifreleme Tipi');
DEFINE('_CONVERT2WS','Dntr (ararken)');

//base_state_common.inc.php
DEFINE('_PHPERRORCSESSION','PHP HATASI: zel (kullanc) bir PHP oturumu saptand. Ancak, BASE aka bu zel ileyiciyi kullanmak zere ayarlanmam. <CODE>base_conf.php</CODE> dosyasnda <CODE>use_user_session=1</CODE> olarak ayarlayn');
DEFINE('_PHPERRORCSESSIONCODE','PHP HATASI: zel (kullanc) bir PHP oturum ileyicisi yaplandrlm, fakat <CODE>user_session_path</CODE> \'teki belirlenmi ileyici kodu geersiz.');
DEFINE('_PHPERRORCSESSIONVAR','PHP HATASI: zel (kullanc) bir PHP oturum ileyicisi yaplandrlm, fakat bu ileyicinin gerekletirilmesi BASE\'de belirlenmemi. Eer zel bir oturum ileyici isteniyorsa, <CODE>base_conf.php</CODE> dosyasndaki <CODE>user_session_path</CODE> deikenini ayarlayn.');
DEFINE('_PHPSESSREG','Oturum Kaydedildi');

//base_state_criteria.inc.php
DEFINE('_REMOVE','Kaldrlyor');
DEFINE('_FROMCRIT','ltten');
DEFINE('_ERRCRITELEM','Geersiz lt esi');

//base_state_query.inc.php
DEFINE('_VALIDCANNED','Geerli Konservelenmi Sorgu Listesi');
DEFINE('_DISPLAYING','Grntleniyor');
DEFINE('_DISPLAYINGTOTAL','%d-%d uyarlar grntleniyor, %d toplamda');
DEFINE('_NOALERTS','Hibir Uyar bulunamad.');
DEFINE('_QUERYRESULTS','Sorgu Sonular');
DEFINE('_QUERYSTATE','Sorgu Durumu');
DEFINE('_DISPACTION','{ eylem }');

//base_ag_common.php
DEFINE('_ERRAGNAMESEARCH','Belirtilen UG ad aramas geersiz.  Tekrar deneyin!');
DEFINE('_ERRAGNAMEEXIST','Belirtilen UG yok.');
DEFINE('_ERRAGIDSEARCH','Belirtilen UG ID aramas geersiz.  Tekrar deneyin!');
DEFINE('_ERRAGLOOKUP','UG ID arama Hatas');
DEFINE('_ERRAGINSERT','Yeni UG Ekleme Hatas');

//base_ag_main.php
DEFINE('_AGMAINTTITLE','Uyar Grubu (UG) Bakm');
DEFINE('_ERRAGUPDATE','UG gncelleme Hatas');
DEFINE('_ERRAGPACKETLIST','UG iin paket listesi silme Hatas:');
DEFINE('_ERRAGDELETE','UG silme Hatas');
DEFINE('_AGDELETE','Baarl biimde SLND');
DEFINE('_AGDELETEINFO','bilgi silindi');
DEFINE('_ERRAGSEARCHINV','Girilen arama lt geersiz.  Tekrar deneyin!');
DEFINE('_ERRAGSEARCHNOTFOUND','Bu lte gre UG bulunamad.');
DEFINE('_NOALERTGOUPS','Hi Uyar Grubu yok');
DEFINE('_NUMALERTS','# Uyarlar');
DEFINE('_ACTIONS','Eylemler');
DEFINE('_NOTASSIGN','henz atanmam');
DEFINE('_SAVECHANGES','Deiiklikleri Kaydet');
DEFINE('_CONFIRMDELETE','Silmeyi Onayla');
DEFINE('_CONFIRMCLEAR','Temizlemeyi Onayla');

//base_common.php
DEFINE('_PORTSCAN','Portscan Trafii');

//base_db_common.php
DEFINE('_ERRDBINDEXCREATE','INDEX YARATMAK Olanaksz');
DEFINE('_DBINDEXCREATE','Baarl biimde INDEX yaratld');
DEFINE('_ERRSNORTVER','Eski bir srm olabilir.  Sadece Snort 1.7-beta0 ve sonraki srmler tarafndan yaratlan uyar veritabanlar desteklenmektedir');
DEFINE('_ERRSNORTVER1','temel veritaban');
DEFINE('_ERRSNORTVER2','eksik/geersiz grnmektedir');
DEFINE('_ERRDBSTRUCT1','veritaban srm geerli, fakat BASE DB yaps');
DEFINE('_ERRDBSTRUCT2','sunulu deil. <A HREF="base_db_setup.php">Setup sayfasn</A> kullanarak DB\'i yaplandrn ve optimize edin.');
DEFINE('_ERRPHPERROR','PHP HATASI');
DEFINE('_ERRPHPERROR1','Uyumsuz srm');
DEFINE('_ERRVERSION','Srm');
DEFINE('_ERRPHPERROR2',' PHP\'nin ok eski.  Ltfen 4.0.4 veya sonraki bir srme ykseltin');
DEFINE('_ERRPHPMYSQLSUP','<B>PHP inas eksik</B>: <FONT>uyar veritabann okumak iin gerekli 
               nkoul Mysql destei PHP iine ina edilmemi.  
               Ltfen gerekli kitaplk ile birlikte PHP\'yi yeniden derleyin (<CODE>--with-mysql</CODE>)</FONT>');
DEFINE('_ERRPHPPOSTGRESSUP','<B>PHP inas eksik</B>: <FONT>uyar veritabann okumak iin gerekli 
               nkoul PostgreSQL destei PHP iine ina edilmemi.  
               Ltfen gerekli kitaplk ile birlikte PHP\'yi yeniden derleyin (<CODE>--with-pgsql</CODE>)</FONT>');
DEFINE('_ERRPHPMSSQLSUP','<B>PHP inas eksik</B>: <FONT>uyar veritabann okumak iin gerekli 
                   nkoul MS SQL Server destei PHP iine ina edilmemi.  
                   Ltfen gerekli kitaplk ile birlikte PHP\'yi yeniden derleyin (<CODE>--enable-mssql</CODE>)</FONT>');
DEFINE('_ERRPHPORACLESUP','<B>PHP inas eksik</B>: <FONT>uyar veritabann okumak iin gerekli 
                   nkoul Oracle destei PHP iine ina edilmemi.  
                   Ltfen gerekli kitaplk ile birlikte PHP\'yi yeniden derleyin (<CODE>--with-oci8</CODE>)</FONT>');

//base_graph_form.php
DEFINE('_CHARTTITLE','Grafik Bal:');
DEFINE('_CHARTTYPE','Grafik Tipi:');
DEFINE('_CHARTTYPES','{ grafik tipi }');
DEFINE('_CHARTPERIOD','Grafik Dnemi:');
DEFINE('_PERIODNO','dnem yok');
DEFINE('_PERIODWEEK','7 (bir hafta)');
DEFINE('_PERIODDAY','24 (btn gn)');
DEFINE('_PERIOD168','168 (24x7)');
DEFINE('_CHARTSIZE','Boyut: (en x ykseklik)');
DEFINE('_PLOTMARGINS','izim Boluklar: (sol x sa x st x alt)');
DEFINE('_PLOTTYPE','izim tipi:');
DEFINE('_TYPEBAR','ubuk');
DEFINE('_TYPELINE','izgi');
DEFINE('_TYPEPIE','pasta');
DEFINE('_CHARTHOUR','{sat}');
DEFINE('_CHARTDAY','{gn}');
DEFINE('_CHARTMONTH','{ay}');
DEFINE('_GRAPHALERTS','izge Uyarlar');
DEFINE('_AXISCONTROLS','X / Y EKSEN KONTROLLER');
DEFINE('_CHRTTYPEHOUR','Zaman (saat) vs. Uyar Says');
DEFINE('_CHRTTYPEDAY','Zaman (gn) vs. Uyar Says');
DEFINE('_CHRTTYPEWEEK','Zaman (hafta) vs. Uyar Says');
DEFINE('_CHRTTYPEMONTH','Zaman (ay) vs. Uyar Says');
DEFINE('_CHRTTYPEYEAR','Zaman (yl) vs. Uyar Says');
DEFINE('_CHRTTYPESRCIP','Kaynak IP adresi vs. Uyar Says');
DEFINE('_CHRTTYPEDSTIP','Var IP adresi vs. Uyar Says');
DEFINE('_CHRTTYPEDSTUDP','Var UDP Portu vs. Uyar Says');
DEFINE('_CHRTTYPESRCUDP','Kynak UDP Portu vs. Uyar Says');
DEFINE('_CHRTTYPEDSTPORT','Var TCP Portu vs. Uyar Says');
DEFINE('_CHRTTYPESRCPORT','Kaynak TCP Portu vs. Uyar Says');
DEFINE('_CHRTTYPESIG','mza Snflamas vs. Uyar Says');
DEFINE('_CHRTTYPESENSOR','Sensor vs. Uyar Says');
DEFINE('_CHRTBEGIN','Grafik Balangc:');
DEFINE('_CHRTEND','Grafik Sonu:');
DEFINE('_CHRTDS','Veri Kayna:');
DEFINE('_CHRTX','X Ekseni');
DEFINE('_CHRTY','Y Ekseni');
DEFINE('_CHRTMINTRESH','En Dk Eik Deeri');
DEFINE('_CHRTROTAXISLABEL','Eksen Etiketlerini Dndr (90 derece)');
DEFINE('_CHRTSHOWX','X-ekseni zgara-izgilerini gster');
DEFINE('_CHRTDISPLABELX','Her bir X-ekseni etiketini grntle');
DEFINE('_CHRTDATAPOINTS','veri gstergeleri');
DEFINE('_CHRTYLOG','Logaritmik Y-ekseni');
DEFINE('_CHRTYGRID','Y-ekseni zgara-izgilerini gster');

//base_graph_main.php
DEFINE('_CHRTTITLE','BASE Grafik');
DEFINE('_ERRCHRTNOTYPE','Hibir grafik tipi belirtilmemi');
DEFINE('_ERRNOAGSPEC','Hibir UG belirtilmemi.  Tm uyarlar kullanyor.');
DEFINE('_CHRTDATAIMPORT','Veri aktarmn balatyor');
DEFINE('_CHRTTIMEVNUMBER','Zaman vs. Uyar Says');
DEFINE('_CHRTTIME','Zaman');
DEFINE('_CHRTALERTOCCUR','Uyar Meydana Geliyor');
DEFINE('_CHRTSIPNUMBER','Kaynak IP vs. Uyar Says');
DEFINE('_CHRTSIP','Kaynak IP Adresi');
DEFINE('_CHRTDIPALERTS','Var IP vs. Uyar Says');
DEFINE('_CHRTDIP','Var IP Adresi');
DEFINE('_CHRTUDPPORTNUMBER','UDP Portu (Var) vs. Uyar Says');
DEFINE('_CHRTDUDPPORT','Var UDP Portu');
DEFINE('_CHRTSUDPPORTNUMBER','UDP Portu (Kaynak) vs. Uyar Says');
DEFINE('_CHRTSUDPPORT','Kaynak UDP Portu');
DEFINE('_CHRTPORTDESTNUMBER','TCP Portu (Var) vs. Uyar Says');
DEFINE('_CHRTPORTDEST','Var TCP Portu');
DEFINE('_CHRTPORTSRCNUMBER','TCP Portu (Kaynak) vs. Uyar Says');
DEFINE('_CHRTPORTSRC','Kaynak TCP Portu');
DEFINE('_CHRTSIGNUMBER','mza Snflamas vs. Uyar Says');
DEFINE('_CHRTCLASS','Snflama');
DEFINE('_CHRTSENSORNUMBER','Sensor vs. Uyar Says');
DEFINE('_CHRTHANDLEPERIOD','leme Dnemi, eer gerekliyse');
DEFINE('_CHRTDUMP','Veriyi boaltyor ... (her birini yazyor');
DEFINE('_CHRTDRAW','Grafii iziyor');
DEFINE('_ERRCHRTNODATAPOINTS','izecek hi veri gstergesi yok');
DEFINE('_GRAPHALERTDATA','Grafik Uyar Verisi');

//base_maintenance.php
DEFINE('_MAINTTITLE','Bakm');
DEFINE('_MNTPHP','PHP nas:');
DEFINE('_MNTCLIENT','STEMC:');
DEFINE('_MNTSERVER','SUNUCU:');
DEFINE('_MNTSERVERHW','SUNUCU HW:');
DEFINE('_MNTPHPVER','PHP SRM:');
DEFINE('_MNTPHPAPI','PHP API:');
DEFINE('_MNTPHPLOGLVL','PHP Gnlkleme dzeyi:');
DEFINE('_MNTPHPMODS','Ykl Modller:');
DEFINE('_MNTDBTYPE','DB Tipi:');
DEFINE('_MNTDBALV','DB Soyutlama Srm:');
DEFINE('_MNTDBALERTNAME','UYARI DB Ad:');
DEFINE('_MNTDBARCHNAME','ARV DB Ad:');
DEFINE('_MNTAIC','Uyar Bilgi nbellei:');
DEFINE('_MNTAICTE','Toplam Olaylar:');
DEFINE('_MNTAICCE','nbellekteki Olaylar:');
DEFINE('_MNTIPAC','IP Adres nbellei');
DEFINE('_MNTIPACUSIP','Benzersiz Kaynak IP:');
DEFINE('_MNTIPACDNSC','DNS nbellee alnd:');
DEFINE('_MNTIPACWC','Whois nbellee alnd:');
DEFINE('_MNTIPACUDIP','Benzersiz Var IP:');

//base_qry_alert.php
DEFINE('_QAINVPAIR','Geersiz (sid,cid) ift');
DEFINE('_QAALERTDELET','Uyar SLND');
DEFINE('_QATRIGGERSIG','Tetiklenmi mza');
DEFINE('_QANORMALD','Normal Grnt');
DEFINE('_QAPLAIND','Dz Grnt');
DEFINE('_QANOPAYLOAD','Hzl gnlkleme kullanld bu yzden payload atld');

//base_qry_common.php
DEFINE('_QCSIG','imza');
DEFINE('_QCIPADDR','IP adresleri');
DEFINE('_QCIPFIELDS','IP alanlar');
DEFINE('_QCTCPPORTS','TCP portlar');
DEFINE('_QCTCPFLAGS','TCP bayraklar');
DEFINE('_QCTCPFIELD','TCP alanlar');
DEFINE('_QCUDPPORTS','UDP portlar');
DEFINE('_QCUDPFIELDS','UDP alanlar');
DEFINE('_QCICMPFIELDS','ICMP alanlar');
DEFINE('_QCDATA','Veri');
DEFINE('_QCERRCRITWARN','lt uyars:');
DEFINE('_QCERRVALUE','deeri');
DEFINE('_QCERRFIELD','alan');
DEFINE('_QCERROPER','iletmeni');
DEFINE('_QCERRDATETIME','tarih/zaman deeri');
DEFINE('_QCERRPAYLOAD','payload deeri');
DEFINE('_QCERRIP','IP adresi');
DEFINE('_QCERRIPTYPE','Tipin IP adresi');
DEFINE('_QCERRSPECFIELD',' bir protokol alan iin girildi, fakat zel alan belirlenmemi.');
DEFINE('_QCERRSPECVALUE','onun bir lt olmas gerektiini gstermek zere seilmi, fakat hangisiyle eleeceini gsteren hibir deer belirlenmemi.');
DEFINE('_QCERRBOOLEAN','Aralarnda bir boolen ileci olmadan (rnein; VE, YA DA) oklu Protokol Alan lt girildi.');
DEFINE('_QCERRDATEVALUE','baz tarih/zaman ltnn elemesi gerektiini gstermek zere seilmi, fakat hibir deer belirlenmemi.');
DEFINE('_QCERRINVHOUR','(Geersiz Saat) Belirtilen zamana uygun hibir tarih girilmemi.');
DEFINE('_QCERRDATECRIT','baz tarih/zaman ltnn elemesi gerektiini gstermek zere seilmi, fakat hibir deer belirlenmemi.');
DEFINE('_QCERROPERSELECT','girilmi fakat hibir iletici seilmemi.');
DEFINE('_QCERRDATEBOOL','Aralarnda bir boolen ileci olmadan (rnein; VE, YA DA) oklu Tarih/Zaman lt girildi.');
DEFINE('_QCERRPAYCRITOPER','bir payload lt alan iin girilmi, fakat bir iletici (rnein; sahip, sahip deil) belirtilmemi.');
DEFINE('_QCERRPAYCRITVALUE','payload\'n bir lt olmas gerektiini gstermek zere seilmi, fakat hangisiyle eleeceini gsteren hibir deer belirlenmemi.');
DEFINE('_QCERRPAYBOOL','Aralarnda bir boolen ileci olmadan (rnein; VE, YA DA) oklu Veri payload lt girildi.');
DEFINE('_QCMETACRIT','Meta lt');
DEFINE('_QCIPCRIT','IP lt');
DEFINE('_QCPAYCRIT','Payload lt');
DEFINE('_QCTCPCRIT','TCP lt');
DEFINE('_QCUDPCRIT','UDP lt');
DEFINE('_QCICMPCRIT','ICMP lt');
DEFINE('_QCLAYER4CRIT','4. Katman lt');
DEFINE('_QCERRINVIPCRIT','Geersiz IP adres lt');
DEFINE('_QCERRCRITADDRESSTYPE','bir lt deeri olmas iin girilmi, fakat adresin tipi (rnein; kaynak, var) belirlenmemi.');
DEFINE('_QCERRCRITIPADDRESSNONE','bir IP adresinin bir lt olmas gerektiini gsteriyor, fakat hangisiyle eleeceini gsteren hibir adres belirlenmemi.');
DEFINE('_QCERRCRITIPADDRESSNONE1','seilmi (#');
DEFINE('_QCERRCRITIPIPBOOL','IP lt arasnda bir boolen ileci olmadan (rnein; VE, YA DA) oklu IP adres lt girildi');

//base_qry_form.php
DEFINE('_QFRMSORTORDER','Sralama dzeni');
DEFINE('_QFRMSORTNONE','hibiri');
DEFINE('_QFRMTIMEA','zaman damgas (artan)');
DEFINE('_QFRMTIMED','zaman damgas (azalan)');
DEFINE('_QFRMSIG','imza');
DEFINE('_QFRMSIP','kaynak IP');
DEFINE('_QFRMDIP','var IP');

//base_qry_sqlcalls.php
DEFINE('_QSCSUMM','statistik zeti');
DEFINE('_QSCTIMEPROF','Zaman profili');
DEFINE('_QSCOFALERTS','uyarlarn');

//base_stat_alerts.php
DEFINE('_ALERTTITLE','Uyar Listeleme');

//base_stat_common.php
DEFINE('_SCCATEGORIES','Kategoriler:');
DEFINE('_SCSENSORTOTAL','Sensorler/Toplam:');
DEFINE('_SCTOTALNUMALERTS','Toplam Uyar Says:');
DEFINE('_SCSRCIP','Kaynak IP adresi:');
DEFINE('_SCDSTIP','Var IP adresi:');
DEFINE('_SCUNILINKS','Benzersiz IP balantlar');
DEFINE('_SCSRCPORTS','Kaynak Portlar: ');
DEFINE('_SCDSTPORTS','Var Portlar: ');
DEFINE('_SCSENSORS','Sensorler');
DEFINE('_SCCLASS','snflamalar');
DEFINE('_SCUNIADDRESS','Benzersiz adresler: ');
DEFINE('_SCSOURCE','Kaynak');
DEFINE('_SCDEST','Var');
DEFINE('_SCPORT','Port');

//base_stat_ipaddr.php
DEFINE('_PSEVENTERR','PORTSCAN OLAY HATASI: ');
DEFINE('_PSEVENTERRNOFILE','\$portscan_file deikeninde hibir dosya belirtilmemi');
DEFINE('_PSEVENTERROPENFILE','Portscan olay dosyasn amak olanaksz');
DEFINE('_PSDATETIME','Tarih/Zaman');
DEFINE('_PSSRCIP','Kaynak IP');
DEFINE('_PSDSTIP','Var IP');
DEFINE('_PSSRCPORT','Kaynak Portu');
DEFINE('_PSDSTPORT','Var Portu');
DEFINE('_PSTCPFLAGS','TCP Bayraklar');
DEFINE('_PSTOTALOCC','Toplam<BR> Olaylar');
DEFINE('_PSNUMSENSORS','Sensor Says');
DEFINE('_PSFIRSTOCC','lk<BR> Gerekleen Olay');
DEFINE('_PSLASTOCC','Son<BR> Gerekleen Olay');
DEFINE('_PSUNIALERTS','Benzersiz Uyarlar');
DEFINE('_PSPORTSCANEVE','Portscan Olaylar');
DEFINE('_PSREGWHOIS','Kayt bak (whois)');
DEFINE('_PSNODNS','hi DNS znrl denenmedi');
DEFINE('_PSNUMSENSORSBR','Sensor <BR>Says');
DEFINE('_PSOCCASSRC','Kaynak olarak <BR>Ortaya kanlar');
DEFINE('_PSOCCASDST','Var olarak <BR>Ortaya kanlar');
DEFINE('_PSWHOISINFO','Whois Bilgisi');
DEFINE('_PSTOTALHOSTS','Toplam Taranan Hostlar');
DEFINE('_PSDETECTAMONG','%d benzersiz uyar saptand, %d uyar arasnda, %s \'de');
DEFINE('_PSALLALERTSAS','tm uyarlarla birlikte %s/%s olarak');
DEFINE('_PSSHOW','gster');
DEFINE('_PSEXTERNAL','d');

//base_stat_iplink.php
DEFINE('_SIPLTITLE','IP Balantlar');
DEFINE('_SIPLSOURCEFGDN','Kaynak FQDN');
DEFINE('_SIPLDESTFGDN','Var FQDN');
DEFINE('_SIPLDIRECTION','Yn');
DEFINE('_SIPLPROTO','Protokol');
DEFINE('_SIPLUNIDSTPORTS','Benzersiz Var Portlar');
DEFINE('_SIPLUNIEVENTS','Benzersiz Olaylar');
DEFINE('_SIPLTOTALEVENTS','Toplam Olaylar');

//base_stat_ports.php
DEFINE('_UNIQ','Benzersiz');
DEFINE('_DSTPS','Var Port(lar)');
DEFINE('_SRCPS','Kaynak Port(lar)');
DEFINE('_OCCURRENCES','Meydana Geliyor');

//base_stat_sensor.php
DEFINE('SPSENSORLIST','Sensor Listeleme');

//base_stat_time.php
DEFINE('_BSTTITLE','Uyarlarn Zaman Profili');
DEFINE('_BSTTIMECRIT','Zaman lt');
DEFINE('_BSTERRPROFILECRIT','<FONT><B>Hibir profilleme lt belirlenmemei!</B>  "saat", "gn", ya da "ay" zerine tklayarak kmelenmi istatistiklerden taneli olan sein.</FONT>');
DEFINE('_BSTERRTIMETYPE','<FONT><B>Geecek olan zaman parametresi tipi belirlenmemei!</B>  Tek bir zaman belirtmek iin "zerinde", ya da bir aralk belirtmek iin "arasnda" \'dan herhangi birini sein.</FONT>');
DEFINE('_BSTERRNOYEAR','<FONT><B>Hibir Yl parametresi belirtilmemi!</B></FONT>');
DEFINE('_BSTERRNOMONTH','<FONT><B>Hibir Ay parametresi belirtilmemi!</B></FONT>');
DEFINE('_BSTERRNODAY','<FONT><B>Hibir Gn parametresi belirtilmemi!</B></FONT>');
DEFINE('_BSTPROFILEBY','Profil tarafndan');
DEFINE('_TIMEON','zerinde');
DEFINE('_TIMEBETWEEN','arasnda');
DEFINE('_PROFILEALERT','Profil Uyars');

//base_stat_uaddr.php
DEFINE('_UNISADD','Benzersiz Kaynak Adres(leri)');
DEFINE('_SUASRCIP','Kaynak IP adresi');
DEFINE('_SUAERRCRITADDUNK','LT HATASI: bilinmeyen adres tipi -- Var adresi olduu sanlyor');
DEFINE('_UNIDADD','Benzersiz Var Adres(leri)');
DEFINE('_SUADSTIP','Var IP adresi');
DEFINE('_SUAUNIALERTS','Benzersiz Uyarlar');
DEFINE('_SUASRCADD','Kaynak Adresi');
DEFINE('_SUADSTADD','Var Adresi');

//base_user.php
DEFINE('_BASEUSERTITLE','BASE Kullanc Yelenenleri');
DEFINE('_BASEUSERERRPWD','Parolanz bo olamaz ya da iki parola elemedi!');
DEFINE('_BASEUSEROLDPWD','Eski Parola:');
DEFINE('_BASEUSERNEWPWD','Yeni Parola:');
DEFINE('_BASEUSERNEWPWDAGAIN','Yeni Parola Tekrar:');

DEFINE('_LOGOUT','Oturumu Kapat');

?>
