
/*
 *  Copyright (c) 1998 - 1999, 2001 Karel Zak "Zakkr" <zakkr@zf.jcu.cz>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  $Id: learn_key.c,v 1.2 2001/01/02 14:16:15 zakkr Exp $
 */

#include "aca.h"
#include "aca_dlg.h"
#include "aca_widget.h"

#define Y(a)	(a+y)
#define X(a)	(a+x)

extern void load_seqences();

static int	yn=16, xn=59;

   typedef struct {
      int	key;
      char	*name;
      int	flag;
   } learn_keys;

   static int setkey_ok(int key, learn_keys *p)
   {
      learn_keys	*x;
   
      for(x=p; x->key != 0; x++) {
         if (x->key == key) {
            x->flag = TRUE;
            return TRUE;
         }	
      }
      return FALSE;
   }

   static void mpr_learn (Wmenu *m, Widget *w, int line, int cols, int item) 
   {
      learn_keys	*p;         
      WidgetColor	*color = &TplC->menu_in;
      
      _D( " mpr_learn() ");
      
      p = ((learn_keys *) m->list) + item;
      
      clean_hline(line, cols, w->cols+3, 
      		(m->item_act == item ? color->sel : color->nsel)); 
      mvaddstr (line, cols, p->name);	
      if (p->flag)	mvaddstr (line, cols+w->cols+1, "OK");	
   }

   static void bgr_learnkey(SessW *s)
   {
      int	x = COLS/2 - xn/2,
                y = LINES/2 - yn/2;
   
      aca_border (y, x, yn, xn, TplC->dlg_bgr);
      clean_box(Y(1), X(1), yn-2, xn-2, TplC->dlg_bgr);
   
      center_addnstr(Y(1), COLS/2, 
         
      _aca("Press all the keys mentioned here. After you have\ndone it, check which keys are not marked with OK. Press\n<ENTER> (or mouse) on the missing key to define it.\nMove around with Tab, ^n, ^p or mouse.\n--> experimental routine <--"), xn-4);
   
      bold;  aca_c(TplC->dlg_header); 
      mvaddstr( Y(0), COLS/2 - (strlen(_aca(" Learn keys "))/2), _aca(" Learn keys "));  
      ubold;	
   }

   void Dlg_LearnKey(aca_INI *ini)
   {
      int		x, y, tmp,
      			re, istermcap;
      char		buff[256];
      learn_keys 	*p_keys;
      learn_keys keys1[] = {			
      	{ KEY_F(1), _aca("Function key 1") },
      	{ KEY_F(2), _aca("Function key 2") },
      	{ KEY_F(3), _aca("Function key 3") },
      	{ KEY_F(4), _aca("Function key 4") },
      	{ KEY_F(5), _aca("Function key 5") },
      	{ KEY_F(6), _aca("Function key 6") },
      	{ KEY_F(7), _aca("Function key 7") },
      	{ 0, 0 			        } 
      }, keys2[] = {	
      	{ KEY_F(8),     _aca("Function key 8")  },
      	{ KEY_F(9),     _aca("Function key 9")  },
      	{ KEY_F(10),    _aca("Function key 10") },
      	{ KEY_BACKSPACE,_aca("Backspace key")   },
      	{ KEY_END,      _aca("End key")         },
      	{ KEY_UP,       _aca("Up arrow key")    },
      	{ KEY_DOWN,     _aca("Down arrow key")  },
      	{ 0, 0                               }
      }, keys3[] = {
      	{ KEY_LEFT,   _aca("Left arrow key")    },
      	{ KEY_RIGHT,  _aca("Right arrow key")   },
      	{ KEY_HOME,   _aca("Home key")          },
      	{ KEY_NPAGE,  _aca("Page Down key")     },
      	{ KEY_PPAGE,  _aca("Page Up key")       },
      	{ KEY_IC,     _aca("Insert key")        },
      	{ KEY_DC,     _aca("Delete key")        },
      	{ 0, 0                               }
      };
      Wmenu   menu[] = {{
 	chN, 0, M_OPEN | M_NOTOUT | M_COLORIN, 
      	6,0,0,6,0,0,0,0,0,0, alistN, (void *) keys1, mpr_learn
      },{
      	chN, 0, M_OPEN | M_NOTOUT | M_COLORIN, 
      	6,0,0,6,0,0,0,0,0,0, alistN, (void *) keys2, mpr_learn 
      },{
      	chN, 0, M_OPEN | M_NOTOUT | M_COLORIN, 
     	6,0,0,6,0,0,0,0,0,0, alistN, (void *) keys3, mpr_learn
      }}; 	
      Widget	w[] = {
      	{ FALSE, 0,0,0,15, menu_fn,  (void *) &menu[0],  Wf_NOTUSE_ASTR, _aca_text_domain },
      	{ FALSE, 0,0,0,15, menu_fn,  (void *) &menu[1],  Wf_NOTUSE_ASTR, _aca_text_domain },
      	{ FALSE, 0,0,0,15, menu_fn,  (void *) &menu[2],  Wf_NOTUSE_ASTR, _aca_text_domain },
      	{ TRUE,  0,0,0,5,  button_fn,(void *) &def_button[_BUTT_OK],     Wf_DEFAULT, _aca_text_domain },
      	{ TRUE,  0,0,0,9,  button_fn,(void *) &def_button[_BUTT_CANCEL], Wf_DEFAULT, _aca_text_domain },
      	W_NULL
      };
      SessW	s;
   
      init_sessw(&s, 0, TRUE, w, bgr_learnkey, Sf_DEFAULT);

#define _SET_LEARN_POZ {					\
   /* set 'x' ant 'y' */					\
      x = COLS/2 - xn/2;					\
      y = LINES/2 - yn/2;					\
   /* menu locate */						\
      w[0].x =X(2);	w[1].x =X(21);	w[2].x =X(40); 		\
      w[0].y = w[1].y = w[2].y = Y(7);				\
   /* button locate */						\
      w[3].y = Y(yn-4+3);					\
      w[4].y = Y(yn-4+3);	 				\
      set_widgets_progression(COLS/2-tmp/2, "wiw", &w[3], 2, &w[4]);	\
}      
	
      tmp = size_widgets_progression("wiw", &w[3], 2, &w[4]);  		
      _SET_LEARN_POZ;
   
      if (aca.keypad) {
         aca_keypad(FALSE);
         load_seqences();
         istermcap = TRUE;
      } 
      else
         istermcap = FALSE;
      init_lbuff();
      W_redraw_session(&s);
      GL_inlearn_mode = TRUE;
      do {
        if (s.key == K_SCREEN_RESIZED) {
        	_SET_LEARN_POZ;
        	W_redraw_session(&s);
        	s.key = get_k();
        	continue;
        }
        /* check key ..hmm this is very s... algorithm */
         if (isfunckey(s.key)) {
            if (!setkey_ok(s.key, keys1)) {
               if (!setkey_ok(s.key, keys2)) {
                  if (setkey_ok(s.key, keys3))
                     W_redraw_session(&s);
               } 
               else
                  W_redraw_session(&s);
            } 
            else	
               W_redraw_session(&s);		
         }	
         re = run_act_widget(&s);
        /*	Cancel */	    
         if((re & Wr_BUTTON_PRESS) && s.actual==4) {
            aca_keypad(istermcap);
            break;
         }	
         /* Ok */	    
         else if((re & Wr_BUTTON_PRESS) && s.actual==3) {
            cpy_lbuff();
            if (learn_keydump_check()) {
               cpy_learn2ini(ini);
               INI_set_flag_save(ini, GL_term_name);
            }   
            break;				
         } 
         else if ((re & Wr_MENU_PRESS) &&s.actual<=2) {
         
         #define	P_NAME	p_keys[menu[s.actual].item_act].name	
         #define	P_FLAG	p_keys[menu[s.actual].item_act].flag		
         #define	P_KEY	p_keys[menu[s.actual].item_act].key			
         
            p_keys = (learn_keys *) menu[s.actual].list;
            sprintf(buff, _aca("Please press the %s.\n\nThen, press it again (in 'Learn keys' menu) to\nsee if OK appears.\n"), P_NAME);			
            Dlg_Warning_org (_aca(" Teach me a key "), buff, 50, Warn_draw, FALSE);
            learn_key(P_KEY); 
            W_redraw_session(&s);
         }
      
         W_key_to_widgets(&s);		
         W_default_go(&s);
      
         if (s.actual <= 2) {
            menu[0].item_act= menu[1].item_act= menu[2].item_act= menu[s.actual].item_act;
            menu[0].scr_act = menu[1].scr_act = menu[2].scr_act = menu[s.actual].scr_act;
         }	
         s.key = get_k();
      } while(1);  
   
      GL_inlearn_mode = FALSE;
   }
